/*
Copyright 2022 Keyfactor
Licensed under the Apache License, Version 2.0 (the "License"); you may
not use this file except in compliance with the License.  You may obtain a
copy of the License at http://www.apache.org/licenses/LICENSE-2.0.  Unless
required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
OR CONDITIONS OF ANY KIND, either express or implied. See the License for
thespecific language governing permissions and limitations under the
License.

SignServer REST Interface

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package signserver

import (
	"encoding/json"
)

// checks if the ProcessRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ProcessRequest{}

// ProcessRequest POJO that represents a process request.
type ProcessRequest struct {
	// The input data to be processed (i.e. signed).
	Data string `json:"data"`
	// Choice of additional encoding of the data.
	Encoding *string `json:"encoding,omitempty"`
	// Additional request metadata for the worker.
	MetaData             *map[string]string `json:"metaData,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _ProcessRequest ProcessRequest

// NewProcessRequest instantiates a new ProcessRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewProcessRequest(data string) *ProcessRequest {
	this := ProcessRequest{}
	this.Data = data
	return &this
}

// NewProcessRequestWithDefaults instantiates a new ProcessRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewProcessRequestWithDefaults() *ProcessRequest {
	this := ProcessRequest{}
	return &this
}

// GetData returns the Data field value
func (o *ProcessRequest) GetData() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Data
}

// GetDataOk returns a tuple with the Data field value
// and a boolean to check if the value has been set.
func (o *ProcessRequest) GetDataOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Data, true
}

// SetData sets field value
func (o *ProcessRequest) SetData(v string) {
	o.Data = v
}

// GetEncoding returns the Encoding field value if set, zero value otherwise.
func (o *ProcessRequest) GetEncoding() string {
	if o == nil || isNil(o.Encoding) {
		var ret string
		return ret
	}
	return *o.Encoding
}

// GetEncodingOk returns a tuple with the Encoding field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProcessRequest) GetEncodingOk() (*string, bool) {
	if o == nil || isNil(o.Encoding) {
		return nil, false
	}
	return o.Encoding, true
}

// HasEncoding returns a boolean if a field has been set.
func (o *ProcessRequest) HasEncoding() bool {
	if o != nil && !isNil(o.Encoding) {
		return true
	}

	return false
}

// SetEncoding gets a reference to the given string and assigns it to the Encoding field.
func (o *ProcessRequest) SetEncoding(v string) {
	o.Encoding = &v
}

// GetMetaData returns the MetaData field value if set, zero value otherwise.
func (o *ProcessRequest) GetMetaData() map[string]string {
	if o == nil || isNil(o.MetaData) {
		var ret map[string]string
		return ret
	}
	return *o.MetaData
}

// GetMetaDataOk returns a tuple with the MetaData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProcessRequest) GetMetaDataOk() (*map[string]string, bool) {
	if o == nil || isNil(o.MetaData) {
		return nil, false
	}
	return o.MetaData, true
}

// HasMetaData returns a boolean if a field has been set.
func (o *ProcessRequest) HasMetaData() bool {
	if o != nil && !isNil(o.MetaData) {
		return true
	}

	return false
}

// SetMetaData gets a reference to the given map[string]string and assigns it to the MetaData field.
func (o *ProcessRequest) SetMetaData(v map[string]string) {
	o.MetaData = &v
}

func (o ProcessRequest) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ProcessRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["data"] = o.Data
	if !isNil(o.Encoding) {
		toSerialize["encoding"] = o.Encoding
	}
	if !isNil(o.MetaData) {
		toSerialize["metaData"] = o.MetaData
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ProcessRequest) UnmarshalJSON(bytes []byte) (err error) {
	varProcessRequest := _ProcessRequest{}

	if err = json.Unmarshal(bytes, &varProcessRequest); err == nil {
		*o = ProcessRequest(varProcessRequest)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "data")
		delete(additionalProperties, "encoding")
		delete(additionalProperties, "metaData")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableProcessRequest struct {
	value *ProcessRequest
	isSet bool
}

func (v NullableProcessRequest) Get() *ProcessRequest {
	return v.value
}

func (v *NullableProcessRequest) Set(val *ProcessRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableProcessRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableProcessRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableProcessRequest(val *ProcessRequest) *NullableProcessRequest {
	return &NullableProcessRequest{value: val, isSet: true}
}

func (v NullableProcessRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableProcessRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
