/*
Copyright 2022 Keyfactor
Licensed under the Apache License, Version 2.0 (the "License"); you may
not use this file except in compliance with the License.  You may obtain a
copy of the License at http://www.apache.org/licenses/LICENSE-2.0.  Unless
required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
OR CONDITIONS OF ANY KIND, either express or implied. See the License for
thespecific language governing permissions and limitations under the
License.

SignServer REST Interface

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package signserver

import (
	"encoding/json"
)

// checks if the ProcessResponse type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ProcessResponse{}

// ProcessResponse POJO that represents a process response.
type ProcessResponse struct {
	// The resulting data (i.e the signature) in Base64 encoding
	Data                 *string            `json:"data,omitempty"`
	RequestId            *string            `json:"requestId,omitempty"`
	ArchiveId            *string            `json:"archiveId,omitempty"`
	SignerCertificate    *string            `json:"signerCertificate,omitempty"`
	MetaData             *map[string]string `json:"metaData,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _ProcessResponse ProcessResponse

// NewProcessResponse instantiates a new ProcessResponse object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewProcessResponse() *ProcessResponse {
	this := ProcessResponse{}
	return &this
}

// NewProcessResponseWithDefaults instantiates a new ProcessResponse object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewProcessResponseWithDefaults() *ProcessResponse {
	this := ProcessResponse{}
	return &this
}

// GetData returns the Data field value if set, zero value otherwise.
func (o *ProcessResponse) GetData() string {
	if o == nil || isNil(o.Data) {
		var ret string
		return ret
	}
	return *o.Data
}

// GetDataOk returns a tuple with the Data field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProcessResponse) GetDataOk() (*string, bool) {
	if o == nil || isNil(o.Data) {
		return nil, false
	}
	return o.Data, true
}

// HasData returns a boolean if a field has been set.
func (o *ProcessResponse) HasData() bool {
	if o != nil && !isNil(o.Data) {
		return true
	}

	return false
}

// SetData gets a reference to the given string and assigns it to the Data field.
func (o *ProcessResponse) SetData(v string) {
	o.Data = &v
}

// GetRequestId returns the RequestId field value if set, zero value otherwise.
func (o *ProcessResponse) GetRequestId() string {
	if o == nil || isNil(o.RequestId) {
		var ret string
		return ret
	}
	return *o.RequestId
}

// GetRequestIdOk returns a tuple with the RequestId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProcessResponse) GetRequestIdOk() (*string, bool) {
	if o == nil || isNil(o.RequestId) {
		return nil, false
	}
	return o.RequestId, true
}

// HasRequestId returns a boolean if a field has been set.
func (o *ProcessResponse) HasRequestId() bool {
	if o != nil && !isNil(o.RequestId) {
		return true
	}

	return false
}

// SetRequestId gets a reference to the given string and assigns it to the RequestId field.
func (o *ProcessResponse) SetRequestId(v string) {
	o.RequestId = &v
}

// GetArchiveId returns the ArchiveId field value if set, zero value otherwise.
func (o *ProcessResponse) GetArchiveId() string {
	if o == nil || isNil(o.ArchiveId) {
		var ret string
		return ret
	}
	return *o.ArchiveId
}

// GetArchiveIdOk returns a tuple with the ArchiveId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProcessResponse) GetArchiveIdOk() (*string, bool) {
	if o == nil || isNil(o.ArchiveId) {
		return nil, false
	}
	return o.ArchiveId, true
}

// HasArchiveId returns a boolean if a field has been set.
func (o *ProcessResponse) HasArchiveId() bool {
	if o != nil && !isNil(o.ArchiveId) {
		return true
	}

	return false
}

// SetArchiveId gets a reference to the given string and assigns it to the ArchiveId field.
func (o *ProcessResponse) SetArchiveId(v string) {
	o.ArchiveId = &v
}

// GetSignerCertificate returns the SignerCertificate field value if set, zero value otherwise.
func (o *ProcessResponse) GetSignerCertificate() string {
	if o == nil || isNil(o.SignerCertificate) {
		var ret string
		return ret
	}
	return *o.SignerCertificate
}

// GetSignerCertificateOk returns a tuple with the SignerCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProcessResponse) GetSignerCertificateOk() (*string, bool) {
	if o == nil || isNil(o.SignerCertificate) {
		return nil, false
	}
	return o.SignerCertificate, true
}

// HasSignerCertificate returns a boolean if a field has been set.
func (o *ProcessResponse) HasSignerCertificate() bool {
	if o != nil && !isNil(o.SignerCertificate) {
		return true
	}

	return false
}

// SetSignerCertificate gets a reference to the given string and assigns it to the SignerCertificate field.
func (o *ProcessResponse) SetSignerCertificate(v string) {
	o.SignerCertificate = &v
}

// GetMetaData returns the MetaData field value if set, zero value otherwise.
func (o *ProcessResponse) GetMetaData() map[string]string {
	if o == nil || isNil(o.MetaData) {
		var ret map[string]string
		return ret
	}
	return *o.MetaData
}

// GetMetaDataOk returns a tuple with the MetaData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ProcessResponse) GetMetaDataOk() (*map[string]string, bool) {
	if o == nil || isNil(o.MetaData) {
		return nil, false
	}
	return o.MetaData, true
}

// HasMetaData returns a boolean if a field has been set.
func (o *ProcessResponse) HasMetaData() bool {
	if o != nil && !isNil(o.MetaData) {
		return true
	}

	return false
}

// SetMetaData gets a reference to the given map[string]string and assigns it to the MetaData field.
func (o *ProcessResponse) SetMetaData(v map[string]string) {
	o.MetaData = &v
}

func (o ProcessResponse) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ProcessResponse) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !isNil(o.Data) {
		toSerialize["data"] = o.Data
	}
	if !isNil(o.RequestId) {
		toSerialize["requestId"] = o.RequestId
	}
	if !isNil(o.ArchiveId) {
		toSerialize["archiveId"] = o.ArchiveId
	}
	if !isNil(o.SignerCertificate) {
		toSerialize["signerCertificate"] = o.SignerCertificate
	}
	if !isNil(o.MetaData) {
		toSerialize["metaData"] = o.MetaData
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ProcessResponse) UnmarshalJSON(bytes []byte) (err error) {
	varProcessResponse := _ProcessResponse{}

	if err = json.Unmarshal(bytes, &varProcessResponse); err == nil {
		*o = ProcessResponse(varProcessResponse)
	}

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(bytes, &additionalProperties); err == nil {
		delete(additionalProperties, "data")
		delete(additionalProperties, "requestId")
		delete(additionalProperties, "archiveId")
		delete(additionalProperties, "signerCertificate")
		delete(additionalProperties, "metaData")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableProcessResponse struct {
	value *ProcessResponse
	isSet bool
}

func (v NullableProcessResponse) Get() *ProcessResponse {
	return v.value
}

func (v *NullableProcessResponse) Set(val *ProcessResponse) {
	v.value = val
	v.isSet = true
}

func (v NullableProcessResponse) IsSet() bool {
	return v.isSet
}

func (v *NullableProcessResponse) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableProcessResponse(val *ProcessResponse) *NullableProcessResponse {
	return &NullableProcessResponse{value: val, isSet: true}
}

func (v NullableProcessResponse) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableProcessResponse) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
