/*
Copyright 2022 Keyfactor
Licensed under the Apache License, Version 2.0 (the "License"); you may
not use this file except in compliance with the License.  You may obtain a
copy of the License at http://www.apache.org/licenses/LICENSE-2.0.  Unless
required by applicable law or agreed to in writing, software distributed
under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
OR CONDITIONS OF ANY KIND, either express or implied. See the License for
thespecific language governing permissions and limitations under the
License.

SignServer REST Interface

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 1.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package signserver

import (
	"encoding/json"
	"fmt"
)

// DataEncoding Choice of additional encoding of the data.
type DataEncoding string

// List of DataEncoding
const (
	NONE   DataEncoding = "NONE"
	BASE64 DataEncoding = "BASE64"
)

// All allowed values of DataEncoding enum
var AllowedDataEncodingEnumValues = []DataEncoding{
	"NONE",
	"BASE64",
}

func (v *DataEncoding) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := DataEncoding(value)
	for _, existing := range AllowedDataEncodingEnumValues {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid DataEncoding", value)
}

// NewDataEncodingFromValue returns a pointer to a valid DataEncoding
// for the value passed as argument, or an error if the value passed is not allowed by the enum
func NewDataEncodingFromValue(v string) (*DataEncoding, error) {
	ev := DataEncoding(v)
	if ev.IsValid() {
		return &ev, nil
	} else {
		return nil, fmt.Errorf("invalid value '%v' for DataEncoding: valid values are %v", v, AllowedDataEncodingEnumValues)
	}
}

// IsValid return true if the value is valid for the enum, false otherwise
func (v DataEncoding) IsValid() bool {
	for _, existing := range AllowedDataEncodingEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to DataEncoding value
func (v DataEncoding) Ptr() *DataEncoding {
	return &v
}

type NullableDataEncoding struct {
	value *DataEncoding
	isSet bool
}

func (v NullableDataEncoding) Get() *DataEncoding {
	return v.value
}

func (v *NullableDataEncoding) Set(val *DataEncoding) {
	v.value = val
	v.isSet = true
}

func (v NullableDataEncoding) IsSet() bool {
	return v.isSet
}

func (v *NullableDataEncoding) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDataEncoding(val *DataEncoding) *NullableDataEncoding {
	return &NullableDataEncoding{value: val, isSet: true}
}

func (v NullableDataEncoding) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDataEncoding) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
