// Copyright 2024 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

package model

type SearchParams struct {
	Page      int               `json:"page"`
	PerPage   int               `json:"per_page"`
	Filters   []FilterPredicate `json:"filters"`
	DeviceIDs []string          `json:"device_ids"`
}

type Filter struct {
	Id    string            `json:"id" bson:"_id"`
	Name  string            `json:"name" bson:"name"`
	Terms []FilterPredicate `json:"terms" bson:"terms"`
}

type FilterPredicate struct {
	Scope     string      `json:"scope" bson:"scope"`
	Attribute string      `json:"attribute" bson:"attribute"`
	Type      string      `json:"type" bson:"type"`
	Value     interface{} `json:"value" bson:"value"`
}
