// Copyright 2022 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

// Code generated by mockery v2.45.1. DO NOT EDIT.

package mocks

import (
	context "context"

	iothub "github.com/mendersoftware/mender-server/services/iot-manager/client/iothub"
	mock "github.com/stretchr/testify/mock"

	model "github.com/mendersoftware/mender-server/services/iot-manager/model"
)

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// DeleteDevice provides a mock function with given fields: ctx, cs, id
func (_m *Client) DeleteDevice(ctx context.Context, cs *model.ConnectionString, id string) error {
	ret := _m.Called(ctx, cs, id)

	if len(ret) == 0 {
		panic("no return value specified for DeleteDevice")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.ConnectionString, string) error); ok {
		r0 = rf(ctx, cs, id)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetDevice provides a mock function with given fields: ctx, cs, id
func (_m *Client) GetDevice(ctx context.Context, cs *model.ConnectionString, id string) (*iothub.Device, error) {
	ret := _m.Called(ctx, cs, id)

	if len(ret) == 0 {
		panic("no return value specified for GetDevice")
	}

	var r0 *iothub.Device
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.ConnectionString, string) (*iothub.Device, error)); ok {
		return rf(ctx, cs, id)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *model.ConnectionString, string) *iothub.Device); ok {
		r0 = rf(ctx, cs, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*iothub.Device)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *model.ConnectionString, string) error); ok {
		r1 = rf(ctx, cs, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDeviceTwin provides a mock function with given fields: ctx, cs, id
func (_m *Client) GetDeviceTwin(ctx context.Context, cs *model.ConnectionString, id string) (*iothub.DeviceTwin, error) {
	ret := _m.Called(ctx, cs, id)

	if len(ret) == 0 {
		panic("no return value specified for GetDeviceTwin")
	}

	var r0 *iothub.DeviceTwin
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.ConnectionString, string) (*iothub.DeviceTwin, error)); ok {
		return rf(ctx, cs, id)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *model.ConnectionString, string) *iothub.DeviceTwin); ok {
		r0 = rf(ctx, cs, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*iothub.DeviceTwin)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *model.ConnectionString, string) error); ok {
		r1 = rf(ctx, cs, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDeviceTwins provides a mock function with given fields: ctx, cs, deviceIDs
func (_m *Client) GetDeviceTwins(ctx context.Context, cs *model.ConnectionString, deviceIDs []string) ([]iothub.DeviceTwin, error) {
	ret := _m.Called(ctx, cs, deviceIDs)

	if len(ret) == 0 {
		panic("no return value specified for GetDeviceTwins")
	}

	var r0 []iothub.DeviceTwin
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.ConnectionString, []string) ([]iothub.DeviceTwin, error)); ok {
		return rf(ctx, cs, deviceIDs)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *model.ConnectionString, []string) []iothub.DeviceTwin); ok {
		r0 = rf(ctx, cs, deviceIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]iothub.DeviceTwin)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *model.ConnectionString, []string) error); ok {
		r1 = rf(ctx, cs, deviceIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateDeviceTwin provides a mock function with given fields: ctx, cs, id, r
func (_m *Client) UpdateDeviceTwin(ctx context.Context, cs *model.ConnectionString, id string, r *iothub.DeviceTwinUpdate) error {
	ret := _m.Called(ctx, cs, id, r)

	if len(ret) == 0 {
		panic("no return value specified for UpdateDeviceTwin")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.ConnectionString, string, *iothub.DeviceTwinUpdate) error); ok {
		r0 = rf(ctx, cs, id, r)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpsertDevice provides a mock function with given fields: ctx, cs, id, deviceUpdate
func (_m *Client) UpsertDevice(ctx context.Context, cs *model.ConnectionString, id string, deviceUpdate ...*iothub.Device) (*iothub.Device, error) {
	_va := make([]interface{}, len(deviceUpdate))
	for _i := range deviceUpdate {
		_va[_i] = deviceUpdate[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, ctx, cs, id)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for UpsertDevice")
	}

	var r0 *iothub.Device
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.ConnectionString, string, ...*iothub.Device) (*iothub.Device, error)); ok {
		return rf(ctx, cs, id, deviceUpdate...)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *model.ConnectionString, string, ...*iothub.Device) *iothub.Device); ok {
		r0 = rf(ctx, cs, id, deviceUpdate...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*iothub.Device)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *model.ConnectionString, string, ...*iothub.Device) error); ok {
		r1 = rf(ctx, cs, id, deviceUpdate...)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NewClient creates a new instance of Client. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewClient(t interface {
	mock.TestingT
	Cleanup(func())
}) *Client {
	mock := &Client{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
