// Copyright 2023 Northern.tech AS
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//	See the License for the specific language governing permissions and
//	limitations under the License.
package model

import (
	"strings"
)

const (
	runeDot = '\uFF0E'
)

var (
	dedotter = strings.NewReplacer(".", string(runeDot))
	redotter = strings.NewReplacer(string(runeDot), ".")
)

// Dedot replaces '.' in a name to make it digestible by ES
func Dedot(name string) string {
	return dedotter.Replace(name)
}

// Redot reverses dedotting
func Redot(name string) string {
	return redotter.Replace(name)
}
