// Copyright 2023 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

// Code generated by mockery v2.45.1. DO NOT EDIT.

package mocks

import (
	context "context"

	jwt "github.com/mendersoftware/mender-server/services/useradm/jwt"
	mock "github.com/stretchr/testify/mock"

	model "github.com/mendersoftware/mender-server/services/useradm/model"

	oid "github.com/mendersoftware/mender-server/pkg/mongo/oid"
)

// DataStore is an autogenerated mock type for the DataStore type
type DataStore struct {
	mock.Mock
}

// CountPersonalAccessTokens provides a mock function with given fields: ctx, userID
func (_m *DataStore) CountPersonalAccessTokens(ctx context.Context, userID string) (int64, error) {
	ret := _m.Called(ctx, userID)

	if len(ret) == 0 {
		panic("no return value specified for CountPersonalAccessTokens")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string) (int64, error)); ok {
		return rf(ctx, userID)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string) int64); ok {
		r0 = rf(ctx, userID)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateUser provides a mock function with given fields: ctx, u
func (_m *DataStore) CreateUser(ctx context.Context, u *model.User) error {
	ret := _m.Called(ctx, u)

	if len(ret) == 0 {
		panic("no return value specified for CreateUser")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.User) error); ok {
		r0 = rf(ctx, u)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteToken provides a mock function with given fields: ctx, userID, tokenID
func (_m *DataStore) DeleteToken(ctx context.Context, userID oid.ObjectID, tokenID oid.ObjectID) error {
	ret := _m.Called(ctx, userID, tokenID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteToken")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, oid.ObjectID, oid.ObjectID) error); ok {
		r0 = rf(ctx, userID, tokenID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteTokens provides a mock function with given fields: ctx
func (_m *DataStore) DeleteTokens(ctx context.Context) error {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for DeleteTokens")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteTokensByUserId provides a mock function with given fields: ctx, userId
func (_m *DataStore) DeleteTokensByUserId(ctx context.Context, userId string) error {
	ret := _m.Called(ctx, userId)

	if len(ret) == 0 {
		panic("no return value specified for DeleteTokensByUserId")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, userId)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteTokensByUserIdExceptCurrentOne provides a mock function with given fields: ctx, userId, tokenID
func (_m *DataStore) DeleteTokensByUserIdExceptCurrentOne(ctx context.Context, userId string, tokenID oid.ObjectID) error {
	ret := _m.Called(ctx, userId, tokenID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteTokensByUserIdExceptCurrentOne")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, oid.ObjectID) error); ok {
		r0 = rf(ctx, userId, tokenID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteUser provides a mock function with given fields: ctx, id
func (_m *DataStore) DeleteUser(ctx context.Context, id string) error {
	ret := _m.Called(ctx, id)

	if len(ret) == 0 {
		panic("no return value specified for DeleteUser")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, id)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// EnsureSessionTokensLimit provides a mock function with given fields: ctx, userID, sessionsLimit
func (_m *DataStore) EnsureSessionTokensLimit(ctx context.Context, userID oid.ObjectID, sessionsLimit int) error {
	ret := _m.Called(ctx, userID, sessionsLimit)

	if len(ret) == 0 {
		panic("no return value specified for EnsureSessionTokensLimit")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, oid.ObjectID, int) error); ok {
		r0 = rf(ctx, userID, sessionsLimit)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetPersonalAccessTokens provides a mock function with given fields: ctx, userID
func (_m *DataStore) GetPersonalAccessTokens(ctx context.Context, userID string) ([]model.PersonalAccessToken, error) {
	ret := _m.Called(ctx, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetPersonalAccessTokens")
	}

	var r0 []model.PersonalAccessToken
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string) ([]model.PersonalAccessToken, error)); ok {
		return rf(ctx, userID)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string) []model.PersonalAccessToken); ok {
		r0 = rf(ctx, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.PersonalAccessToken)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSettings provides a mock function with given fields: ctx
func (_m *DataStore) GetSettings(ctx context.Context) (*model.Settings, error) {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for GetSettings")
	}

	var r0 *model.Settings
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context) (*model.Settings, error)); ok {
		return rf(ctx)
	}
	if rf, ok := ret.Get(0).(func(context.Context) *model.Settings); ok {
		r0 = rf(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Settings)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(ctx)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTokenById provides a mock function with given fields: ctx, id
func (_m *DataStore) GetTokenById(ctx context.Context, id oid.ObjectID) (*jwt.Token, error) {
	ret := _m.Called(ctx, id)

	if len(ret) == 0 {
		panic("no return value specified for GetTokenById")
	}

	var r0 *jwt.Token
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, oid.ObjectID) (*jwt.Token, error)); ok {
		return rf(ctx, id)
	}
	if rf, ok := ret.Get(0).(func(context.Context, oid.ObjectID) *jwt.Token); ok {
		r0 = rf(ctx, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*jwt.Token)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, oid.ObjectID) error); ok {
		r1 = rf(ctx, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserAndPasswordById provides a mock function with given fields: ctx, id
func (_m *DataStore) GetUserAndPasswordById(ctx context.Context, id string) (*model.User, error) {
	ret := _m.Called(ctx, id)

	if len(ret) == 0 {
		panic("no return value specified for GetUserAndPasswordById")
	}

	var r0 *model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string) (*model.User, error)); ok {
		return rf(ctx, id)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string) *model.User); ok {
		r0 = rf(ctx, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserByEmail provides a mock function with given fields: ctx, email
func (_m *DataStore) GetUserByEmail(ctx context.Context, email model.Email) (*model.User, error) {
	ret := _m.Called(ctx, email)

	if len(ret) == 0 {
		panic("no return value specified for GetUserByEmail")
	}

	var r0 *model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, model.Email) (*model.User, error)); ok {
		return rf(ctx, email)
	}
	if rf, ok := ret.Get(0).(func(context.Context, model.Email) *model.User); ok {
		r0 = rf(ctx, email)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, model.Email) error); ok {
		r1 = rf(ctx, email)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserById provides a mock function with given fields: ctx, id
func (_m *DataStore) GetUserById(ctx context.Context, id string) (*model.User, error) {
	ret := _m.Called(ctx, id)

	if len(ret) == 0 {
		panic("no return value specified for GetUserById")
	}

	var r0 *model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string) (*model.User, error)); ok {
		return rf(ctx, id)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string) *model.User); ok {
		r0 = rf(ctx, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserSettings provides a mock function with given fields: ctx, userID
func (_m *DataStore) GetUserSettings(ctx context.Context, userID string) (*model.Settings, error) {
	ret := _m.Called(ctx, userID)

	if len(ret) == 0 {
		panic("no return value specified for GetUserSettings")
	}

	var r0 *model.Settings
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string) (*model.Settings, error)); ok {
		return rf(ctx, userID)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string) *model.Settings); ok {
		r0 = rf(ctx, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Settings)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUsers provides a mock function with given fields: ctx, fltr
func (_m *DataStore) GetUsers(ctx context.Context, fltr model.UserFilter) ([]model.User, error) {
	ret := _m.Called(ctx, fltr)

	if len(ret) == 0 {
		panic("no return value specified for GetUsers")
	}

	var r0 []model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, model.UserFilter) ([]model.User, error)); ok {
		return rf(ctx, fltr)
	}
	if rf, ok := ret.Get(0).(func(context.Context, model.UserFilter) []model.User); ok {
		r0 = rf(ctx, fltr)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, model.UserFilter) error); ok {
		r1 = rf(ctx, fltr)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Ping provides a mock function with given fields: ctx
func (_m *DataStore) Ping(ctx context.Context) error {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for Ping")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SaveSettings provides a mock function with given fields: ctx, s, etag
func (_m *DataStore) SaveSettings(ctx context.Context, s *model.Settings, etag string) error {
	ret := _m.Called(ctx, s, etag)

	if len(ret) == 0 {
		panic("no return value specified for SaveSettings")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.Settings, string) error); ok {
		r0 = rf(ctx, s, etag)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SaveToken provides a mock function with given fields: ctx, token
func (_m *DataStore) SaveToken(ctx context.Context, token *jwt.Token) error {
	ret := _m.Called(ctx, token)

	if len(ret) == 0 {
		panic("no return value specified for SaveToken")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *jwt.Token) error); ok {
		r0 = rf(ctx, token)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SaveUserSettings provides a mock function with given fields: ctx, userID, s, etag
func (_m *DataStore) SaveUserSettings(ctx context.Context, userID string, s *model.Settings, etag string) error {
	ret := _m.Called(ctx, userID, s, etag)

	if len(ret) == 0 {
		panic("no return value specified for SaveUserSettings")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *model.Settings, string) error); ok {
		r0 = rf(ctx, userID, s, etag)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateLoginTs provides a mock function with given fields: ctx, id
func (_m *DataStore) UpdateLoginTs(ctx context.Context, id string) error {
	ret := _m.Called(ctx, id)

	if len(ret) == 0 {
		panic("no return value specified for UpdateLoginTs")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, id)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateTokenLastUsed provides a mock function with given fields: ctx, id
func (_m *DataStore) UpdateTokenLastUsed(ctx context.Context, id oid.ObjectID) error {
	ret := _m.Called(ctx, id)

	if len(ret) == 0 {
		panic("no return value specified for UpdateTokenLastUsed")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, oid.ObjectID) error); ok {
		r0 = rf(ctx, id)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateUser provides a mock function with given fields: ctx, id, u
func (_m *DataStore) UpdateUser(ctx context.Context, id string, u *model.UserUpdate) (*model.User, error) {
	ret := _m.Called(ctx, id, u)

	if len(ret) == 0 {
		panic("no return value specified for UpdateUser")
	}

	var r0 *model.User
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *model.UserUpdate) (*model.User, error)); ok {
		return rf(ctx, id, u)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, *model.UserUpdate) *model.User); ok {
		r0 = rf(ctx, id, u)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.User)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, *model.UserUpdate) error); ok {
		r1 = rf(ctx, id, u)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NewDataStore creates a new instance of DataStore. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewDataStore(t interface {
	mock.TestingT
	Cleanup(func())
}) *DataStore {
	mock := &DataStore{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
