// Copyright 2019 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

package http

import (
	"github.com/gin-gonic/gin"

	"github.com/mendersoftware/mender-server/services/deployments/model"
)

type RESTView interface {
	RenderSuccessGet(c *gin.Context, object interface{})
	RenderError(c *gin.Context, err error, status int)
	RenderInternalError(c *gin.Context, err error)
	RenderNoUpdateForDevice(c *gin.Context)
	RenderSuccessPost(c *gin.Context, id string)
	RenderEmptySuccessResponse(c *gin.Context)
	RenderErrorNotFound(c *gin.Context)
	RenderDeploymentLog(c *gin.Context, dlog model.DeploymentLog)
	RenderSuccessDelete(c *gin.Context)
	RenderSuccessPut(c *gin.Context)
}
