// Copyright 2021 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

// Code generated by mockery v2.45.1. DO NOT EDIT.

package mocks

import (
	context "context"

	model "github.com/mendersoftware/mender-server/services/deviceconfig/model"
	mock "github.com/stretchr/testify/mock"
)

// App is an autogenerated mock type for the App type
type App struct {
	mock.Mock
}

// DecommissionDevice provides a mock function with given fields: ctx, devID
func (_m *App) DecommissionDevice(ctx context.Context, devID string) error {
	ret := _m.Called(ctx, devID)

	if len(ret) == 0 {
		panic("no return value specified for DecommissionDevice")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, devID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteTenant provides a mock function with given fields: ctx, tenant_id
func (_m *App) DeleteTenant(ctx context.Context, tenant_id string) error {
	ret := _m.Called(ctx, tenant_id)

	if len(ret) == 0 {
		panic("no return value specified for DeleteTenant")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, tenant_id)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeployConfiguration provides a mock function with given fields: ctx, device, request
func (_m *App) DeployConfiguration(ctx context.Context, device model.Device, request model.DeployConfigurationRequest) (model.DeployConfigurationResponse, error) {
	ret := _m.Called(ctx, device, request)

	if len(ret) == 0 {
		panic("no return value specified for DeployConfiguration")
	}

	var r0 model.DeployConfigurationResponse
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, model.Device, model.DeployConfigurationRequest) (model.DeployConfigurationResponse, error)); ok {
		return rf(ctx, device, request)
	}
	if rf, ok := ret.Get(0).(func(context.Context, model.Device, model.DeployConfigurationRequest) model.DeployConfigurationResponse); ok {
		r0 = rf(ctx, device, request)
	} else {
		r0 = ret.Get(0).(model.DeployConfigurationResponse)
	}

	if rf, ok := ret.Get(1).(func(context.Context, model.Device, model.DeployConfigurationRequest) error); ok {
		r1 = rf(ctx, device, request)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDevice provides a mock function with given fields: ctx, devID
func (_m *App) GetDevice(ctx context.Context, devID string) (model.Device, error) {
	ret := _m.Called(ctx, devID)

	if len(ret) == 0 {
		panic("no return value specified for GetDevice")
	}

	var r0 model.Device
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string) (model.Device, error)); ok {
		return rf(ctx, devID)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string) model.Device); ok {
		r0 = rf(ctx, devID)
	} else {
		r0 = ret.Get(0).(model.Device)
	}

	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, devID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// HealthCheck provides a mock function with given fields: ctx
func (_m *App) HealthCheck(ctx context.Context) error {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for HealthCheck")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ProvisionDevice provides a mock function with given fields: ctx, dev
func (_m *App) ProvisionDevice(ctx context.Context, dev model.NewDevice) error {
	ret := _m.Called(ctx, dev)

	if len(ret) == 0 {
		panic("no return value specified for ProvisionDevice")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, model.NewDevice) error); ok {
		r0 = rf(ctx, dev)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ProvisionTenant provides a mock function with given fields: ctx, tenant
func (_m *App) ProvisionTenant(ctx context.Context, tenant model.NewTenant) error {
	ret := _m.Called(ctx, tenant)

	if len(ret) == 0 {
		panic("no return value specified for ProvisionTenant")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, model.NewTenant) error); ok {
		r0 = rf(ctx, tenant)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetConfiguration provides a mock function with given fields: ctx, devID, configuration
func (_m *App) SetConfiguration(ctx context.Context, devID string, configuration model.Attributes) error {
	ret := _m.Called(ctx, devID, configuration)

	if len(ret) == 0 {
		panic("no return value specified for SetConfiguration")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, model.Attributes) error); ok {
		r0 = rf(ctx, devID, configuration)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetReportedConfiguration provides a mock function with given fields: ctx, devID, configuration
func (_m *App) SetReportedConfiguration(ctx context.Context, devID string, configuration model.Attributes) error {
	ret := _m.Called(ctx, devID, configuration)

	if len(ret) == 0 {
		panic("no return value specified for SetReportedConfiguration")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, model.Attributes) error); ok {
		r0 = rf(ctx, devID, configuration)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateConfiguration provides a mock function with given fields: ctx, devID, attrs
func (_m *App) UpdateConfiguration(ctx context.Context, devID string, attrs model.Attributes) error {
	ret := _m.Called(ctx, devID, attrs)

	if len(ret) == 0 {
		panic("no return value specified for UpdateConfiguration")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, model.Attributes) error); ok {
		r0 = rf(ctx, devID, attrs)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NewApp creates a new instance of App. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewApp(t interface {
	mock.TestingT
	Cleanup(func())
}) *App {
	mock := &App{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
