// Copyright 2023 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

// Code generated by mockery v2.45.1. DO NOT EDIT.

package mocks

import (
	context "context"

	inventory "github.com/mendersoftware/mender-server/services/reporting/client/inventory"
	mock "github.com/stretchr/testify/mock"

	model "github.com/mendersoftware/mender-server/services/reporting/model"
)

// App is an autogenerated mock type for the App type
type App struct {
	mock.Mock
}

// AggregateDeployments provides a mock function with given fields: ctx, aggregateParams
func (_m *App) AggregateDeployments(ctx context.Context, aggregateParams *model.AggregateDeploymentsParams) ([]model.DeviceAggregation, error) {
	ret := _m.Called(ctx, aggregateParams)

	if len(ret) == 0 {
		panic("no return value specified for AggregateDeployments")
	}

	var r0 []model.DeviceAggregation
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.AggregateDeploymentsParams) ([]model.DeviceAggregation, error)); ok {
		return rf(ctx, aggregateParams)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *model.AggregateDeploymentsParams) []model.DeviceAggregation); ok {
		r0 = rf(ctx, aggregateParams)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.DeviceAggregation)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *model.AggregateDeploymentsParams) error); ok {
		r1 = rf(ctx, aggregateParams)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// AggregateDevices provides a mock function with given fields: ctx, aggregateParams
func (_m *App) AggregateDevices(ctx context.Context, aggregateParams *model.AggregateParams) ([]model.DeviceAggregation, error) {
	ret := _m.Called(ctx, aggregateParams)

	if len(ret) == 0 {
		panic("no return value specified for AggregateDevices")
	}

	var r0 []model.DeviceAggregation
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.AggregateParams) ([]model.DeviceAggregation, error)); ok {
		return rf(ctx, aggregateParams)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *model.AggregateParams) []model.DeviceAggregation); ok {
		r0 = rf(ctx, aggregateParams)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.DeviceAggregation)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *model.AggregateParams) error); ok {
		r1 = rf(ctx, aggregateParams)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMapping provides a mock function with given fields: ctx, tid
func (_m *App) GetMapping(ctx context.Context, tid string) (*model.Mapping, error) {
	ret := _m.Called(ctx, tid)

	if len(ret) == 0 {
		panic("no return value specified for GetMapping")
	}

	var r0 *model.Mapping
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string) (*model.Mapping, error)); ok {
		return rf(ctx, tid)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string) *model.Mapping); ok {
		r0 = rf(ctx, tid)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Mapping)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, tid)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetSearchableInvAttrs provides a mock function with given fields: ctx, tid
func (_m *App) GetSearchableInvAttrs(ctx context.Context, tid string) ([]model.FilterAttribute, error) {
	ret := _m.Called(ctx, tid)

	if len(ret) == 0 {
		panic("no return value specified for GetSearchableInvAttrs")
	}

	var r0 []model.FilterAttribute
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string) ([]model.FilterAttribute, error)); ok {
		return rf(ctx, tid)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string) []model.FilterAttribute); ok {
		r0 = rf(ctx, tid)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.FilterAttribute)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, tid)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// HealthCheck provides a mock function with given fields: ctx
func (_m *App) HealthCheck(ctx context.Context) error {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for HealthCheck")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SearchDeployments provides a mock function with given fields: ctx, searchParams
func (_m *App) SearchDeployments(ctx context.Context, searchParams *model.DeploymentsSearchParams) ([]model.Deployment, int, error) {
	ret := _m.Called(ctx, searchParams)

	if len(ret) == 0 {
		panic("no return value specified for SearchDeployments")
	}

	var r0 []model.Deployment
	var r1 int
	var r2 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.DeploymentsSearchParams) ([]model.Deployment, int, error)); ok {
		return rf(ctx, searchParams)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *model.DeploymentsSearchParams) []model.Deployment); ok {
		r0 = rf(ctx, searchParams)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.Deployment)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *model.DeploymentsSearchParams) int); ok {
		r1 = rf(ctx, searchParams)
	} else {
		r1 = ret.Get(1).(int)
	}

	if rf, ok := ret.Get(2).(func(context.Context, *model.DeploymentsSearchParams) error); ok {
		r2 = rf(ctx, searchParams)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// SearchDevices provides a mock function with given fields: ctx, searchParams
func (_m *App) SearchDevices(ctx context.Context, searchParams *model.SearchParams) ([]inventory.Device, int, error) {
	ret := _m.Called(ctx, searchParams)

	if len(ret) == 0 {
		panic("no return value specified for SearchDevices")
	}

	var r0 []inventory.Device
	var r1 int
	var r2 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.SearchParams) ([]inventory.Device, int, error)); ok {
		return rf(ctx, searchParams)
	}
	if rf, ok := ret.Get(0).(func(context.Context, *model.SearchParams) []inventory.Device); ok {
		r0 = rf(ctx, searchParams)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]inventory.Device)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, *model.SearchParams) int); ok {
		r1 = rf(ctx, searchParams)
	} else {
		r1 = ret.Get(1).(int)
	}

	if rf, ok := ret.Get(2).(func(context.Context, *model.SearchParams) error); ok {
		r2 = rf(ctx, searchParams)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// NewApp creates a new instance of App. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewApp(t interface {
	mock.TestingT
	Cleanup(func())
}) *App {
	mock := &App{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
