import react from '@vitejs/plugin-react';
import { cpus } from 'os';
import path from 'path';
import svgr from 'vite-plugin-svgr';
import tsconfigPaths from 'vite-tsconfig-paths';
import { UserWorkspaceConfig, defineConfig } from 'vitest/config';

export default defineConfig(() => {
  const isCi = process.env.CI;
  const cpuCount = cpus().length;
  const threadCount = isCi ? cpuCount / 4 : undefined;

  return {
    plugins: [
      react(),
      svgr({
        svgrOptions: {
          ref: true,
          svgo: false,
          titleProp: true
        },
        include: '**/*.svg'
      }),
      tsconfigPaths({ root: path.resolve(__dirname) })
    ],

    resolve: {
      alias: [
        {
          find: '@northern.tech/common-ui',
          replacement: path.resolve(__dirname, 'src/js/common-ui')
        },
        {
          find: '@/testUtils',
          replacement: path.resolve(__dirname, 'tests', 'testUtils')
        }
      ]
    },
    server: {
      port: 80,
      middlewareMode: false
    },
    test: {
      coverage: {
        reporter: ['json', 'lcov'],
        reportsDirectory: 'coverage'
      },
      env: {
        BABEL_ENV: 'test',
        NODE_ENV: 'test',
        PUBLIC_URL: '',
        TZ: 'UTC'
      },
      environment: 'jsdom',
      globals: true,
      setupFiles: path.resolve(__dirname, 'tests', 'setupTests.ts'),
      fakeTimers: {
        toFake: ['setTimeout', 'clearTimeout', 'Date']
      }
    },
    pool: 'threads',
    poolOptions: {
      threads: {
        minThreads: threadCount,
        maxThreads: threadCount,
        useAtomics: true
      }
    }
  } as UserWorkspaceConfig;
});
