// Copyright 2023 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

// Code generated by mockery v2.45.1. DO NOT EDIT.

package mocks

import (
	context "context"

	model "github.com/mendersoftware/mender-server/services/inventory/model"
	mock "github.com/stretchr/testify/mock"

	store "github.com/mendersoftware/mender-server/services/inventory/store"

	time "time"
)

// DataStore is an autogenerated mock type for the DataStore type
type DataStore struct {
	mock.Mock
}

// AddDevice provides a mock function with given fields: ctx, dev
func (_m *DataStore) AddDevice(ctx context.Context, dev *model.Device) error {
	ret := _m.Called(ctx, dev)

	if len(ret) == 0 {
		panic("no return value specified for AddDevice")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.Device) error); ok {
		r0 = rf(ctx, dev)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteDevices provides a mock function with given fields: ctx, ids
func (_m *DataStore) DeleteDevices(ctx context.Context, ids []model.DeviceID) (*model.UpdateResult, error) {
	ret := _m.Called(ctx, ids)

	if len(ret) == 0 {
		panic("no return value specified for DeleteDevices")
	}

	var r0 *model.UpdateResult
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceID) (*model.UpdateResult, error)); ok {
		return rf(ctx, ids)
	}
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceID) *model.UpdateResult); ok {
		r0 = rf(ctx, ids)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UpdateResult)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, []model.DeviceID) error); ok {
		r1 = rf(ctx, ids)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteGroup provides a mock function with given fields: ctx, group
func (_m *DataStore) DeleteGroup(ctx context.Context, group model.GroupName) (chan model.DeviceID, error) {
	ret := _m.Called(ctx, group)

	if len(ret) == 0 {
		panic("no return value specified for DeleteGroup")
	}

	var r0 chan model.DeviceID
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, model.GroupName) (chan model.DeviceID, error)); ok {
		return rf(ctx, group)
	}
	if rf, ok := ret.Get(0).(func(context.Context, model.GroupName) chan model.DeviceID); ok {
		r0 = rf(ctx, group)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(chan model.DeviceID)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, model.GroupName) error); ok {
		r1 = rf(ctx, group)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetAllAttributeNames provides a mock function with given fields: ctx
func (_m *DataStore) GetAllAttributeNames(ctx context.Context) ([]string, error) {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for GetAllAttributeNames")
	}

	var r0 []string
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context) ([]string, error)); ok {
		return rf(ctx)
	}
	if rf, ok := ret.Get(0).(func(context.Context) []string); ok {
		r0 = rf(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]string)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(ctx)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDevice provides a mock function with given fields: ctx, id
func (_m *DataStore) GetDevice(ctx context.Context, id model.DeviceID) (*model.Device, error) {
	ret := _m.Called(ctx, id)

	if len(ret) == 0 {
		panic("no return value specified for GetDevice")
	}

	var r0 *model.Device
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, model.DeviceID) (*model.Device, error)); ok {
		return rf(ctx, id)
	}
	if rf, ok := ret.Get(0).(func(context.Context, model.DeviceID) *model.Device); ok {
		r0 = rf(ctx, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Device)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, model.DeviceID) error); ok {
		r1 = rf(ctx, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDeviceGroup provides a mock function with given fields: ctx, id
func (_m *DataStore) GetDeviceGroup(ctx context.Context, id model.DeviceID) (model.GroupName, error) {
	ret := _m.Called(ctx, id)

	if len(ret) == 0 {
		panic("no return value specified for GetDeviceGroup")
	}

	var r0 model.GroupName
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, model.DeviceID) (model.GroupName, error)); ok {
		return rf(ctx, id)
	}
	if rf, ok := ret.Get(0).(func(context.Context, model.DeviceID) model.GroupName); ok {
		r0 = rf(ctx, id)
	} else {
		r0 = ret.Get(0).(model.GroupName)
	}

	if rf, ok := ret.Get(1).(func(context.Context, model.DeviceID) error); ok {
		r1 = rf(ctx, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDevices provides a mock function with given fields: ctx, q
func (_m *DataStore) GetDevices(ctx context.Context, q store.ListQuery) ([]model.Device, int, error) {
	ret := _m.Called(ctx, q)

	if len(ret) == 0 {
		panic("no return value specified for GetDevices")
	}

	var r0 []model.Device
	var r1 int
	var r2 error
	if rf, ok := ret.Get(0).(func(context.Context, store.ListQuery) ([]model.Device, int, error)); ok {
		return rf(ctx, q)
	}
	if rf, ok := ret.Get(0).(func(context.Context, store.ListQuery) []model.Device); ok {
		r0 = rf(ctx, q)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.Device)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, store.ListQuery) int); ok {
		r1 = rf(ctx, q)
	} else {
		r1 = ret.Get(1).(int)
	}

	if rf, ok := ret.Get(2).(func(context.Context, store.ListQuery) error); ok {
		r2 = rf(ctx, q)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// GetDevicesByGroup provides a mock function with given fields: ctx, group, skip, limit
func (_m *DataStore) GetDevicesByGroup(ctx context.Context, group model.GroupName, skip int, limit int) ([]model.DeviceID, int, error) {
	ret := _m.Called(ctx, group, skip, limit)

	if len(ret) == 0 {
		panic("no return value specified for GetDevicesByGroup")
	}

	var r0 []model.DeviceID
	var r1 int
	var r2 error
	if rf, ok := ret.Get(0).(func(context.Context, model.GroupName, int, int) ([]model.DeviceID, int, error)); ok {
		return rf(ctx, group, skip, limit)
	}
	if rf, ok := ret.Get(0).(func(context.Context, model.GroupName, int, int) []model.DeviceID); ok {
		r0 = rf(ctx, group, skip, limit)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.DeviceID)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, model.GroupName, int, int) int); ok {
		r1 = rf(ctx, group, skip, limit)
	} else {
		r1 = ret.Get(1).(int)
	}

	if rf, ok := ret.Get(2).(func(context.Context, model.GroupName, int, int) error); ok {
		r2 = rf(ctx, group, skip, limit)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// GetFiltersAttributes provides a mock function with given fields: ctx
func (_m *DataStore) GetFiltersAttributes(ctx context.Context) ([]model.FilterAttribute, error) {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for GetFiltersAttributes")
	}

	var r0 []model.FilterAttribute
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context) ([]model.FilterAttribute, error)); ok {
		return rf(ctx)
	}
	if rf, ok := ret.Get(0).(func(context.Context) []model.FilterAttribute); ok {
		r0 = rf(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.FilterAttribute)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(ctx)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListGroups provides a mock function with given fields: ctx, filters
func (_m *DataStore) ListGroups(ctx context.Context, filters []model.FilterPredicate) ([]model.GroupName, error) {
	ret := _m.Called(ctx, filters)

	if len(ret) == 0 {
		panic("no return value specified for ListGroups")
	}

	var r0 []model.GroupName
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, []model.FilterPredicate) ([]model.GroupName, error)); ok {
		return rf(ctx, filters)
	}
	if rf, ok := ret.Get(0).(func(context.Context, []model.FilterPredicate) []model.GroupName); ok {
		r0 = rf(ctx, filters)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.GroupName)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, []model.FilterPredicate) error); ok {
		r1 = rf(ctx, filters)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Maintenance provides a mock function with given fields: ctx, version, tenantIDs
func (_m *DataStore) Maintenance(ctx context.Context, version string, tenantIDs ...string) error {
	_va := make([]interface{}, len(tenantIDs))
	for _i := range tenantIDs {
		_va[_i] = tenantIDs[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, ctx, version)
	_ca = append(_ca, _va...)
	ret := _m.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for Maintenance")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, ...string) error); ok {
		r0 = rf(ctx, version, tenantIDs...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Migrate provides a mock function with given fields: ctx, version
func (_m *DataStore) Migrate(ctx context.Context, version string) error {
	ret := _m.Called(ctx, version)

	if len(ret) == 0 {
		panic("no return value specified for Migrate")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, version)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// MigrateTenant provides a mock function with given fields: ctx, version, tenantId
func (_m *DataStore) MigrateTenant(ctx context.Context, version string, tenantId string) error {
	ret := _m.Called(ctx, version, tenantId)

	if len(ret) == 0 {
		panic("no return value specified for MigrateTenant")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string) error); ok {
		r0 = rf(ctx, version, tenantId)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Ping provides a mock function with given fields: ctx
func (_m *DataStore) Ping(ctx context.Context) error {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for Ping")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SearchDevices provides a mock function with given fields: ctx, searchParams
func (_m *DataStore) SearchDevices(ctx context.Context, searchParams model.SearchParams) ([]model.Device, int, error) {
	ret := _m.Called(ctx, searchParams)

	if len(ret) == 0 {
		panic("no return value specified for SearchDevices")
	}

	var r0 []model.Device
	var r1 int
	var r2 error
	if rf, ok := ret.Get(0).(func(context.Context, model.SearchParams) ([]model.Device, int, error)); ok {
		return rf(ctx, searchParams)
	}
	if rf, ok := ret.Get(0).(func(context.Context, model.SearchParams) []model.Device); ok {
		r0 = rf(ctx, searchParams)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]model.Device)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, model.SearchParams) int); ok {
		r1 = rf(ctx, searchParams)
	} else {
		r1 = ret.Get(1).(int)
	}

	if rf, ok := ret.Get(2).(func(context.Context, model.SearchParams) error); ok {
		r2 = rf(ctx, searchParams)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// UnsetDevicesGroup provides a mock function with given fields: ctx, deviceIDs, group
func (_m *DataStore) UnsetDevicesGroup(ctx context.Context, deviceIDs []model.DeviceID, group model.GroupName) (*model.UpdateResult, error) {
	ret := _m.Called(ctx, deviceIDs, group)

	if len(ret) == 0 {
		panic("no return value specified for UnsetDevicesGroup")
	}

	var r0 *model.UpdateResult
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceID, model.GroupName) (*model.UpdateResult, error)); ok {
		return rf(ctx, deviceIDs, group)
	}
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceID, model.GroupName) *model.UpdateResult); ok {
		r0 = rf(ctx, deviceIDs, group)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UpdateResult)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, []model.DeviceID, model.GroupName) error); ok {
		r1 = rf(ctx, deviceIDs, group)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateDeviceText provides a mock function with given fields: ctx, id, text
func (_m *DataStore) UpdateDeviceText(ctx context.Context, id model.DeviceID, text string) error {
	ret := _m.Called(ctx, id, text)

	if len(ret) == 0 {
		panic("no return value specified for UpdateDeviceText")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, model.DeviceID, string) error); ok {
		r0 = rf(ctx, id, text)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UpdateDevicesGroup provides a mock function with given fields: ctx, devIDs, group
func (_m *DataStore) UpdateDevicesGroup(ctx context.Context, devIDs []model.DeviceID, group model.GroupName) (*model.UpdateResult, error) {
	ret := _m.Called(ctx, devIDs, group)

	if len(ret) == 0 {
		panic("no return value specified for UpdateDevicesGroup")
	}

	var r0 *model.UpdateResult
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceID, model.GroupName) (*model.UpdateResult, error)); ok {
		return rf(ctx, devIDs, group)
	}
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceID, model.GroupName) *model.UpdateResult); ok {
		r0 = rf(ctx, devIDs, group)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UpdateResult)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, []model.DeviceID, model.GroupName) error); ok {
		r1 = rf(ctx, devIDs, group)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpsertDevicesAttributes provides a mock function with given fields: ctx, ids, attrs, notModifiedAfter
func (_m *DataStore) UpsertDevicesAttributes(ctx context.Context, ids []model.DeviceID, attrs model.DeviceAttributes, notModifiedAfter *time.Time) (*model.UpdateResult, error) {
	ret := _m.Called(ctx, ids, attrs, notModifiedAfter)

	if len(ret) == 0 {
		panic("no return value specified for UpsertDevicesAttributes")
	}

	var r0 *model.UpdateResult
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceID, model.DeviceAttributes, *time.Time) (*model.UpdateResult, error)); ok {
		return rf(ctx, ids, attrs, notModifiedAfter)
	}
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceID, model.DeviceAttributes, *time.Time) *model.UpdateResult); ok {
		r0 = rf(ctx, ids, attrs, notModifiedAfter)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UpdateResult)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, []model.DeviceID, model.DeviceAttributes, *time.Time) error); ok {
		r1 = rf(ctx, ids, attrs, notModifiedAfter)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpsertDevicesAttributesWithRevision provides a mock function with given fields: ctx, ids, attrs
func (_m *DataStore) UpsertDevicesAttributesWithRevision(ctx context.Context, ids []model.DeviceUpdate, attrs model.DeviceAttributes) (*model.UpdateResult, error) {
	ret := _m.Called(ctx, ids, attrs)

	if len(ret) == 0 {
		panic("no return value specified for UpsertDevicesAttributesWithRevision")
	}

	var r0 *model.UpdateResult
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceUpdate, model.DeviceAttributes) (*model.UpdateResult, error)); ok {
		return rf(ctx, ids, attrs)
	}
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceUpdate, model.DeviceAttributes) *model.UpdateResult); ok {
		r0 = rf(ctx, ids, attrs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UpdateResult)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, []model.DeviceUpdate, model.DeviceAttributes) error); ok {
		r1 = rf(ctx, ids, attrs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpsertDevicesAttributesWithUpdated provides a mock function with given fields: ctx, ids, attrs, scope, etag
func (_m *DataStore) UpsertDevicesAttributesWithUpdated(ctx context.Context, ids []model.DeviceID, attrs model.DeviceAttributes, scope string, etag string) (*model.UpdateResult, error) {
	ret := _m.Called(ctx, ids, attrs, scope, etag)

	if len(ret) == 0 {
		panic("no return value specified for UpsertDevicesAttributesWithUpdated")
	}

	var r0 *model.UpdateResult
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceID, model.DeviceAttributes, string, string) (*model.UpdateResult, error)); ok {
		return rf(ctx, ids, attrs, scope, etag)
	}
	if rf, ok := ret.Get(0).(func(context.Context, []model.DeviceID, model.DeviceAttributes, string, string) *model.UpdateResult); ok {
		r0 = rf(ctx, ids, attrs, scope, etag)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UpdateResult)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, []model.DeviceID, model.DeviceAttributes, string, string) error); ok {
		r1 = rf(ctx, ids, attrs, scope, etag)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpsertRemoveDeviceAttributes provides a mock function with given fields: ctx, id, updateAttrs, removeAttrs, scope, etag
func (_m *DataStore) UpsertRemoveDeviceAttributes(ctx context.Context, id model.DeviceID, updateAttrs model.DeviceAttributes, removeAttrs model.DeviceAttributes, scope string, etag string) (*model.UpdateResult, error) {
	ret := _m.Called(ctx, id, updateAttrs, removeAttrs, scope, etag)

	if len(ret) == 0 {
		panic("no return value specified for UpsertRemoveDeviceAttributes")
	}

	var r0 *model.UpdateResult
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, model.DeviceID, model.DeviceAttributes, model.DeviceAttributes, string, string) (*model.UpdateResult, error)); ok {
		return rf(ctx, id, updateAttrs, removeAttrs, scope, etag)
	}
	if rf, ok := ret.Get(0).(func(context.Context, model.DeviceID, model.DeviceAttributes, model.DeviceAttributes, string, string) *model.UpdateResult); ok {
		r0 = rf(ctx, id, updateAttrs, removeAttrs, scope, etag)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.UpdateResult)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, model.DeviceID, model.DeviceAttributes, model.DeviceAttributes, string, string) error); ok {
		r1 = rf(ctx, id, updateAttrs, removeAttrs, scope, etag)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// WithAutomigrate provides a mock function with given fields:
func (_m *DataStore) WithAutomigrate() store.DataStore {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for WithAutomigrate")
	}

	var r0 store.DataStore
	if rf, ok := ret.Get(0).(func() store.DataStore); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(store.DataStore)
		}
	}

	return r0
}

// NewDataStore creates a new instance of DataStore. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewDataStore(t interface {
	mock.TestingT
	Cleanup(func())
}) *DataStore {
	mock := &DataStore{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
