---
## 4.0.0 - 2025-02-10


### Bug fixes


- *(deployments)* Deprecate v1 endpoint for listing deployments
([MEN-7543](https://northerntech.atlassian.net/browse/MEN-7543)) ([879b589](https://github.com/mendersoftware/mender-server/commit/879b58986f7e34906cff649c687d47de9152455c))  by @kjaskiewiczz


  We deprecated GET v1 /deployments/deployments endpoint because of an
  issue with "search" query parameter behavior. As a replacement we
  introduce v2 version of the endpoint, where we replaced "search"
  parameter with "id" and "name" parameters.

- *(deviceconfig)* Enable multiplatform build
([QA-673](https://northerntech.atlassian.net/browse/QA-673)) ([fbbe646](https://github.com/mendersoftware/mender-server/commit/fbbe6466981015f47f250ad673f35f00004d1589))  by @oldgiova


  The required TARGETOS and TARGETARCH variables were missing from the
  Dockerfile.

- *(gui)* Fixed an issue that could prevent browsers from following programmatically triggered downloads
 ([f2b6189](https://github.com/mendersoftware/mender-server/commit/f2b61896fc476d08f65d11a604777bb7809d6de1))  by @mzedel


  - relative download addresses seem not to be followed, switched to absolute instead

- *(gui)* Fixed an issue that would sometimes prevent users from switching between tenants
([MEN-7774](https://northerntech.atlassian.net/browse/MEN-7774)) ([ce777fd](https://github.com/mendersoftware/mender-server/commit/ce777fdc9ae558a21a630384152152872c94b7a5))  by @mzedel


  can't rely on the user list data as it doesn't contain all the user details

- *(gui)* Fixed an issue that prevented deployment sizes from being shown
 ([d2bbb8d](https://github.com/mendersoftware/mender-server/commit/d2bbb8df54aea9288af6d77944a516a075816928))  by @mzedel

- *(gui)* Fixed an issue that caused number comparisons in device filters to not work
([MEN-7717](https://northerntech.atlassian.net/browse/MEN-7717)) ([84e2398](https://github.com/mendersoftware/mender-server/commit/84e2398fece6b10fddcf6f60e3ff744af903c707))  by @mzedel

- *(gui)* Added readable name for ltne device filter
([MEN-7717](https://northerntech.atlassian.net/browse/MEN-7717)) ([a741011](https://github.com/mendersoftware/mender-server/commit/a74101176c22df69455a9d0634494912e219daab))  by @mzedel

- *(gui)* Fixed an issue that could lead to unexpected locations in the UI when accessing unauthorized sections while authorized
([MEN-7842](https://northerntech.atlassian.net/browse/MEN-7842)) ([7938291](https://github.com/mendersoftware/mender-server/commit/7938291f8ac37c7ee3366c0cf2773e2c0053438f))  by @mzedel

- *(gui)* Enable device configuration for non enterprise users
 ([67170c5](https://github.com/mendersoftware/mender-server/commit/67170c5edb27a1061abf2826234fabab45e4dedf))  by @thall


  Currently it's not possible to see device configuration if you host
  Mender self and have environment variable `HAVE_DEVICECONFIG=true`.

  Changes the predicate to be the same as for `hasDeviceConnect`.

- *(gui)* Added missing link to rbac docs in the cooresponding section
([MEN-7826](https://northerntech.atlassian.net/browse/MEN-7826)) ([1d8c4ff](https://github.com/mendersoftware/mender-server/commit/1d8c4ff3f71f5918ea98ff277f96c31a85ebffe5))  by @mzedel

- *(gui)* Prevented disabled form inputs from showing validation errors
 ([2e7215a](https://github.com/mendersoftware/mender-server/commit/2e7215aa93a3d357cfad34ec24e852ca66faf7df))  by @mzedel

- *(gui)* Aligned quick actions in release details with actually possibile actions
 ([365f564](https://github.com/mendersoftware/mender-server/commit/365f5646f2c32956fa8c0cee22c20d8c3757948d))  by @mzedel

- *(gui)* Fixed an issue that would prevent showing deployment reports for phased deployments
 ([132d6b2](https://github.com/mendersoftware/mender-server/commit/132d6b2aa932924c6612a8ca39867f246b388a88))  by @mzedel

- *(gui)* Fixed an issue that would prevent upgrading a running session to a different plan
([MEN-7898](https://northerntech.atlassian.net/browse/MEN-7898)) ([7668b29](https://github.com/mendersoftware/mender-server/commit/7668b293bc71d4eaffda0c00823cac5026dfbf4c))  by @mzedel

- *(gui)* Fixed an issue that would crash the site when showing release details with multiple artifacts
 ([fd06f66](https://github.com/mendersoftware/mender-server/commit/fd06f66516e4f33e52c9f305fb058594eecf714f))  by @mzedel

- *(gui)* Made addon availability rely more on addons where possible to prevent erroneous device config retrieval
([MEN-7895](https://northerntech.atlassian.net/browse/MEN-7895)) ([62d6516](https://github.com/mendersoftware/mender-server/commit/62d6516b848b35e493db8be9908abaf7e573e008))  by @mzedel

- *(gui)* Aligned webhook details behaviour w/ rest of UI
([MEN-7955](https://northerntech.atlassian.net/browse/MEN-7955)) ([7860b5b](https://github.com/mendersoftware/mender-server/commit/7860b5b40c698b580f5a299ee8c9206490ea5710))  by @mzedel

- *(gui)* Prevented sso config retrieval on plans that don't support this
 ([fe6da5d](https://github.com/mendersoftware/mender-server/commit/fe6da5dbea68222226ab01f52df7e5975fedc09d))  by @mzedel

- *(gui)* Fixed an issue that would prevent deleting & tagging releases in the release overview
([MEN-7960](https://northerntech.atlassian.net/browse/MEN-7960)) ([16b2628](https://github.com/mendersoftware/mender-server/commit/16b2628feaf39eba631b5ab013bf3eeecfa95217))  by @mzedel

- *(gui)* Let on-prem installations refer to the docs to prevent server-url misconfiguration following monorepo transition
([MEN-7948](https://northerntech.atlassian.net/browse/MEN-7948)) ([e0dae51](https://github.com/mendersoftware/mender-server/commit/e0dae512f67f08f312a61bd3be8192b7bbb7d6db))  by @mzedel

- *(gui)* Fixed end date filters out today's entries in the Audit log, Deployments and Devices
 ([3ee84f2](https://github.com/mendersoftware/mender-server/commit/3ee84f2d743b51462f72e68efeae870a51c4d12c))  by @aleksandrychev

- *(gui)* Ensured target directory is nonempty on artifact generation
([MEN-8010](https://northerntech.atlassian.net/browse/MEN-8010)) ([5616722](https://github.com/mendersoftware/mender-server/commit/561672221f31d0be257c4e1da98c63eda40f792d))  by @mzedel

- *(gui)* Fixed an issue that could prevent listing devices with their custom identity in a deployment report
 ([f1fcf26](https://github.com/mendersoftware/mender-server/commit/f1fcf26f33a3ae458e60f994fed60231d75abd5c))  by @mzedel

- *(gui)* Fixed an issue that would prevent navigating to devices from a software distribution chart
([MEN-8038](https://northerntech.atlassian.net/browse/MEN-8038)) ([6516986](https://github.com/mendersoftware/mender-server/commit/6516986b82ce08ecdfd9ed3c790590796c60da2d))  by @mzedel

- *(gui)* Made user list tracking rely only on backend data instead of local store to prevent duplicate users listed
([MEN-8049](https://northerntech.atlassian.net/browse/MEN-8049)) ([7d1b060](https://github.com/mendersoftware/mender-server/commit/7d1b060d096ff2549305cc0f453d8a35b21257b0))  by @mzedel

- *(gui)* Fixed an issue that would cause the ui to crash when creating phased deployments
 ([9827ba9](https://github.com/mendersoftware/mender-server/commit/9827ba928889f52e7eb4216b68707386c082dc74))  by @mzedel

- *(gui)* Fixed remaining device percentage not being displayed correctly on phased deployment creation
 ([5600913](https://github.com/mendersoftware/mender-server/commit/560091349c778c288ad1bdc5a8bcd9b54c39f399))  by @mzedel

- *(iot-core)* Incosistent serialization format for device private key
([MEN-7478](https://northerntech.atlassian.net/browse/MEN-7478)) ([6deadef](https://github.com/mendersoftware/mender-server/commit/6deadef48a11f8f845fdb9c1e33ddf33a366d531))  by @alfrunes


  The generated key is serialized using SEC 1 (RFC5915) ASN.1 encoding,
  but encoded to PEM using PKCS8 (RFC5208) block header/trailer.

- Aligned identity attribute usage with scoped inventory data to prevent overriding custom naming attributes with name tags
([MEN-7218](https://northerntech.atlassian.net/browse/MEN-7218)) ([9d82ea1](https://github.com/mendersoftware/mender-server/commit/9d82ea13bbc705dae08f277d3cbd5905386a9452))  by @mzedel
- Document the 409 return for creating deployment to a group
([MEN-7414](https://northerntech.atlassian.net/browse/MEN-7414)) ([5327dac](https://github.com/mendersoftware/mender-server/commit/5327daca07acc2e5b955ed2a23ae6ead39182e0d))  by @kjaskiewiczz
- Prevented commercial client components are only selected when plan/ addon accessible
([MEN-7458](https://northerntech.atlassian.net/browse/MEN-7458)) ([81e0b73](https://github.com/mendersoftware/mender-server/commit/81e0b73047ba17c2301b080fa5a16f1200d7975a))  by @mzedel
- Fixed an issue that prevented retrieving group devices & related reports
([MEN-7461](https://northerntech.atlassian.net/browse/MEN-7461)) ([95ea85f](https://github.com/mendersoftware/mender-server/commit/95ea85f46e26cacd59ce3f8c2a10fc086c756405))  by @mzedel
- Fixed an issue that prevented showing PATs on page refresh
 ([bde80fe](https://github.com/mendersoftware/mender-server/commit/bde80fe781be0c07684d2d4689227708695a548e))  by @mzedel
- Fixed an issue that prevented onboarding tips from showing
 ([c2ecfcf](https://github.com/mendersoftware/mender-server/commit/c2ecfcffd0a21f17ea8b3485a5d87efa21ab233a))  by @mzedel
- Fixed an issue that prevented the UI from showing deeply nested software installations
([MEN-7640](https://northerntech.atlassian.net/browse/MEN-7640)) ([13496f3](https://github.com/mendersoftware/mender-server/commit/13496f3468fd08dcc9656ba07463eba682cfaff4))  by @mzedel
- Stop user from having similar email and password
([MEN-6462](https://northerntech.atlassian.net/browse/MEN-6462)) ([3fa4a43](https://github.com/mendersoftware/mender-server/commit/3fa4a432780a40fb9b8c37633c7feca6ba3445c5))  by @bahaa-ghazal
- Implement signal handler for `server` commands
([QA-782](https://northerntech.atlassian.net/browse/QA-782)) ([6e17ada](https://github.com/mendersoftware/mender-server/commit/6e17adaaffa6778dc021353248d83b08cf645182))  by @bahaa-ghazal
- Deviceauth healthcheck panics malformed inventory address
 ([70d493a](https://github.com/mendersoftware/mender-server/commit/70d493a6913827d893758cd481a535de67fbeff9))  by @alfrunes
- Use internal URLs for storage backend when generating artifacts
([MEN-7939](https://northerntech.atlassian.net/browse/MEN-7939)) ([3d72d5e](https://github.com/mendersoftware/mender-server/commit/3d72d5e5b0294a3dcf3faa4413104ef27f95ba19))  by @alfrunes
  - **BREAKING**: Generate artifacts API ignores `storage.proxy_uri` and
`aws.external_url` configuration values and instead access the API using
the same URL as deployments service.


  When generating artifacts, the backend will use the direct access URL
  instead of rewriting the URL using the configured `storage.proxy_uri` or
  `aws.external_url`.
- Deployment device count should not exceed max devices
([MEN-7847](https://northerntech.atlassian.net/browse/MEN-7847)) ([15e5fee](https://github.com/mendersoftware/mender-server/commit/15e5feec727e4257a1ee4345265146a194edb4ab))  by @alfrunes


  Added a condition to skip deployments when the device count reaches max
  devices.
- Update outdated api endpoints in the `inventory` service
([MEN-7017](https://northerntech.atlassian.net/browse/MEN-7017)) ([73c7149](https://github.com/mendersoftware/mender-server/commit/73c714951a61642b2fc100214c61e5f66c27ee0c))  by @bahaa-ghazal
- Limiting the size of metadata when uploading and generating artifacts
([MEN-7166](https://northerntech.atlassian.net/browse/MEN-7166)) ([9e80728](https://github.com/mendersoftware/mender-server/commit/9e8072874c94da9e7a3659207e08c6a05fc48cc4))  by @bahaa-ghazal

- *(create-artifact-worker)* do not install openssl1.1-compat

  Changes:

  - use mender-artifact which does not depend on openssl1.1-compat
  - do not install openssl1.1-compat
- *(deployments)* Accesslog catches panic traces and remove "dev" middleware ([MC-7155](https://northerntech.atlassian.net/browse/MC-7155))
- *(deployments)* Improve error message when uploading too large artifacts ([MEN-7175](https://northerntech.atlassian.net/browse/MEN-7175))
- *(deployments)* fix release filtering and RBAC for releases
-  (deployments)* With the old implementation, when using more than one tag in the filter, or when using role which grants access to releases with given tag (and more than one tag was specified), deployments will present only releases containg ALL the tags each. With the new behavior, deployments will retrun all the releases containg ANY of the tags. ([MEN-7272](https://northerntech.atlassian.net/browse/MEN-7272))
- *(deployments)* Compatibility with MongoDB \> 5.0 ([MEN-6956](https://northerntech.atlassian.net/browse/MEN-6956))
- *(deviceauth)* Handling preauthorized auth set when device is accepted
- *(deviceauth)* The previous behavior was putting the device in a conflicting state and returning 500 errors on auth requests. With this commit, the preauthorized auth set will take precedence and take over as the accepted auth set. ([ALV-213](https://northerntech.atlassian.net/browse/ALV-213))
- *(deviceauth)* Wrong Content-Type header on successful authentication
- *(deviceauth)* On success, the Content-Type header is set to `application/jwt` instead of invalid `application/json` on 200 responses to POST /api/devices/v1/authentication/auth\_requests ([MEN-6912](https://northerntech.atlassian.net/browse/MEN-6912))
- *(deviceauth)* Preauthorize force behavior applies to existing auth sets
- *(deviceauth)* Updates the behavior of the Preauthorize endpoint if "force" paremeter is set:
   * If an authset already exist, the status will be forced to "preauthorized".
   * If the auth set does not exist, a new one will be created. ([MEN-7241](https://northerntech.atlassian.net/browse/MEN-7241))
- *(deviceauth)* Inconsistent device `check_in_time` when listing devices

  The lookup for `check_in_time` from the cache does not work when running Redis in cluster mode because of the MGET command requires keys to hash to the same slot. This commit replaces MGET with multiple batched GET commands when running Redis in cluster mode. ([MEN-7337](https://northerntech.atlassian.net/browse/MEN-7337))
- *(gui)* fixed missing theme global variables ([MEN-7044](https://northerntech.atlassian.net/browse/MEN-7044))
- *(gui)* fixed terminal closure made by exit command ([MEN-7081](https://northerntech.atlassian.net/browse/MEN-7081))
- *(gui)* Devices tab not showing in the UI with Deployments manager ([MEN-7111](https://northerntech.atlassian.net/browse/MEN-7111))
- *(gui)* fixed Software distribution widget displayed wrong other devices count
- *(gui)* ensured release is retrieved on deployment recreation ([MEN-7228](https://northerntech.atlassian.net/browse/MEN-7228))
- *(gui)* ensured an attempt to show fresh device information is made in every device related auditlog entry ([MEN-7034](https://northerntech.atlassian.net/browse/MEN-7034))
- *(gui)* fixed an issue that sometimes prevented reopening paginated auditlog links
- *(gui)* fixed an issue that could prevent SSO logins depending on the type of SSO
- *(gui)* fixed SSO information not being adjusted depending on the type of SSO configured ([MEN-7277](https://northerntech.atlassian.net/browse/MEN-7277))
- *(gui)* fixed an issue that prevented accessing releases with routing relevant symbols in their name ([MEN-7209](https://northerntech.atlassian.net/browse/MEN-7209))
- *(gui)* ensured browser generated reports are refreshed on every full device data retrieval to prevent partly initialized report data to show misleading software distributions ([MEN-7123](https://northerntech.atlassian.net/browse/MEN-7123))
- *(gui)* fixed an issue that would prevent promoting a device to a gateway device ([MEN-7334](https://northerntech.atlassian.net/browse/MEN-7334))
- *(gui)* limited global settings saving for less privileged users ([MEN-6970](https://northerntech.atlassian.net/browse/MEN-6970))
- *(inventory)* Accesslog middleware log panic traces and remove "dev" middleware ([MC-7155](https://northerntech.atlassian.net/browse/MC-7155))
- *(inventory)* Bound the number of devices considered when aggregating filter attributes to maximum 5,000. ([MEN-6917](https://northerntech.atlassian.net/browse/MEN-6917))
- *(inventory)* do not return updated\_ts as zero time if updated\_ts is not set
- *(inventory)* store "check\_in\_time" attribute as ISODate instead of string ([MEN-7259](https://northerntech.atlassian.net/browse/MEN-7259))
- *(inventory)* attribute modification in the range loop

- *(iot-manager)* Event APIs return OK if event is saved to database ([MEN-6898](https://northerntech.atlassian.net/browse/MEN-6898))
- *(iot-manager)* Create TTL index for removing expired logs ([MEN-7101](https://northerntech.atlassian.net/browse/MEN-7101))
- *(iot-manager)* Incosistent serialization format for device private key

  The generated key is serialized using (RFC5915) ASN.1 encoding, but encoded to PEM using PKCS8 (RFC5208) block header/trailer. ([MEN-7478](https://northerntech.atlassian.net/browse/MEN-7478), \[SEC 1\]([https://northerntech.atlassian.net/browse/SEC](https://northerntech.atlassian.net/browse/SEC) 1))

- *(useradm)* Update accesslog middleware to catch panic traces and remove dev mode ([MC-7155](https://northerntech.atlassian.net/browse/MC-7155))

### Documentation


- *(README)* Add step to clone repository
 ([f9d3bbd](https://github.com/mendersoftware/mender-server/commit/f9d3bbde382bca4592f41e3d6be7e8292dcb221f))  by @alfrunes

- *(README)* Consistently add syntax highlighting to code blocks
 ([8583102](https://github.com/mendersoftware/mender-server/commit/8583102cbbf49882b9a9ab1b80257516ec13dc24))  by @alfrunes

- *(deployments)* Clarifications for the GET /deployments version 2 endpoint.
([MEN-8053](https://northerntech.atlassian.net/browse/MEN-8053)) ([ea9fda0](https://github.com/mendersoftware/mender-server/commit/ea9fda0593e982f15eaa6be0d5b0f240a7994878))

- Update README.md with instructions on using the docker composition
 ([c9aa7dc](https://github.com/mendersoftware/mender-server/commit/c9aa7dc73db9717f436def2b14dc8f7cce74903f))  by @alfrunes
- Add section about testing build artifacts
 ([5c7eaaa](https://github.com/mendersoftware/mender-server/commit/5c7eaaa22c9cdb0016b9f06afc3bccdfdd9b9578))  by @alfrunes
- Add snippet for starting a mender client to README
 ([a322b2d](https://github.com/mendersoftware/mender-server/commit/a322b2d8c22e5e9e409a9a5c96c3b8412cef555f))  by @alfrunes
- Update README.md
 ([f7a1b09](https://github.com/mendersoftware/mender-server/commit/f7a1b097726672dd40ed7df17551229c5cf6ce7f))  by @alfrunes


  Adjusted styling (note color, added 1st level indentation,  taxonomy i.e., Mender Server, Mender Enterprise) to make it easy to follow and read.
- Document how to bring up the Virtual Device for enterprise setup
 ([c674566](https://github.com/mendersoftware/mender-server/commit/c674566e6d834c64d6e64d321c6e09b5f2a36259))  by @lluiscampos
- Fix typo in snippet for creating tenant
 ([a346d33](https://github.com/mendersoftware/mender-server/commit/a346d33781086d157d831478cfb64bebeef6c3bd))  by @alfrunes
- Docmentation on backend integration tests running separately
([QA-683](https://northerntech.atlassian.net/browse/QA-683)) ([a8f8d54](https://github.com/mendersoftware/mender-server/commit/a8f8d545573100186fba953c7179592a23196b23))  by @merlin-northern




### Features


- *(deployments)* Add filter field to deployment object
([MEN-7416](https://northerntech.atlassian.net/browse/MEN-7416)) ([fec5b91](https://github.com/mendersoftware/mender-server/commit/fec5b91d59d07b1a0d85ccf077cd56aa5b192278))  by @kjaskiewiczz


  The filter field contains information about devices targeted by the
  deployment.

- *(deployments)* New endpoint for getting release by name
([MEN-7575](https://northerntech.atlassian.net/browse/MEN-7575)) ([3a18e88](https://github.com/mendersoftware/mender-server/commit/3a18e880ec5cddedc19ed08949777caedda4350d))  by @kjaskiewiczz

- *(gui)* Enabled webhook scope selection
([MEN-7455](https://northerntech.atlassian.net/browse/MEN-7455)) ([cec277d](https://github.com/mendersoftware/mender-server/commit/cec277d83adf930de47ca5bb03935aa350ea1af5))  by @mzedel

- *(gui)* Extended webhook event details
([MEN-7574](https://northerntech.atlassian.net/browse/MEN-7574)) ([0bfda40](https://github.com/mendersoftware/mender-server/commit/0bfda409122ed6837e13cf7f5418b093bf3ef97b))  by @mzedel

- *(gui)* Aligned webhook listing with updated design
([MEN-7573](https://northerntech.atlassian.net/browse/MEN-7573)) ([80e55d1](https://github.com/mendersoftware/mender-server/commit/80e55d15e361c21988e192bf715a219bb300f487))  by @mzedel

- *(gui)* Added the possibility to create service provider administering roles
([MEN-7570](https://northerntech.atlassian.net/browse/MEN-7570)) ([92d7e50](https://github.com/mendersoftware/mender-server/commit/92d7e50e311d8c88f9847a83cec7b797ef9cebcc))  by @mzedel

- *(gui)* Aligned role removal dialog with other parts of the UI
 ([8661704](https://github.com/mendersoftware/mender-server/commit/866170425bef1f01f3a4a25f0d4e19fe5da94a6e))  by @mzedel

- *(gui)* Added support for Personal Access Token auditlog entries
([MEN-7622](https://northerntech.atlassian.net/browse/MEN-7622)) ([9a9a6c3](https://github.com/mendersoftware/mender-server/commit/9a9a6c3829611c35622e3812db7bbedd9bc9f9e5))  by @mzedel

- *(gui)* Added possibility to trigger deployment & inventory data updates when troubleshooting
([MEN-7657](https://northerntech.atlassian.net/browse/MEN-7657)) ([11a9b7a](https://github.com/mendersoftware/mender-server/commit/11a9b7a57a179c3d9605779b41f6d10b6dbc72fb))  by @mzedel

- *(gui)* Made deployment targets rely on filter information in the deployment to more reliably display target devices etc.
([MEN-7647](https://northerntech.atlassian.net/browse/MEN-7647)) ([47c92d4](https://github.com/mendersoftware/mender-server/commit/47c92d4db494cfc77116258fc2ed7fdca8691400))  by @mzedel

- *(gui)* Aligned notions of "latest device activity" in listing & details
 ([40ee57d](https://github.com/mendersoftware/mender-server/commit/40ee57da173c1d5bc2a39b2a5534b62dc986f53c))  by @mzedel

- *(gui)* Limited onboarding to hosted Mender to ensure a streamlined experience
([MEN-7896](https://northerntech.atlassian.net/browse/MEN-7896)) ([cee60f8](https://github.com/mendersoftware/mender-server/commit/cee60f8de9eb5b6940828f5e09e11dbd4e2d4059))  by @mzedel

- *(gui)* Added feedback on file size limits to artifact upload dialog
([MEN-7858](https://northerntech.atlassian.net/browse/MEN-7858)) ([d612334](https://github.com/mendersoftware/mender-server/commit/d612334ebfae6b1a3d416016ee500b89daa70804))  by @mzedel

- *(gui)* Aligned text input appearance with MUI updated guidelines
([MEN-7838](https://northerntech.atlassian.net/browse/MEN-7838)) ([e5d5672](https://github.com/mendersoftware/mender-server/commit/e5d56720b901a451fa47a514424f710763b50291))  by @mzedel

- *(gui)* Added explanation about integration number limitation
([MEN-7899](https://northerntech.atlassian.net/browse/MEN-7899)) ([dbdfa67](https://github.com/mendersoftware/mender-server/commit/dbdfa672a62eb30745fb4b0e73bea7d345644932))  by @mzedel

- *(gui)* Clarified user creation capabilities for non-enterprise users
([MEN-7883](https://northerntech.atlassian.net/browse/MEN-7883)) ([d2fd192](https://github.com/mendersoftware/mender-server/commit/d2fd192e8c09443dabb694288d73636853b02d86))  by @mzedel

- *(gui)* Added automatic refresh to get webhook events
([MEN-8045](https://northerntech.atlassian.net/browse/MEN-8045)) ([502e06a](https://github.com/mendersoftware/mender-server/commit/502e06aab96f3ce980cd6fe197a2fd6d7e99233a))  by @mzedel

- *(inventory)* Add support for "$in" operator in the device search API
([MEN-7667](https://northerntech.atlassian.net/browse/MEN-7667)) ([fd4eaf0](https://github.com/mendersoftware/mender-server/commit/fd4eaf0ecc8b72ff7fa9cfe7b6f214bc4678a97f))  by @kjaskiewiczz

- Added option to limit deployments to a maximum number of devices in a dynamic group
([MEN-7403](https://northerntech.atlassian.net/browse/MEN-7403)) ([c04d736](https://github.com/mendersoftware/mender-server/commit/c04d736fd58adba549858b86b936d076f855eb7c))  by @mzedel
- Made search results reopen whenever the search field is clicked again and has a search term
([MEN-6894](https://northerntech.atlassian.net/browse/MEN-6894)) ([c36eb96](https://github.com/mendersoftware/mender-server/commit/c36eb96c9c1790a0b23f05507021378c59267690))  by @mzedel
- Added feedback dialog
([MEN-7355](https://northerntech.atlassian.net/browse/MEN-7355)) ([8c0a3ba](https://github.com/mendersoftware/mender-server/commit/8c0a3baa2fa4e4cf935d818235e651bd4c5ed85c))  by @mzedel
- New endpoint for listing deployments
([MEN-7541](https://northerntech.atlassian.net/browse/MEN-7541)) ([afb1566](https://github.com/mendersoftware/mender-server/commit/afb15665474440751e0463582e5d08d07b626da8))  by @kjaskiewiczz
- Add `version` command to all Go binaries
 ([ff439c9](https://github.com/mendersoftware/mender-server/commit/ff439c93552ae7e32d3a0cb932339902f45271ec))  by @alfrunes


  The `version` command will display the app version (linked at build
  time) as well as runtime version and commit SHA1.

- *(deployments)* Add configuration for max data size when generating artifacts
- *(deployments)* Adds a new configuration option for setting the max data section size when generating an image with a default of 512MiB. The configuraiton path is `storage.max_generate_data_size` or environment variable `DEPLOYMENTS_STORAGE_MAX_GENERATE_DATA_SIZE`. ([MEN-7134](https://northerntech.atlassian.net/browse/MEN-7134))
- *(deployments)* prevent the creation of deployments if there is already an active deployment with the same constructor parameters ([MEN-6622](https://northerntech.atlassian.net/browse/MEN-6622))
- *(deviceauth)* accept and support preauth at any time ([MEN-6961](https://northerntech.atlassian.net/browse/MEN-6961))
- *(deviceauth)* sync check\_in\_time with inventory if reporting is disabled ([MEN-7202](https://northerntech.atlassian.net/browse/MEN-7202))
- *(deviceconfig)* internal endpoint to delete all records related to a tenant ([MEN-7312](https://northerntech.atlassian.net/browse/MEN-7312))
- *(deviceconnect)* Forward filetransfer statuscode from client ([ALV-209](https://northerntech.atlassian.net/browse/ALV-209))
- *(deviceconnect)* internal endpoint to delete all records related to a tenant ([MEN-7317](https://northerntech.atlassian.net/browse/MEN-7317))
- *(devicemonitor)* internal endpoint to delete all records related to a tenant ([MEN-7318](https://northerntech.atlassian.net/browse/MEN-7318))

- *(gui)* treat devices which didn't contact server after being accepted as offline ([MEN-6880](https://northerntech.atlassian.net/browse/MEN-6880))
- *(gui)* treat devices without update\_ts as offline
- *(gui)  The new "$ltne" filter operator allows to get list of device where the update\_ts is lower than given value or update\_ts doesn't exist. ([MEN-6880](https://northerntech.atlassian.net/browse/MEN-6880))
- *(gui)* Added UI interface to save the Open ID connect Single sign-on ([MEN-6922](https://northerntech.atlassian.net/browse/MEN-6922))
- *(gui)* allow to save SAML Single Sign-On without config providing
- *(gui)* allow personal access tokens generation for the SSO users ([MEN-6824](https://northerntech.atlassian.net/browse/MEN-6824))
- *(gui)* Added releases quick actions support ([MEN-6859](https://northerntech.atlassian.net/browse/MEN-6859))
- *(gui)* added two-step login for enterprise users ([MEN-6823](https://northerntech.atlassian.net/browse/MEN-6823))
- *(gui)* enabled password reset during user creation ([MEN-7192](https://northerntech.atlassian.net/browse/MEN-7192))
- *(gui)* use inventory's check\_in\_time to extract and list offline devices ([MEN-7251](https://northerntech.atlassian.net/browse/MEN-7251))
- *(gui)* gave device deployment log files more descriptive file names ([MEN-7221](https://northerntech.atlassian.net/browse/MEN-7221))
- *(gui)* made log viewer wider to ease going through deployment logs ([MEN-7220](https://northerntech.atlassian.net/browse/MEN-7220))
- *(gui)* added copyable userid to user information ([MEN-7277](https://northerntech.atlassian.net/browse/MEN-7277))
- *(gui)* allowed adding users by user id in user creation dialog ([MEN-7277](https://northerntech.atlassian.net/browse/MEN-7277))
- *(gui)* restructured account menu & added option to switch tenant in supporting setups ([MEN-6906](https://northerntech.atlassian.net/browse/MEN-6906))
- *(gui)* let device details remain open when adding the device to a group ([MEN-7336](https://northerntech.atlassian.net/browse/MEN-7336))
- *(gui)* added notification about changes to the device offline threshold ([MEN-7288](https://northerntech.atlassian.net/browse/MEN-7288))

- *(inventory)* do not set updated\_ts field when inserting the device ([MEN-6878](https://northerntech.atlassian.net/browse/MEN-6878))

- *(iot-manager)* process webhook requests asynchronously, returing `202 Accepted` instead of `204 No Content` or `200 OK` ([MEN-7227](https://northerntech.atlassian.net/browse/MEN-7227))
- *(iot-manager)* add a timeout for webhook requests, defaults to 10 seconds; you can modify it using the `webhooks_timeout_seconds` configuration setting ([MEN-7227](https://northerntech.atlassian.net/browse/MEN-7227))
- *(iot-manager)* internal endpoint to delete all records related to a tenant ([MEN-7319](https://northerntech.atlassian.net/browse/MEN-7319))

- *(workflows)* Add encoding option "html" for html-escaping string parameters ([MEN-7003](https://northerntech.atlassian.net/browse/MEN-7003))



### Build

- (gui) **BREAKING**: Changed container image to unprivileged port 8090 and unprivileged user ([13b2268](https://github.com/mendersoftware/mender-server/commit/13b2268027f678e52ce69aa8bfa912c713d12093)) by @alfrunes

- (docker) **BREAKING**: Changed container image tag scheme from `mender-x.y.z` to `vX.Y.Z`

  The new versioning scheme uses the **Mender Server** version which is decoupled from the other components in the Mender ecosystem.

- *(docker)* Add build stage to Dockerfiles
 ([ba3692e](https://github.com/mendersoftware/mender-server/commit/ba3692eb52dd146081014de05ffae9b6331d6ff6))  by @alfrunes


  The Dockerfiles are now self-contained by moving the build stage into
  the Dockerfile.

- *(docker)* Build images on BUILDPLATFORM
 ([44e5b7f](https://github.com/mendersoftware/mender-server/commit/44e5b7f574f9437ccad0954dafbf75ea78f511f3))  by @alfrunes

- *(docker)* Use make(1) when building inside docker images
 ([153269e](https://github.com/mendersoftware/mender-server/commit/153269e6916ddfde68d4846621cd87a8b89c3dcf))  by @alfrunes


  For consistent builds.

- *(make)* Update `docker` targets to use updated Dockerfiles
 ([11f26d6](https://github.com/mendersoftware/mender-server/commit/11f26d6684f4732e3003cac69b4d03b11ae9924c))  by @alfrunes


  Refactored common parts to parent directory.

- *(make)* Change default target to `docker` and add variable TAGS
 ([92ac12a](https://github.com/mendersoftware/mender-server/commit/92ac12a512235c8b0013513935fe63bb712fea85))  by @alfrunes


  Containers are the primary build artifacts for this repo so it makes
  sense to build them by default.

- *(make)* Fix acceptance test targets after refactor
 ([70919bd](https://github.com/mendersoftware/mender-server/commit/70919bdda6ca3af15bdd61f3cbe03f01156fe71c))  by @alfrunes


  Put common acceptance test targets in Makefile.common and made
  exceptions for `create-artifact-worker` and `reporting`.

- *(make)* Do not expand `go` shell commands unconditionally
 ([1c68b83](https://github.com/mendersoftware/mender-server/commit/1c68b833d7823f6b0666e0f290ea0c073f482634))  by @alfrunes

- *(make)* Run acceptance tests without rebuilding the containers
 ([ce241cc](https://github.com/mendersoftware/mender-server/commit/ce241cc9cb5da92372787fbcd236a8b43c705242))  by @alfrunes


  Removed the dependency on `docker-acceptance` for the
  `test-acceptance-run`.

- *(make)* `test-unit` target runs in same environment as build
 ([141ea40](https://github.com/mendersoftware/mender-server/commit/141ea401f90b63d6667d403743b294908fb662b1))  by @alfrunes

- *(make)* Change TAGS behavior to always include required build tags
 ([5bae608](https://github.com/mendersoftware/mender-server/commit/5bae608e706384cd5ebb88dbd6869291c1fa33d8))  by @alfrunes

- *(make)* Rename DOCKER_ARGS to DOCKER_BUILDARGS, TAGS to BUILDTAGS
 ([1a97891](https://github.com/mendersoftware/mender-server/commit/1a978917316ce620ecc0fee01002ece409437765))  by @alfrunes


  It seems like Gitlab has a built in TAGS env variable which conflicts
  with the Make environment.

- *(make)* Add `docker-pull` target for pulling images
 ([37f4391](https://github.com/mendersoftware/mender-server/commit/37f4391dee7624d583c68aba6235f7f61deddd76))  by @alfrunes

- *(make)* Define DOCKER_PLATFORM template as multiline variable
 ([0db0c9a](https://github.com/mendersoftware/mender-server/commit/0db0c9ad67430ba3bbe109cb9d5e8613eb2af621))  by @alfrunes

- *(make)* Fix tag override for `docker-acceptance`
 ([7f0b260](https://github.com/mendersoftware/mender-server/commit/7f0b26011d422b539cdbdf6acbcb22156ac6a076))  by @alfrunes


  MENDER_IMAGE_TAG_TEST should set the tag when building the target.

- *(make)* Remove make 4.4 function `let`
 ([75f980e](https://github.com/mendersoftware/mender-server/commit/75f980eb118298e0fcaf3dc08dcda0eb46131541))  by @alfrunes

- *(make)* Added target `docker-publish` for publishing images
 ([c400b04](https://github.com/mendersoftware/mender-server/commit/c400b04c2c30a4a2e2ac5a2e2f53fddf44caeffb))  by @alfrunes

- *(make)* Split MENDER_PUBLISH_REGISTRY into registry and repository
 ([e27c770](https://github.com/mendersoftware/mender-server/commit/e27c77001704218b36442641598e3b3d1ef65fd1))  by @alfrunes

- *(test)* Force serialize unit tests for deviceauth
 ([a0ab55e](https://github.com/mendersoftware/mender-server/commit/a0ab55e6f84242b34b176520b7c2218e1c1d678e))  by @alfrunes





### Check


- Make `sed(1)` Linux compatible again
 ([1271396](https://github.com/mendersoftware/mender-server/commit/1271396faf49b2220a39cd5e4ef7a1cd1cdee443))  by @alfrunes


  Replace flag `-i=''` with `-i.bak` and removing the files.




### Refac


- *(compose)* Refactor SeaweedFS topology and optimize startup/shutdown time
 ([fe7ee2e](https://github.com/mendersoftware/mender-server/commit/fe7ee2eb37177521cb9ab060f551b2d441c86874))  by @alfrunes


  Instead of running SeaweedFS as a monolith using the `server` command,
  we explicitly launch all services in different containers. It appears
  that the `server` command has some issues when initializing the master
  and sometimes enter a deadlock the healthcheck interval is too low at
  startup. Moreover, running the services in different containers makes it
  easier to debug and interpret the logs.

- *(iotcore)* Break on errors instead of falling through
 ([733f8ab](https://github.com/mendersoftware/mender-server/commit/733f8ab45cc8a76566b79d86507306b78742f324))  by @alfrunes


  Using long chains of fallthrough error conditions makes it very
  difficult to read and error prone to extend. Refactoring to use common
  coding patterns instead.

- Use an overlay directory to create Makefiles and Dockerfiles
 ([85e93e0](https://github.com/mendersoftware/mender-server/commit/85e93e0081410b1fa295ddd6b639af969d3f47ac))  by @alfrunes


  Allows for easier individual customization required for accepatnce
  tests.
- Move compat tests to dedicated test suite
 ([059f437](https://github.com/mendersoftware/mender-server/commit/059f4375d3b33073e711fdbf81212a2cd5dacfbb))  by @alfrunes




### Revert


- *(docker)* Revert generate-delta-worker dockerfile
 ([d205b3e](https://github.com/mendersoftware/mender-server/commit/d205b3e4a279da0ee9660f3e14f828012ff0f5ab))  by @alfrunes


  Reverts the dockerfile to the upstream docker file with the two
  exceptions of copying the binaries from this repositories rather than
  relying on master docker images.

- Change docker entrypoint to launch workflows worker
 ([0d39c96](https://github.com/mendersoftware/mender-server/commit/0d39c964eeec8b833604b91be7f707c7ce1357a4))  by @alfrunes


  This was done by mistake when updating the Dockerfile for the monorepo.

## Mender 3.7.11

_Released 05.22.2025_

### Changelogs

#### create-artifact-worker (1.4.1)

New changes in create-artifact-worker since 1.4.0:

* Update `mender-artifact` binary used in the container to the
  latest released to mitigate a set of CVEs in the Go standard library.
  ([MEN-8337](https://northerntech.atlassian.net/browse/MEN-8337))
* Upgrade container image `golang` to `1.24.3`
* Upgrade container image `alpine` to `3.18.12`
* Update golang dependencies

  - github.com/spf13/cobra v1.8.0 -> v1.9.1
  - github.com/spf13/viper v1.17.0 -> v1.20.1
  - github.com/stretchr/testify v1.8.4 -> v1.10.0

#### deployments-enterprise (4.6.3)

New changes in deployments-enterprise since 4.6.2:

* Upgrade container image `golang` to `1.23.9`

#### deviceconnect (1.5.2)

New changes in deviceconnect since 1.5.1:

* Upgrade `golang` container image to `1.23.9`
* Update go dependencies

  - github.com/gin-gonic/gin v1.9.1 -> v1.10.0
  - github.com/google/uuid v1.4.0 -> v1.6.0
  - github.com/gorilla/websocket v1.5.1 -> v1.5.3
  - github.com/mendersoftware/go-lib-micro v0.0.0-20231031082957-e2bce6ff3edd -> v0.0.0-20250319141021-adca5cc5e022
  - github.com/nats-io/nats-server/v2 v2.10.4 -> v2.11.3
  - github.com/nats-io/nats.go v1.31.0 -> v1.42.0
  - github.com/stretchr/testify v1.8.4 -> v1.10.0
  - github.com/urfave/cli v1.22.14 -> v1.22.16
  - go.mongodb.org/mongo-driver v1.13.0 -> v1.17.3
  - golang.org/x/sys v0.15.0 -> v0.33.0

#### generate-delta-worker (1.1.2)

New changes in generate-delta-worker since 1.1.1:

* Update `mender-artifact` binary used in the container to the
  latest released to mitigate a set of CVEs in the Go standard library.
  ([MEN-8337](https://northerntech.atlassian.net/browse/MEN-8337))
* Upgraded container image `golang` to `1.24.3-alpine3.21`
* Upgraded container image `alpine` to `3.18.12`
* Update golang dependencies

  - github.com/spf13/cobra v1.8.0 -> v1.9.1
  - github.com/spf13/viper v1.17.0 -> v1.20.1
  - github.com/stretchr/testify v1.8.4 -> v1.10.0

#### gui (3.7.4)

New changes in gui since 3.7.3:

* Upgrade container image `node` to `22.2.15`
* Upgrade container image `nginx` to `1.27.5`

#### integration (3.7.11)

New changes in integration since 3.7.10:

* Upgrade create-artifact-worker to 1.4.1.
* Upgrade deployments-enterprise to 4.6.3.
* Upgrade deployments to 4.6.3.
* Upgrade deviceconnect to 1.5.2.
* Upgrade generate-delta-worker to 1.1.2.
* Upgrade gui to 3.7.4.
* Upgrade integration to 3.7.11.
* Upgrade tenantadm to 4.1.2.
* Upgrade useradm-enterprise to 1.22.5.
* Upgrade useradm to 1.22.5.

#### useradm (1.22.5)

New changes in useradm since 1.22.4:

* Upgrade container image `golang` to `1.23.9-alpine3.20`
* Upgrade go dependencies

  - github.com/golang-jwt/jwt/v4 v4.5.0 -> v4.5.2
  - github.com/google/uuid v1.4.0 -> v1.6.0
  - github.com/mendersoftware/go-lib-micro v0.0.0-20231016090356-4769be2f2c88 -> v0.0.0-20250319141021-adca5cc5e022
  - github.com/mendersoftware/go-lib-micro/mongo/codec v0.0.0-20231016090356-4769be2f2c88 -> v0.0.0-20250319141021-adca5cc5e022
  - github.com/stretchr/testify v1.8.4 -> v1.10.0
  - github.com/urfave/cli v1.22.14 -> v1.22.16
  - go.mongodb.org/mongo-driver v1.13.1 -> v1.17.3
  - golang.org/x/crypto v0.16.0 -> v0.38.0
  - golang.org/x/term v0.15.0 -> v0.32.0

#### useradm-enterprise (1.22.5)

New changes in useradm-enterprise since 1.22.4:

##### Bug fixes

* Fix GenerateTFASecret using insecure RNG

##### Other

* Upgrade container image `golang` to `1.23.9-alpine3.20`
* Upgrade go dependencies

  - github.com/golang-jwt/jwt/v4 v4.5.0 -> v4.5.2
  - github.com/google/uuid v1.4.0 -> v1.6.0
  - github.com/mendersoftware/go-lib-micro v0.0.0-20231016090356-4769be2f2c88 -> v0.0.0-20250319141021-adca5cc5e022
  - github.com/mendersoftware/go-lib-micro/mongo/codec v0.0.0-20231016090356-4769be2f2c88 -> v0.0.0-20250319141021-adca5cc5e022
  - github.com/stretchr/testify v1.8.4 -> v1.10.0
  - github.com/urfave/cli v1.22.14 -> v1.22.16
  - go.mongodb.org/mongo-driver v1.13.1 -> v1.17.3
  - golang.org/x/crypto v0.16.0 -> v0.38.0
  - golang.org/x/term v0.15.0 -> v0.32.0

## Mender 3.7.8

_Released 12.02.2024_

### Changelogs

#### integration (3.7.8)

New changes in integration since 3.7.7:

* Upgrade auditlogs to 3.2.1.
* Upgrade deployments-enterprise to 4.6.2.
* Upgrade deployments to 4.6.2.
* Upgrade deviceauth-enterprise to 3.6.1.
* Upgrade deviceauth to 3.6.1.
* Upgrade deviceconfig to 1.4.1.
* Upgrade devicemonitor to 1.5.1.
* Upgrade generate-delta-worker to 1.1.1.
* Upgrade gui to 3.7.3.
* Upgrade integration to 3.7.8.
* Upgrade inventory-enterprise to 4.4.3.
* Upgrade inventory to 4.4.3.
* Upgrade iot-manager to 1.3.1.
* Upgrade mender-artifact to 3.11.3.
* Upgrade mender-convert to 4.2.3.
* Upgrade mender-gateway to 1.2.1.
* Upgrade mender to 4.0.5.
* Upgrade tenantadm to 4.1.1.
* Upgrade useradm-enterprise to 1.22.4.
* Upgrade useradm to 1.22.4.
* Upgrade workflows-enterprise to 2.6.2.
* Upgrade workflows to 2.6.2.

#### iot-manager (1.3.1)

New changes in iot-manager since 1.3.0:

##### Bug fixes

* Incosistent serialization format for device private key

  The generated key is serialized using SEC 1 (RFC5915) ASN.1 encoding,
  but encoded to PEM using PKCS8 (RFC5208) block header/trailer.
  ([MEN-7478](https://northerntech.atlassian.net/browse/MEN-7478))


## Mender 3.7.7

_Released 08.15.2024_

### Security fixes

* Fixed CVE-2024-46947 - SSRF issues in Mender Enterprise Server.
  See the official announcement for more information:
  [mender.io/blog/cve-2024-46947-cve-2024-47190-ssrf-issues-in-mender-enterprise-server](https://mender.io/blog/cve-2024-46947-cve-2024-47190-ssrf-issues-in-mender-enterprise-server)

### Changelogs

#### deviceconnect (1.5.1)

New changes in deviceconnect since 1.5.0:

##### Bug fixes

* Connection status race on rapid reconnect

  Devices that reconnect too fast may result in a state where the
  persisted status shows “disconnected” while the device is actually
  connected. This especially happens when the network latency is very low
  (< 5ms) which causes the device to establish a new connection before the
  old request handler had time to mark it as closed.
  ([MEN-7333](https://northerntech.atlassian.net/browse/MEN-7333))

#### integration (3.7.7)

New changes in integration since 3.7.5:

* Upgrade deviceconnect to 1.5.1.
* Upgrade integration to 3.7.7.
* Upgrade inventory-enterprise to 4.4.2.
* Upgrade inventory to 4.4.2.
* Upgrade useradm-enterprise to 1.22.3.
* Upgrade useradm to 1.22.3.

#### useradm-enterprise (1.22.3)

New changes in useradm-enterprise since 1.22.2:

##### Bug fixes

* Harden HTTP client when resolving SAML Artifact requests

  When making a request to fetch a Security Assertion Markup Language
  (SAML) ArtifactResolve requests, the backend no longer allows
  redirects and prevents making request to reserved IP ranges.
  ([MEN-7365](https://northerntech.atlassian.net/browse/MEN-7365))
* Replace SSO metadata on PUT requests

  This commit fixes the replacement semantics when updating the SSO
  metadata document for SAML and OpenID Connect. The former behavior uses
  a PATCH-like semantic which can lead to unwanted side-effects when
  changing mode between SAML and OIDC.
  ([MEN-7377](https://northerntech.atlassian.net/browse/MEN-7377))


## Mender 3.7.5

_Released 06.12.2024_

### Security fixes

* Fixed CVE-2024-46948 - Missing filtering based on RBAC device groups.
  See the official announcement for more information:
  [mender.io/blog/cve-2024-46948](https://mender.io/blog/cve-2024-46948)

### Changelogs

#### integration (3.7.5)

New changes in integration since 3.7.4:

* Upgrade integration to 3.7.5.
* Upgrade mender-convert to 4.2.2.
* Upgrade mender to 4.0.3.
* Upgrade useradm-enterprise to 1.22.2.
* Upgrade useradm to 1.22.2.
* Upgrade workflows-enterprise to 2.6.1.
* Upgrade workflows to 2.6.1.

#### useradm-enterprise (1.22.2)

New changes in useradm-enterprise since 1.22.1:

##### Bug fixes

* do not allow users with access to given device groups to list all the devices
  ([ME-267](https://northerntech.atlassian.net/browse/ME-267))

#### workflows (2.6.1)

New changes in workflows since 2.6.0:

##### Bug fixes

* Use context and add TTL to prevent sidecar blocking forever
  ([MEN-7214](https://northerntech.atlassian.net/browse/MEN-7214))

##### Other

* Fix deadlock in worker Go routines.
  ([MEN-7214](https://northerntech.atlassian.net/browse/MEN-7214))

#### workflows-enterprise (2.6.1)

New changes in workflows-enterprise since 2.6.0:

##### Bug fixes

* Use context and add TTL to prevent sidecar blocking forever
  ([MEN-7214](https://northerntech.atlassian.net/browse/MEN-7214))

##### Other

* Fix deadlock in worker Go routines.
  ([MEN-7214](https://northerntech.atlassian.net/browse/MEN-7214))


## Mender 3.7.4

_Released 05.01.2024_

### Security fixes

* Fixed CVE-2024-37019 - Account takeover using SAML.
  See the official announcement for more information:
  [mender.io/blog/cve-2024-37019-account-takeover-using-saml](https://mender.io/blog/cve-2024-37019-account-takeover-using-saml)

### Changelogs

#### integration (3.7.4)

New changes in integration since 3.7.3:

* Upgrade integration to 3.7.4.
* Upgrade useradm-enterprise to 1.22.1.
* Upgrade useradm to 1.22.1.

#### useradm-enterprise (1.22.1)

New changes in useradm-enterprise since 1.22.0:

##### Bug fixes

* When assigning SSO configuration to the user, check if the SSO with
  given Id is configured for the tenant the user has access to. (CVE-2024-37019)

##### Other

* add method for assigning SSO config to user


## Mender 3.6.5

_Released 06.12.2024_

### Security fixes

* Fixed CVE-2024-46948 - Missing filtering based on RBAC device groups.
  See the official announcement for more information:
  [mender.io/blog/cve-2024-46948](https://mender.io/blog/cve-2024-46948)

### Changelogs

#### integration (3.6.5)

New changes in integration since 3.6.4:

* Upgrade integration to 3.6.5.
* Upgrade mender-artifact to 3.11.2.
* Upgrade mender-configure-module to 1.1.2.
* Upgrade mender-connect to 2.1.2.
* Upgrade mender-convert to 4.2.2.
* Upgrade mender to 3.5.3.
* Upgrade mtls-ambassador to 1.2.2.
* Upgrade useradm-enterprise to 1.21.4.
* Upgrade useradm to 1.21.4.
* Upgrade workflows-enterprise to 2.5.2.
* Upgrade workflows to 2.5.2.

#### useradm-enterprise (1.21.4)

New changes in useradm-enterprise since 1.21.3:

##### Bug fixes

* do not allow users with access to given device groups to list all the devices
  ([ME-267](https://northerntech.atlassian.net/browse/ME-267))

#### workflows (2.5.2)

New changes in workflows since 2.5.1:

##### Bug fixes

* Use context and add TTL to prevent sidecar blocking forever
  ([MEN-7214](https://northerntech.atlassian.net/browse/MEN-7214))

##### Other

* Fix deadlock in worker Go routines.
  ([MEN-7214](https://northerntech.atlassian.net/browse/MEN-7214))

#### workflows-enterprise (2.5.2)

New changes in workflows-enterprise since 2.5.1:

##### Bug fixes

* Use context and add TTL to prevent sidecar blocking forever
  ([MEN-7214](https://northerntech.atlassian.net/browse/MEN-7214))

##### Other

* Fix deadlock in worker Go routines.
  ([MEN-7214](https://northerntech.atlassian.net/browse/MEN-7214))


## Mender 3.6.4

_Released 05.01.2024_

### Security fixes

* Fixed CVE-2024-37019 - Account takeover using SAML.
  See the official announcement for more information:
  [mender.io/blog/cve-2024-37019-account-takeover-using-saml](https://mender.io/blog/cve-2024-37019-account-takeover-using-saml)

### Changelogs

#### integration (3.6.4)

New changes in integration since 3.6.3:

* Upgrade integration to 3.6.4.
* Upgrade useradm-enterprise to 1.21.3.
* Upgrade useradm to 1.21.3.

#### useradm-enterprise (1.21.3)

New changes in useradm-enterprise since 1.21.2:

##### Bug fixes

* When assigning SSO configuration to the user, check if the SSO with
  given Id is configured for the tenant the user has access to. (CVE-2024-37019)

##### Other

* add method for assigning SSO config to user


## Mender 3.7.3

_Released 03.21.2024_

### Changelogs

#### deployments-enterprise (4.6.1)

New changes in deployments-enterprise since 4.6.0:

##### Features

* device API end-points for the artifacts list, show and download
  ([MEN-6916](https://northerntech.atlassian.net/browse/MEN-6916))

#### gui (3.7.2)

New changes in gui since 3.7.1:

##### Bug fixes

* fixed gateway and monitor links on the Downloads page
  ([MEN-7004](https://northerntech.atlassian.net/browse/MEN-7004))
* display removed groups in the role defenitions
  ([MEN-6891](https://northerntech.atlassian.net/browse/MEN-6891))
* fixed the final onboarding step not being displayed
  ([MEN-6949](https://northerntech.atlassian.net/browse/MEN-6949))

##### Features

* explicitly install mender-client4 in bash snippets, for onboarding tutorial and 'Connect a new device'
  ([MEN-6976](https://northerntech.atlassian.net/browse/MEN-6976))

#### integration (3.7.3)

New changes in integration since 3.7.2:

* Upgrade deployments-enterprise to 4.6.1.
* Upgrade deployments to 4.6.1.
* Upgrade gui to 3.7.2.
* Upgrade integration to 3.7.3.
* Upgrade mender-binary-delta to 1.5.0.
* Upgrade mender-convert to 4.2.0.
* Upgrade mender to 4.0.2.


## Mender 3.7.2

_Released 02.12.2024_

### Statistics

| Developers with the most changesets | |
|---|---|
| Lluis Campos | 3 (42.9%) |
| Roberto Giovanardi | 1 (14.3%) |
| Fabio Tranchitella | 1 (14.3%) |
| Ole Petter Orhagen | 1 (14.3%) |
| Alf-Rune Siqveland | 1 (14.3%) |

| Developers with the most changed lines | |
|---|---|
| Fabio Tranchitella | 62 (42.5%) |
| Ole Petter Orhagen | 45 (30.8%) |
| Lluis Campos | 28 (19.2%) |
| Alf-Rune Siqveland | 10 (6.8%) |
| Roberto Giovanardi | 1 (0.7%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 7 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 146 (100.0%) |

| Employers with the most hackers (total 5) | |
|---|---|
| Northern.tech | 5 (100.0%) |

### Changelogs

#### integration (3.7.2)

New changes in integration since 3.7.1:

* Upgrade gui to 3.7.1.
* Upgrade integration to 3.7.2.
* Upgrade inventory-enterprise to 4.4.1.
* Upgrade inventory to 4.4.1.
* Upgrade mender-artifact to 3.11.2.
* Upgrade mender-connect to 2.2.1.
* Upgrade mender to 4.0.1.

#### inventory-enterprise (4.4.1)

New changes in inventory-enterprise since 4.4.0:

##### Bug fixes

* Index out of bounds on empty regular expression
  ([MEN-6930](https://northerntech.atlassian.net/browse/MEN-6930))


## Mender 3.7.1

_Released 01.15.2024_

### Statistics

A total of 1338 lines added, 1636 removed (delta -298)

| Developers with the most changesets | |
|---|---|
| Lluis Campos | 67 (65.7%) |
| Ole Petter Orhagen | 28 (27.5%) |
| Alf-Rune Siqveland | 3 (2.9%) |
| Kristian Amlie | 2 (2.0%) |
| Roberto Giovanardi | 1 (1.0%) |
| Fabio Tranchitella | 1 (1.0%) |

| Developers with the most changed lines | |
|---|---|
| Lluis Campos | 1274 (58.0%) |
| Ole Petter Orhagen | 858 (39.1%) |
| Roberto Giovanardi | 53 (2.4%) |
| Alf-Rune Siqveland | 5 (0.2%) |
| Kristian Amlie | 5 (0.2%) |
| Fabio Tranchitella | 2 (0.1%) |

| Developers with the most lines removed | |
|---|---|
| Ole Petter Orhagen | 405 (24.8%) |
| Kristian Amlie | 3 (0.2%) |
| Alf-Rune Siqveland | 2 (0.1%) |
| Fabio Tranchitella | 1 (0.1%) |

| Developers with the most signoffs (total 1) | |
|---|---|
| Lluis Campos | 1 (100.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 102 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 2197 (100.0%) |

| Employers with the most signoffs (total 1) | |
|---|---|
| Northern.tech | 1 (100.0%) |

| Employers with the most hackers (total 6) | |
|---|---|
| Northern.tech | 6 (100.0%) |

### Changelogs

#### integration (3.7.1)

New changes in integration since 3.7.0:

* Upgrade integration to 3.7.1.
* Upgrade mender-artifact to 3.11.1.
* Upgrade mender-configure-module to 1.1.2.
* Upgrade mender-convert to 4.1.1.
* Upgrade mender-setup to 1.0.0.
* Upgrade mender-snapshot to 1.0.0.
* Upgrade mender to 4.0.0.


## Mender 3.7.0

_Released 12.28.2023_

### Statistics

| Developers with the most changesets | |
|---|---|
| Manuel Zedel | 261 (32.0%) |
| Alf-Rune Siqveland | 159 (19.5%) |
| Krzysztof Jaskiewicz | 122 (15.0%) |
| Fabio Tranchitella | 85 (10.4%) |
| Roberto Giovanardi | 78 (9.6%) |
| Peter Grzybowski | 52 (6.4%) |
| Lluis Campos | 18 (2.2%) |
| Kristian Amlie | 11 (1.3%) |
| Mender Test Bot | 8 (1.0%) |
| Ihor Aleksandrychiev | 7 (0.9%) |

| Developers with the most changed lines | |
|---|---|
| Fabio Tranchitella | 16898 (23.6%) |
| Krzysztof Jaskiewicz | 15347 (21.4%) |
| Manuel Zedel | 14491 (20.2%) |
| Alf-Rune Siqveland | 13023 (18.2%) |
| Peter Grzybowski | 9439 (13.2%) |
| Roberto Giovanardi | 1373 (1.9%) |
| Mender Test Bot | 398 (0.6%) |
| Lluis Campos | 361 (0.5%) |
| Kristian Amlie | 104 (0.1%) |
| Michael Clelland | 99 (0.1%) |

| Developers with the most lines removed | |
|---|---|
| Fabio Tranchitella | 4236 (10.0%) |
| Manuel Zedel | 1016 (2.4%) |
| Lluis Campos | 118 (0.3%) |
| Michael Clelland | 18 (0.0%) |

| Developers with the most signoffs (total 1) | |
|---|---|
| Fabio Tranchitella | 1 (100.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 815 (99.9%) |
| ondracek.roman@centrum.cz | 1 (0.1%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 71717 (100.0%) |
| ondracek.roman@centrum.cz | 14 (0.0%) |

| Employers with the most signoffs (total 1) | |
|---|---|
| Northern.tech | 1 (100.0%) |

| Employers with the most hackers (total 16) | |
|---|---|
| Northern.tech | 15 (93.8%) |
| ondracek.roman@centrum.cz | 1 (6.2%) |

### Changelogs

#### auditlogs (3.2.0)

New changes in auditlogs since 3.1.1:

##### Bug fixes

* Terminate application on unexpected server shutdown
  ([MEN-6596](https://northerntech.atlassian.net/browse/MEN-6596))

##### Features

* enable multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* feat: limit the audit logs list and export end-points to non-enterprise to a configurable interval, by default two days

#### create-artifact-worker (1.4.0)

New changes in create-artifact-worker since 1.3.2:

##### Bug fixes

* Provide default value for CREATE_ARTIFACT_DEPLOYMENTS_URL
  ([MEN-6237](https://northerntech.atlassian.net/browse/MEN-6237))

##### Other

* enabled multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))

#### deployments (4.6.0)

New changes in deployments since 4.5.2:

##### Bug fixes

* perform automigration only if the service was configured to perform it
* Collection scan retrieving deployments for device

  This commit fixes a collection scan on the deployments collection if
  there are no device deployments for a device.
  ([MEN-6724](https://northerntech.atlassian.net/browse/MEN-6724))
* Added missing name resolution libraries to the scratch container
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* `proxy_uri` not picked up by s3 client
* Presign client options not applied unless `external_uri` is set
* convert to tags to lowercase on querying.
  ([MEN-6786](https://northerntech.atlassian.net/browse/MEN-6786))
* new field: Started in the device deployment struct.
  ([MEN-6793](https://northerntech.atlassian.net/browse/MEN-6793))
* fix documentation of /statistics/list endpoint
  ([MEN-6865](https://northerntech.atlassian.net/browse/MEN-6865))

##### Features

* make releases persistent in the database
  ([MEN-5180](https://northerntech.atlassian.net/browse/MEN-5180))
* New configuration parameter `storage.proxy_uri`

  The new configuration parameter rewrites presigned URLs to target the
  specified proxy URL instead of the direct link. This allows setting
  application level proxies in front of s3/azure blob storage.
  ([MEN-6562](https://northerntech.atlassian.net/browse/MEN-6562))
* Add tags property to releases

  Releases now optionally contain user-defined tags.
  To update release tags, there's a new v2 endpoint for assigning tags to
  releases:
    PUT /api/management/v2/deployments/releases/{release_name}/tags
  ([MEN-6348](https://northerntech.atlassian.net/browse/MEN-6348))
* Endpoint for listing all release tag key names

  The new endpoint is exposed as:
    GET /api/management/v2/deployments/releases/all/tags
  ([MEN-6348](https://northerntech.atlassian.net/browse/MEN-6348))
* release notes: update and store.
  ([MEN-6593](https://northerntech.atlassian.net/browse/MEN-6593))
* remove release when last artifact is removed
  ([MEN-6616](https://northerntech.atlassian.net/browse/MEN-6616))
* query releases by update type
  ([MEN-6592](https://northerntech.atlassian.net/browse/MEN-6592))
* save and get the update types
  ([MEN-6623](https://northerntech.atlassian.net/browse/MEN-6623))
* sort releases by artifacts_count and tags
  ([MEN-6353](https://northerntech.atlassian.net/browse/MEN-6353))
* enable multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* deprecate the `/v1/deployments/releases/list` end-point, replaced by the new end-point `/v2/deployments/releases`
  ([MEN-6349](https://northerntech.atlassian.net/browse/MEN-6349))
* add support for filtering releases by tags
  ([MEN-6349](https://northerntech.atlassian.net/browse/MEN-6349))
* introduce disable_new_releases_feature setting

  With this setting set to true, service can work with minimum version of
  database (1.2.14), but with limited functionality - new v2/releases
  endpoint will not work.
  ([MEN-6773](https://northerntech.atlassian.net/browse/MEN-6773))
* disable end-points manipulating artifacts if new releases feature is disabled
  ([MEN-6773](https://northerntech.atlassian.net/browse/MEN-6773))
* endpoint for bulk removal of releases by names
  ([MEN-6354](https://northerntech.atlassian.net/browse/MEN-6354))

##### Other

* use release name as an _id in the release collection
  ([MEN-5180](https://northerntech.atlassian.net/browse/MEN-5180))
* change the way we check if artifact is part of any deployment
* specification of the endpoint for bulk removal of releases
  ([MEN-6354](https://northerntech.atlassian.net/browse/MEN-6354))
* endpoint for bulk removal of releases by names tests
  ([MEN-6354](https://northerntech.atlassian.net/browse/MEN-6354))
* move release related tests to separate file

#### deployments-enterprise (4.6.0)

New changes in deployments-enterprise since 4.5.2:

##### Bug fixes

* perform automigration only if the service was configured to perform it
* Collection scan retrieving deployments for device

  This commit fixes a collection scan on the deployments collection if
  there are no device deployments for a device.
  ([MEN-6724](https://northerntech.atlassian.net/browse/MEN-6724))
* Added missing name resolution libraries to the scratch container
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* Added missing name resolution libraries to the scratch container
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* `proxy_uri` not picked up by s3 client
* Presign client options not applied unless `external_uri` is set
* convert to tags to lowercase on querying.
  ([MEN-6786](https://northerntech.atlassian.net/browse/MEN-6786))
* new field: Started in the device deployment struct.
  ([MEN-6793](https://northerntech.atlassian.net/browse/MEN-6793))
* align GenerateDeltaJobStatusFailure const.
  ([MEN-6791](https://northerntech.atlassian.net/browse/MEN-6791))
* fix documentation of /statistics/list endpoint
  ([MEN-6865](https://northerntech.atlassian.net/browse/MEN-6865))

##### Features

* make releases persistent in the database
  ([MEN-5180](https://northerntech.atlassian.net/browse/MEN-5180))
* New configuration parameter `storage.proxy_uri`

  The new configuration parameter rewrites presigned URLs to target the
  specified proxy URL instead of the direct link. This allows setting
  application level proxies in front of s3/azure blob storage.
  ([MEN-6562](https://northerntech.atlassian.net/browse/MEN-6562))
* Add tags property to releases

  Releases now optionally contain user-defined tags.
  To update release tags, there's a new v2 endpoint for assigning tags to
  releases:
    PUT /api/management/v2/deployments/releases/{release_name}/tags
  ([MEN-6348](https://northerntech.atlassian.net/browse/MEN-6348))
* Endpoint for listing all release tag key names

  The new endpoint is exposed as:
    GET /api/management/v2/deployments/releases/all/tags
  ([MEN-6348](https://northerntech.atlassian.net/browse/MEN-6348))
* release notes: update and store.
  ([MEN-6593](https://northerntech.atlassian.net/browse/MEN-6593))
* remove release when last artifact is removed
  ([MEN-6616](https://northerntech.atlassian.net/browse/MEN-6616))
* query releases by update type
  ([MEN-6592](https://northerntech.atlassian.net/browse/MEN-6592))
* save and get the update types
  ([MEN-6623](https://northerntech.atlassian.net/browse/MEN-6623))
* sort releases by artifacts_count and tags
  ([MEN-6353](https://northerntech.atlassian.net/browse/MEN-6353))
* enable multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* enable multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* deprecate the `/v1/deployments/releases/list` end-point, replaced by the new end-point `/v2/deployments/releases`
  ([MEN-6349](https://northerntech.atlassian.net/browse/MEN-6349))
* add support for filtering releases by tags
  ([MEN-6349](https://northerntech.atlassian.net/browse/MEN-6349))
* introduce disable_new_releases_feature setting

  With this setting set to true, service can work with minimum version of
  database (1.2.14), but with limited functionality - new v2/releases
  endpoint will not work.
  ([MEN-6773](https://northerntech.atlassian.net/browse/MEN-6773))
* introduce disable_new_releases_feature setting

  With this setting set to true, service can work with minimum version of
  database (1.2.14), but with limited functionality - new v2/releases
  endpoint will not work.
  ([MEN-6773](https://northerntech.atlassian.net/browse/MEN-6773))
* disable end-points manipulating artifacts if new releases feature is disabled
  ([MEN-6773](https://northerntech.atlassian.net/browse/MEN-6773))
* get the status of the server side delta generation job
  ([MEN-6791](https://northerntech.atlassian.net/browse/MEN-6791))
* endpoint for bulk removal of releases by names
  ([MEN-6354](https://northerntech.atlassian.net/browse/MEN-6354))

##### Other

* use release name as an _id in the release collection
  ([MEN-5180](https://northerntech.atlassian.net/browse/MEN-5180))
* change the way we check if artifact is part of any deployment
* specification of the endpoint for bulk removal of releases
  ([MEN-6354](https://northerntech.atlassian.net/browse/MEN-6354))
* endpoint for bulk removal of releases by names tests
  ([MEN-6354](https://northerntech.atlassian.net/browse/MEN-6354))
* move release related tests to separate file

#### deviceauth (3.6.0)

New changes in deviceauth since 3.5.0:

##### Bug fixes

* propagate id data to inventory for all tenants case.
* Redis key prefix configuration not applied
  ([MEN-6926](https://northerntech.atlassian.net/browse/MEN-6926))

##### Features

* Allow tenant token to be an opaque string
  ([MEN-6502](https://northerntech.atlassian.net/browse/MEN-6502))
* Added multiplaform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* feat: optimize the authentication requests checking the `X-MEN-Signature` value only for successful authentication requests
  ([MEN-5497](https://northerntech.atlassian.net/browse/MEN-5497))
* feat: optimize the token verification end-point delaying the JWT token signature and claims validation after the cache look-up
  ([MEN-5497](https://northerntech.atlassian.net/browse/MEN-5497))
* support for Ed25519 server keys for signing the JWT tokens
  ([MEN-6775](https://northerntech.atlassian.net/browse/MEN-6775))
* make service compatible with redis cluster

  Changes:
  - do not use redis databases;
  - use service/version specific prefix for all the keys;
  - change redis configuration - use connection string to create redis
    client;

  BREAKING CHANGE: Old redis_* configuration parameters are deprecated
  and most of them will not work. Use redis_connection_string and
  redis_key_prefix to configure redis cache client.
  ([MC-7056](https://northerntech.atlassian.net/browse/MC-7056))
* replace method for flushing database with method for suspending tenant

  We achive cache invalidation by incrementing tenant key version.
  Each tenant related key in the cache has to contain tenant key version.
  This way, by incrementing tenant key version, we invalidate all tenant
  related keys.
  ([MC-7056](https://northerntech.atlassian.net/browse/MC-7056))

##### Other

* fix cli acceptance tests
* use Pipeline instead of TxPipeline in the Throttle method

  Use of transaction in this particular case is unnecessary.

#### deviceauth-enterprise (3.6.0)

New changes in deviceauth-enterprise since 3.5.0:

##### Bug fixes

* propagate id data to inventory for all tenants case.
* Redis key prefix configuration not applied
  ([MEN-6926](https://northerntech.atlassian.net/browse/MEN-6926))

##### Features

* Allow tenant token to be an opaque string
  ([MEN-6502](https://northerntech.atlassian.net/browse/MEN-6502))
* Added multiplaform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* save external identity and track its status
* cache unauthorized responses when processing device authentication requests
  ([MEN-5497](https://northerntech.atlassian.net/browse/MEN-5497))
* cache the tenant data by tenant token
  ([MEN-5497](https://northerntech.atlassian.net/browse/MEN-5497))
* feat: optimize the authentication requests checking the `X-MEN-Signature` value only for successful authentication requests
  ([MEN-5497](https://northerntech.atlassian.net/browse/MEN-5497))
* feat: optimize the token verification end-point delaying the JWT token signature and claims validation after the cache look-up
  ([MEN-5497](https://northerntech.atlassian.net/browse/MEN-5497))
* support for Ed25519 server keys for signing the JWT tokens
  ([MEN-6775](https://northerntech.atlassian.net/browse/MEN-6775))
* make service compatible with redis cluster

  Changes:
  - do not use redis databases;
  - use service/version specific prefix for all the keys;
  - change redis configuration - use connection string to create redis
    client;

  BREAKING CHANGE: Old redis_* configuration parameters are deprecated
  and most of them will not work. Use redis_connection_string and
  redis_key_prefix to configure redis cache client.
  ([MC-7056](https://northerntech.atlassian.net/browse/MC-7056))
* replace method for flushing database with method for suspending tenant

  We achive cache invalidation by incrementing tenant key version.
  Each tenant related key in the cache has to contain tenant key version.
  This way, by incrementing tenant key version, we invalidate all tenant
  related keys.
  ([MC-7056](https://northerntech.atlassian.net/browse/MC-7056))

##### Other

* extend device API documentation

  The authentication set object has been extended by new field which
  allows to provide external identification of the device.

  Ticket: ALV-73
* update tests after extending auth set endpoint functionality
* reduce cyclomatic complexity of the processPreAuth method
* fix cli acceptance tests
* use Pipeline instead of TxPipeline in the Throttle method

  Use of transaction in this particular case is unnecessary.

#### deviceconfig (1.4.0)

New changes in deviceconfig since 1.3.2:

##### Bug fixes

* do not use deprecated types and methods from bson package

##### Features

* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))

#### deviceconnect (1.5.0)

New changes in deviceconnect since 1.4.1:

##### Bug fixes

* do not use deprecated types and methods from bson package

##### Features

* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* feat: graceful shutdown of websockets on signal SIGUSR1 with a configurable timeout `graceful_shutdown_timeout`, with a default of `60s`
  ([MC-7039](https://northerntech.atlassian.net/browse/MC-7039))
* new internal API end-point to gracefully shutdown the service
  ([MC-7039](https://northerntech.atlassian.net/browse/MC-7039))
* Add support for HEAD to download API endpoint

#### devicemonitor (1.5.0)

New changes in devicemonitor since 1.4.1:

##### Bug fixes

* do not use deprecated types and methods from bson package

##### Features

* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))

#### generate-delta-worker (1.1.0)

New changes in generate-delta-worker since 1.0.2:

* Fix multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))

#### gui (3.7.0)

New changes in gui since 3.6.2:

##### Bug fixes

* fixed an issue that could show configuration deployments without a name
* fixed faulty interpretation of granular role definitions that prevented the UI from showing accessible sections
* re-enabled deletion of custom roles
* fixed an error that would prevent accurate role creation
* fixed an issue that could cause the app to freeze when selecting a release
* fixed deployment phase size calculation for single device deployments
  ([MEN-6489](https://northerntech.atlassian.net/browse/MEN-6489))
* fixed an issue that would cause too many search request
  ([MEN-6682](https://northerntech.atlassian.net/browse/MEN-6682))
* fixed an issue that would readd existing filters
* fixed an issue that could crash the ui for users without auditlogs enabled when looking at auditlogs
* fixed an issue that could cause auditlog details for device changes to crash the ui
* fixed an issue that would cause the ui to crash when listing single object related entries
* fixed an issue that made the link to target devices in a deployment report unreliable
  ([MEN-6718](https://northerntech.atlassian.net/browse/MEN-6718))
* fixed an issue that would prevent the dashboard issues widget from pointing to the intended location
  ([MEN-6720](https://northerntech.atlassian.net/browse/MEN-6720))
* removed auth requests from device issue widget as it requires reporting which is not available yet
* fixed an issue that would cause the UI to freeze when looking at webhook activity
  ([MEN-6759](https://northerntech.atlassian.net/browse/MEN-6759))
* worked around an issue that would render the ui mostly unclickable due to a dangling background
  ([MEN-6749](https://northerntech.atlassian.net/browse/MEN-6749))
* fixed onboarding showing up even if cancelled
  ([MEN-6748](https://northerntech.atlassian.net/browse/MEN-6748))
* fixed an issue that made resizing device list columns unpredictable
  ([MEN-6744](https://northerntech.atlassian.net/browse/MEN-6744))
* fixed a regression that prevented filtering by release tags
  ([MEN-6785](https://northerntech.atlassian.net/browse/MEN-6785))
* made remote terminal slightly wider to accomodate at least 80 chars
* fixed an issue that could reset delta config settings to their default values
  ([MEN-6790](https://northerntech.atlassian.net/browse/MEN-6790))
* fixed an issue that caused the integrated terminal to render too frequent & never settle on a size
  ([MEN-6800](https://northerntech.atlassian.net/browse/MEN-6800))
* fixed an issue that would prevent oauth based signup
* fixed an issue that would overwrite device inventory update timestamps with other services' times
  ([MEN-6811](https://northerntech.atlassian.net/browse/MEN-6811))
* fixed deployment report init by fixing open state detection
  ([MEN-6792](https://northerntech.atlassian.net/browse/MEN-6792))
* made use of newly added information about when a device actually started a deployment
  ([MEN-6793](https://northerntech.atlassian.net/browse/MEN-6793))
* update the timestamp labels in the deployment detail view
  ([MEN-6793](https://northerntech.atlassian.net/browse/MEN-6793))
* Fixed the infinite page redirects when the back button is pressed
  ([MEN-6796](https://northerntech.atlassian.net/browse/MEN-6796), [MEN-6847](https://northerntech.atlassian.net/browse/MEN-6847))

##### Features

* moved existing helptips to updated design & allowing per tip visibility toggling
  ([MEN-5414](https://northerntech.atlassian.net/browse/MEN-5414))
* made role management actions more explicit
  ([MEN-6689](https://northerntech.atlassian.net/browse/MEN-6689))
* removed limitation of 5 custom columns
  ([MEN-6603](https://northerntech.atlassian.net/browse/MEN-6603))
* added support for release tags & update type filtering
  ([MEN-6455](https://northerntech.atlassian.net/browse/MEN-6455))
* reworked filtering setup in auditlogs & finished deployments to align with releases & updated designs

  - this also removes the timerange selection in deployments & auditlogs in order to streamline date related filtering to a single selector
  - this should also address filter settings parsing on refresh
  ([MEN-6456](https://northerntech.atlassian.net/browse/MEN-6456))
* allowed resizing name column
  ([MEN-6600](https://northerntech.atlassian.net/browse/MEN-6600))
* added warning about the nature of tenant tokens to reduce chance of this being shared
  ([MEN-6768](https://northerntech.atlassian.net/browse/MEN-6768))
* rename `artifact_name` column to `Current artifact` in device list

##### Other

* adjusted floating action buttons to open/close on click
* gave terminal slightly more room to improve usability

#### integration (3.7.0)

New changes in integration since 3.6.3:

##### Bug fixes

* Disable authentication for the new signup endpoint

##### Features

* Bump MongoDB version 4.4 -> 5.0
  ([MC-6324](https://northerntech.atlassian.net/browse/MC-6324))
* enable redis cache in the inventory-enterprise service
* change redis configuration

##### Other

* test(full integration): fix the check if the devices reported inventory
* Upgrade auditlogs to 3.2.0.
* Upgrade create-artifact-worker to 1.4.0.
* Upgrade deployments-enterprise to 4.6.0.
* Upgrade deployments to 4.6.0.
* Upgrade deviceauth-enterprise to 3.6.0.
* Upgrade deviceauth to 3.6.0.
* Upgrade deviceconfig to 1.4.0.
* Upgrade deviceconnect to 1.5.0.
* Upgrade devicemonitor to 1.5.0.
* Upgrade generate-delta-worker to 1.1.0.
* Upgrade gui to 3.7.0.
* Upgrade integration to 3.7.0.
* Upgrade inventory-enterprise to 4.4.0.
* Upgrade inventory to 4.4.0.
* Upgrade iot-manager to 1.3.0.
* Upgrade mender-artifact to 3.11.0.
* Upgrade mender-cli to 1.12.0.
* Upgrade mender-connect to 2.2.0.
* Upgrade mender-convert to 4.1.0.
* Upgrade mender-gateway to 1.2.0.
* Upgrade mender to 3.5.2.
* Upgrade mtls-ambassador to 1.3.0.
* Upgrade tenantadm to 4.1.0.
* Upgrade useradm-enterprise to 1.22.0.
* Upgrade useradm to 1.22.0.
* Upgrade workflows-enterprise to 2.6.0.
* Upgrade workflows to 2.6.0.

#### inventory (4.4.0)

New changes in inventory since 4.3.2:

##### Bug fixes

* attributes changed: compare timestamps with configurable threshold.
  ([MEN-6643](https://northerntech.atlassian.net/browse/MEN-6643))
* do not use deprecated methods from bson package

##### Features

* update inventory only when changed or outdated.
  ([MEN-6425](https://northerntech.atlassian.net/browse/MEN-6425))
* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* update device inventory only when changed but at least daily
  ([MEN-6643](https://northerntech.atlassian.net/browse/MEN-6643))

##### Other

* fix(management api): fix value returned by /filters/attributes endpoint

  In the /filters/attributes endpoint, in case there are no attributes,
  return empty list instead of null.
  ([MEN-6477](https://northerntech.atlassian.net/browse/MEN-6477))
* add clinet for management API v2
  ([MEN-6477](https://northerntech.atlassian.net/browse/MEN-6477))
* check returned value of /filters/attributes
  ([MEN-6477](https://northerntech.atlassian.net/browse/MEN-6477))

#### inventory-enterprise (4.4.0)

New changes in inventory-enterprise since 4.3.2:

##### Bug fixes

* attributes changed: compare timestamps with configurable threshold.
  ([MEN-6643](https://northerntech.atlassian.net/browse/MEN-6643))
* do not use deprecated methods from bson package
* do not use deprecated types and methods from bson package
* sort inventory attributes when detecting duplicated updates
* Updating attributes no longer panics if cache is not configured
  ([MEN-6864](https://northerntech.atlassian.net/browse/MEN-6864))

##### Features

* update inventory only when changed or outdated.
  ([MEN-6425](https://northerntech.atlassian.net/browse/MEN-6425))
* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* update device inventory only when changed but at least daily
  ([MEN-6643](https://northerntech.atlassian.net/browse/MEN-6643))
* detect duplicated device inventory updates and cache responses
* remove checks for enterprise plan in some of the endpoint handlers

  Access to this endpoints is restricted by applying access rules in
  useradm.
* Redis cache changes:
  - do not use redis databases;
  - use service/version specific prefix for all the keys;
  - use connection string to create redis client;
  - BREAKING CHANGE: Old redis_* configuration parameters will not work.
  Use redis_connection_string and redis_key_prefix to configure redis
  cache client.
  ([MC-7057](https://northerntech.atlassian.net/browse/MC-7057))
* support redis_addr setting for backward compatibility

##### Other

* fix(management api): fix value returned by /filters/attributes endpoint

  In the /filters/attributes endpoint, in case there are no attributes,
  return empty list instead of null.
  ([MEN-6477](https://northerntech.atlassian.net/browse/MEN-6477))
* add clinet for management API v2
  ([MEN-6477](https://northerntech.atlassian.net/browse/MEN-6477))
* check returned value of /filters/attributes
  ([MEN-6477](https://northerntech.atlassian.net/browse/MEN-6477))

#### iot-manager (1.3.0)

New changes in iot-manager since 1.2.1:

##### Bug fixes

* do not use deprecated types and methods from bson package

##### Features

* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))

##### Other

* adjust tests after introducing support for Azure authentication

#### mtls-ambassador (1.3.0)

New changes in mtls-ambassador since 1.2.1:

##### Features

* expose an HTTP server on port `8081` with the `/status` end-point
  ([MEN-6700](https://northerntech.atlassian.net/browse/MEN-6700))

#### tenantadm (4.1.0)

New changes in tenantadm since 4.0.0:

##### Bug fixes

* HubSpot: update contact if exists
  ([MEN-6778](https://northerntech.atlassian.net/browse/MEN-6778))
* Signup requests accept integer values for login

##### Features

* Marketing sync: moving to HubSpot
  ([MEN-6420](https://northerntech.atlassian.net/browse/MEN-6420))
* remove data synchronization between useradm and tenantadm
  ([MEN-5733](https://northerntech.atlassian.net/browse/MEN-5733))
* remove old and unused signup API end-points with support for Stripe
  ([MEN-5742](https://northerntech.atlassian.net/browse/MEN-5742))
* create users instead of relying on the create_organization workflow
  ([MEN-5733](https://northerntech.atlassian.net/browse/MEN-5733))
* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* New signup endpoint supporting subscription managed by Azure

  The new endpoint extends the existing sign-up endpoint
  `POST /api/management/v2/tenantadm/tenants/trial` with the ability to
  sign up using an existing subscription managed by Azure.

  Ticket: ALV-149
* Initial implementation of the Microsoft marketplace webhook

  The webhook does nothing but logging the raw event to the database.

  Ticket: ALV-133
* Implement webhook API to handle events from Microsoft marketplace
* Integrate Azure market subscriptions with plan change requests
* Integrate Azure Marketplace with cancel tenant API
* introduce plan bindings
* method for setting plan binding for given tenant
* method for setting limits for given tenant
* set plan binding and limits when creating/updating tenants
* Add option `disable_legacy_addons` to disable addons

#### useradm (1.22.0)

New changes in useradm since 1.21.0:

##### Bug fixes

* removed jwt cookie transmission to minimize potential leakage of auth info
* describe plan_definitions_path setting

##### Features

* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* introduce plans API
* support for Ed25519 server keys for signing the JWT tokens
  ([MEN-5676](https://northerntech.atlassian.net/browse/MEN-5676))
* add file_transfer feature flag to plan definitions
* introduce new feature flag - reporting
* "kid" support in JWT header and multiple keys.
  ([MEN-6804](https://northerntech.atlassian.net/browse/MEN-6804))

##### Other

* add "reporting" feature flag to API spec

#### useradm-enterprise (1.22.0)

New changes in useradm-enterprise since 1.21.2:

##### Bug fixes

* fix Troubleshooting role definition

  User with "Troubleshooting" role should be able to see devices.
  To achive that add "ReadDevices" permission set to the troubleshooting
  role definition.
  ([MEN-6615](https://northerntech.atlassian.net/browse/MEN-6615))
* fix error handling when creating users

  In case the limit on number of users has been exceeded, endpoint for
  creating users should return proper error.

  Ticket: ALV-129
* return limit with user count from GET /limits endpoint even when there is no limit
* do not return Internal Server Error if the user doesn't exist on login
* removed jwt cookie transmission to minimize potential leakage of auth info
* fix status code returned from PUT /plan_bindings endpoint
* describe plan_definitions_path setting
* Redis key prefix configuration not applied
  ([MEN-6927](https://northerntech.atlassian.net/browse/MEN-6927))

##### Features

* remove data synchronization between useradm and tenantadm
  ([MEN-5733](https://northerntech.atlassian.net/browse/MEN-5733))
* Allow overriding the built-in RBAC definitions at startup

  If the configuration `rbac_override_path` is set, the built-in roles are
  replaced with the definitions parsed from the override file. The new
  rules can be specified in YAML or JSON and follows the API schema:
  ```yaml
  type: object
    properties:
      roles:
        type: object
        description: |
          Built-in roles; keys are role names, values are Role from the
          API
        additionalProperties:
          $ref: '#/components/schemas/Role'
      permissions:
        type: object
        description: |
          Built-in permissions; keys are role names, values are
          PermissionSetsWithScope from the API
        additionalProperties:
          $ref: '#/components/schemas/PermissionSetsWithScope'
  ```

  Ticket: ALV-67
* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* new configuration setting `audit_logs_min_plan` to specify the minimum plan to enable audit logs; it defaults to `enterprise`
  Ticket: ALV-115
* introduce limit for maximum number of users
* new configuration setting `rbac_min_plan` to specify the minimum plan to enable RBAC; it defaults to `enterprise`
  Ticket: ALV-135
* Add OIDC integration with Azure Marketplace
* introduce plans API
* support for Ed25519 server keys for signing the JWT tokens
  ([MEN-5676](https://northerntech.atlassian.net/browse/MEN-5676))
* restrict access to dynamic groups and SSO
* remove checks for enterprise plan in some endpoint handlers

  Access to this endpoints is restricted by applying access rules.
* add file_transfer feature flag to plan definitions
* introduce new feature flag - reporting
* "kid" support in JWT header and multiple keys.
  ([MEN-6804](https://northerntech.atlassian.net/browse/MEN-6804))
* extend basic permissions with access to /plans and /plan_binding endpoints
* make service compatible with redis cluster

  Changes:
  - do not use redis databases;
  - use service/version specific prefix for all the keys;
  - change redis configuration - use connection string to create redis
    client;
  - do not use flush db command;

  BREAKING CHANGE: Old redis_* configuration parameters are deprecated
  and most of them will not work. Use redis_connection_string and
  redis_key_prefix to configure redis cache client.
  ([MC-6926](https://northerntech.atlassian.net/browse/MC-6926))
* replace method for flushing database with method for suspending tenant

  We achive cache invalidation by incrementing tenant key version.
  Each tenant related key in the cache has to contain tenant key version.
  This way, by incrementing tenant key version, we invalidate all tenant
  related keys.
  ([MC-6926](https://northerntech.atlassian.net/browse/MC-6926))
* allow empty POST to sso/idp/metadata and later PUT of metadata.
  ([MEN-6340](https://northerntech.atlassian.net/browse/MEN-6340))

##### Other

* improve the SSO filter implementation
  ([MEN-5733](https://northerntech.atlassian.net/browse/MEN-5733))
* add "reporting" feature flag to API spec

#### workflows (2.6.0)

New changes in workflows since 2.5.1:

##### Bug fixes

* do not use deprecated types and methods from bson package

##### Features

* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* get job status by id
  ([MEN-6791](https://northerntech.atlassian.net/browse/MEN-6791))

#### workflows-enterprise (2.6.0)

New changes in workflows-enterprise since 2.5.1:

##### Bug fixes

* fixed an issue on publishing the workflows-worker container
  image ([QA-613](https://northerntech.atlassian.net/browse/QA-613))
* do not use deprecated types and methods from bson package
* do not use deprecated types and methods from bson package
* demo artifact generation
  ([MEN-6857](https://northerntech.atlassian.net/browse/MEN-6857))
* Missing path prefix from hubspot URLs

##### Features

* do not create the user in the create_organization workflow
  ([MEN-5733](https://northerntech.atlassian.net/browse/MEN-5733))
* Added multiplatform build
  ([QA-613](https://northerntech.atlassian.net/browse/QA-613))

* workflow for setting tenant limits
* get job status by id
  ([MEN-6791](https://northerntech.atlassian.net/browse/MEN-6791))

##### Other

* use aiosmtpd instead of smtpd

##### Dependabot bumps


## Mender 3.6.3

_Released 10.18.2023_

### Statistics

| Developers with the most changesets | |
|---|---|
| Fabio Tranchitella | 15 (42.9%) |
| Manuel Zedel | 5 (14.3%) |
| Krzysztof Jaskiewicz | 5 (14.3%) |
| Peter Grzybowski | 3 (8.6%) |
| Lluis Campos | 3 (8.6%) |
| Alf-Rune Siqveland | 2 (5.7%) |
| Roberto Giovanardi | 1 (2.9%) |
| Kristian Amlie | 1 (2.9%) |

| Developers with the most changed lines | |
|---|---|
| Peter Grzybowski | 296 (29.7%) |
| Fabio Tranchitella | 232 (23.2%) |
| Krzysztof Jaskiewicz | 227 (22.7%) |
| Manuel Zedel | 117 (11.7%) |
| Roberto Giovanardi | 78 (7.8%) |
| Lluis Campos | 31 (3.1%) |
| Kristian Amlie | 14 (1.4%) |
| Alf-Rune Siqveland | 3 (0.3%) |

| Developers with the most lines removed | |
|---|---|
| Krzysztof Jaskiewicz | 109 (18.8%) |
| Manuel Zedel | 45 (7.8%) |
| Kristian Amlie | 7 (1.2%) |

| Developers with the most signoffs (total 1) | |
|---|---|
| Lluis Campos | 1 (100.0%) |

| Top changeset contributors by employer | |
|---|---|
| | Northern.tech | 35 (100.0%) |

Top lines changed by employer | |
|---|---|
| Northern.tech | 998 (100.0%) |

| Employers with the most signoffs (total 1) | |
|---|---|
| Northern.tech | 1 (100.0%) |

| Employers with the most hackers (total 8) | |
|---|---|
| Northern.tech | 8 (100.0%) |

### Changelogs

#### deployments (4.5.2)

New changes in deployments since 4.5.0:

##### Bug fixes

* db.Find: look for phrases (escape the $text elements)
  ([MEN-6730](https://northerntech.atlassian.net/browse/MEN-6730))

##### Features

* direct upload with skip verify: set metadata on complete
  ([MEN-6696](https://northerntech.atlassian.net/browse/MEN-6696))

#### deployments-enterprise (4.5.2)

New changes in deployments-enterprise since 4.5.1:

##### Bug fixes

* db.Find: look for phrases (escape the $text elements)
  ([MEN-6730](https://northerntech.atlassian.net/browse/MEN-6730))

##### Features

* direct upload with skip verify: set metadata on complete
  ([MEN-6696](https://northerntech.atlassian.net/browse/MEN-6696))

#### integration (3.6.3)

New changes in integration since 3.6.2:

* Upgrade deployments-enterprise to 4.5.2.
* Upgrade deployments to 4.5.2.
* Upgrade generate-delta-worker to 1.0.2.
* Upgrade gui to 3.6.2.
* Upgrade integration to 3.6.3.
* Upgrade inventory-enterprise to 4.3.2.
* Upgrade inventory to 4.3.2.
* Upgrade mender-artifact to 3.10.2.
* Upgrade mender-cli to 1.11.1.
* Upgrade mender-connect to 2.1.1.
* Upgrade mender-convert to 4.0.3.
* Upgrade mtls-ambassador to 1.2.1.
* Upgrade useradm-enterprise to 1.21.2.
* Upgrade workflows-enterprise to 2.5.1.
* Upgrade workflows to 2.5.1.

#### inventory (4.3.2)

New changes in inventory since 4.3.1:

##### Bug fixes

* update `updated_ts` only if we are updating the inventory scope
  ([MEN-6705](https://northerntech.atlassian.net/browse/MEN-6705))

#### inventory-enterprise (4.3.2)

New changes in inventory-enterprise since 4.3.1:

##### Bug fixes

* update `updated_ts` only if we are updating the inventory scope
  ([MEN-6705](https://northerntech.atlassian.net/browse/MEN-6705))

#### mtls-ambassador (1.2.1)

New changes in mtls-ambassador since 1.2.0:

##### Bug fixes

* update the API docs for the `/status` internal endpoint
  ([MEN-6700](https://northerntech.atlassian.net/browse/MEN-6700))
* misleading stack trace on auth errors
  ([MEN-6746](https://northerntech.atlassian.net/browse/MEN-6746))

#### useradm-enterprise (1.21.2)

New changes in useradm-enterprise since 1.21.1:

##### Bug fixes

* SAML authentication not case insensitive
  ([MEN-6750](https://northerntech.atlassian.net/browse/MEN-6750))

#### workflows (2.5.1)

New changes in workflows since 2.5.0:

##### Bug fixes

* `migrate` command tries to create Jetstream consumer before stream
  ([MEN-6698](https://northerntech.atlassian.net/browse/MEN-6698))

#### workflows-enterprise (2.5.1)

New changes in workflows-enterprise since 2.5.0:

##### Bug fixes

* `migrate` command tries to create Jetstream consumer before stream
  ([MEN-6698](https://northerntech.atlassian.net/browse/MEN-6698))


## Mender 3.6.2

_Released 08.25.2023_

### Statistics

A total of 60 lines added, 60 removed (delta 0)

| Developers with the most changesets | |
|---|---|
| Fabio Tranchitella | 1 (100.0%) |

| Developers with the most changed lines | |
|---|---|
| Fabio Tranchitella | 60 (100.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 1 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 60 (100.0%) |

| Employers with the most hackers (total 1) | |
|---|---|
| Northern.tech | 1 (100.0%) |

### Changelogs

#### integration (3.6.2)

New changes in integration since 3.6.1:

* Upgrade integration to 3.6.2.
* Upgrade mender-convert to 4.0.2.


## Mender 3.6.1

_Released 08.19.2023_

### Statistics

A total of 180 lines added, 100 removed (delta 80)

| Developers with the most changesets | |
|---|---|
| Fabio Tranchitella | 5 (55.6%) |
| Manuel Zedel | 4 (44.4%) |

| Developers with the most changed lines | |
|---|---|
| Fabio Tranchitella | 117 (65.0%) |
| Manuel Zedel | 63 (35.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 9 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 180 (100.0%) |

| Employers with the most hackers (total 2) | |
|---|---|
| Northern.tech | 2 (100.0%) |

### Changelogs

#### create-artifact-worker (1.3.2)

New changes in create-artifact-worker since 1.3.1:

##### Features

* update mender-artifact to `3.10.1`

#### deployments-enterprise (4.5.1)

New changes in deployments-enterprise since 4.5.0:

##### Bug fixes

* ignore artifact_name when checking if an artifact is already installed
  ([MEN-6644](https://northerntech.atlassian.net/browse/MEN-6644))

#### gui (3.6.1)

New changes in gui since 3.6.0:

##### Bug fixes

* fixed an issue that prevented deselecting a release selection during deployment creation
* ensured current software alias is more reliably shown in column customization dialog
  ([MEN-6641](https://northerntech.atlassian.net/browse/MEN-6641))

#### integration (3.6.1)

New changes in integration since 3.6.0:

* Upgrade create-artifact-worker to 1.3.2.
* Upgrade deployments-enterprise to 4.5.1.
* Upgrade gui to 3.6.1.
* Upgrade integration to 3.6.1.
* Upgrade mender-configure-module to 1.1.1.
* Upgrade useradm-enterprise to 1.21.1.

#### useradm-enterprise (1.21.1)

New changes in useradm-enterprise since 1.21.0:

##### Bug fixes

* add directupload API endpoints to the `UploadArtifacts` permission set
  ([MEN-6642](https://northerntech.atlassian.net/browse/MEN-6642))


## Mender 3.6.0

_Released 07.28.2023_

### Statistics

A total of 34993 lines added, 21314 removed (delta 13679)

| Developers with the most changesets | |
|---|---|
| Manuel Zedel | 143 (44.1%) |
| Krzysztof Jaskiewicz | 48 (14.8%) |
| Alf-Rune Siqveland | 42 (13.0%) |
| Fabio Tranchitella | 42 (13.0%) |
| Peter Grzybowski | 22 (6.8%) |
| Lluis Campos | 14 (4.3%) |
| Michael Clelland | 6 (1.9%) |
| Mender Test Bot | 3 (0.9%) |
| Alex Miliukov | 2 (0.6%) |
| Kristian Amlie | 1 (0.3%) |

| Developers with the most changed lines | |
|---|---|
| Manuel Zedel | 16299 (36.7%) |
| Krzysztof Jaskiewicz | 7188 (16.2%) |
| Fabio Tranchitella | 7135 (16.1%) |
| Peter Grzybowski | 5326 (12.0%) |
| Alf-Rune Siqveland | 3988 (9.0%) |
| Mender Test Bot | 3871 (8.7%) |
| Lluis Campos | 419 (0.9%) |
| Michael Clelland | 122 (0.3%) |
| Roman Ondráček | 14 (0.0%) |
| Alex Miliukov | 12 (0.0%) |

| Developers with the most lines removed | |
|---|---|
| Fabio Tranchitella | 1622 (7.6%) |
| Krzysztof Jaskiewicz | 1273 (6.0%) |
| Lluis Campos | 26 (0.1%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 323 (99.7%) |
| ondracek.roman@centrum.cz | 1 (0.3%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 44371 (100.0%) |
| ondracek.roman@centrum.cz | 14 (0.0%) |

| Employers with the most hackers (total 11) | |
|---|---|
| Northern.tech | 10 (90.9%) |
| ondracek.roman@centrum.cz | 1 (9.1%) |

### Changelogs

#### deployments (4.5.0)

New changes in deployments since 4.4.1:

##### Bug fixes

* increment deployment total size only if new artifact has been assigned
* add undocumented groups field to deployment object
* fix model of the last device deployment status request
* save correct status of last finished deployment
* Delete device deployment history incorrectly triggering reindex

  The endpoint was missing the reporting feature flag check, which caused
  it to send reindexing request even though the reporting service is
  disabled.
  ([MEN-6614](https://northerntech.atlassian.net/browse/MEN-6614))

##### Features

* add artifact information to deployment device information
  ([MEN-3995](https://northerntech.atlassian.net/browse/MEN-3995))
* track and show deployment total size
  ([MEN-3994](https://northerntech.atlassian.net/browse/MEN-3994))
* Retrieve signed direct upload URL for artifacts

  This is the first part of the implementation of the direct artifact
  upload feature. This commit introduce a new API that issues signed
  upload URLs for transferring artifacts directly to the storage backend
  without involoving the Mender backend services.
  POST /api/management/v1/deployments/artifacts/directupload
  ([MEN-5989](https://northerntech.atlassian.net/browse/MEN-5989))
* Direct artifact upload API

  Users can upload artifacts asynchronously to the object storage backend
  using the API to generate a signed upload link:
  POST /api/management/v1/deployments/artifacts/directupload
  The response contains a link and an allocated artifact ID. Once the
  artifact is uploaded, calling another API will make the backend parse
  the artifact and make it available for devices:
  POST /api/management/v1/deployments/artifacts/directupload/:id/complete
  ([MEN-6337](https://northerntech.atlassian.net/browse/MEN-6337))
* New command 'storage-daemon' for cleaning up expired objects from storage
  ([MEN-6339](https://northerntech.atlassian.net/browse/MEN-6339))
* Store device deployments status separately
  ([MEN-6423](https://northerntech.atlassian.net/browse/MEN-6423))
* internal endpoint to get the latest device deployment statuses
  ([MEN-6421](https://northerntech.atlassian.net/browse/MEN-6421))
* Skip verification and download of the artifact via DEPLYOMENTS_DIRECT_UPLOAD_SKIP_VERIFY
  ([MEN-6474](https://northerntech.atlassian.net/browse/MEN-6474))
* Add configuration option to skip signing headers for s3
  ([MEN-6501](https://northerntech.atlassian.net/browse/MEN-6501))

##### Other

* docs(management API spec): extend device object with image info

  /deployments/{deployment_id}/devices/list endpoint will return list of
  device objects with info about images assigned to given device;
  The same is true for deprecated /deployments/{deployment_id}/devices
  ([MEN-3995](https://northerntech.atlassian.net/browse/MEN-3995))
* docs(management API spec): extend main deployment object with statistics
  ([MEN-3994](https://northerntech.atlassian.net/browse/MEN-3994))
* refac: refactor GetDeploymentForDeviceWithCurrent method

  Changes:
  - code refactoring
  - assign artifact to device deployment object even
    if given artifact has already been installed
  ([MEN-6363](https://northerntech.atlassian.net/browse/MEN-6363))
* fix(list device deployments): device ID is not always UUID
  ([MEN-6376](https://northerntech.atlassian.net/browse/MEN-6376))
* update of the mender-artifact including zstd compression
  ([MEN-6617](https://northerntech.atlassian.net/browse/MEN-6617))

#### deployments-enterprise (4.5.0)

New changes in deployments-enterprise since 4.4.1:

##### Bug fixes

* increment deployment total size only if new artifact has been assigned
* increment deployment total size only if new artifact has been assigned
* add undocumented groups field to deployment object
* add undocumented groups field to deployment object
* fix model of the last device deployment status request
* save correct status of last finished deployment
* fix model of the last device deployment status request
* save correct status of last finished deployment
* Delete device deployment history incorrectly triggering reindex

  The endpoint was missing the reporting feature flag check, which caused
  it to send reindexing request even though the reporting service is
  disabled.
  ([MEN-6614](https://northerntech.atlassian.net/browse/MEN-6614))

##### Features

* add artifact information to deployment device information
  ([MEN-3995](https://northerntech.atlassian.net/browse/MEN-3995))
* track and show deployment total size
  ([MEN-3994](https://northerntech.atlassian.net/browse/MEN-3994))
* Retrieve signed direct upload URL for artifacts

  This is the first part of the implementation of the direct artifact
  upload feature. This commit introduce a new API that issues signed
  upload URLs for transferring artifacts directly to the storage backend
  without involoving the Mender backend services.
  POST /api/management/v1/deployments/artifacts/directupload
  ([MEN-5989](https://northerntech.atlassian.net/browse/MEN-5989))
* Direct artifact upload API

  Users can upload artifacts asynchronously to the object storage backend
  using the API to generate a signed upload link:
  POST /api/management/v1/deployments/artifacts/directupload
  The response contains a link and an allocated artifact ID. Once the
  artifact is uploaded, calling another API will make the backend parse
  the artifact and make it available for devices:
  POST /api/management/v1/deployments/artifacts/directupload/:id/complete
  ([MEN-6337](https://northerntech.atlassian.net/browse/MEN-6337))
* New command 'storage-daemon' for cleaning up expired objects from storage
  ([MEN-6339](https://northerntech.atlassian.net/browse/MEN-6339))
* Store device deployments status separately
  ([MEN-6423](https://northerntech.atlassian.net/browse/MEN-6423))
* internal endpoint to get the latest device deployment statuses
  ([MEN-6421](https://northerntech.atlassian.net/browse/MEN-6421))
* Skip verification and download of the artifact via DEPLYOMENTS_DIRECT_UPLOAD_SKIP_VERIFY
  ([MEN-6474](https://northerntech.atlassian.net/browse/MEN-6474))
* Add configuration option to skip signing headers for s3
  ([MEN-6501](https://northerntech.atlassian.net/browse/MEN-6501))

##### Other

* docs(management API spec): extend device object with image info

  /deployments/{deployment_id}/devices/list endpoint will return list of
  device objects with info about images assigned to given device;
  The same is true for deprecated /deployments/{deployment_id}/devices
  ([MEN-3995](https://northerntech.atlassian.net/browse/MEN-3995))
* docs(management API spec): extend main deployment object with statistics
  ([MEN-3994](https://northerntech.atlassian.net/browse/MEN-3994))
* refac: refactor GetDeploymentForDeviceWithCurrent method

  Changes:
  - code refactoring
  - assign artifact to device deployment object even
    if given artifact has already been installed
  ([MEN-6363](https://northerntech.atlassian.net/browse/MEN-6363))
* fix(list device deployments): device ID is not always UUID
  ([MEN-6376](https://northerntech.atlassian.net/browse/MEN-6376))
* update of the mender-artifact including zstd compression
  ([MEN-6617](https://northerntech.atlassian.net/browse/MEN-6617))

#### deviceauth (3.5.0)

New changes in deviceauth since 3.4.0:

##### Bug fixes

* Do not terminate process if Redis is unavailable
  ([MEN-6399](https://northerntech.atlassian.net/browse/MEN-6399))
* do not accept device which is being decommissioned
  ([MEN-6504](https://northerntech.atlassian.net/browse/MEN-6504))

##### Features

* handle device check-in time
  ([MEN-6372](https://northerntech.atlassian.net/browse/MEN-6372), [MEN-6373](https://northerntech.atlassian.net/browse/MEN-6373), [MEN-6379](https://northerntech.atlassian.net/browse/MEN-6379))

#### deviceauth-enterprise (3.5.0)

New changes in deviceauth-enterprise since 3.4.0:

##### Bug fixes

* Do not terminate process if Redis is unavailable
  ([MEN-6399](https://northerntech.atlassian.net/browse/MEN-6399))
* do not accept device which is being decommissioned
  ([MEN-6504](https://northerntech.atlassian.net/browse/MEN-6504))

##### Features

* handle device check-in time
  ([MEN-6372](https://northerntech.atlassian.net/browse/MEN-6372), [MEN-6373](https://northerntech.atlassian.net/browse/MEN-6373), [MEN-6379](https://northerntech.atlassian.net/browse/MEN-6379))
* handle device check-in time
  ([MEN-6372](https://northerntech.atlassian.net/browse/MEN-6372), [MEN-6373](https://northerntech.atlassian.net/browse/MEN-6373), [MEN-6379](https://northerntech.atlassian.net/browse/MEN-6379))

#### gui (3.6.0)

New changes in gui since 3.5.1:

##### Bug fixes

* fixed an issue that would prevent properly clearing device group selection on deployment creation
* fixed an issue that would cause the devices view to go to device details when filtering multiple devices by id
* made device group check rely on per device information for more reliable error messages
  ([ME-64](https://northerntech.atlassian.net/browse/ME-64))
* fixed an issue that could cause pagination to select a page out of bounds
* ensured app initialization is done after normal login as well
* also clear input text when confirming an entry to a chip autocomplete
  ([MEN-6440](https://northerntech.atlassian.net/browse/MEN-6440))
* fixed an issue that prevented using some RBAC limited UI features
  ([MEN-6461](https://northerntech.atlassian.net/browse/MEN-6461))
* fixed an issue that would result in an infinite loop of navigating between device groups
  ([ME-89](https://northerntech.atlassian.net/browse/ME-89))
* fixed an issue that would prevent navigating from a deployment to the target group
  ([MEN-6416](https://northerntech.atlassian.net/browse/MEN-6416))
* fixed an issue that could prevent showing the device identity for a fresh deployment
  ([MEN-6485](https://northerntech.atlassian.net/browse/MEN-6485))
* fixed an issue that would prevent linking to a specific release
  ([MEN-6492](https://northerntech.atlassian.net/browse/MEN-6492))
* fixed an issue that could cause the release selection to be ignored when creating a deployment from a release
* fixed an issue that would not take device identity selections into account in the deployments lists
* fixed an issue that would prevent linking to devices filtered by something containing ':'
* fixed an issue that prevented filtering for details in the audit log
  ([MEN-6512](https://northerntech.atlassian.net/browse/MEN-6512))
* fixed issues that prevented navigating to a filtered audit log from device details & from within the audit log
  ([MEN-6510](https://northerntech.atlassian.net/browse/MEN-6510))
* added more granular check for device troubleshooting feature
  ([MEN-6487](https://northerntech.atlassian.net/browse/MEN-6487))
* extended monitoring issue levels and fixed an issue that would crash the ui
  ([MEN-6590](https://northerntech.atlassian.net/browse/MEN-6590))
* healthcheck url adjustment.

##### Features

* enabled scheduling deployments to multiple selected devices
  ([MEN-5210](https://northerntech.atlassian.net/browse/MEN-5210))
* added deployment data consumption to completed deployments list
  ([MEN-3917](https://northerntech.atlassian.net/browse/MEN-3917))
* added possibility to create never expiring PATs
  ([ME-59](https://northerntech.atlassian.net/browse/ME-59))
* updated releases section to ease navigating bigger numbers of releases
  ([MEN-6347](https://northerntech.atlassian.net/browse/MEN-6347))
* allowed release navigation by url + query
* added installation counter for artifacts with non-legacy versioning scheme
  ([MEN-6345](https://northerntech.atlassian.net/browse/MEN-6345))
* extended role creation capabilities to allow release tag based role settings
  ([MEN-6347](https://northerntech.atlassian.net/browse/MEN-6347))
* made tenant id visible in the settings to prevent accidental tenanttoken submissions
  ([MEN-6508](https://northerntech.atlassian.net/browse/MEN-6508))

##### Other

* added size + delta information in deployment device table
  ([MEN-3917](https://northerntech.atlassian.net/browse/MEN-3917))

#### integration (3.6.0)

New changes in integration since 3.5.1:

##### Bug fixes

* test: test_compat: UTC TZ does not need +hh:mm

##### Features

* add docker-compose v2 support

##### Other

* test: backend test for show artifact download size feature
  ([MEN-4346](https://northerntech.atlassian.net/browse/MEN-4346))
* Upgrade auditlogs to 3.1.1.
* Upgrade create-artifact-worker to 1.3.1.
* Upgrade deployments-enterprise to 4.5.0.
* Upgrade deployments to 4.5.0.
* Upgrade deviceauth-enterprise to 3.5.0.
* Upgrade deviceauth to 3.5.0.
* Upgrade deviceconfig to 1.3.1.
* Upgrade deviceconnect to 1.4.1.
* Upgrade devicemonitor to 1.4.1.
* Upgrade generate-delta-worker to 1.0.1.
* Upgrade gui to 3.6.0.
* Upgrade integration to 3.6.0.
* Upgrade inventory-enterprise to 4.3.1.
* Upgrade inventory to 4.3.1.
* Upgrade iot-manager to 1.2.1.
* Upgrade mender-artifact to 3.10.1.
* Upgrade mender-cli to 1.11.0.
* Upgrade mender-configure-module to 1.1.0.
* Upgrade mender to 3.5.1.
* Upgrade monitor-client to 1.3.0.
* Upgrade useradm-enterprise to 1.21.0.
* Upgrade useradm to 1.21.0.
* Upgrade workflows-enterprise to 2.5.0.
* Upgrade workflows to 2.5.0.

#### useradm (1.21.0)

New changes in useradm since 1.20.1:

##### Bug fixes

* Return 400 for malformed JSON schema to POST /auth/login
  ([MEN-6411](https://northerntech.atlassian.net/browse/MEN-6411))
* Fix broken TTL index in tokens collection after migration 2.0.0
  ([MEN-6550](https://northerntech.atlassian.net/browse/MEN-6550))

##### Features

* add support for never expiring PATs
  ([ME-59](https://northerntech.atlassian.net/browse/ME-59))
* add support for returning never-expiring JWT tokens when logging in
  ([MEN-6378](https://northerntech.atlassian.net/browse/MEN-6378))
* limit the number of JWT tokens (sessions) per user
  ([MEN-6382](https://northerntech.atlassian.net/browse/MEN-6382))

#### useradm-enterprise (1.21.0)

New changes in useradm-enterprise since 1.20.1:

##### Bug fixes

* update `login_ts` when logging in using SAML and OAuth2
  ([ME-66](https://northerntech.atlassian.net/browse/ME-66))
* fix regular expression for finding device id in the path
  ([MEN-6405](https://northerntech.atlassian.net/browse/MEN-6405))
* Return 400 for malformed JSON schema to POST /auth/login
  ([MEN-6411](https://northerntech.atlassian.net/browse/MEN-6411))
* Add API for getting two-factor authentication QR to basic permissions
  ([ME-55](https://northerntech.atlassian.net/browse/ME-55))
* Fix broken TTL index in tokens collection after migration 2.0.0
  ([MEN-6550](https://northerntech.atlassian.net/browse/MEN-6550))

##### Features

* add support for never expiring PATs
  ([ME-59](https://northerntech.atlassian.net/browse/ME-59))
* add support for returning never-expiring JWT tokens when logging in
  ([MEN-6378](https://northerntech.atlassian.net/browse/MEN-6378))
* limit the number of JWT tokens (sessions) per user
  ([MEN-6382](https://northerntech.atlassian.net/browse/MEN-6382))
* extend read permission with access to new reporting endpoints

  Read Devices permission set (and thus "observer" role) will grant access to:
  - /api/management/v1/reporting/devices/search/attributes
  - /api/management/v1/reporting/devices/attributes
  - /api/management/v1/reporting/devices/aggregate
  ([MEN-6405](https://northerntech.atlassian.net/browse/MEN-6405))
* extend read permission with access to new reporting endpoints

  Read Devices permission set (and thus "observer" role) will grant access to:
  - /api/management/v1/reporting/deployments/devices/search
  - /api/management/v1/reporting/deployments/devices/aggregate
  ([MEN-6405](https://northerntech.atlassian.net/browse/MEN-6405))

#### workflows (2.5.0)

New changes in workflows since 2.4.0:

##### Bug fixes

* Make Jetstream initialization contextual on `server` and `worker` commands
  ([MEN-6459](https://northerntech.atlassian.net/browse/MEN-6459))

##### Features

* Expose NATS consumer configuration parameters
  ([MEN-6450](https://northerntech.atlassian.net/browse/MEN-6450))

#### workflows-enterprise (2.5.0)

New changes in workflows-enterprise since 2.4.0:

##### Bug fixes

* Make Jetstream initialization contextual on `server` and `worker` commands
  ([MEN-6459](https://northerntech.atlassian.net/browse/MEN-6459))

##### Features

* Expose NATS consumer configuration parameters
  ([MEN-6450](https://northerntech.atlassian.net/browse/MEN-6450))
* workflow: moving to create contacts in HubSpot.
  ([MEN-6420](https://northerntech.atlassian.net/browse/MEN-6420))

##### Other

* fix: create temporary files in the /tmp directory to avoid permission issues when running the service as a non-root user
  ([MEN-5809](https://northerntech.atlassian.net/browse/MEN-5809))
* HubSpot tenant suspension


## Mender 3.5.1

_Released 03.08.2023_

### Statistics

A total of 279 lines added, 143 removed (delta 136)

| Developers with the most changesets | |
|---|---|
| Lluis Campos | 5 (35.7%) |
| Fabio Tranchitella | 4 (28.6%) |
| Alf-Rune Siqveland | 2 (14.3%) |
| Manuel Zedel | 2 (14.3%) |
| Kristian Amlie | 1 (7.1%) |

| Developers with the most changed lines | |
|---|---|
| Fabio Tranchitella | 126 (44.8%) |
| Kristian Amlie | 63 (22.4%) |
| Alf-Rune Siqveland | 48 (17.1%) |
| Lluis Campos | 24 (8.5%) |
| Manuel Zedel | 20 (7.1%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 14 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 281 (100.0%) |

| Employers with the most hackers (total 5) | |
|---|---|
| Northern.tech | 5 (100.0%) |

### Changelogs

#### deployments (4.4.1)

New changes in deployments since 4.4.0:

##### Bug fixes

* Use separate object storage path for raw file and artifact
  ([MEN-6091](https://northerntech.atlassian.net/browse/MEN-6091))

#### deployments-enterprise (4.4.1)

New changes in deployments-enterprise since 4.4.0:

##### Bug fixes

* Use separate object storage path for raw file and artifact
  ([MEN-6091](https://northerntech.atlassian.net/browse/MEN-6091))

#### integration (3.5.1)

New changes in integration since 3.5.0:

* Upgrade deployments-enterprise to 4.4.1.
* Upgrade deployments to 4.4.1.
* Upgrade gui to 3.5.1.
* Upgrade integration to 3.5.1.
* Upgrade mender-convert to 4.0.1.
* Upgrade reporting to 1.0.1.
* Upgrade useradm-enterprise to 1.20.1.
* Upgrade useradm to 1.20.1.

#### reporting (1.0.1)

New changes in reporting since 1.0.0:

##### Bug fixes

* update `/deployments` API end-points to `deployments/devices`
  ([MEN-6331](https://northerntech.atlassian.net/browse/MEN-6331))
* add `deployment_started` to the mapping
  ([MEN-6328](https://northerntech.atlassian.net/browse/MEN-6328))
* filter device deployment records by device and deployment IDs
  ([MEN-6330](https://northerntech.atlassian.net/browse/MEN-6330))

#### useradm-enterprise (1.20.1)

New changes in useradm-enterprise since 1.20.0:

##### Bug fixes

* do not allow password reset for SSO users
  ([ME-60](https://northerntech.atlassian.net/browse/ME-60))


## Mender 3.5.0

_Released 02.20.2023_

### Security fixes

* Fixed CVE-2022-45929 - Low-privileged users can edit their own roles.
  See the official announcement for more information:
  [mender.io/blog/cve-2022-45929-cve-2022-41324-improper-access-control-for-low-privileged-users](https://mender.io/blog/cve-2022-45929-cve-2022-41324-improper-access-control-for-low-privileged-users)

### Statistics

A total of 44757 lines added, 18182 removed (delta 26575)

| Developers with the most changesets | |
|---|---|
| Manuel Zedel | 194 (30.5%) |
| Alf-Rune Siqveland | 110 (17.3%) |
| Fabio Tranchitella | 93 (14.6%) |
| Lluis Campos | 73 (11.5%) |
| Krzysztof Jaskiewicz | 48 (7.5%) |
| Peter Grzybowski | 41 (6.4%) |
| Ole Petter Orhagen | 26 (4.1%) |
| Maciej Tomczuk | 21 (3.3%) |
| Alex Miliukov | 13 (2.0%) |
| Kristian Amlie | 12 (1.9%) |

| Developers with the most changed lines | |
|---|---|
| Manuel Zedel | 13129 (27.4%) |
| Krzysztof Jaskiewicz | 9564 (19.9%) |
| Alf-Rune Siqveland | 7652 (15.9%) |
| Fabio Tranchitella | 7147 (14.9%) |
| Peter Grzybowski | 4569 (9.5%) |
| Maciej Tomczuk | 2617 (5.5%) |
| Lluis Campos | 1223 (2.5%) |
| Kristian Amlie | 1148 (2.4%) |
| Ole Petter Orhagen | 604 (1.3%) |
| Alex Miliukov | 322 (0.7%) |

| Developers with the most signoffs (total 1) | |
|---|---|
| Manuel Zedel | 1 (100.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 636 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 47985 (100.0%) |

| Employers with the most signoffs (total 1) | |
|---|---|
| Northern.tech | 1 (100.0%) |

| Employers with the most hackers (total 12) | |
|---|---|
| Northern.tech | 12 (100.0%) |

### Changelogs

#### auditlogs (3.1.0)

New changes in auditlogs since 3.0.2:

##### Bug fixes

* update API specs and validation to accept all object types as filters
  ([MEN-6247](https://northerntech.atlassian.net/browse/MEN-6247))

##### Other

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5506](https://northerntech.atlassian.net/browse/MEN-5506))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.4 to 1.7.7.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.4...v1.7.7)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### create-artifact-worker (1.3.0)

New changes in create-artifact-worker since 1.2.0:

##### Features

* accept more single-file-artifact-gen arguments
  ([MEN-6046](https://northerntech.atlassian.net/browse/MEN-6046))

##### Other

* Update mender-artifact tool to latest

#### deployments (4.4.0)

New changes in deployments since 4.3.0:

##### Bug fixes

* Enforce setting validation constraints for internal PUT settings endpoint
  ([MEN-5908](https://northerntech.atlassian.net/browse/MEN-5908))
* use correct artifact size for multipart uploads
* Internal storage API not following PUT semantics
* Content-Disposition of artifacts set to artifact name instead of ID
  ([MEN-6025](https://northerntech.atlassian.net/browse/MEN-6025))
* reindex device deployments when resetting device deployments history
  ([MEN-6253](https://northerntech.atlassian.net/browse/MEN-6253))

##### Features

* Include HTTP method in link objects
* Add support for Azure Blob Storage

  The storage configurations have been refactored to gather storage settings
  that are not specific to vendors; the old configuration settings are
  aliases to the new settings.
  ([MEN-5871](https://northerntech.atlassian.net/browse/MEN-5871))
* Allow arbitrary storage backend per tenant
  ([MEN-5942](https://northerntech.atlassian.net/browse/MEN-5942))
* change image (aka artifact) schema

  With the new schema it will be possible to query by artifact provides.
  ([MEN-6107](https://northerntech.atlassian.net/browse/MEN-6107))
* use scratch as base image, run as non-root user
  ([MEN-5658](https://northerntech.atlassian.net/browse/MEN-5658))
* endpoint for returning the deployments history for a given device
  ([MEN-6045](https://northerntech.atlassian.net/browse/MEN-6045))
* add newly uploaded artifacts to existing deployments

  If newly uploaded artifact has same name as artifacts in some of the
  pending deployments, the artifact will become part of these deployments.
  ([MEN-5806](https://northerntech.atlassian.net/browse/MEN-5806))
* new deployment's option to force the installation of the Artifacts
  ([MEN-6131](https://northerntech.atlassian.net/browse/MEN-6131))
* end-point to the delete device deployments history
  ([MEN-6134](https://northerntech.atlassian.net/browse/MEN-6134))
* ignore deleted device deployments in all end-points
  ([MEN-6135](https://northerntech.atlassian.net/browse/MEN-6135))
* expose the image object in the device deployment API endpoints
  ([MEN-6138](https://northerntech.atlassian.net/browse/MEN-6138))
* internal end-point to retrieve the device deployments history
  ([MEN-5911](https://northerntech.atlassian.net/browse/MEN-5911))
* trigger a device reindex in reporting when a device deployment finishes
  ([MEN-5911](https://northerntech.atlassian.net/browse/MEN-5911))
* add support to filter device deployments by status `finished`
  ([MEN-5911](https://northerntech.atlassian.net/browse/MEN-5911))
* internal end point to get device deployments by ID
  ([MEN-5930](https://northerntech.atlassian.net/browse/MEN-5930))
* trigger the deployment reindex workflow on deployment completion
  ([MEN-5930](https://northerntech.atlassian.net/browse/MEN-5930))
* add special representation of artifact provides to artifact object
* Add support for zstd compressed artifacts.
* CLI command to reindex to the reporting service all the device deployments
  ([MEN-6252](https://northerntech.atlassian.net/browse/MEN-6252))

##### Other

* chore(go mod): Bump required Golang version to 1.18
* Upgrade github.com/Azure/azure-sdk-for-go/sdk/storage/azblob to v0.6.1
  ([MEN-6187](https://northerntech.atlassian.net/browse/MEN-6187))
* fix(workflows client): do not fail when identity is not present in the context
  ([MEN-6252](https://northerntech.atlassian.net/browse/MEN-6252))

#### deployments-enterprise (4.4.0)

New changes in deployments-enterprise since 4.3.0:

##### Bug fixes

* Enforce setting validation constraints for internal PUT settings endpoint
  ([MEN-5908](https://northerntech.atlassian.net/browse/MEN-5908))
* use correct artifact size for multipart uploads
* Internal storage API not following PUT semantics
* Content-Disposition of artifacts set to artifact name instead of ID
  ([MEN-6025](https://northerntech.atlassian.net/browse/MEN-6025))
* autogenerate delta fixes

  Changes:
  - fix binary delta module version key
  - improve error handling
  - get generate delta job timeout from the right place from configuration
  - fix generate delta job status URL
  ([MEN-5806](https://northerntech.atlassian.net/browse/MEN-5806))
* change error handling in configuration related endpoints

  Changes:
  - when there is no per tenant configuration, return empty object instead
  of 404
  - on attempt of changing binary delta configuration:
   - when the configuration does not exists at all - return 404
   - when the delta generation is disabled for the given tenant return 409
* reindex device deployments when resetting device deployments history
  ([MEN-6253](https://northerntech.atlassian.net/browse/MEN-6253))
* get full configuration in the deployments/next handler
  ([MEN-6299](https://northerntech.atlassian.net/browse/MEN-6299))

##### Features

* Include HTTP method in link objects
* Add support for Azure Blob Storage

  The storage configurations have been refactored to gather storage settings
  that are not specific to vendors; the old configuration settings are
  aliases to the new settings.
  ([MEN-5871](https://northerntech.atlassian.net/browse/MEN-5871))
* endpoints for getting and setting per tenant configuration
  ([MEN-5804](https://northerntech.atlassian.net/browse/MEN-5804))
* add possibility to enable autogeneration of delta artifacts for a given deploymnet
  ([MEN-5844](https://northerntech.atlassian.net/browse/MEN-5844))
* introduce timeout limits for xdelta job generation
  ([MEN-5804](https://northerntech.atlassian.net/browse/MEN-5804))
* Allow arbitrary storage backend per tenant
  ([MEN-5942](https://northerntech.atlassian.net/browse/MEN-5942))
* handle strict schema for binary delta arguments
  ([MEN-5940](https://northerntech.atlassian.net/browse/MEN-5940))
* handle auto-generation of delta artifacts
  ([MEN-5805](https://northerntech.atlassian.net/browse/MEN-5805))
* internal endpoint for updating generate delta jobs
  ([MEN-5850](https://northerntech.atlassian.net/browse/MEN-5850))
* change image (aka artifact) schema

  With the new schema it will be possible to query by artifact provides.
  ([MEN-6107](https://northerntech.atlassian.net/browse/MEN-6107))
* use scratch as base image, run as non-root user
  ([MEN-5658](https://northerntech.atlassian.net/browse/MEN-5658))
* endpoint for returning the deployments history for a given device
  ([MEN-6045](https://northerntech.atlassian.net/browse/MEN-6045))
* adjust query to new image/artifact schema
  ([MEN-6107](https://northerntech.atlassian.net/browse/MEN-6107))
* add newly uploaded artifacts to existing deployments

  If newly uploaded artifact has same name as artifacts in some of the
  pending deployments, the artifact will become part of these deployments.
  ([MEN-5806](https://northerntech.atlassian.net/browse/MEN-5806))
* add newly uploaded artifacts to existing deployments

  If newly uploaded artifact has same name as artifacts in some of the
  pending deployments, the artifact will become part of these deployments.
  ([MEN-5806](https://northerntech.atlassian.net/browse/MEN-5806))
* new deployment's option to force the installation of the Artifacts
  ([MEN-6131](https://northerntech.atlassian.net/browse/MEN-6131))
* end-point to the delete device deployments history
  ([MEN-6134](https://northerntech.atlassian.net/browse/MEN-6134))
* ignore deleted device deployments in all end-points
  ([MEN-6135](https://northerntech.atlassian.net/browse/MEN-6135))
* expose the image object in the device deployment API endpoints
  ([MEN-6138](https://northerntech.atlassian.net/browse/MEN-6138))
* expose the image object in the device deployment API endpoints
  ([MEN-6138](https://northerntech.atlassian.net/browse/MEN-6138))
* internal end-point to retrieve the device deployments history
  ([MEN-5911](https://northerntech.atlassian.net/browse/MEN-5911))
* trigger a device reindex in reporting when a device deployment finishes
  ([MEN-5911](https://northerntech.atlassian.net/browse/MEN-5911))
* add support to filter device deployments by status `finished`
  ([MEN-5911](https://northerntech.atlassian.net/browse/MEN-5911))
* internal end point to get device deployments by ID
  ([MEN-5930](https://northerntech.atlassian.net/browse/MEN-5930))
* trigger the deployment reindex workflow on deployment completion
  ([MEN-5930](https://northerntech.atlassian.net/browse/MEN-5930))
* add special representation of artifact provides to artifact object
* add special representation of artifact provides to artifact object
* decide if the artifact has already been installed based on provides
  ([MEN-6096](https://northerntech.atlassian.net/browse/MEN-6096))
* chagnge in checking if artifact has already been installed

  if the device provides only artifact name and the device type
  fall back to simple check - compare artifact name from the request with
  artifact name from the deployment
  ([MEN-6096](https://northerntech.atlassian.net/browse/MEN-6096))
* Add support for zstd compressed artifacts.
* CLI command to reindex to the reporting service all the device deployments
  ([MEN-6252](https://northerntech.atlassian.net/browse/MEN-6252))

##### Other

* chore(go mod): Bump required Golang version to 1.18
* feat(workflows client): new methods introduced

  Methods for starting workflow for generating delta artifact
  and for checking workflow status.
  ([MEN-5803](https://northerntech.atlassian.net/browse/MEN-5803))
* docs: strict schema for binary delta configuration
  ([MEN-5940](https://northerntech.atlassian.net/browse/MEN-5940))
* fix(delta generation): select rootfs-image as a base image for delta

  It is possible to have more than one image with the same rootfs version
  and rootfs checksum. In fact this is a normal situation when you will
  generate delta image.
  To be able to autogenerate delta for the device, the deployments service
  has to find artifact which is installed on the device, and this artifact
  has to be of "rootfs-image" type.
* fix(delta generation): fix endpoint for updating delta generation job status
* feat(delta configuration): introduce default configuration
* Upgrade github.com/Azure/azure-sdk-for-go/sdk/storage/azblob to v0.6.1
  ([MEN-6187](https://northerntech.atlassian.net/browse/MEN-6187))
* fix(workflows client): do not fail when identity is not present in the context
  ([MEN-6252](https://northerntech.atlassian.net/browse/MEN-6252))

#### deviceauth (3.4.0)

New changes in deviceauth since 3.3.0:

##### Bug fixes

* data inconsistency
  ([ME-41](https://northerntech.atlassian.net/browse/ME-41))
* trigger reporting reindex on device decommissioning
  ([MEN-6211](https://northerntech.atlassian.net/browse/MEN-6211))

##### Features

* CLI command to reindex to the reporting service all the devices
  ([MEN-6183](https://northerntech.atlassian.net/browse/MEN-6183))

#### deviceauth-enterprise (3.4.0)

New changes in deviceauth-enterprise since 3.3.0:

##### Bug fixes

* data inconsistency
  ([ME-41](https://northerntech.atlassian.net/browse/ME-41))
* trigger reporting reindex on device decommissioning
  ([MEN-6211](https://northerntech.atlassian.net/browse/MEN-6211))

##### Features

* License check: accepted device count and signature and endpoint
  ([MEN-5896](https://northerntech.atlassian.net/browse/MEN-5896), [MEN-5897](https://northerntech.atlassian.net/browse/MEN-5897))
* CLI command to reindex to the reporting service all the devices
  ([MEN-6183](https://northerntech.atlassian.net/browse/MEN-6183))

#### deviceconfig (1.3.0)

New changes in deviceconfig since 1.2.2:

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5504](https://northerntech.atlassian.net/browse/MEN-5504))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.4 to 1.7.7.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.4...v1.7.7)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### deviceconnect (1.4.0)

New changes in deviceconnect since 1.3.3:

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5505](https://northerntech.atlassian.net/browse/MEN-5505))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/gorilla/websocket](https://github.com/gorilla/websocket) from 1.4.2 to 1.5.0.
      - [Release notes](https://github.com/gorilla/websocket/releases)
      - [Commits](https://github.com/gorilla/websocket/compare/v1.4.2...v1.5.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/gorilla/websocket
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### generate-delta-worker (1.0.0)

##### Bug fixes

* missing publish stage after move to custom docker build
* ci: correct image reference.
* align exec name
* remove default output path setting

##### Features

* cmd implementation
  ([MEN-5801](https://northerntech.atlassian.net/browse/MEN-5801))
* call status endpoint.
  ([MEN-6113](https://northerntech.atlassian.net/browse/MEN-6113))

#### gui (3.5.0)

New changes in gui since 3.4.0:

##### Bug fixes

* fixed an issue that caused retrying deployments to not work for non-enterprise users
* fixed an issue that prevented config of users using SSO to log in
* aligned deployments manager role in ui with backend
  ([MEN-5949](https://northerntech.atlassian.net/browse/MEN-5949))
* allowed "Stay logged in" setting to work for sso users as well
* prevented navigation history from being overwritten when using the dashboard
  ([ME-18](https://northerntech.atlassian.net/browse/ME-18))
* removed assumption devices could always show a mac address in their details
* aligned device auditlog links with current param naming to allow navigating to the auditlog
* reverted react-idle-timer to known working version to try fix unexpected log out issue
  ([MEN-6061](https://northerntech.atlassian.net/browse/MEN-6061))
* fixed an issue that prevented offline devices on the dashboard from using any custom offline time limits
* fixed device offline notifications in device monitoring section
* moved state toggling calls to updater functions to stop stale state from preventing UI updates
  ([ME-26](https://northerntech.atlassian.net/browse/ME-26))
* fixed an issue that would cause the UI to crash when showing device details of a device that's only partially initialized
* fixed an issue that occurred when accessing authenticated devices without inventory
* fixed an issue that would prevent the device issue widget from being initialized
* made session expiration prevention part of the login flow to prevent it from getting removed by a failed 2fa login
  ([MEN-6061](https://northerntech.atlassian.net/browse/MEN-6061))
* User not being able to change email with two-factor authentication
  ([ME-46](https://northerntech.atlassian.net/browse/ME-46))
* fixed an issue that would crash the auditlogs page when clearing a url tracked selection
  ([MEN-6246](https://northerntech.atlassian.net/browse/MEN-6246))
* fixed an issue that prevented finished deployments from settling on their deployment data
* fixed an issue that would make the device list appear scrambled
  ([ME-38](https://northerntech.atlassian.net/browse/ME-38))

##### Features

* made device offline threshold setting configurable
  ([MEN-5923](https://northerntech.atlassian.net/browse/MEN-5923))
* added possibility to add extra confirmation step on deployment creation
  ([MEN-5283](https://northerntech.atlassian.net/browse/MEN-5283))
* made it possible to upload multiple files in parallel
  ([MEN-5744](https://northerntech.atlassian.net/browse/MEN-5744))
* added an easy access to the JWT for api/ cli usage
  ([MEN-5966](https://northerntech.atlassian.net/browse/MEN-5966))
* added support for multiple levels of device software information in device details
  ([MEN-5875](https://northerntech.atlassian.net/browse/MEN-5875))
* added way to retrieve license information about on prem deployments
  ([MEN-5899](https://northerntech.atlassian.net/browse/MEN-5899))
* added devices with issues widget to allow ease access to devices that require attention
  ([MEN-5919](https://northerntech.atlassian.net/browse/MEN-5919))
* refactored deployments dashboard widgets to ease direct access to recent deployments
  ([MEN-5920](https://northerntech.atlassian.net/browse/MEN-5920))
* prevented elements limited by RBAC permissions from showing up
  ([ME-17](https://northerntech.atlassian.net/browse/ME-17))
* moved device details to tabbed layout to ease information display
  ([MEN-6034](https://northerntech.atlassian.net/browse/MEN-6034))
* allowed selecting a Mender region on signup to help keep data where it supposed to reside
  ([MEN-5948](https://northerntech.atlassian.net/browse/MEN-5948))
* Show a welcome message in the console.
* added information about reporting limits + attributes in use
  ([MEN-6088](https://northerntech.atlassian.net/browse/MEN-6088))
* added safeguard to prevent rbac limited users from logging in
  ([ME-47](https://northerntech.atlassian.net/browse/ME-47))
* added an option to force deployment installation on deployment creation
  ([MEN-6130](https://northerntech.atlassian.net/browse/MEN-6130))
* expanded artifact upload form to allow more options to be sent
  ([MEN-6085](https://northerntech.atlassian.net/browse/MEN-6085))
* added configuration option for delta artifact generation
  ([MEN-5847](https://northerntech.atlassian.net/browse/MEN-5847))
* enabled automatic delta deployment on deployment creation
  ([MEN-5847](https://northerntech.atlassian.net/browse/MEN-5847))
* added information about device system in deployment + device details
  ([MEN-6035](https://northerntech.atlassian.net/browse/MEN-6035))
* added device deployment history in device details
  ([MEN-6051](https://northerntech.atlassian.net/browse/MEN-6051))
* added support for bar chart software distributions
  ([MEN-5921](https://northerntech.atlassian.net/browse/MEN-5921))

#### integration (3.5.0)

New changes in integration since 3.4.0:

##### Bug fixes

* Do not double count integration in changelogs and statistics.

##### Features

* add qemu commercial image to the setup
  ([MEN-5806](https://northerntech.atlassian.net/browse/MEN-5806))
* add reporting service as a default component in the docker composition
* bump file format version to 2.3 in all docker compose files

  This is because the start_period option which we're started to use
  was added in file format 2.3.

##### Other

* Enable the reporting service and the related tests
  ([MEN-5971](https://northerntech.atlassian.net/browse/MEN-5971))
* upgrade elasticsearch to version 7.17.7
  ([MEN-5971](https://northerntech.atlassian.net/browse/MEN-5971))
* test(autogenerate delta): introduce test for autogenerate delta feature
  ([MEN-5806](https://northerntech.atlassian.net/browse/MEN-5806))
* version bump to 2021-04-22T15-44-28Z
* Upgrade auditlogs to 3.1.0.
* Upgrade create-artifact-worker to 1.3.0.
* Upgrade deployments-enterprise to 4.4.0.
* Upgrade deployments to 4.4.0.
* Upgrade deviceauth-enterprise to 3.4.0.
* Upgrade deviceauth to 3.4.0.
* Upgrade deviceconfig to 1.3.0.
* Upgrade deviceconnect to 1.4.0.
* Upgrade devicemonitor to 1.4.0.
* Add generate-delta-worker 1.0.0.
* Upgrade gui to 3.5.0.
* Upgrade integration to 3.5.0.
* Upgrade inventory-enterprise to 4.3.0.
* Upgrade inventory to 4.3.0.
* Upgrade iot-manager to 1.2.0.
* Upgrade mender-artifact to 3.10.0.
* Upgrade mender-cli to 1.10.0.
* Upgrade mender-convert to 4.0.0.
* Upgrade mender-gateway to 1.1.0.
* Upgrade mender to 3.5.0.
* Upgrade mtls-ambassador to 1.2.0.
* Upgrade reporting to 1.0.0.
* Upgrade tenantadm to 4.0.0.
* Upgrade useradm-enterprise to 1.20.0.
* Upgrade useradm to 1.20.0.
* Upgrade workflows-enterprise to 2.4.0.
* Upgrade workflows to 2.4.0.

#### inventory (4.3.0)

New changes in inventory since 4.2.1:

##### Bug fixes

* update_ts field when searching devices and selecting attributes
  ([ME-50](https://northerntech.atlassian.net/browse/ME-50))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### inventory-enterprise (4.3.0)

New changes in inventory-enterprise since 4.2.1:

##### Bug fixes

* update_ts field when searching devices and selecting attributes
  ([ME-50](https://northerntech.atlassian.net/browse/ME-50))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.11.4 to 8.11.5.
      - [Release notes](https://github.com/go-redis/redis/releases)
      - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/go-redis/redis/compare/v8.11.4...v8.11.5)

      ```
      updated-dependencies:
      - dependency-name: github.com/go-redis/redis/v8
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### iot-manager (1.2.0)

New changes in iot-manager since 1.1.0:

##### Bug fixes

* wait for principal detachment to propagate when deleting device

  DetachThingPrincipal operation is asynchronous.
  According to the docs, it might take several seconds for the detachment to propagate.
  With this change we will wait up to 10 seconds for the detachment to propagate,
  and if some principals are still not detached from the Thing, we'll retrun an error.
  ([MEN-6001](https://northerntech.atlassian.net/browse/MEN-6001))
* wrong capitalization for `Type`
  ([QA-481](https://northerntech.atlassian.net/browse/QA-481))

#### mtls-ambassador (1.2.0)

New changes in mtls-ambassador since 1.1.0:

##### Features

* switch to `scratch` and run as non-root user

##### Other

* bump github.com/mendersoftware/go-lib-micro to v0.0.0-20221025103319-e1f941fb3145
  ([QA-524](https://northerntech.atlassian.net/browse/QA-524))

#### tenantadm (4.0.0)

New changes in tenantadm since 3.5.0:

##### Features

* disable addons by default when creating tenants
  ([MEN-6292](https://northerntech.atlassian.net/browse/MEN-6292))

##### Other

* remove the create-user CLI command as it was designed to act on the tenantadm service only, without propagating the data to useradm; use the `useradm-enterprise create-user` CLI command to create new users instead.
  ([MEN-5924](https://northerntech.atlassian.net/browse/MEN-5924))

#### useradm (1.20.0)

New changes in useradm since 1.19.0:

##### Bug fixes

* Protect user updates from concurrent updates
  ([MEN-6003](https://northerntech.atlassian.net/browse/MEN-6003))
* Updating existing users is blocked by ETag check
  ([MEN-6087](https://northerntech.atlassian.net/browse/MEN-6087))
* Make user updates default to skip ETag checks (wildcard match)
  ([MEN-6106](https://northerntech.atlassian.net/browse/MEN-6106))

##### Features

* do not check the JWT issuer.
  ([MEN-5969](https://northerntech.atlassian.net/browse/MEN-5969))

#### useradm-enterprise (1.20.0)

New changes in useradm-enterprise since 1.19.0:

##### Bug fixes

* Proper parsing of XFF header with configurable depth strategy
  ([MEN-5980](https://northerntech.atlassian.net/browse/MEN-5980))
* Protect user updates from concurrent updates
  ([MEN-6003](https://northerntech.atlassian.net/browse/MEN-6003))
* Changing email makes the user email unverified
  ([MEN-5974](https://northerntech.atlassian.net/browse/MEN-5974))
* user should not be able to modify all his data
  ([MEN-6012](https://northerntech.atlassian.net/browse/MEN-6012))
* Remove ability to modify internal parameters of the user object
  ([MEN-6037](https://northerntech.atlassian.net/browse/MEN-6037))
* BaseURL illegal settings can lead to service exiting with 0 due to wrapping of nil errors.
  ([ME-39](https://northerntech.atlassian.net/browse/ME-39))
* Updating existing users is blocked by ETag check
  ([MEN-6087](https://northerntech.atlassian.net/browse/MEN-6087))
* apply plan based restriction to permission_sets endpoints
  ([MEN-6093](https://northerntech.atlassian.net/browse/MEN-6093))
* Make user updates default to skip ETag checks (wildcard match)
  ([MEN-6106](https://northerntech.atlassian.net/browse/MEN-6106))

##### Features

* do not check the JWT issuer.
  ([MEN-5969](https://northerntech.atlassian.net/browse/MEN-5969))
* added possibility to login via short lived magic link
  ([MEN-5948](https://northerntech.atlassian.net/browse/MEN-5948))

#### workflows (2.4.0)

New changes in workflows since 2.3.0:

##### Bug fixes

* Remove hard-coded default read/write concern
  ([MEN-6029](https://northerntech.atlassian.net/browse/MEN-6029))
* call internal delete device api endpoint
  ([ME-41](https://northerntech.atlassian.net/browse/ME-41))

##### Features

* reindex_reporting_deployment workflow to index device deployments
  ([MEN-5930](https://northerntech.atlassian.net/browse/MEN-5930))

##### Other

* Workflows version increment for updated workflows definitions

#### workflows-enterprise (2.4.0)

New changes in workflows-enterprise since 2.3.0:

##### Bug fixes

* Remove hard-coded default read/write concern
  ([MEN-6029](https://northerntech.atlassian.net/browse/MEN-6029))
* call internal delete device api endpoint
  ([ME-41](https://northerntech.atlassian.net/browse/ME-41))

##### Features

* reindex_reporting_deployment workflow to index device deployments
  ([MEN-5930](https://northerntech.atlassian.net/browse/MEN-5930))

##### Other

* Workflows version increment for updated workflows definitions


## Mender 3.4.0

_Released 09.25.2022_

### Security fixes

* Fixed CVE-2022-41324 - Read-only API access can leak secrets in Mender.
  See the official announcement for more information:
  [mender.io/blog/cve-2022-45929-cve-2022-41324-improper-access-control-for-low-privileged-users](https://mender.io/blog/cve-2022-45929-cve-2022-41324-improper-access-control-for-low-privileged-users)

### Statistics

A total of 52469 lines added, 19890 removed (delta 32579)

| Developers with the most changesets | |
|---|---|
| Manuel Zedel | 250 (32.7%) |
| Fabio Tranchitella | 110 (14.4%) |
| Alf-Rune Siqveland | 86 (11.2%) |
| Krzysztof Jaskiewicz | 80 (10.5%) |
| Maciej Tomczuk | 55 (7.2%) |
| Peter Grzybowski | 51 (6.7%) |
| Ole Petter Orhagen | 39 (5.1%) |
| Lluis Campos | 35 (4.6%) |
| Kristian Amlie | 26 (3.4%) |
| Alex Miliukov | 18 (2.4%) |

| Developers with the most changed lines | |
|---|---|
| Fabio Tranchitella | 12030 (21.3%) |
| Manuel Zedel | 11324 (20.0%) |
| Peter Grzybowski | 10349 (18.3%) |
| Alf-Rune Siqveland | 9959 (17.6%) |
| Krzysztof Jaskiewicz | 6353 (11.2%) |
| Maciej Tomczuk | 3036 (5.4%) |
| Lluis Campos | 1415 (2.5%) |
| Alex Miliukov | 1075 (1.9%) |
| Kristian Amlie | 484 (0.9%) |
| Ole Petter Orhagen | 183 (0.3%) |

| Developers with the most signoffs (total 5) | |
|---|---|
| Ole Petter Orhagen | 4 (80.0%) |
| Manuel Zedel | 1 (20.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 764 (99.9%) |
| benjamin.texier@outlook.com | 1 (0.1%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 56481 (99.8%) |
| benjamin.texier@outlook.com | 120 (0.2%) |

| Employers with the most signoffs (total 5) | |
|---|---|
| Northern.tech | 5 (100.0%) |

| Employers with the most hackers (total 13) | |
|---|---|
| Northern.tech | 12 (92.3%) |
| benjamin.texier@outlook.com | 1 (7.7%) |

### Changelogs

#### auditlogs (3.0.2)

New changes in auditlogs since 3.0.1:

* upgrade mendersoftware/go-lib-micro to v0.0.0-20220304124258-d8414885f1c3
  ([MEN-5506](https://northerntech.atlassian.net/browse/MEN-5506))

#### create-artifact-worker (1.2.0)

New changes in create-artifact-worker since 1.1.2:

* fix CVEs rebuilding using the latest `workflows:master`
* Update mender-artifact tool to latest

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.8.1 to 1.10.1.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.8.1...v1.10.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/spf13/cobra](https://github.com/spf13/cobra) from 1.2.1 to 1.4.0.
      - [Release notes](https://github.com/spf13/cobra/releases)
      - [Changelog](https://github.com/spf13/cobra/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/spf13/cobra/compare/v1.2.1...v1.4.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/cobra
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps golang from 1.17.8-alpine3.15 to 1.18.1-alpine3.15.

      ```
      updated-dependencies:
      - dependency-name: golang
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.10.1 to 1.11.0.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.10.1...v1.11.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### deployments (4.3.0)

New changes in deployments since 4.2.0:

##### Bug fixes

* Fix bad indexing from database versions 1.2.8 and 1.2.9
  ([MEN-5695](https://northerntech.atlassian.net/browse/MEN-5695))
* Escape configuration download URL path and support '.' in parameter
  ([MEN-5712](https://northerntech.atlassian.net/browse/MEN-5712))

##### Features

* migration 1.2.11 to index devices logs
  ([MEN-5710](https://northerntech.atlassian.net/browse/MEN-5710))
* Upgrade mender-artifact library to latest to support parsing
  empty Artifacts, such as the bootstrap Artifact used to initialize
  devices' local database.
  ([MEN-2583](https://northerntech.atlassian.net/browse/MEN-2583))
* `ArtifactTypeInfo` object returned in `/artifacts` or
  `/deployments/releases` can now return `nil` as its type. This would be
  the case for bootstrap Artifacts.
  ([MEN-2583](https://northerntech.atlassian.net/browse/MEN-2583))
* omit configuration values in the deployment details

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### deployments-enterprise (4.3.0)

New changes in deployments-enterprise since 4.2.0:

##### Bug fixes

* Fix bad indexing from database versions 1.2.8 and 1.2.9
  ([MEN-5695](https://northerntech.atlassian.net/browse/MEN-5695))
* Escape configuration download URL path and support '.' in parameter
  ([MEN-5712](https://northerntech.atlassian.net/browse/MEN-5712))

##### Features

* migration 1.2.11 to index devices logs
  ([MEN-5710](https://northerntech.atlassian.net/browse/MEN-5710))
* Upgrade mender-artifact library to latest to support parsing
  empty Artifacts, such as the bootstrap Artifact used to initialize
  devices' local database.
  ([MEN-2583](https://northerntech.atlassian.net/browse/MEN-2583))
* introduce limit for maximum number of active deployments per tenant
  ([MEN-5696](https://northerntech.atlassian.net/browse/MEN-5696))
* `ArtifactTypeInfo` object returned in `/artifacts` or
  `/deployments/releases` can now return `nil` as its type. This would be
  the case for bootstrap Artifacts.
  ([MEN-2583](https://northerntech.atlassian.net/browse/MEN-2583))
* do not limit number of configuration deployments
  ([MEN-5696](https://northerntech.atlassian.net/browse/MEN-5696))
* omit configuration values in the deployment details

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### deviceauth (3.3.0)

New changes in deviceauth since 3.2.1:

##### Bug fixes

* Support PKCS#8 PEM format for JWT Signing key
  ([MEN-5673](https://northerntech.atlassian.net/browse/MEN-5673))
* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))
* Missing hash in inventory client

##### Other

* refactor: do not store the public key in the device document
* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5471](https://northerntech.atlassian.net/browse/MEN-5471))

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bump alpine from 3.14.2 to 3.15.0
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/golang-jwt/jwt/v4](https://github.com/golang-jwt/jwt) from 4.2.0 to 4.4.1.
      - [Release notes](https://github.com/golang-jwt/jwt/releases)
      - [Changelog](https://github.com/golang-jwt/jwt/blob/main/VERSION_HISTORY.md)
      - [Commits](https://github.com/golang-jwt/jwt/compare/v4.2.0...v4.4.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/golang-jwt/jwt/v4
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.11.4 to 8.11.5.
      - [Release notes](https://github.com/go-redis/redis/releases)
      - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/go-redis/redis/compare/v8.11.4...v8.11.5)

      ```
      updated-dependencies:
      - dependency-name: github.com/go-redis/redis/v8
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### deviceauth-enterprise (3.3.0)

New changes in deviceauth-enterprise since 3.2.1:

##### Bug fixes

* Support PKCS#8 PEM format for JWT Signing key
  ([MEN-5673](https://northerntech.atlassian.net/browse/MEN-5673))
* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))
* Missing hash in inventory client

##### Other

* refactor: do not store the public key in the device document
* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5471](https://northerntech.atlassian.net/browse/MEN-5471))

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bump alpine from 3.14.2 to 3.15.0
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/golang-jwt/jwt/v4](https://github.com/golang-jwt/jwt) from 4.2.0 to 4.4.1.
      - [Release notes](https://github.com/golang-jwt/jwt/releases)
      - [Changelog](https://github.com/golang-jwt/jwt/blob/main/VERSION_HISTORY.md)
      - [Commits](https://github.com/golang-jwt/jwt/compare/v4.2.0...v4.4.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/golang-jwt/jwt/v4
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.11.4 to 8.11.5.
      - [Release notes](https://github.com/go-redis/redis/releases)
      - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/go-redis/redis/compare/v8.11.4...v8.11.5)

      ```
      updated-dependencies:
      - dependency-name: github.com/go-redis/redis/v8
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### deviceconfig (1.2.2)

New changes in deviceconfig since 1.2.1:

##### Bug fixes

* Fix borken migration.
  ([MEN-5719](https://northerntech.atlassian.net/browse/MEN-5719))

##### Other

* upgrade mendersoftware/go-lib-micro to v0.0.0-20220304124258-d8414885f1c3
  ([MEN-5504](https://northerntech.atlassian.net/browse/MEN-5504))

#### deviceconnect (1.3.3)

New changes in deviceconnect since 1.3.2:

##### Bug fixes

* Correct broken document migration in 2.0.0
  ([MEN-5718](https://northerntech.atlassian.net/browse/MEN-5718))
* Apply migration to all databases prior to 2.0.0
  ([MEN-5718](https://northerntech.atlassian.net/browse/MEN-5718))
* New migration (2.0.1) patching 2.0.0 document migration
  ([MEN-5718](https://northerntech.atlassian.net/browse/MEN-5718))

##### Other

* upgrade mendersoftware/go-lib-micro to v0.0.0-20220304124258-d8414885f1c3
  ([MEN-5505](https://northerntech.atlassian.net/browse/MEN-5505))

#### devicemonitor (1.3.0)

New changes in devicemonitor since 1.2.0:

##### Bug fixes

* Reduce the maximum number of alerts/configurations per request
  ([MEN-5854](https://northerntech.atlassian.net/browse/MEN-5854))

##### Features

* Static device group in alert emails Subject:
  ([MEN-5379](https://northerntech.atlassian.net/browse/MEN-5379))

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### gui (3.4.0)

New changes in gui since 3.3.0:

##### Bug fixes

* prevented scheduling deployments earlier in the day
  ([MEN-5639](https://northerntech.atlassian.net/browse/MEN-5639))
* fixed an issue that caused dynamic groups with a "doesn't exist" filter to not show up properly
  ([MEN-5640](https://northerntech.atlassian.net/browse/MEN-5640))
* ensured deployment release information doesn't overflow list info
  ([MEN-5620](https://northerntech.atlassian.net/browse/MEN-5620))
* fixed an issue that caused the device list to crash on group selection if a device was selected at the time
* added missing check for plan availability for auditlogs
  ([MEN-5686](https://northerntech.atlassian.net/browse/MEN-5686))
* ensured dynamic group filters are used on group device retrieval
  ([MEN-5668](https://northerntech.atlassian.net/browse/MEN-5668))
* made use of derived permissions when creating group based roles too
  ([MEN-5706](https://northerntech.atlassian.net/browse/MEN-5706))
* fixed an issue that prevented single device deployment creation
  ([MEN-5728](https://northerntech.atlassian.net/browse/MEN-5728))
* fixed an issue that caused a faulty deployment creator to be shown in the deployment details
  ([MEN-5729](https://northerntech.atlassian.net/browse/MEN-5729))
* prevented nginx from preloading version info file
  ([MEN-5707](https://northerntech.atlassian.net/browse/MEN-5707))
* fixed an issue that might prevent pagination through active deployments
  ([MEN-5730](https://northerntech.atlassian.net/browse/MEN-5730))
* added password validation for email changes
* fixed an issue that prevented group selection urls from working
  ([MEN-5741](https://northerntech.atlassian.net/browse/MEN-5741))
* removed effect cascade in order to fix an issue when opening a device as a RO user
  ([MEN-5770](https://northerntech.atlassian.net/browse/MEN-5770))
* addressed an issue that caused showing device details to crash the UI
  ([MEN-5770](https://northerntech.atlassian.net/browse/MEN-5770))
* prevented concurrent uploads to align with UI setup
  ([MEN-5811](https://northerntech.atlassian.net/browse/MEN-5811))
* fixed an issue that prevented direct device links from working
  ([MEN-5781](https://northerntech.atlassian.net/browse/MEN-5781))
* remove references to `pi` user.
  ([MEN-5582](https://northerntech.atlassian.net/browse/MEN-5582))
* aligned final onboarding snackbar rendering with onboarding progress
  ([MEN-5909](https://northerntech.atlassian.net/browse/MEN-5909))

##### Features

* added per user access token functionality to the user settings page
  ([MEN-5525](https://northerntech.atlassian.net/browse/MEN-5525))
* improved alignment between device list page & browser url
  ([MEN-4989](https://northerntech.atlassian.net/browse/MEN-4989))
* improved alignment between auditlogs page & browser url
  ([MEN-4989](https://northerntech.atlassian.net/browse/MEN-4989))
* improved alignment between deployment pages & browser url
  ([MEN-4989](https://northerntech.atlassian.net/browse/MEN-4989))
* made 2fa setup available for all plans
  ([MEN-5679](https://northerntech.atlassian.net/browse/MEN-5679))
* made device id shown in deployment context also take selected device id into account
* added a way to configure an AWS IoT core connection
  ([MEN-5453](https://northerntech.atlassian.net/browse/MEN-5453))
* made retry selection accept custom values between 0 & 100
  ([MEN-5739](https://northerntech.atlassian.net/browse/MEN-5739))
* added downloads section to ease downloading packages + tools
  ([MEN-5624](https://northerntech.atlassian.net/browse/MEN-5624))
* made it possible to configure SAML connection to ease SSO setup
  ([MEN-5103](https://northerntech.atlassian.net/browse/MEN-5103))
* allowed creation of passwordless users to support SSO scenarios
  ([MEN-5104](https://northerntech.atlassian.net/browse/MEN-5104))
* made dark mode available for everyone
  ([MEN-5516](https://northerntech.atlassian.net/browse/MEN-5516))
* made deployment creation easier to review by moving it to a single view
  ([MEN-5647](https://northerntech.atlassian.net/browse/MEN-5647))
* made device configure a separate rbac config option
  ([MEN-5821](https://northerntech.atlassian.net/browse/MEN-5821))
* added webhook integration option
  ([MEN-57231](https://northerntech.atlassian.net/browse/MEN-57231))

#### integration (3.4.0)

New changes in integration since 3.3.0:

##### Bug fixes

* don't allow to use openssl lower than v.1.1.1
  ([MEN-5746](https://northerntech.atlassian.net/browse/MEN-5746))
* Correctly pass mender client version to GUI env
  ([MEN-5901](https://northerntech.atlassian.net/browse/MEN-5901))

##### Other

* feat(traefik conf): add SAML SSO endpoints exposed without authentication
  ([MEN-5102](https://northerntech.atlassian.net/browse/MEN-5102))
* Upgrade auditlogs to 3.0.2.
* Upgrade create-artifact-worker to 1.2.0.
* Upgrade deployments-enterprise to 4.3.0.
* Upgrade deployments to 4.3.0.
* Upgrade deviceauth-enterprise to 3.3.0.
* Upgrade deviceauth to 3.3.0.
* Upgrade deviceconfig to 1.2.2.
* Upgrade deviceconnect to 1.3.3.
* Upgrade devicemonitor to 1.3.0.
* Upgrade gui to 3.4.0.
* Upgrade integration to 3.4.0.
* Upgrade inventory-enterprise to 4.2.1.
* Upgrade inventory to 4.2.1.
* Upgrade iot-manager to 1.1.0.
* Upgrade mender-artifact to 3.9.0.
* Upgrade mender-binary-delta to 1.4.1.
* Upgrade mender-cli to 1.9.0.
* Upgrade mender-connect to 2.1.0.
* Upgrade mender-convert to 3.0.1.
* Upgrade mender-gateway to 1.0.1.
* Upgrade mender to 3.4.0.
* Upgrade monitor-client to 1.2.1.
* Upgrade mtls-ambassador to 1.1.0.
* Upgrade tenantadm to 3.5.0.
* Upgrade useradm-enterprise to 1.19.0.
* Upgrade useradm to 1.19.0.
* Upgrade workflows-enterprise to 2.3.0.
* Upgrade workflows to 2.3.0.

#### inventory (4.2.1)

New changes in inventory since 4.2.0:

##### Bug fixes

* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))

#### inventory-enterprise (4.2.1)

New changes in inventory-enterprise since 4.2.0:

##### Bug fixes

* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))

#### iot-manager (1.1.0)

New changes in iot-manager since 1.0.2:

##### Bug fixes

* fix GET /integrations returned object definition
* Fire webhook independent if device was provisioned
  ([MEN-5832](https://northerntech.atlassian.net/browse/MEN-5832))

##### Features

* add support for a new integration type: AWS IoT Core
  ([MEN-5447](https://northerntech.atlassian.net/browse/MEN-5447))
* AWS IoT Core device lifecycle integration
  ([MEN-5449](https://northerntech.atlassian.net/browse/MEN-5449))
* migrate from aws-go-sdk to aws-go-sdk-v2
  ([MEN-5448](https://northerntech.atlassian.net/browse/MEN-5448))
* introduce AWS IoT Device Shadow support
  ([MEN-5448](https://northerntech.atlassian.net/browse/MEN-5448))
* Add support for IoT Core for 'sync-devices' commandline job
  ([MEN-5450](https://northerntech.atlassian.net/browse/MEN-5450))
* store device lifecycle events
  ([MEN-5714](https://northerntech.atlassian.net/browse/MEN-5714))
* new API endpoint for retrieving events
  ([MEN-5714](https://northerntech.atlassian.net/browse/MEN-5714))
* Add webhooks to the integrations API

  This commit expands the configuration API to specify webhooks endpoint
  and HMAC256 secret.
  ([MEN-5715](https://northerntech.atlassian.net/browse/MEN-5715))
* Fire webhooks when device changes status

  A webhook fires when a device is provisioned, decommission or the
  authentication data changes status.
  ([MEN-5715](https://northerntech.atlassian.net/browse/MEN-5715))

##### Other

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5467](https://northerntech.atlassian.net/browse/MEN-5467))
* test(IoTCore): extend AWS IoT core tests with device shadow related tests
  ([MEN-5448](https://northerntech.atlassian.net/browse/MEN-5448))
* docs: document the endpoint for returning list of events
  ([MEN-5714](https://northerntech.atlassian.net/browse/MEN-5714))
* Add xAWS endpoint information to the device credentials
  ([MEN-5778](https://northerntech.atlassian.net/browse/MEN-5778))

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.4 to 1.7.7.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.4...v1.7.7)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/urfave/cli](https://github.com/urfave/cli) from 1.22.5 to 1.22.9.
      - [Release notes](https://github.com/urfave/cli/releases)
      - [Changelog](https://github.com/urfave/cli/blob/main/docs/CHANGELOG.md)
      - [Commits](https://github.com/urfave/cli/compare/v1.22.5...v1.22.9)

      ```
      updated-dependencies:
      - dependency-name: github.com/urfave/cli
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.8.3 to 1.9.1.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.8.3...v1.9.1)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### mtls-ambassador (1.1.0)

New changes in mtls-ambassador since 1.0.2:

##### Bug fixes

* Improve public certificate key comparison

  This commit deserializes the request public key before comparing it with
  the certificate to make it insensitive to whitespace and newlines.

##### Features

* Configuration for setting Mender Server CA certificate
  ([MEN-5818](https://northerntech.atlassian.net/browse/MEN-5818))

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.12 to 3.14.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/urfave/cli](https://github.com/urfave/cli) from 1.22.4 to 1.22.5.
      - [Release notes](https://github.com/urfave/cli/releases)
      - [Changelog](https://github.com/urfave/cli/blob/master/docs/CHANGELOG.md)
      - [Commits](https://github.com/urfave/cli/compare/v1.22.4...v1.22.5)

      ```
      updated-dependencies:
      - dependency-name: github.com/urfave/cli
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps golang from 1.14-alpine3.12 to 1.16.5-alpine3.12.

      ```
      updated-dependencies:
      - dependency-name: golang
        dependency-type: direct:production
      ```
  * Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.6.0 to 1.8.1.
      - [Release notes](https://github.com/sirupsen/logrus/releases)
      - [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/sirupsen/logrus/compare/v1.6.0...v1.8.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/sirupsen/logrus
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.6.3 to 1.7.2.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.6.3...v1.7.2)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.2 to 1.7.4.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.2...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.0 to 3.14.2.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/fsnotify/fsnotify](https://github.com/fsnotify/fsnotify) from 1.4.9 to 1.5.1.
      - [Release notes](https://github.com/fsnotify/fsnotify/releases)
      - [Changelog](https://github.com/fsnotify/fsnotify/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/fsnotify/fsnotify/compare/v1.4.9...v1.5.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/fsnotify/fsnotify
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.4 to 1.7.7.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.4...v1.7.7)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/gofrs/uuid](https://github.com/gofrs/uuid) from 3.3.0+incompatible to 4.2.0+incompatible.
      - [Release notes](https://github.com/gofrs/uuid/releases)
      - [Commits](https://github.com/gofrs/uuid/compare/v3.3.0...v4.2.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/gofrs/uuid
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```

#### tenantadm (3.5.0)

New changes in tenantadm since 3.4.0:

##### Bug fixes

* Make username/emails case insensitive
  ([MEN-3524](https://northerntech.atlassian.net/browse/MEN-3524))
* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/golang-jwt/jwt/v4](https://github.com/golang-jwt/jwt) from 4.3.0 to 4.4.1.
      - [Release notes](https://github.com/golang-jwt/jwt/releases)
      - [Changelog](https://github.com/golang-jwt/jwt/blob/main/VERSION_HISTORY.md)
      - [Commits](https://github.com/golang-jwt/jwt/compare/v4.3.0...v4.4.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/golang-jwt/jwt/v4
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### useradm (1.19.0)

New changes in useradm since 1.18.0:

##### Bug fixes

* delete user tokens when deleting user
* Make username/email case-insensitive

  This commit forces the internal representation of the username/email
  addresses to be lowercase. This means that any users that signed up with
  an email containing uppercase characters will be locked out from their
  account. To fix this issue, the server maintainer should run the
  following mongodb migration script:
  ```
  let tAdm = db.getSiblingDB("tenantadm");
  tAdm.users.find({}).forEach((doc) => {
    if (doc.name.toLowerCase() != doc.name) {
      print(
        "Converting to lower case (<tenantid>/<userid>): " +
          doc.tenant_id +
          "/" +
          doc._id
      );
      tAdm.users.updateOne(
        { _id: doc._id },
        { $set: { name: doc.name.toLowerCase() } }
      );
      let usrAdm = db.getSiblingDB("useradm-" + doc.tenant_id);
      usrAdm.users.updateOne(
        { _id: doc._id },
        { $set: { email: doc.name.toLowerCase() } }
      );
    }
  });
  let usrAdm = db.getSiblingDB("useradm");
  usrAdm.users.find({}).forEach((doc) => {
    if (doc.email.toLowerCase() != doc.email) {
      print("Converting to lower case (<userid>):" + doc._id);
      usrAdm.updateOne(
        { _id: doc._id },
        { $set: { email: doc.email.toLowerCase() } }
      );
    }
  });
  ```
  ([MEN-3524](https://northerntech.atlassian.net/browse/MEN-3524))
* Add support for PKCS#8 private key format
  ([MEN-5672](https://northerntech.atlassian.net/browse/MEN-5672))
* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))
* invalidate user sessions but the current one on user updates
  ([MEN-5731](https://northerntech.atlassian.net/browse/MEN-5731))
* require password prompt for changing email
  ([MEN-5738](https://northerntech.atlassian.net/browse/MEN-5738))
* allow privileged users to change email address of another user
  ([MEN-5829](https://northerntech.atlassian.net/browse/MEN-5829))

##### Features

* new endpoints for managing Personal Access Tokens

  New endpoints:
  POST /api/management/v1/useradm/settings/tokens
  GET /api/management/v1/useradm/settings/tokens
  DELETE /api/management/v1/useradm/settings/tokens/:id

  ,
  ([MEN-5522](https://northerntech.atlassian.net/browse/MEN-5522), [MEN-5523](https://northerntech.atlassian.net/browse/MEN-5523))
* make maximum expiration time of Personal Access Tokens configurable
  ([MEN-5522](https://northerntech.atlassian.net/browse/MEN-5522), [MEN-5523](https://northerntech.atlassian.net/browse/MEN-5523))
* change multi-tenancy data model
  ([MEN-4749](https://northerntech.atlassian.net/browse/MEN-4749))
* support for ETag and If-Match for the GET/POST settings end-points
  ([MEN-5666](https://northerntech.atlassian.net/browse/MEN-5666))
* end-points to save user-specific settings for the current user
  ([MEN-5666](https://northerntech.atlassian.net/browse/MEN-5666))
* migration (2.0.1) to move the user settings to a dedicated collection
  ([MEN-5666](https://northerntech.atlassian.net/browse/MEN-5666))

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/golang-jwt/jwt/v4](https://github.com/golang-jwt/jwt) from 4.2.0 to 4.4.1.
      - [Release notes](https://github.com/golang-jwt/jwt/releases)
      - [Changelog](https://github.com/golang-jwt/jwt/blob/main/VERSION_HISTORY.md)
      - [Commits](https://github.com/golang-jwt/jwt/compare/v4.2.0...v4.4.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/golang-jwt/jwt/v4
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### useradm-enterprise (1.19.0)

New changes in useradm-enterprise since 1.18.0:

##### Bug fixes

* delete user tokens when deleting user
* Make username/email case-insensitive

  This commit forces the internal representation of the username/email
  addresses to be lowercase. This means that any users that signed up with
  an email containing uppercase characters will be locked out from their
  account. To fix this issue, the server maintainer should run the
  following mongodb migration script:
  ```
  let tAdm = db.getSiblingDB("tenantadm");
  tAdm.users.find({}).forEach((doc) => {
    if (doc.name.toLowerCase() != doc.name) {
      print(
        "Converting to lower case (<tenantid>/<userid>): " +
          doc.tenant_id +
          "/" +
          doc._id
      );
      tAdm.users.updateOne(
        { _id: doc._id },
        { $set: { name: doc.name.toLowerCase() } }
      );
      let usrAdm = db.getSiblingDB("useradm-" + doc.tenant_id);
      usrAdm.users.updateOne(
        { _id: doc._id },
        { $set: { email: doc.name.toLowerCase() } }
      );
    }
  });
  let usrAdm = db.getSiblingDB("useradm");
  usrAdm.users.find({}).forEach((doc) => {
    if (doc.email.toLowerCase() != doc.email) {
      print("Converting to lower case (<userid>):" + doc._id);
      usrAdm.updateOne(
        { _id: doc._id },
        { $set: { email: doc.email.toLowerCase() } }
      );
    }
  });
  ```
  ([MEN-3524](https://northerntech.atlassian.net/browse/MEN-3524))
* increase default limit for a number of permission sets in the role definition
* add PATCH inventory/* permission to "manage devices" permission set
* Add support for PKCS#8 private key format
  ([MEN-5672](https://northerntech.atlassian.net/browse/MEN-5672))
* failed to update RBAC roles
  ([MEN-5694](https://northerntech.atlassian.net/browse/MEN-5694))
* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))
* invalidate user sessions but the current one on user updates
  ([MEN-5731](https://northerntech.atlassian.net/browse/MEN-5731))
* OAuth users cant issue personal access tokens.
  ([MEN-5723](https://northerntech.atlassian.net/browse/MEN-5723))
* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))
* Forbid oauth logins for suspended tenants.
* require password prompt for changing email
  ([MEN-5738](https://northerntech.atlassian.net/browse/MEN-5738))
* SAML Metadata endpoint returns id instead of _id.
* allow privileged users to change email address of another user
  ([MEN-5829](https://northerntech.atlassian.net/browse/MEN-5829))
* restrict access to GET /events endpoint to Admin users only
  ([MEN-5831](https://northerntech.atlassian.net/browse/MEN-5831))
* remove access to deviceconfig from ReadDevices permission set
  ([MEN-5817](https://northerntech.atlassian.net/browse/MEN-5817))
* remove permision for downloading artifact from ReadReleases permission set
  ([MEN-5816](https://northerntech.atlassian.net/browse/MEN-5816))
* DeployToDevices permission set should grant access to deployments only
  ([MEN-5816](https://northerntech.atlassian.net/browse/MEN-5816), [MEN-5817](https://northerntech.atlassian.net/browse/MEN-5817))
* update Deployments Manager role

  The role should grant basic access and access to read releases, read devices and
  deploy to devices.
  ([MEN-5816](https://northerntech.atlassian.net/browse/MEN-5816))
* Read Devices permission should not grant access to artifacts
  ([MEN-5816](https://northerntech.atlassian.net/browse/MEN-5816))
* Connect permission should allow downloaing files from the device
  ([MEN-5839](https://northerntech.atlassian.net/browse/MEN-5839))
* Read Access role should grant access to device state in the iot-manager
* Read Access role should grant access to view deployments
* clear location of the Single Logout Service
  ([MEN-5886](https://northerntech.atlassian.net/browse/MEN-5886))
* clear location of the Single Logout Service
  ([MEN-5886](https://northerntech.atlassian.net/browse/MEN-5886))

##### Features

* new endpoints for managing Personal Access Tokens

  New endpoints:
  POST /api/management/v1/useradm/settings/tokens
  GET /api/management/v1/useradm/settings/tokens
  DELETE /api/management/v1/useradm/settings/tokens/:id

  ,
  ([MEN-5522](https://northerntech.atlassian.net/browse/MEN-5522), [MEN-5523](https://northerntech.atlassian.net/browse/MEN-5523))
* make maximum expiration time of Personal Access Tokens configurable
  ([MEN-5522](https://northerntech.atlassian.net/browse/MEN-5522), [MEN-5523](https://northerntech.atlassian.net/browse/MEN-5523))
* Update single sign-on schema for user objects
  ([MEN-5649](https://northerntech.atlassian.net/browse/MEN-5649))
* SAML metadata management endpoints.
  ([MEN-5100](https://northerntech.atlassian.net/browse/MEN-5100))
* GET service provider meta data
  ([MEN-5101](https://northerntech.atlassian.net/browse/MEN-5101))
* change multi-tenancy data model
  ([MEN-4749](https://northerntech.atlassian.net/browse/MEN-4749))
* change multi-tenancy data model
  ([MEN-4749](https://northerntech.atlassian.net/browse/MEN-4749))
* support for ETag and If-Match for the GET/POST settings end-points
  ([MEN-5666](https://northerntech.atlassian.net/browse/MEN-5666))
* end-points to save user-specific settings for the current user
  ([MEN-5666](https://northerntech.atlassian.net/browse/MEN-5666))
* migration (2.0.1) to move the user settings to a dedicated collection
  ([MEN-5666](https://northerntech.atlassian.net/browse/MEN-5666))
* 2FA is now available in all plans
  ([MEN-5727](https://northerntech.atlassian.net/browse/MEN-5727))
* SAML SSO login and assertion endpoints.
  ([MEN-5102](https://northerntech.atlassian.net/browse/MEN-5102))
* Only SAML configured users are allowed to use SAML login, and fixes.
  ([MEN-5750](https://northerntech.atlassian.net/browse/MEN-5750), [MEN-5752](https://northerntech.atlassian.net/browse/MEN-5752))
* introduce ConfigureDevices permission set
  ([MEN-5817](https://northerntech.atlassian.net/browse/MEN-5817))
* save raw representation of the IDP Metadata
  ([MEN-5887](https://northerntech.atlassian.net/browse/MEN-5887))
* endpoint for getting xml with configured IDP metadata
  ([MEN-5887](https://northerntech.atlassian.net/browse/MEN-5887))
* save raw representation of the IDP Metadata
  ([MEN-5887](https://northerntech.atlassian.net/browse/MEN-5887))
* endpoint for getting xml with configured IDP metadata
  ([MEN-5887](https://northerntech.atlassian.net/browse/MEN-5887))

##### Other

* upgrade crewjam/saml
  ([MEN-5102](https://northerntech.atlassian.net/browse/MEN-5102))
* docs(SAML): document endpoint for getting Identity Provider Metadata
  ([MEN-5887](https://northerntech.atlassian.net/browse/MEN-5887))
* test(SAML): test endpoint for getting IDP matadata
  ([MEN-5887](https://northerntech.atlassian.net/browse/MEN-5887))
* docs(SAML): document endpoint for getting Identity Provider Metadata
  ([MEN-5887](https://northerntech.atlassian.net/browse/MEN-5887))
* test(SAML): test endpoint for getting IDP matadata
  ([MEN-5887](https://northerntech.atlassian.net/browse/MEN-5887))

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/stretchr/testify
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/golang-jwt/jwt/v4](https://github.com/golang-jwt/jwt) from 4.2.0 to 4.4.1.
      - [Release notes](https://github.com/golang-jwt/jwt/releases)
      - [Changelog](https://github.com/golang-jwt/jwt/blob/main/VERSION_HISTORY.md)
      - [Commits](https://github.com/golang-jwt/jwt/compare/v4.2.0...v4.4.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/golang-jwt/jwt/v4
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.11.4 to 8.11.5.
      - [Release notes](https://github.com/go-redis/redis/releases)
      - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/go-redis/redis/compare/v8.11.4...v8.11.5)

      ```
      updated-dependencies:
      - dependency-name: github.com/go-redis/redis/v8
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### workflows (2.3.0)

New changes in workflows since 2.2.1:

##### Bug fixes

* Support for flags insize the ${workflow.input.identifier} via ${encoding=url;workflow.input.identifier}
  ([MEN-5819](https://northerntech.atlassian.net/browse/MEN-5819))
* All workflows use encoding=url in the input variables passed in the URIs.
  ([MEN-5819](https://northerntech.atlassian.net/browse/MEN-5819))

##### Other

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5473](https://northerntech.atlassian.net/browse/MEN-5473))

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.4 to 1.7.7.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.4...v1.7.7)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### workflows-enterprise (2.3.0)

New changes in workflows-enterprise since 2.2.1:

##### Bug fixes

* aligned ui links with updated url scheme
  ([MEN-5734](https://northerntech.atlassian.net/browse/MEN-5734))
* Update mender-artifact download URL
* Support for flags insize the ${workflow.input.identifier} via ${encoding=url;workflow.input.identifier}
  ([MEN-5819](https://northerntech.atlassian.net/browse/MEN-5819))
* All workflows use encoding=url in the input variables passed in the URIs.
  ([MEN-5819](https://northerntech.atlassian.net/browse/MEN-5819))

##### Features

* Static device group in alert emails Subject:
  ([MEN-5379](https://northerntech.atlassian.net/browse/MEN-5379))

##### Other

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5473](https://northerntech.atlassian.net/browse/MEN-5473))
* update Python dependencies for create_artifacts.py
* fix: create temporary files in the /tmp directory to avoid permission issues when running the service as a non-root user
  ([MEN-5809](https://northerntech.atlassian.net/browse/MEN-5809))

##### Dependency updates

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.4 to 1.7.7.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.4...v1.7.7)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.4 to 1.7.7.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.4...v1.7.7)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [google.golang.org/api](https://github.com/googleapis/google-api-go-client) from 0.60.0 to 0.66.0.
      - [Release notes](https://github.com/googleapis/google-api-go-client/releases)
      - [Changelog](https://github.com/googleapis/google-api-go-client/blob/main/CHANGES.md)
      - [Commits](https://github.com/googleapis/google-api-go-client/compare/v0.60.0...v0.66.0)

      ```
      updated-dependencies:
      - dependency-name: google.golang.org/api
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [google.golang.org/api](https://github.com/googleapis/google-api-go-client) from 0.66.0 to 0.67.0.
      - [Release notes](https://github.com/googleapis/google-api-go-client/releases)
      - [Changelog](https://github.com/googleapis/google-api-go-client/blob/main/CHANGES.md)
      - [Commits](https://github.com/googleapis/google-api-go-client/compare/v0.66.0...v0.67.0)

      ```
      updated-dependencies:
      - dependency-name: google.golang.org/api
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [google.golang.org/api](https://github.com/googleapis/google-api-go-client) from 0.67.0 to 0.69.0.
      - [Release notes](https://github.com/googleapis/google-api-go-client/releases)
      - [Changelog](https://github.com/googleapis/google-api-go-client/blob/main/CHANGES.md)
      - [Commits](https://github.com/googleapis/google-api-go-client/compare/v0.67.0...v0.69.0)

      ```
      updated-dependencies:
      - dependency-name: google.golang.org/api
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### integration (3.4.0)

New changes in integration since 3.3.0:

##### Bug fixes

* don't allow to use openssl lower than v.1.1.1
  ([MEN-5746](https://northerntech.atlassian.net/browse/MEN-5746))
* Correctly pass mender client version to GUI env
  ([MEN-5901](https://northerntech.atlassian.net/browse/MEN-5901))

##### Other

* feat(traefik conf): add SAML SSO endpoints exposed without authentication
  ([MEN-5102](https://northerntech.atlassian.net/browse/MEN-5102))
* Upgrade auditlogs to 3.0.2.
* Upgrade create-artifact-worker to 1.2.0.
* Upgrade deployments-enterprise to 4.3.0.
* Upgrade deployments to 4.3.0.
* Upgrade deviceauth-enterprise to 3.3.0.
* Upgrade deviceauth to 3.3.0.
* Upgrade deviceconfig to 1.2.2.
* Upgrade deviceconnect to 1.3.3.
* Upgrade devicemonitor to 1.3.0.
* Upgrade gui to 3.4.0.
* Upgrade integration to 3.4.0.
* Upgrade inventory-enterprise to 4.2.1.
* Upgrade inventory to 4.2.1.
* Upgrade iot-manager to 1.1.0.
* Upgrade mender-artifact to 3.9.0.
* Upgrade mender-binary-delta to 1.4.1.
* Upgrade mender-cli to 1.9.0.
* Upgrade mender-connect to 2.1.0.
* Upgrade mender-convert to 3.0.1.
* Upgrade mender-gateway to 1.0.1.
* Upgrade mender to 3.4.0.
* Upgrade monitor-client to 1.2.1.
* Upgrade mtls-ambassador to 1.1.0.
* Upgrade tenantadm to 3.5.0.
* Upgrade useradm-enterprise to 1.19.0.
* Upgrade useradm to 1.19.0.
* Upgrade workflows-enterprise to 2.3.0.
* Upgrade workflows to 2.3.0.


## Mender 3.3.2

_Released 03.10.2023_

### Security fixes

* Fixed CVE-2022-41324 - Read-only API access can leak secrets in Mender.
  See the official announcement for more information:
  [mender.io/blog/cve-2022-45929-cve-2022-41324-improper-access-control-for-low-privileged-users](https://mender.io/blog/cve-2022-45929-cve-2022-41324-improper-access-control-for-low-privileged-users)
* Fixed CVE-2022-45929 - Low-privileged users can edit their own roles.
  See the official announcement for more information:
  [mender.io/blog/cve-2022-45929-cve-2022-41324-improper-access-control-for-low-privileged-users](https://mender.io/blog/cve-2022-45929-cve-2022-41324-improper-access-control-for-low-privileged-users)

### Statistics

A total of 2694 lines added, 1426 removed (delta 1268)

| Developers with the most changesets | |
|---|---|
| Lluis Campos | 21 (32.3%) |
| Krzysztof Jaskiewicz | 16 (24.6%) |
| Alf-Rune Siqveland | 12 (18.5%) |
| Peter Grzybowski | 8 (12.3%) |
| Fabio Tranchitella | 4 (6.2%) |
| Kristian Amlie | 2 (3.1%) |
| Maciej Tomczuk | 2 (3.1%) |

| Developers with the most changed lines | |
|---|---|
| Peter Grzybowski | 1309 (38.7%) |
| Alf-Rune Siqveland | 740 (21.9%) |
| Krzysztof Jaskiewicz | 730 (21.6%) |
| Lluis Campos | 298 (8.8%) |
| Maciej Tomczuk | 192 (5.7%) |
| Kristian Amlie | 57 (1.7%) |
| Fabio Tranchitella | 54 (1.6%) |

| Developers with the most lines removed | |
|---|---|
| Peter Grzybowski | 26 (1.8%) |

| Developers with the most signoffs (total 2) | |
|---|---|
| Kristian Amlie | 1 (50.0%) |
| Lluis Campos | 1 (50.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 65 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 3380 (100.0%) |

| Employers with the most signoffs (total 2) | |
|---|---|
| Northern.tech | 2 (100.0%) |

| Employers with the most hackers (total 7) | |
|---|---|
| Northern.tech | 7 (100.0%) |

### Changelogs

#### deployments (4.2.2)

New changes in deployments since 4.2.1:

##### Features

* omit configuration values in the deployment details

#### deployments-enterprise (4.2.2)

New changes in deployments-enterprise since 4.2.1:

##### Features

* omit configuration values in the deployment details

#### integration (3.3.2)

New changes in integration since 3.3.1:

* test: adjust integration tests after backporting RBAC fixes
* Upgrade deployments-enterprise to 4.2.2.
* Upgrade deployments to 4.2.2.
* Upgrade integration to 3.3.2.
* Upgrade iot-manager to 1.0.4.
* Upgrade mender-cli to 1.8.2.
* Upgrade mender-convert to 3.0.2.
* Upgrade mender to 3.3.2.
* Upgrade useradm-enterprise to 1.18.2.
* Upgrade useradm to 1.18.2.

#### iot-manager (1.0.4)

New changes in iot-manager since 1.0.3:

##### Bug fixes

* wrong capitalization for `Type`
  ([QA-481](https://northerntech.atlassian.net/browse/QA-481))

#### useradm (1.18.2)

New changes in useradm since 1.18.1:

##### Bug fixes

* allow privileged users to change email address of another user
  ([MEN-5829](https://northerntech.atlassian.net/browse/MEN-5829))
* Protect user updates from concurrent updates
  ([MEN-6003](https://northerntech.atlassian.net/browse/MEN-6003))
* Updating existing users is blocked by ETag check
  ([MEN-6087](https://northerntech.atlassian.net/browse/MEN-6087))

#### useradm-enterprise (1.18.2)

New changes in useradm-enterprise since 1.18.1:

##### Bug fixes

* user should not be able to modify all his data
  ([MEN-6012](https://northerntech.atlassian.net/browse/MEN-6012))
* allow privileged users to change email address of another user
  ([MEN-5829](https://northerntech.atlassian.net/browse/MEN-5829))
* Protect user updates from concurrent updates
  ([MEN-6003](https://northerntech.atlassian.net/browse/MEN-6003))
* Changing email makes the user email unverified
  ([MEN-5974](https://northerntech.atlassian.net/browse/MEN-5974))
* Updating existing users is blocked by ETag check
  ([MEN-6087](https://northerntech.atlassian.net/browse/MEN-6087))
* Remove ability to modify internal parameters of the user object
  ([MEN-6037](https://northerntech.atlassian.net/browse/MEN-6037))
* apply plan based restriction to permission_sets endpoints
  ([MEN-6093](https://northerntech.atlassian.net/browse/MEN-6093))
* restrict access to GET /events endpoint to Admin users only
  ([MEN-5831](https://northerntech.atlassian.net/browse/MEN-5831))
* remove access to deviceconfig from ReadDevices permission set
  ([MEN-5817](https://northerntech.atlassian.net/browse/MEN-5817))
* remove permision for downloading artifact from ReadReleases permission set
  ([MEN-5816](https://northerntech.atlassian.net/browse/MEN-5816))
* DeployToDevices permission set should grant access to deployments only
  ([MEN-5816](https://northerntech.atlassian.net/browse/MEN-5816), [MEN-5817](https://northerntech.atlassian.net/browse/MEN-5817))
* update Deployments Manager role

  The role should grant basic access and access to read releases, read devices and
  deploy to devices.
  ([MEN-5816](https://northerntech.atlassian.net/browse/MEN-5816))
* Read Devices permission should not grant access to artifacts
  ([MEN-5816](https://northerntech.atlassian.net/browse/MEN-5816))
* Connect permission should allow downloaing files from the device
  ([MEN-5839](https://northerntech.atlassian.net/browse/MEN-5839))
* Read Access role should grant access to device state in the iot-manager
* Read Access role should grant access to view deployments
* extend read releases permission with access to statistics/list

##### Features

* introduce ConfigureDevices permission set
  ([MEN-5817](https://northerntech.atlassian.net/browse/MEN-5817))


## Mender 3.3.1

_Released 10.19.2022_

### Statistics

A total of 4148 lines added, 2523 removed (delta 1625)

| Developers with the most changesets | |
|---|---|
| Peter Grzybowski | 23 (19.5%) |
| Fabio Tranchitella | 19 (16.1%) |
| Ole Petter Orhagen | 15 (12.7%) |
| Lluis Campos | 14 (11.9%) |
| Alf-Rune Siqveland | 14 (11.9%) |
| Kristian Amlie | 13 (11.0%) |
| Manuel Zedel | 9 (7.6%) |
| Maciej Tomczuk | 6 (5.1%) |
| Alex Miliukov | 3 (2.5%) |
| Mikael Torp-Holte | 2 (1.7%) |

| Developers with the most changed lines | |
|---|---|
| Lluis Campos | 1003 (21.4%) |
| Peter Grzybowski | 843 (18.0%) |
| Alf-Rune Siqveland | 821 (17.5%) |
| Fabio Tranchitella | 677 (14.4%) |
| Kristian Amlie | 674 (14.4%) |
| Maciej Tomczuk | 236 (5.0%) |
| Alex Miliukov | 236 (5.0%) |
| Ole Petter Orhagen | 81 (1.7%) |
| Mikael Torp-Holte | 67 (1.4%) |
| Manuel Zedel | 50 (1.1%) |

| Developers with the most lines removed | |
|---|---|
| Kristian Amlie | 188 (7.5%) |

| Developers with the most signoffs (total 4) | |
|---|---|
| Ole Petter Orhagen | 2 (50.0%) |
| Kristian Amlie | 1 (25.0%) |
| Fabio Tranchitella | 1 (25.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 118 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 4688 (100.0%) |

| Employers with the most signoffs (total 4) | |
|---|---|
| Northern.tech | 4 (100.0%) |

| Employers with the most hackers (total 10) | |
|---|---|
| Northern.tech | 10 (100.0%) |

### Changelogs

#### auditlogs (3.0.2)

New changes in auditlogs since 3.0.1:

* upgrade mendersoftware/go-lib-micro to v0.0.0-20220304124258-d8414885f1c3
  ([MEN-5506](https://northerntech.atlassian.net/browse/MEN-5506))

#### deployments (4.2.1)

New changes in deployments since 4.2.0:

##### Bug fixes

* Fix bad indexing from database versions 1.2.8 and 1.2.9
  ([MEN-5695](https://northerntech.atlassian.net/browse/MEN-5695))
* Escape configuration download URL path and support '.' in parameter
  ([MEN-5712](https://northerntech.atlassian.net/browse/MEN-5712))
* Multipart upload not working when loading s3 settings from env
  ([MEN-5939](https://northerntech.atlassian.net/browse/MEN-5939))

#### deployments-enterprise (4.2.1)

New changes in deployments-enterprise since 4.2.0:

##### Bug fixes

* Fix bad indexing from database versions 1.2.8 and 1.2.9
  ([MEN-5695](https://northerntech.atlassian.net/browse/MEN-5695))
* Escape configuration download URL path and support '.' in parameter
  ([MEN-5712](https://northerntech.atlassian.net/browse/MEN-5712))
* Multipart upload not working when loading s3 settings from env
  ([MEN-5939](https://northerntech.atlassian.net/browse/MEN-5939))

#### deviceauth (3.2.2)

New changes in deviceauth since 3.2.1:

##### Bug fixes

* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))
* Missing hash in inventory client

##### Other

* upgrade mendersoftware/go-lib-micro to v0.0.0-20220302103938-7561c751e1fd
  ([MEN-5471](https://northerntech.atlassian.net/browse/MEN-5471))

#### deviceauth-enterprise (3.2.2)

New changes in deviceauth-enterprise since 3.2.1:

##### Bug fixes

* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))
* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))
* Missing hash in inventory client

##### Other

* upgrade mendersoftware/go-lib-micro to v0.0.0-20220302103938-7561c751e1fd
  ([MEN-5471](https://northerntech.atlassian.net/browse/MEN-5471))

#### deviceconfig (1.2.2)

New changes in deviceconfig since 1.2.1:

##### Bug fixes

* Fix borken migration.
  ([MEN-5719](https://northerntech.atlassian.net/browse/MEN-5719))

##### Other

* upgrade mendersoftware/go-lib-micro to v0.0.0-20220304124258-d8414885f1c3
  ([MEN-5504](https://northerntech.atlassian.net/browse/MEN-5504))

#### deviceconnect (1.3.3)

New changes in deviceconnect since 1.3.2:

##### Bug fixes

* Correct broken document migration in 2.0.0
  ([MEN-5718](https://northerntech.atlassian.net/browse/MEN-5718))
* Apply migration to all databases prior to 2.0.0
  ([MEN-5718](https://northerntech.atlassian.net/browse/MEN-5718))
* New migration (2.0.1) patching 2.0.0 document migration
  ([MEN-5718](https://northerntech.atlassian.net/browse/MEN-5718))

##### Other

* upgrade mendersoftware/go-lib-micro to v0.0.0-20220304124258-d8414885f1c3
  ([MEN-5505](https://northerntech.atlassian.net/browse/MEN-5505))

#### devicemonitor (1.2.1)

New changes in devicemonitor since 1.2.0:

##### Bug fixes

* Reduce the maximum number of alerts/configurations per request
  ([MEN-5854](https://northerntech.atlassian.net/browse/MEN-5854))

#### gui (3.3.1)

New changes in gui since 3.3.0:

##### Bug fixes

* fixed an issue that caused the device list to crash on group selection if a device was selected at the time
* added missing check for plan availability for auditlogs
  ([MEN-5686](https://northerntech.atlassian.net/browse/MEN-5686))
* ensured dynamic group filters are used on group device retrieval
  ([MEN-5668](https://northerntech.atlassian.net/browse/MEN-5668))
* prevented nginx from preloading version info file
  ([MEN-5707](https://northerntech.atlassian.net/browse/MEN-5707))
* aligned final onboarding snackbar rendering with onboarding progress
  ([MEN-5909](https://northerntech.atlassian.net/browse/MEN-5909))

#### integration (3.3.1)

New changes in integration since 3.3.0:

##### Bug fixes

* Correctly pass mender client version to GUI env
  ([MEN-5901](https://northerntech.atlassian.net/browse/MEN-5901))
* Do not double count integration in changelogs and statistics.

##### Other

* Upgrade auditlogs to 3.0.2.
* Upgrade deployments-enterprise to 4.2.1.
* Upgrade deployments to 4.2.1.
* Upgrade deviceauth-enterprise to 3.2.2.
* Upgrade deviceauth to 3.2.2.
* Upgrade deviceconfig to 1.2.2.
* Upgrade deviceconnect to 1.3.3.
* Upgrade devicemonitor to 1.2.1.
* Upgrade gui to 3.3.1.
* Upgrade integration to 3.3.1.
* Upgrade inventory-enterprise to 4.2.1.
* Upgrade inventory to 4.2.1.
* Upgrade iot-manager to 1.0.3.
* Upgrade mender-artifact to 3.8.1.
* Upgrade mender-binary-delta to 1.4.1.
* Upgrade mender-cli to 1.8.1.
* Upgrade mender-convert to 3.0.1.
* Upgrade mender-gateway to 1.0.1.
* Upgrade mender to 3.3.1.
* Upgrade monitor-client to 1.2.1.
* Upgrade tenantadm to 3.4.1.
* Upgrade useradm-enterprise to 1.18.1.
* Upgrade useradm to 1.18.1.
* Upgrade workflows-enterprise to 2.2.2.
* Upgrade workflows to 2.2.2.

#### inventory (4.2.1)

New changes in inventory since 4.2.0:

##### Bug fixes

* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))

#### inventory-enterprise (4.2.1)

New changes in inventory-enterprise since 4.2.0:

##### Bug fixes

* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))

#### iot-manager (1.0.3)

New changes in iot-manager since 1.0.2:

* upgrade mendersoftware/go-lib-micro to v0.0.0-20220304124258-d8414885f1c3
  ([MEN-5467](https://northerntech.atlassian.net/browse/MEN-5467))

#### tenantadm (3.4.1)

New changes in tenantadm since 3.4.0:

##### Bug fixes

* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))

#### useradm (1.18.1)

New changes in useradm since 1.18.0:

##### Bug fixes

* invalidate user sessions but the current one on user updates
  ([MEN-5731](https://northerntech.atlassian.net/browse/MEN-5731))
* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))

#### useradm-enterprise (1.18.1)

New changes in useradm-enterprise since 1.18.0:

##### Bug fixes

* invalidate user sessions but the current one on user updates
  ([MEN-5731](https://northerntech.atlassian.net/browse/MEN-5731))
* replace colon with hash for path params modifiers in URLs
  ([MEN-5713](https://northerntech.atlassian.net/browse/MEN-5713))
* Forbid oauth logins for suspended tenants.

#### workflows (2.2.2)

New changes in workflows since 2.2.1:

##### Bug fixes

* Support for flags insize the ${workflow.input.identifier} via ${encoding=url;workflow.input.identifier}
  ([MEN-5819](https://northerntech.atlassian.net/browse/MEN-5819))
* All workflows use encoding=url in the input variables passed in the URIs.
  ([MEN-5819](https://northerntech.atlassian.net/browse/MEN-5819))

##### Other

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5473](https://northerntech.atlassian.net/browse/MEN-5473))

#### workflows-enterprise (2.2.2)

New changes in workflows-enterprise since 2.2.1:

##### Bug fixes

* Support for flags insize the ${workflow.input.identifier} via ${encoding=url;workflow.input.identifier}
  ([MEN-5819](https://northerntech.atlassian.net/browse/MEN-5819))
* All workflows use encoding=url in the input variables passed in the URIs.
  ([MEN-5819](https://northerntech.atlassian.net/browse/MEN-5819))

##### Other

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5473](https://northerntech.atlassian.net/browse/MEN-5473))


## Mender 3.3.0

_Released 06.14.2022_

### Statistics

A total of 52292 lines added, 17854 removed (delta 34438)

| Developers with the most changesets | |
|---|---|
| Manuel Zedel | 174 (30.6%) |
| Fabio Tranchitella | 114 (20.0%) |
| Krzysztof Jaskiewicz | 82 (14.4%) |
| Lluis Campos | 39 (6.9%) |
| Alf-Rune Siqveland | 35 (6.2%) |
| Ole Petter Orhagen | 33 (5.8%) |
| Kristian Amlie | 28 (4.9%) |
| Peter Grzybowski | 20 (3.5%) |
| Mikael Torp-Holte | 15 (2.6%) |
| Jack Bennett | 13 (2.3%) |

| Developers with the most changed lines | |
|---|---|
| Krzysztof Jaskiewicz | 14238 (25.6%) |
| Fabio Tranchitella | 12713 (22.9%) |
| Manuel Zedel | 10635 (19.1%) |
| Alf-Rune Siqveland | 10033 (18.0%) |
| Lluis Campos | 2124 (3.8%) |
| Jack Bennett | 1185 (2.1%) |
| Ole Petter Orhagen | 1055 (1.9%) |
| Kristian Amlie | 884 (1.6%) |
| Peter Grzybowski | 874 (1.6%) |
| Maciej Tomczuk | 713 (1.3%) |

| Developers with the most lines removed | |
|---|---|
| Michael Clelland | 270 (1.5%) |
| Lluis Campos | 143 (0.8%) |

| Developers with the most signoffs (total 18) | |
|---|---|
| dependabot[bot] | 10 (55.6%) |
| Lluis Campos | 4 (22.2%) |
| dependabot-preview[bot] | 2 (11.1%) |
| Ole Petter Orhagen | 2 (11.1%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 526 (92.4%) |
| RnDity | 28 (4.9%) |
| Engineered Arts | 13 (2.3%) |
| benjamin.texier@outlook.com | 2 (0.4%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 47158 (84.8%) |
| RnDity | 7013 (12.6%) |
| Engineered Arts | 1185 (2.1%) |
| benjamin.texier@outlook.com | 240 (0.4%) |

| Employers with the most signoffs (total 18) | |
|---|---|
| Northern.tech | 18 (100.0%) |

| Employers with the most hackers (total 14) | |
|---|---|
| Northern.tech | 11 (78.6%) |
| RnDity | 1 (7.1%) |
| Engineered Arts | 1 (7.1%) |
| benjamin.texier@outlook.com | 1 (7.1%) |

### Changelogs

#### deployments (4.2.0)

New changes in deployments since 4.1.0:

##### Bug fixes

* change the error handling when the device is reporting wrong artifact name

  In case the device is reporting new artifact name before finishing the
  update process, log the error and continue the update.
* fix the device_type handling in the deployments/next handler

  On the device_type change, deployments service is trying to select new
  artfiact for the device deployment.
  With this change, deployments service will:
  - save the device_type with the device deployment object;
  - try to update the artifact assigned to the device deployment
    only if the device_type has changed and the device deployment
    is not in progress
* always reassign artifact on the device type change
* assign artifact to the device deployment only if it was not assigned previously
* improve error handling in the /deployments/next handlers

##### Features

* extend deployments instruction with artifact id
  ([MEN-5314](https://northerntech.atlassian.net/browse/MEN-5314))
* Allow to use S3 Exernal URI
  ([MEN-5280](https://northerntech.atlassian.net/browse/MEN-5280))

##### Other

* perf: optimize the database lookups for new deployments
  ([MEN-5443](https://northerntech.atlassian.net/browse/MEN-5443))
* replace `satori/go.uuid` with `google/uuid`
  ([MEN-5468](https://northerntech.atlassian.net/browse/MEN-5468))
* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5468](https://northerntech.atlassian.net/browse/MEN-5468))
* perf: Optimize mongodb query for finding the next deployment for device

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.40.59 to 1.42.47.
      - [Release notes](https://github.com/aws/aws-sdk-go/releases)
      - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.40.59...v1.42.47)

      ```
      updated-dependencies:
      - dependency-name: github.com/aws/aws-sdk-go
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### deployments-enterprise (4.2.0)

New changes in deployments-enterprise since 4.1.0:

##### Bug fixes

* change the error handling when the device is reporting wrong artifact name

  In case the device is reporting new artifact name before finishing the
  update process, log the error and continue the update.
* change the error handling when the device is reporting wrong artifact name

  In case the device is reporting new artifact name before finishing the
  update process, log the error and continue the update.
* fix the device_type handling in the deployments/next handler

  On the device_type change, deployments service is trying to select new
  artfiact for the device deployment.
  With this change, deployments service will:
  - save the device_type with the device deployment object;
  - try to update the artifact assigned to the device deployment
    only if the device_type has changed and the device deployment
    is not in progress
* fix the device_type handling in the deployments/next handler

  On the device_type change, deployments service is trying to select new
  artfiact for the device deployment.
  With this change, deployments service will:
  - save the "device_type" and "provides" with the device deployment object;
  - try to update the artifact assigned to the device deployment
    if the device_type or provides has changed
* always reassign artifact on the device type change
* assign artifact to the device deployment only if it was not assigned previously
* assign artifact to the device deployment only if it was not assigned previously
* improve error handling in the /deployments/next handlers
* wrong detection of empty update control maps
  ([MEN-5626](https://northerntech.atlassian.net/browse/MEN-5626))

##### Features

* new enpoint for retrieving deployment update control map
* deployment's update control map can be updated only if exist

  With this change it is possible to patch deployment's update control map
  only if the deployment contain update control map.
  In case the deployment does not contain update control map, service will
  return 409 Conflict on attempt to patch update control map.
* extend deployments instruction with artifact id
  ([MEN-5314](https://northerntech.atlassian.net/browse/MEN-5314))
* Allow to use S3 Exernal URI
  ([MEN-5280](https://northerntech.atlassian.net/browse/MEN-5280))
* Allow to use S3 Exernal URI
  ([MEN-5280](https://northerntech.atlassian.net/browse/MEN-5280))

##### Other

* perf: optimize the database lookups for new deployments
  ([MEN-5443](https://northerntech.atlassian.net/browse/MEN-5443))
* replace `satori/go.uuid` with `google/uuid`
  ([MEN-5468](https://northerntech.atlassian.net/browse/MEN-5468))
* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5468](https://northerntech.atlassian.net/browse/MEN-5468))
* perf: Optimize mongodb query for finding the next deployment for device

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.40.59 to 1.42.44.
      - [Release notes](https://github.com/aws/aws-sdk-go/releases)
      - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.40.59...v1.42.44)

      ```
      updated-dependencies:
      - dependency-name: github.com/aws/aws-sdk-go
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.8.2.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.8.2)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.40.59 to 1.42.47.
      - [Release notes](https://github.com/aws/aws-sdk-go/releases)
      - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.40.59...v1.42.47)

      ```
      updated-dependencies:
      - dependency-name: github.com/aws/aws-sdk-go
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### devicemonitor (1.2.0)

New changes in devicemonitor since 1.1.0:

##### Bug fixes

* Invalid OpenAPI schema for configuration endpoints

##### Features

* extend the device APIs validation of requests
  ([MEN-5427](https://northerntech.atlassian.net/browse/MEN-5427))

##### Other

* add internal end-point to list tenant devices and their latest alerts
  ([MEN-4966](https://northerntech.atlassian.net/browse/MEN-4966))
* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5472](https://northerntech.atlassian.net/browse/MEN-5472))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### gui (3.3.0)

New changes in gui since 3.2.0:

##### Bug fixes

* disable the update control map control if not enterprise
  ([MEN-5424](https://northerntech.atlassian.net/browse/MEN-5424))
* the group selection is no longer changed on group creation
* prevented an issue that allowed to create a group that could not be removed
  ([MEN-5562](https://northerntech.atlassian.net/browse/MEN-5562))
* fixed an issue that caused device list selections to not work
* fixed an issue that made pagination unreliable in auditlogs
* fixed an issue that caused final onboarding notification to stay visible
  ([MEN-5382](https://northerntech.atlassian.net/browse/MEN-5382))
* fixed a faulty notification access that might cause a crash when filtering devices
* prevented file upload dialog popping up when clicking on remote terminal
* fixed an issue that prevented dismissing multiple devices
  ([MEN-5615](https://northerntech.atlassian.net/browse/MEN-5615))
* fixed an issue that prevented device ids from showing when added as custom column
  ([MEN-5612](https://northerntech.atlassian.net/browse/MEN-5612))
* fixed an issue that would prevent creating deployments from releases with url components in their name
  ([MEN-5625](https://northerntech.atlassian.net/browse/MEN-5625))
* fixed an issue that prevented device names from showing up in deployment report
  ([MEN-5616](https://northerntech.atlassian.net/browse/MEN-5616))
* fixed an issue that let device searches show non-group devices in a group focused search
  ([MEN-5608](https://northerntech.atlassian.net/browse/MEN-5608))
* fixed an issue that could cause device lists to show a wrong device id attribute
* fixed an issue that caused the ui to crash when using a custom role
* fixed an issue that in some cases prevent reducing permissions of a role
* fixed an issue in evaluating ui permissions that would prevent users from creating a deployment when not given full deploy rights
  ([MEN-5663](https://northerntech.atlassian.net/browse/MEN-5663))
* fixed an issue that allowed device expansion only once
  ([MEN-5665](https://northerntech.atlassian.net/browse/MEN-5665))

##### Features

* added possibility to configure device list columns
* added column customization capability in device list
  ([MEN-5233](https://northerntech.atlassian.net/browse/MEN-5233))
* simplified pagination controls
* added a way to promote a device to become a Mender gateway
  ([MEN-5476](https://northerntech.atlassian.net/browse/MEN-5476))
* Update Help topics and content #5580
* aligned device action access on details with the device list -> in the lower right corner
  ([MEN-5563](https://northerntech.atlassian.net/browse/MEN-5563))
* added support for new and improved RBAC backend
  ([MEN-5214](https://northerntech.atlassian.net/browse/MEN-5214))
* made UI element visibility depend more on access rights
  ([MEN-5214](https://northerntech.atlassian.net/browse/MEN-5214))
* added device search capability to ease device access from around the app
  ([MEN-5191](https://northerntech.atlassian.net/browse/MEN-5191))
* adjusted the layout of the devices page to make better use of the new search capabilities
* Aggregated Dependabot Changelogs:
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.13.0 to 8.14.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.13.0...v8.14.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps node from 17.9.0-alpine to 18.0.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.21.0 to 1.21.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.21.0...v1.21.1)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.4.4 to 10.4.5.
      - [Release notes](https://github.com/postcss/autoprefixer/releases)
      - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/autoprefixer/compare/10.4.4...10.4.5)

      ```
      updated-dependencies:
      - dependency-name: autoprefixer
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.3.8 to 12.4.0.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.3.8...v12.4.0)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@nuintun/qrcode](https://github.com/nuintun/qrcode) from 3.1.1 to 3.1.3.
      - [Release notes](https://github.com/nuintun/qrcode/releases)
      - [Commits](https://github.com/nuintun/qrcode/commits)

      ```
      updated-dependencies:
      - dependency-name: "@nuintun/qrcode"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.22.0 to 3.22.2.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.22.0...v3.22.2)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.27.0 to 1.29.0.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.27.0...v1.29.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [react-window](https://github.com/bvaughn/react-window) from 1.8.6 to 1.8.7.
      - [Release notes](https://github.com/bvaughn/react-window/releases)
      - [Changelog](https://github.com/bvaughn/react-window/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/bvaughn/react-window/commits)

      ```
      updated-dependencies:
      - dependency-name: react-window
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [react-redux](https://github.com/reduxjs/react-redux) from 8.0.0 to 8.0.1.
      - [Release notes](https://github.com/reduxjs/react-redux/releases)
      - [Changelog](https://github.com/reduxjs/react-redux/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/reduxjs/react-redux/compare/v8.0.0...v8.0.1)

      ```
      updated-dependencies:
      - dependency-name: react-redux
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.5.1 to 28.0.0.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v28.0.0/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-major
      ```
  * Bumps [jest-junit](https://github.com/jest-community/jest-junit) from 13.1.0 to 13.2.0.
      - [Release notes](https://github.com/jest-community/jest-junit/releases)
      - [Commits](https://github.com/jest-community/jest-junit/compare/v13.1.0...v13.2.0)

      ```
      updated-dependencies:
      - dependency-name: jest-junit
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest-watch-typeahead](https://github.com/jest-community/jest-watch-typeahead) from 1.0.0 to 1.1.0.
      - [Release notes](https://github.com/jest-community/jest-watch-typeahead/releases)
      - [Changelog](https://github.com/jest-community/jest-watch-typeahead/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/jest-community/jest-watch-typeahead/compare/v1.0.0...v1.1.0)

      ```
      updated-dependencies:
      - dependency-name: jest-watch-typeahead
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/lab](https://github.com/mui/material-ui/tree/HEAD/packages/mui-lab) from 5.0.0-alpha.78 to 5.0.0-alpha.79.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/HEAD/packages/mui-lab)

      ```
      updated-dependencies:
      - dependency-name: "@mui/lab"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-material) from 5.6.2 to 5.6.3.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.6.3/packages/mui-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/material"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.5.1 to 28.0.0.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v28.0.0/packages/babel-jest)

      ```
      updated-dependencies:
      - dependency-name: babel-jest
        dependency-type: direct:development
        update-type: version-update:semver-major
      ```
  * Bumps [jest](https://github.com/facebook/jest/tree/HEAD/packages/jest) from 27.5.1 to 28.0.0.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v28.0.0/packages/jest)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-major
      ```
  * Bumps [react-idle-timer](https://github.com/supremetechnopriest/react-idle-timer) from 4.6.4 to 5.0.0.
      - [Release notes](https://github.com/supremetechnopriest/react-idle-timer/releases)
      - [Changelog](https://github.com/SupremeTechnopriest/react-idle-timer/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/supremetechnopriest/react-idle-timer/commits)

      ```
      updated-dependencies:
      - dependency-name: react-idle-timer
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [@monaco-editor/react](https://github.com/suren-atoyan/monaco-react) from 4.4.2 to 4.4.4.
      - [Release notes](https://github.com/suren-atoyan/monaco-react/releases)
      - [Changelog](https://github.com/suren-atoyan/monaco-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/suren-atoyan/monaco-react/compare/v4.4.2...v4.4.4)

      ```
      updated-dependencies:
      - dependency-name: "@monaco-editor/react"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.26.1 to 0.27.2.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.26.1...v0.27.2)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

##### Other

* Moved theme-manager.js into a new MUI theme light+dark variants
* made retrying failed group deployments more defensive
* let device monitoring alerts stay in  distinct section
  ([MEN-5174](https://northerntech.atlassian.net/browse/MEN-5174))
* switched to production intervals when starting mender setup from the UI once onboarding is completed
  ([MEN-5139](https://northerntech.atlassian.net/browse/MEN-5139))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps node from 17.3.0-alpine to 17.3.1-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [msw](https://github.com/mswjs/msw) from 0.36.3 to 0.36.4.
      - [Release notes](https://github.com/mswjs/msw/releases)
      - [Changelog](https://github.com/mswjs/msw/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/mswjs/msw/compare/v0.36.3...v0.36.4)

      ```
      updated-dependencies:
      - dependency-name: msw
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.16.7 to 7.16.8.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.8/packages/babel-preset-env)

      ```
      updated-dependencies:
      - dependency-name: "@babel/preset-env"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.20.2 to 3.20.3.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.20.2...v3.20.3)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps playwright from v1.17.1 to v1.17.2.

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:production
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.6.0 to 8.7.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.6.0...v8.7.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.38.4 to 0.38.5.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.38.4...v0.38.5)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.65.0 to 5.66.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.65.0...v5.66.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.11.1 to 8.11.2.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.11.1...v8.11.2)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.16.7 to 7.16.8.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.8/packages/babel-plugin-transform-runtime)

      ```
      updated-dependencies:
      - dependency-name: "@babel/plugin-transform-runtime"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.24.0 to 0.25.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.24.0...v0.25.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.4.6 to 2.5.2.
      - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.4.6...v2.5.2)

      ```
      updated-dependencies:
      - dependency-name: mini-css-extract-plugin
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.24.0 to 0.25.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.24.0...v0.25.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.66.0 to 5.67.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.66.0...v5.67.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.16.8 to 7.16.10.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.10/packages/babel-plugin-transform-runtime)

      ```
      updated-dependencies:
      - dependency-name: "@babel/plugin-transform-runtime"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.16.7 to 7.16.10.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.10/packages/babel-core)

      ```
      updated-dependencies:
      - dependency-name: "@babel/core"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.1.7 to 12.2.2.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.1.7...v12.2.2)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.16.8 to 7.16.11.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.11/packages/babel-preset-env)

      ```
      updated-dependencies:
      - dependency-name: "@babel/preset-env"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps node from 17.3.1-alpine to 17.4.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.16.10 to 7.16.12.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.12/packages/babel-core)

      ```
      updated-dependencies:
      - dependency-name: "@babel/core"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.17.2 to 1.18.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.17.2...v1.18.0)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.17.2 to 1.18.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.17.2...v1.18.0)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.2.2 to 12.3.1.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.2.2...v12.3.1)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.17.2 to 1.18.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.17.2...v1.18.0)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@nuintun/qrcode](https://github.com/nuintun/qrcode) from 3.0.1 to 3.1.1.
      - [Release notes](https://github.com/nuintun/qrcode/releases)
      - [Commits](https://github.com/nuintun/qrcode/commits)

      ```
      updated-dependencies:
      - dependency-name: "@nuintun/qrcode"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [copy-webpack-plugin](https://github.com/webpack-contrib/copy-webpack-plugin) from 10.2.0 to 10.2.1.
      - [Release notes](https://github.com/webpack-contrib/copy-webpack-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/copy-webpack-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/copy-webpack-plugin/compare/v10.2.0...v10.2.1)

      ```
      updated-dependencies:
      - dependency-name: copy-webpack-plugin
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [msw](https://github.com/mswjs/msw) from 0.36.4 to 0.36.5.
      - [Release notes](https://github.com/mswjs/msw/releases)
      - [Changelog](https://github.com/mswjs/msw/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/mswjs/msw/compare/v0.36.4...v0.36.5)

      ```
      updated-dependencies:
      - dependency-name: msw
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.5.4 to 4.5.5.
      - [Release notes](https://github.com/Microsoft/TypeScript/releases)
      - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.5.4...v4.5.5)

      ```
      updated-dependencies:
      - dependency-name: typescript
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack-cli](https://github.com/webpack/webpack-cli) from 4.9.1 to 4.9.2.
      - [Release notes](https://github.com/webpack/webpack-cli/releases)
      - [Changelog](https://github.com/webpack/webpack-cli/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack/webpack-cli/compare/webpack-cli@4.9.1...webpack-cli@4.9.2)

      ```
      updated-dependencies:
      - dependency-name: webpack-cli
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [msw](https://github.com/mswjs/msw) from 0.36.5 to 0.36.7.
      - [Release notes](https://github.com/mswjs/msw/releases)
      - [Changelog](https://github.com/mswjs/msw/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/mswjs/msw/compare/v0.36.5...v0.36.7)

      ```
      updated-dependencies:
      - dependency-name: msw
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.5.2 to 2.5.3.
      - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.5.2...v2.5.3)

      ```
      updated-dependencies:
      - dependency-name: mini-css-extract-plugin
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps nginx from 1.21.5-alpine to 1.21.6-alpine.

      ```
      updated-dependencies:
      - dependency-name: nginx
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.18.0 to 1.18.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.18.0...v1.18.1)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.18.0 to 1.18.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.18.0...v1.18.1)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.11.2 to 8.11.3.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.11.2...v8.11.3)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.7.0 to 8.8.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.7.0...v8.8.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [copy-webpack-plugin](https://github.com/webpack-contrib/copy-webpack-plugin) from 10.2.1 to 10.2.3.
      - [Release notes](https://github.com/webpack-contrib/copy-webpack-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/copy-webpack-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/copy-webpack-plugin/compare/v10.2.1...v10.2.3)

      ```
      updated-dependencies:
      - dependency-name: copy-webpack-plugin
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.18.0 to 1.18.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.18.0...v1.18.1)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.20.3 to 3.21.0.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.20.3...v3.21.0)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.16.1 to 5.16.2.
      - [Release notes](https://github.com/testing-library/jest-dom/releases)
      - [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/jest-dom/compare/v5.16.1...v5.16.2)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/jest-dom"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.16.10 to 7.17.0.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.17.0/packages/babel-plugin-transform-runtime)

      ```
      updated-dependencies:
      - dependency-name: "@babel/plugin-transform-runtime"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/eslint-parser](https://github.com/babel/babel/tree/HEAD/eslint/babel-eslint-parser) from 7.16.5 to 7.17.0.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.17.0/eslint/babel-eslint-parser)

      ```
      updated-dependencies:
      - dependency-name: "@babel/eslint-parser"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.3.1 to 12.3.3.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.3.1...v12.3.3)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 6.5.1 to 6.6.0.
      - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/css-loader/compare/v6.5.1...v6.6.0)

      ```
      updated-dependencies:
      - dependency-name: css-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.16.12 to 7.17.0.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.17.0/packages/babel-core)

      ```
      updated-dependencies:
      - dependency-name: "@babel/core"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.67.0 to 5.68.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.67.0...v5.68.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [react-dropzone](https://github.com/react-dropzone/react-dropzone) from 11.5.1 to 11.5.3.
      - [Release notes](https://github.com/react-dropzone/react-dropzone/releases)
      - [Commits](https://github.com/react-dropzone/react-dropzone/compare/v11.5.1...v11.5.3)

      ```
      updated-dependencies:
      - dependency-name: react-dropzone
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.4.5 to 8.4.6.
      - [Release notes](https://github.com/postcss/postcss/releases)
      - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/postcss/compare/8.4.5...8.4.6)

      ```
      updated-dependencies:
      - dependency-name: postcss
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [msw](https://github.com/mswjs/msw) from 0.36.7 to 0.36.8.
      - [Release notes](https://github.com/mswjs/msw/releases)
      - [Changelog](https://github.com/mswjs/msw/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/mswjs/msw/compare/v0.36.7...v0.36.8)

      ```
      updated-dependencies:
      - dependency-name: msw
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [victory](https://github.com/formidablelabs/victory) from 36.2.0 to 36.2.1.
      - [Release notes](https://github.com/formidablelabs/victory/releases)
      - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/formidablelabs/victory/compare/v36.2.0...v36.2.1)

      ```
      updated-dependencies:
      - dependency-name: victory
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.38.5 to 0.38.6.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.38.5...v0.38.6)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [copy-webpack-plugin](https://github.com/webpack-contrib/copy-webpack-plugin) from 10.2.3 to 10.2.4.
      - [Release notes](https://github.com/webpack-contrib/copy-webpack-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/copy-webpack-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/copy-webpack-plugin/compare/v10.2.3...v10.2.4)

      ```
      updated-dependencies:
      - dependency-name: copy-webpack-plugin
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@reduxjs/toolkit](https://github.com/reduxjs/redux-toolkit) from 1.7.1 to 1.7.2.
      - [Release notes](https://github.com/reduxjs/redux-toolkit/releases)
      - [Commits](https://github.com/reduxjs/redux-toolkit/compare/v1.7.1...v1.7.2)

      ```
      updated-dependencies:
      - dependency-name: "@reduxjs/toolkit"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.4.6 to 27.5.0.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.5.0/packages/babel-jest)

      ```
      updated-dependencies:
      - dependency-name: babel-jest
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [xterm-addon-web-links](https://github.com/xtermjs/xterm.js) from 0.5.0 to 0.5.1.
      - [Release notes](https://github.com/xtermjs/xterm.js/releases)
      - [Commits](https://github.com/xtermjs/xterm.js/commits)

      ```
      updated-dependencies:
      - dependency-name: xterm-addon-web-links
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [xterm](https://github.com/xtermjs/xterm.js) from 4.16.0 to 4.17.0.
      - [Release notes](https://github.com/xtermjs/xterm.js/releases)
      - [Commits](https://github.com/xtermjs/xterm.js/compare/4.16.0...4.17.0)

      ```
      updated-dependencies:
      - dependency-name: xterm
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.4.6 to 27.5.0.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.5.0/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.4.7 to 27.5.0.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.4.7...v27.5.0)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.38.6 to 0.38.7.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.38.6...v0.38.7)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps node from 17.4.0-alpine to 17.5.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.38.7 to 0.38.9.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.38.7...v0.38.9)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.18.1 to 1.19.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.18.1...v1.19.0)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.18.1 to 1.19.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.18.1...v1.19.0)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.5.0 to 27.5.1.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.5.1/packages/babel-jest)

      ```
      updated-dependencies:
      - dependency-name: babel-jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.3.3 to 12.3.4.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.3.3...v12.3.4)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [follow-redirects](https://github.com/follow-redirects/follow-redirects) from 1.14.7 to 1.14.8.
      - [Release notes](https://github.com/follow-redirects/follow-redirects/releases)
      - [Commits](https://github.com/follow-redirects/follow-redirects/compare/v1.14.7...v1.14.8)

      ```
      updated-dependencies:
      - dependency-name: follow-redirects
        dependency-type: indirect
      ```
  * Bumps [follow-redirects](https://github.com/follow-redirects/follow-redirects) from 1.14.7 to 1.14.8.
      - [Release notes](https://github.com/follow-redirects/follow-redirects/releases)
      - [Commits](https://github.com/follow-redirects/follow-redirects/compare/v1.14.7...v1.14.8)

      ```
      updated-dependencies:
      - dependency-name: follow-redirects
        dependency-type: indirect
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.8.0 to 8.9.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.8.0...v8.9.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.18.1 to 1.19.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.18.1...v1.19.1)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.25.0 to 0.26.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.25.0...v0.26.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.5.0 to 27.5.1.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.5.0...v27.5.1)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.68.0 to 5.69.1.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.68.0...v5.69.1)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.17.0 to 7.17.5.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.17.5/packages/babel-core)

      ```
      updated-dependencies:
      - dependency-name: "@babel/core"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.22.0 to 1.23.0.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.22.0...v1.23.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [tss-react](https://github.com/garronej/tss-react) from 3.3.6 to 3.4.2.
      - [Release notes](https://github.com/garronej/tss-react/releases)
      - [Changelog](https://github.com/garronej/tss-react/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/garronej/tss-react/compare/v3.3.6...v3.4.2)

      ```
      updated-dependencies:
      - dependency-name: tss-react
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps node from 17.5.0-alpine to 17.6.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.19.0 to 1.19.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.19.0...v1.19.2)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.19.0 to 1.19.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.19.0...v1.19.2)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/lab](https://github.com/mui/material-ui/tree/HEAD/packages/mui-lab) from 5.0.0-alpha.65 to 5.0.0-alpha.70.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/HEAD/packages/mui-lab)

      ```
      updated-dependencies:
      - dependency-name: "@mui/lab"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.19.1 to 1.19.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.19.1...v1.19.2)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.25.0 to 0.26.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.25.0...v0.26.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/icons-material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-icons-material) from 5.3.0 to 5.4.2.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.4.2/packages/mui-icons-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/icons-material"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@emotion/jest](https://github.com/emotion-js/emotion) from 11.7.1 to 11.8.0.
      - [Release notes](https://github.com/emotion-js/emotion/releases)
      - [Changelog](https://github.com/emotion-js/emotion/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/emotion-js/emotion/compare/@emotion/jest@11.7.1...@emotion/jest@11.8.0)

      ```
      updated-dependencies:
      - dependency-name: "@emotion/jest"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.9.0 to 8.10.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.9.0...v8.10.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/react](https://github.com/testing-library/react-testing-library) from 12.1.2 to 12.1.3.
      - [Release notes](https://github.com/testing-library/react-testing-library/releases)
      - [Changelog](https://github.com/testing-library/react-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/react-testing-library/compare/v12.1.2...v12.1.3)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/react"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@emotion/react](https://github.com/emotion-js/emotion) from 11.7.1 to 11.8.1.
      - [Release notes](https://github.com/emotion-js/emotion/releases)
      - [Changelog](https://github.com/emotion-js/emotion/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/emotion-js/emotion/compare/@emotion/react@11.7.1...@emotion/react@11.8.1)

      ```
      updated-dependencies:
      - dependency-name: "@emotion/react"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.4.6 to 8.4.7.
      - [Release notes](https://github.com/postcss/postcss/releases)
      - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/postcss/compare/8.4.6...8.4.7)

      ```
      updated-dependencies:
      - dependency-name: postcss
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [victory](https://github.com/formidablelabs/victory) from 36.2.1 to 36.3.0.
      - [Release notes](https://github.com/formidablelabs/victory/releases)
      - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/formidablelabs/victory/compare/v36.2.1...v36.3.0)

      ```
      updated-dependencies:
      - dependency-name: victory
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/styles](https://github.com/mui/material-ui/tree/HEAD/packages/mui-styles) from 5.3.0 to 5.4.4.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.4.4/packages/mui-styles)

      ```
      updated-dependencies:
      - dependency-name: "@mui/styles"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.28.0 to 7.29.2.
      - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
      - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.28.0...v7.29.2)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-react
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@emotion/styled](https://github.com/emotion-js/emotion) from 11.6.0 to 11.8.1.
      - [Release notes](https://github.com/emotion-js/emotion/releases)
      - [Changelog](https://github.com/emotion-js/emotion/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/emotion-js/emotion/compare/@emotion/styled@11.6.0...@emotion/styled@11.8.1)

      ```
      updated-dependencies:
      - dependency-name: "@emotion/styled"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@reduxjs/toolkit](https://github.com/reduxjs/redux-toolkit) from 1.7.2 to 1.8.0.
      - [Release notes](https://github.com/reduxjs/redux-toolkit/releases)
      - [Commits](https://github.com/reduxjs/redux-toolkit/compare/v1.7.2...v1.8.0)

      ```
      updated-dependencies:
      - dependency-name: "@reduxjs/toolkit"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-plugin-sonarjs](https://github.com/SonarSource/eslint-plugin-sonarjs) from 0.11.0 to 0.12.0.
      - [Release notes](https://github.com/SonarSource/eslint-plugin-sonarjs/releases)
      - [Commits](https://github.com/SonarSource/eslint-plugin-sonarjs/compare/0.11.0...0.12.0)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-sonarjs
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/icons-material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-icons-material) from 5.4.2 to 5.4.4.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.4.4/packages/mui-icons-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/icons-material"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.21.0 to 3.21.1.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.21.0...v3.21.1)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/lab](https://github.com/mui/material-ui/tree/HEAD/packages/mui-lab) from 5.0.0-alpha.70 to 5.0.0-alpha.71.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/HEAD/packages/mui-lab)

      ```
      updated-dependencies:
      - dependency-name: "@mui/lab"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [xterm](https://github.com/xtermjs/xterm.js) from 4.17.0 to 4.18.0.
      - [Release notes](https://github.com/xtermjs/xterm.js/releases)
      - [Commits](https://github.com/xtermjs/xterm.js/compare/4.17.0...4.18.0)

      ```
      updated-dependencies:
      - dependency-name: xterm
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-material) from 5.3.0 to 5.4.4.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.4.4/packages/mui-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/material"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [dayjs](https://github.com/iamkun/dayjs) from 1.10.7 to 1.10.8.
      - [Release notes](https://github.com/iamkun/dayjs/releases)
      - [Changelog](https://github.com/iamkun/dayjs/blob/v1.10.8/CHANGELOG.md)
      - [Commits](https://github.com/iamkun/dayjs/compare/v1.10.7...v1.10.8)

      ```
      updated-dependencies:
      - dependency-name: dayjs
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.5.5 to 4.6.2.
      - [Release notes](https://github.com/Microsoft/TypeScript/releases)
      - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.5.5...v4.6.2)

      ```
      updated-dependencies:
      - dependency-name: typescript
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.29.2 to 7.29.3.
      - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
      - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.29.2...v7.29.3)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-react
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.5.3 to 2.6.0.
      - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.5.3...v2.6.0)

      ```
      updated-dependencies:
      - dependency-name: mini-css-extract-plugin
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.69.1 to 5.70.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.69.1...v5.70.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.23.0 to 1.24.0.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.23.0...v1.24.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.4.7 to 8.4.8.
      - [Release notes](https://github.com/postcss/postcss/releases)
      - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/postcss/compare/8.4.7...8.4.8)

      ```
      updated-dependencies:
      - dependency-name: postcss
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [tss-react](https://github.com/garronej/tss-react) from 3.4.2 to 3.5.2.
      - [Release notes](https://github.com/garronej/tss-react/releases)
      - [Changelog](https://github.com/garronej/tss-react/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/garronej/tss-react/compare/v3.4.2...v3.5.2)

      ```
      updated-dependencies:
      - dependency-name: tss-react
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.3.4 to 12.3.5.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.3.4...v12.3.5)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 6.6.0 to 6.7.0.
      - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/css-loader/compare/v6.6.0...v6.7.0)

      ```
      updated-dependencies:
      - dependency-name: css-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.38.9 to 0.39.0.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.38.9...v0.39.0)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/styles](https://github.com/mui/material-ui/tree/HEAD/packages/mui-styles) from 5.4.4 to 5.5.0.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.5.0/packages/mui-styles)

      ```
      updated-dependencies:
      - dependency-name: "@mui/styles"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps node from 17.6.0-alpine to 17.7.1-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.26.0 to 0.26.1.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.26.0...v0.26.1)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/lab](https://github.com/mui/material-ui/tree/HEAD/packages/mui-lab) from 5.0.0-alpha.71 to 5.0.0-alpha.72.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/HEAD/packages/mui-lab)

      ```
      updated-dependencies:
      - dependency-name: "@mui/lab"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.10.0 to 8.11.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.10.0...v8.11.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 6.7.0 to 6.7.1.
      - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/css-loader/compare/v6.7.0...v6.7.1)

      ```
      updated-dependencies:
      - dependency-name: css-loader
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/icons-material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-icons-material) from 5.4.4 to 5.5.0.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.5.0/packages/mui-icons-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/icons-material"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@emotion/react](https://github.com/emotion-js/emotion) from 11.8.1 to 11.8.2.
      - [Release notes](https://github.com/emotion-js/emotion/releases)
      - [Changelog](https://github.com/emotion-js/emotion/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/emotion-js/emotion/compare/@emotion/react@11.8.1...@emotion/react@11.8.2)

      ```
      updated-dependencies:
      - dependency-name: "@emotion/react"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.26.0 to 0.26.1.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.26.0...v0.26.1)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.29.3 to 7.29.4.
      - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
      - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.29.3...v7.29.4)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-react
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.39.0 to 0.39.3.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.39.0...v0.39.3)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-material) from 5.4.4 to 5.5.0.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.5.0/packages/mui-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/material"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/react](https://github.com/testing-library/react-testing-library) from 12.1.3 to 12.1.4.
      - [Release notes](https://github.com/testing-library/react-testing-library/releases)
      - [Changelog](https://github.com/testing-library/react-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/react-testing-library/compare/v12.1.3...v12.1.4)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/react"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps node from 17.7.1-alpine to 17.7.2-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [dayjs](https://github.com/iamkun/dayjs) from 1.10.8 to 1.11.0.
      - [Release notes](https://github.com/iamkun/dayjs/releases)
      - [Changelog](https://github.com/iamkun/dayjs/blob/v1.11.0/CHANGELOG.md)
      - [Commits](https://github.com/iamkun/dayjs/compare/v1.10.8...v1.11.0)

      ```
      updated-dependencies:
      - dependency-name: dayjs
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [victory](https://github.com/formidablelabs/victory) from 36.3.0 to 36.3.1.
      - [Release notes](https://github.com/formidablelabs/victory/releases)
      - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/formidablelabs/victory/compare/v36.3.0...v36.3.1)

      ```
      updated-dependencies:
      - dependency-name: victory
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.19.2 to 1.20.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.19.2...v1.20.0)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.19.2 to 1.20.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.19.2...v1.20.0)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.4.2 to 10.4.4.
      - [Release notes](https://github.com/postcss/autoprefixer/releases)
      - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/autoprefixer/compare/10.4.2...10.4.4)

      ```
      updated-dependencies:
      - dependency-name: autoprefixer
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [prettier](https://github.com/prettier/prettier) from 2.5.1 to 2.6.0.
      - [Release notes](https://github.com/prettier/prettier/releases)
      - [Changelog](https://github.com/prettier/prettier/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/prettier/prettier/compare/2.5.1...2.6.0)

      ```
      updated-dependencies:
      - dependency-name: prettier
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.19.2 to 1.20.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.19.2...v1.20.0)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.4.8 to 8.4.12.
      - [Release notes](https://github.com/postcss/postcss/releases)
      - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/postcss/compare/8.4.8...8.4.12)

      ```
      updated-dependencies:
      - dependency-name: postcss
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/lab](https://github.com/mui/material-ui/tree/HEAD/packages/mui-lab) from 5.0.0-alpha.72 to 5.0.0-alpha.74.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/HEAD/packages/mui-lab)

      ```
      updated-dependencies:
      - dependency-name: "@mui/lab"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.3.5 to 12.3.7.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.3.5...v12.3.7)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/styles](https://github.com/mui/material-ui/tree/HEAD/packages/mui-styles) from 5.5.0 to 5.5.1.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.5.1/packages/mui-styles)

      ```
      updated-dependencies:
      - dependency-name: "@mui/styles"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [tss-react](https://github.com/garronej/tss-react) from 3.5.2 to 3.6.0.
      - [Release notes](https://github.com/garronej/tss-react/releases)
      - [Changelog](https://github.com/garronej/tss-react/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/garronej/tss-react/compare/v3.5.2...v3.6.0)

      ```
      updated-dependencies:
      - dependency-name: tss-react
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.17.5 to 7.17.8.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.17.8/packages/babel-core)

      ```
      updated-dependencies:
      - dependency-name: "@babel/core"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [yarn](https://github.com/yarnpkg/yarn) from 1.22.17 to 1.22.18.
      - [Release notes](https://github.com/yarnpkg/yarn/releases)
      - [Changelog](https://github.com/yarnpkg/yarn/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yarnpkg/yarn/compare/v1.22.17...v1.22.18)

      ```
      updated-dependencies:
      - dependency-name: yarn
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/icons-material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-icons-material) from 5.5.0 to 5.5.1.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.5.1/packages/mui-icons-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/icons-material"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-material) from 5.5.0 to 5.5.2.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.5.2/packages/mui-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/material"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.24.0 to 1.25.0.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.24.0...v1.25.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [minimist](https://github.com/substack/minimist) from 1.2.5 to 1.2.6.
      - [Release notes](https://github.com/substack/minimist/releases)
      - [Commits](https://github.com/substack/minimist/compare/1.2.5...1.2.6)

      ```
      updated-dependencies:
      - dependency-name: minimist
        dependency-type: indirect
      ```
  * Bumps node from 17.7.2-alpine to 17.8.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.6.2 to 4.6.3.
      - [Release notes](https://github.com/Microsoft/TypeScript/releases)
      - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.6.2...v4.6.3)

      ```
      updated-dependencies:
      - dependency-name: typescript
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.20.0 to 1.20.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.20.0...v1.20.1)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mdi/js](https://github.com/Templarian/MaterialDesign-JS) from 6.5.95 to 6.6.96.
      - [Release notes](https://github.com/Templarian/MaterialDesign-JS/releases)
      - [Commits](https://github.com/Templarian/MaterialDesign-JS/compare/v6.5.95...v6.6.96)

      ```
      updated-dependencies:
      - dependency-name: "@mdi/js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.11.0 to 8.12.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.11.0...v8.12.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.11.3 to 8.12.0.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.11.3...v8.12.0)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [prettier](https://github.com/prettier/prettier) from 2.6.0 to 2.6.1.
      - [Release notes](https://github.com/prettier/prettier/releases)
      - [Changelog](https://github.com/prettier/prettier/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/prettier/prettier/compare/2.6.0...2.6.1)

      ```
      updated-dependencies:
      - dependency-name: prettier
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.20.0 to 1.20.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.20.0...v1.20.1)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.39.3 to 0.40.0.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.39.3...v0.40.0)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.16.2 to 5.16.3.
      - [Release notes](https://github.com/testing-library/jest-dom/releases)
      - [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/jest-dom/compare/v5.16.2...v5.16.3)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/jest-dom"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.20.0 to 1.20.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.20.0...v1.20.1)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.20.1 to 1.20.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.20.1...v1.20.2)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.20.1 to 1.20.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.20.1...v1.20.2)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-material) from 5.5.2 to 5.5.3.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.5.3/packages/mui-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/material"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@monaco-editor/react](https://github.com/suren-atoyan/monaco-react) from 4.3.1 to 4.4.1.
      - [Release notes](https://github.com/suren-atoyan/monaco-react/releases)
      - [Changelog](https://github.com/suren-atoyan/monaco-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/suren-atoyan/monaco-react/compare/v4.3.1...v4.4.1)

      ```
      updated-dependencies:
      - dependency-name: "@monaco-editor/react"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.25.0 to 1.26.0.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.25.0...v1.26.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.20.1 to 1.20.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.20.1...v1.20.2)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/styles](https://github.com/mui/material-ui/tree/HEAD/packages/mui-styles) from 5.5.1 to 5.5.3.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.5.3/packages/mui-styles)

      ```
      updated-dependencies:
      - dependency-name: "@mui/styles"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@reduxjs/toolkit](https://github.com/reduxjs/redux-toolkit) from 1.8.0 to 1.8.1.
      - [Release notes](https://github.com/reduxjs/redux-toolkit/releases)
      - [Commits](https://github.com/reduxjs/redux-toolkit/compare/v1.8.0...1.8.1)

      ```
      updated-dependencies:
      - dependency-name: "@reduxjs/toolkit"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint-plugin-sonarjs](https://github.com/SonarSource/eslint-plugin-sonarjs) from 0.12.0 to 0.13.0.
      - [Release notes](https://github.com/SonarSource/eslint-plugin-sonarjs/releases)
      - [Commits](https://github.com/SonarSource/eslint-plugin-sonarjs/compare/0.12.0...0.13.0)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-sonarjs
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [prettier](https://github.com/prettier/prettier) from 2.6.1 to 2.6.2.
      - [Release notes](https://github.com/prettier/prettier/releases)
      - [Changelog](https://github.com/prettier/prettier/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/prettier/prettier/compare/2.6.1...2.6.2)

      ```
      updated-dependencies:
      - dependency-name: prettier
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [moment](https://github.com/moment/moment) from 2.29.1 to 2.29.2.
      - [Release notes](https://github.com/moment/moment/releases)
      - [Changelog](https://github.com/moment/moment/blob/develop/CHANGELOG.md)
      - [Commits](https://github.com/moment/moment/compare/2.29.1...2.29.2)

      ```
      updated-dependencies:
      - dependency-name: moment
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [react-redux](https://github.com/reduxjs/react-redux) from 7.2.6 to 7.2.8.
      - [Release notes](https://github.com/reduxjs/react-redux/releases)
      - [Changelog](https://github.com/reduxjs/react-redux/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/reduxjs/react-redux/compare/v7.2.6...v7.2.8)

      ```
      updated-dependencies:
      - dependency-name: react-redux
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.70.0 to 5.71.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.70.0...v5.71.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/lab](https://github.com/mui/material-ui/tree/HEAD/packages/mui-lab) from 5.0.0-alpha.74 to 5.0.0-alpha.75.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/HEAD/packages/mui-lab)

      ```
      updated-dependencies:
      - dependency-name: "@mui/lab"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@stripe/react-stripe-js](https://github.com/stripe/react-stripe-js) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/stripe/react-stripe-js/releases)
      - [Changelog](https://github.com/stripe/react-stripe-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/react-stripe-js/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/react-stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint-plugin-import](https://github.com/import-js/eslint-plugin-import) from 2.25.4 to 2.26.0.
      - [Release notes](https://github.com/import-js/eslint-plugin-import/releases)
      - [Changelog](https://github.com/import-js/eslint-plugin-import/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/import-js/eslint-plugin-import/compare/v2.25.4...v2.26.0)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-import
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/styles](https://github.com/mui/material-ui/tree/HEAD/packages/mui-styles) from 5.5.3 to 5.6.0.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.6.0/packages/mui-styles)

      ```
      updated-dependencies:
      - dependency-name: "@mui/styles"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/icons-material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-icons-material) from 5.5.1 to 5.6.0.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.6.0/packages/mui-icons-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/icons-material"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.17.8 to 7.17.9.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.17.9/packages/babel-core)

      ```
      updated-dependencies:
      - dependency-name: "@babel/core"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-material) from 5.5.3 to 5.6.1.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.6.1/packages/mui-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/material"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.12.0 to 8.13.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.12.0...v8.13.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.71.0 to 5.72.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.71.0...v5.72.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [tss-react](https://github.com/garronej/tss-react) from 3.6.0 to 3.6.1.
      - [Release notes](https://github.com/garronej/tss-react/releases)
      - [Changelog](https://github.com/garronej/tss-react/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/garronej/tss-react/compare/v3.6.0...v3.6.1)

      ```
      updated-dependencies:
      - dependency-name: tss-react
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/styles](https://github.com/mui/material-ui/tree/HEAD/packages/mui-styles) from 5.6.0 to 5.6.1.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.6.1/packages/mui-styles)

      ```
      updated-dependencies:
      - dependency-name: "@mui/styles"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.12.0 to 8.13.0.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.12.0...v8.13.0)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@emotion/react](https://github.com/emotion-js/emotion) from 11.8.2 to 11.9.0.
      - [Release notes](https://github.com/emotion-js/emotion/releases)
      - [Changelog](https://github.com/emotion-js/emotion/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/emotion-js/emotion/compare/@emotion/react@11.8.2...@emotion/react@11.9.0)

      ```
      updated-dependencies:
      - dependency-name: "@emotion/react"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/lab](https://github.com/mui/material-ui/tree/HEAD/packages/mui-lab) from 5.0.0-alpha.75 to 5.0.0-alpha.77.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/HEAD/packages/mui-lab)

      ```
      updated-dependencies:
      - dependency-name: "@mui/lab"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.26.0 to 1.27.0.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.26.0...v1.27.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@emotion/jest](https://github.com/emotion-js/emotion) from 11.8.0 to 11.9.1.
      - [Release notes](https://github.com/emotion-js/emotion/releases)
      - [Changelog](https://github.com/emotion-js/emotion/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/emotion-js/emotion/compare/@emotion/jest@11.8.0...@emotion/jest@11.9.1)

      ```
      updated-dependencies:
      - dependency-name: "@emotion/jest"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/icons-material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-icons-material) from 5.6.0 to 5.6.1.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.6.1/packages/mui-icons-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/icons-material"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.16.3 to 5.16.4.
      - [Release notes](https://github.com/testing-library/jest-dom/releases)
      - [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/jest-dom/compare/v5.16.3...v5.16.4)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/jest-dom"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [react-dropzone](https://github.com/react-dropzone/react-dropzone) from 11.7.1 to 12.0.5.
      - [Release notes](https://github.com/react-dropzone/react-dropzone/releases)
      - [Commits](https://github.com/react-dropzone/react-dropzone/compare/v11.7.1...v12.0.5)

      ```
      updated-dependencies:
      - dependency-name: react-dropzone
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [jest-junit](https://github.com/jest-community/jest-junit) from 13.0.0 to 13.1.0.
      - [Release notes](https://github.com/jest-community/jest-junit/releases)
      - [Commits](https://github.com/jest-community/jest-junit/compare/v13.0.0...v13.1.0)

      ```
      updated-dependencies:
      - dependency-name: jest-junit
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps node from 17.8.0-alpine to 17.9.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.20.2 to 1.21.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.20.2...v1.21.0)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [dayjs](https://github.com/iamkun/dayjs) from 1.11.0 to 1.11.1.
      - [Release notes](https://github.com/iamkun/dayjs/releases)
      - [Changelog](https://github.com/iamkun/dayjs/blob/dev/CHANGELOG.md)
      - [Commits](https://github.com/iamkun/dayjs/compare/v1.11.0...v1.11.1)

      ```
      updated-dependencies:
      - dependency-name: dayjs
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [msgpack5](https://github.com/mcollina/msgpack5) from 5.3.2 to 6.0.0.
      - [Release notes](https://github.com/mcollina/msgpack5/releases)
      - [Commits](https://github.com/mcollina/msgpack5/compare/v5.3.2...v6.0.0)

      ```
      updated-dependencies:
      - dependency-name: msgpack5
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [tss-react](https://github.com/garronej/tss-react) from 3.6.1 to 3.6.2.
      - [Release notes](https://github.com/garronej/tss-react/releases)
      - [Changelog](https://github.com/garronej/tss-react/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/garronej/tss-react/compare/v3.6.1...v3.6.2)

      ```
      updated-dependencies:
      - dependency-name: tss-react
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [victory](https://github.com/formidablelabs/victory) from 36.3.1 to 36.3.2.
      - [Release notes](https://github.com/formidablelabs/victory/releases)
      - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/formidablelabs/victory/compare/v36.3.1...v36.3.2)

      ```
      updated-dependencies:
      - dependency-name: victory
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.20.2 to 1.21.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.20.2...v1.21.1)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.20.2 to 1.21.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.20.2...v1.21.1)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/react](https://github.com/testing-library/react-testing-library) from 12.1.4 to 12.1.5.
      - [Release notes](https://github.com/testing-library/react-testing-library/releases)
      - [Changelog](https://github.com/testing-library/react-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/react-testing-library/compare/v12.1.4...v12.1.5)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/react"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@monaco-editor/react](https://github.com/suren-atoyan/monaco-react) from 4.4.1 to 4.4.2.
      - [Release notes](https://github.com/suren-atoyan/monaco-react/releases)
      - [Changelog](https://github.com/suren-atoyan/monaco-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/suren-atoyan/monaco-react/compare/v4.4.1...v4.4.2)

      ```
      updated-dependencies:
      - dependency-name: "@monaco-editor/react"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/icons-material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-icons-material) from 5.6.1 to 5.6.2.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.6.2/packages/mui-icons-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/icons-material"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.40.0 to 0.40.1.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.40.0...v0.40.1)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@stripe/react-stripe-js](https://github.com/stripe/react-stripe-js) from 1.7.1 to 1.7.2.
      - [Release notes](https://github.com/stripe/react-stripe-js/releases)
      - [Changelog](https://github.com/stripe/react-stripe-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/react-stripe-js/compare/v1.7.1...v1.7.2)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/react-stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/styles](https://github.com/mui/material-ui/tree/HEAD/packages/mui-styles) from 5.6.1 to 5.6.2.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.6.2/packages/mui-styles)

      ```
      updated-dependencies:
      - dependency-name: "@mui/styles"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [moment](https://github.com/moment/moment) from 2.29.2 to 2.29.3.
      - [Release notes](https://github.com/moment/moment/releases)
      - [Changelog](https://github.com/moment/moment/blob/2.29.3/CHANGELOG.md)
      - [Commits](https://github.com/moment/moment/compare/2.29.2...2.29.3)

      ```
      updated-dependencies:
      - dependency-name: moment
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@mui/lab](https://github.com/mui/material-ui/tree/HEAD/packages/mui-lab) from 5.0.0-alpha.77 to 5.0.0-alpha.78.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/HEAD/packages/mui-lab)

      ```
      updated-dependencies:
      - dependency-name: "@mui/lab"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [react-copy-to-clipboard](https://github.com/nkbt/react-copy-to-clipboard) from 5.0.4 to 5.1.0.
      - [Release notes](https://github.com/nkbt/react-copy-to-clipboard/releases)
      - [Commits](https://github.com/nkbt/react-copy-to-clipboard/compare/v5.0.4...v5.1.0)

      ```
      updated-dependencies:
      - dependency-name: react-copy-to-clipboard
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.3.7 to 12.3.8.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.3.7...v12.3.8)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.21.1 to 3.22.0.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.21.1...v3.22.0)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@mui/material](https://github.com/mui/material-ui/tree/HEAD/packages/mui-material) from 5.6.1 to 5.6.2.
      - [Release notes](https://github.com/mui/material-ui/releases)
      - [Changelog](https://github.com/mui/material-ui/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mui/material-ui/commits/v5.6.2/packages/mui-material)

      ```
      updated-dependencies:
      - dependency-name: "@mui/material"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [react-redux](https://github.com/reduxjs/react-redux) from 7.2.8 to 8.0.0.
      - [Release notes](https://github.com/reduxjs/react-redux/releases)
      - [Changelog](https://github.com/reduxjs/react-redux/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/reduxjs/react-redux/compare/v7.2.8...v8.0.0)

      ```
      updated-dependencies:
      - dependency-name: react-redux
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```

#### integration (3.3.0)

New changes in integration since 3.2.2:

##### Bug fixes

* wrong path for the useradm private key in the prod yaml templates
  ([MEN-5641](https://northerntech.atlassian.net/browse/MEN-5641))

##### Features

* make use of the S3 external URI configuration for deployments
  ([MEN-5280](https://northerntech.atlassian.net/browse/MEN-5280))

##### Other

* Upgrade auditlogs to 3.0.1.
* Upgrade create-artifact-worker to 1.1.2.
* Upgrade deployments-enterprise to 4.2.0.
* Upgrade deployments to 4.2.0.
* Upgrade deviceauth-enterprise to 3.2.1.
* Upgrade deviceauth to 3.2.1.
* Upgrade deviceconfig to 1.2.1.
* Upgrade deviceconnect to 1.3.2.
* Upgrade devicemonitor to 1.2.0.
* Upgrade gui to 3.3.0.
* Upgrade integration to 3.3.0.
* Upgrade inventory-enterprise to 4.2.0.
* Upgrade inventory to 4.2.0.
* Upgrade iot-manager to 1.0.2.
* Upgrade mender-artifact to 3.8.0.
* Upgrade mender-binary-delta to 1.3.1.
* Upgrade mender-cli to 1.8.0.
* Upgrade mender-configure-module to 1.0.4.
* Upgrade mender-connect to 2.0.2.
* Upgrade mender-convert to 3.0.0.
* Add mender-gateway 1.0.0.
* Upgrade mender to 3.3.0.
* Upgrade monitor-client to 1.2.0.
* Upgrade mtls-ambassador to 1.0.2.
* Upgrade tenantadm to 3.4.0.
* Upgrade useradm-enterprise to 1.18.0.
* Upgrade useradm to 1.18.0.
* Upgrade workflows-enterprise to 2.2.1.
* Upgrade workflows to 2.2.1.

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [pyparsing](https://github.com/pyparsing/pyparsing) from 3.0.6 to 3.0.7.
      - [Release notes](https://github.com/pyparsing/pyparsing/releases)
      - [Changelog](https://github.com/pyparsing/pyparsing/blob/master/CHANGES)
      - [Commits](https://github.com/pyparsing/pyparsing/compare/pyparsing_3.0.6...pyparsing_3.0.7)

      ```
      updated-dependencies:
      - dependency-name: pyparsing
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.64.0 to 2.65.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.64.0...v2.65.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest-timeout](https://github.com/pytest-dev/pytest-timeout) from 2.0.2 to 2.1.0.
      - [Release notes](https://github.com/pytest-dev/pytest-timeout/releases)
      - [Commits](https://github.com/pytest-dev/pytest-timeout/compare/2.0.2...2.1.0)

      ```
      updated-dependencies:
      - dependency-name: pytest-timeout
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [ordered-set](https://github.com/rspeer/ordered-set) from 4.0.2 to 4.1.0.
      - [Release notes](https://github.com/rspeer/ordered-set/releases)
      - [Changelog](https://github.com/rspeer/ordered-set/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/rspeer/ordered-set/compare/release/4.0.2...release/4.1.0)

      ```
      updated-dependencies:
      - dependency-name: ordered-set
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.2.5 to 7.0.0.
      - [Release notes](https://github.com/pytest-dev/pytest/releases)
      - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest/compare/6.2.5...7.0.0)

      ```
      updated-dependencies:
      - dependency-name: pytest
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 7.0.0 to 7.0.1.
      - [Release notes](https://github.com/pytest-dev/pytest/releases)
      - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest/compare/7.0.0...7.0.1)

      ```
      updated-dependencies:
      - dependency-name: pytest
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pathlib2](https://github.com/jazzband/pathlib2) from 2.3.6 to 2.3.7.post1.
      - [Release notes](https://github.com/jazzband/pathlib2/releases)
      - [Changelog](https://github.com/jazzband/pathlib2/blob/develop/CHANGELOG.rst)
      - [Commits](https://github.com/jazzband/pathlib2/compare/2.3.6...2.3.7-post1)

      ```
      updated-dependencies:
      - dependency-name: pathlib2
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.4.2 to 3.6.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.4.2...3.6.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [websockets](https://github.com/aaugustin/websockets) from 10.1 to 10.2.
      - [Release notes](https://github.com/aaugustin/websockets/releases)
      - [Commits](https://github.com/aaugustin/websockets/compare/10.1...10.2)

      ```
      updated-dependencies:
      - dependency-name: websockets
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.65.0 to 2.66.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.65.0...v2.66.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [distro](https://github.com/python-distro/distro) from 1.6.0 to 1.7.0.
      - [Release notes](https://github.com/python-distro/distro/releases)
      - [Changelog](https://github.com/python-distro/distro/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/python-distro/distro/compare/v1.6.0...v1.7.0)

      ```
      updated-dependencies:
      - dependency-name: distro
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 4.0.1 to 4.0.2.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/4.0.2/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/4.0.1...4.0.2)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.66.0 to 2.67.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.66.0...v2.67.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.9.2 to 2.10.1.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.9.2...2.10.1)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 7.0.1 to 7.1.0.
      - [Release notes](https://github.com/pytest-dev/pytest/releases)
      - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest/compare/7.0.1...7.1.0)

      ```
      updated-dependencies:
      - dependency-name: pytest
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.10.1 to 2.10.2.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.10.1...2.10.2)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### inventory (4.2.0)

New changes in inventory since 4.1.0:

##### Features

* enhance the filtering API to support device full-text search
  ([MEN-5527](https://northerntech.atlassian.net/browse/MEN-5527))
* add database migration to reindex the devices for the full-text search
  ([MEN-5527](https://northerntech.atlassian.net/browse/MEN-5527))

##### Other

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5492](https://northerntech.atlassian.net/browse/MEN-5492))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.9.0 to 1.10.1.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.9.0...v1.10.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### inventory-enterprise (4.2.0)

New changes in inventory-enterprise since 4.1.0:

##### Features

* enhance the filtering API to support device full-text search
  ([MEN-5527](https://northerntech.atlassian.net/browse/MEN-5527))
* add database migration to reindex the devices for the full-text search
  ([MEN-5527](https://northerntech.atlassian.net/browse/MEN-5527))

##### Other

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5492](https://northerntech.atlassian.net/browse/MEN-5492))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.9.0 to 1.10.1.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.9.0...v1.10.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.2.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.2)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.9.0 to 1.10.1.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.9.0...v1.10.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### mtls-ambassador (1.0.2)

New changes in mtls-ambassador since 1.0.1:

##### Bug fixes

* replace host header when proxying requests
  ([MEN-5495](https://northerntech.atlassian.net/browse/MEN-5495))

#### tenantadm (3.4.0)

New changes in tenantadm since 3.3.0:

##### Bug fixes

* Implement enable_sign_up setting which restricts access to create organization functionalities

##### Other

* Upgrade from deprecated `golang.org/x/crypto/ssh/terminal` to
  `golang.org/x/term`
  ([QA-235](https://northerntech.atlassian.net/browse/QA-235))
* migrate to community maintained jwt package
  ([MEN-5469](https://northerntech.atlassian.net/browse/MEN-5469))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.0 to 3.14.2.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.8.1 to 1.9.0.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.8.1...v1.9.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.9.0 to 1.10.1.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.9.0...v1.10.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### useradm (1.18.0)

New changes in useradm since 1.17.0:

* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5470](https://northerntech.atlassian.net/browse/MEN-5470))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### useradm-enterprise (1.18.0)

New changes in useradm-enterprise since 1.17.0:

##### Bug fixes

* extend the RBAC roles to support iot-manager
  ([MEN-5386](https://northerntech.atlassian.net/browse/MEN-5386))
* make it impossible to update user with empty list of roles
  ([MEN-5613](https://northerntech.atlassian.net/browse/MEN-5613))
* extend basic permissions with access to permission_set definitions
* extend read releases permission with access to statistics/list

##### Features

* introduce limits in user and roles creation
  ([MEN-5546](https://northerntech.atlassian.net/browse/MEN-5546))
* update endpoing for getting list of emails with access to given device
  ([MEN-5274](https://northerntech.atlassian.net/browse/MEN-5274))

##### Other

* docs: second version of the API for managing roles and permission sets
* model/rbac: introduce permission sets; change role definition
* store/mongo: methods for managing permission sets (CRUD)
* user: methods for managing roles and permission sets
* user: new roles handling
* store/mongo: migrate roles
* RBAC: pagination support for GET /roles endpoint
* upgrade mendersoftware/go-lib-micro to the latest
  ([MEN-5470](https://northerntech.atlassian.net/browse/MEN-5470))

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.2.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.2)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/lestrrat-go/jwx](https://github.com/lestrrat-go/jwx) from 1.2.7 to 1.2.18.
      - [Release notes](https://github.com/lestrrat-go/jwx/releases)
      - [Changelog](https://github.com/lestrrat-go/jwx/blob/main/Changes)
      - [Commits](https://github.com/lestrrat-go/jwx/compare/v1.2.7...v1.2.18)

      ```
      updated-dependencies:
      - dependency-name: github.com/lestrrat-go/jwx
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.4 to 1.8.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.4...v1.8.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### integration (3.3.0)

New changes in integration since 3.2.2:

##### Bug fixes

* wrong path for the useradm private key in the prod yaml templates
  ([MEN-5641](https://northerntech.atlassian.net/browse/MEN-5641))

##### Features

* make use of the S3 external URI configuration for deployments
  ([MEN-5280](https://northerntech.atlassian.net/browse/MEN-5280))

##### Other

* Upgrade auditlogs to 3.0.1.
* Upgrade create-artifact-worker to 1.1.2.
* Upgrade deployments-enterprise to 4.2.0.
* Upgrade deployments to 4.2.0.
* Upgrade deviceauth-enterprise to 3.2.1.
* Upgrade deviceauth to 3.2.1.
* Upgrade deviceconfig to 1.2.1.
* Upgrade deviceconnect to 1.3.2.
* Upgrade devicemonitor to 1.2.0.
* Upgrade gui to 3.3.0.
* Upgrade integration to 3.3.0.
* Upgrade inventory-enterprise to 4.2.0.
* Upgrade inventory to 4.2.0.
* Upgrade iot-manager to 1.0.2.
* Upgrade mender-artifact to 3.8.0.
* Upgrade mender-binary-delta to 1.3.1.
* Upgrade mender-cli to 1.8.0.
* Upgrade mender-configure-module to 1.0.4.
* Upgrade mender-connect to 2.0.2.
* Upgrade mender-convert to 3.0.0.
* Add mender-gateway 1.0.0.
* Upgrade mender to 3.3.0.
* Upgrade monitor-client to 1.2.0.
* Upgrade mtls-ambassador to 1.0.2.
* Upgrade tenantadm to 3.4.0.
* Upgrade useradm-enterprise to 1.18.0.
* Upgrade useradm to 1.18.0.
* Upgrade workflows-enterprise to 2.2.1.
* Upgrade workflows to 2.2.1.

##### Dependabot bumps

* Aggregated Dependabot Changelogs:
  * Bumps [pyparsing](https://github.com/pyparsing/pyparsing) from 3.0.6 to 3.0.7.
      - [Release notes](https://github.com/pyparsing/pyparsing/releases)
      - [Changelog](https://github.com/pyparsing/pyparsing/blob/master/CHANGES)
      - [Commits](https://github.com/pyparsing/pyparsing/compare/pyparsing_3.0.6...pyparsing_3.0.7)

      ```
      updated-dependencies:
      - dependency-name: pyparsing
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.64.0 to 2.65.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.64.0...v2.65.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest-timeout](https://github.com/pytest-dev/pytest-timeout) from 2.0.2 to 2.1.0.
      - [Release notes](https://github.com/pytest-dev/pytest-timeout/releases)
      - [Commits](https://github.com/pytest-dev/pytest-timeout/compare/2.0.2...2.1.0)

      ```
      updated-dependencies:
      - dependency-name: pytest-timeout
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [ordered-set](https://github.com/rspeer/ordered-set) from 4.0.2 to 4.1.0.
      - [Release notes](https://github.com/rspeer/ordered-set/releases)
      - [Changelog](https://github.com/rspeer/ordered-set/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/rspeer/ordered-set/compare/release/4.0.2...release/4.1.0)

      ```
      updated-dependencies:
      - dependency-name: ordered-set
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.2.5 to 7.0.0.
      - [Release notes](https://github.com/pytest-dev/pytest/releases)
      - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest/compare/6.2.5...7.0.0)

      ```
      updated-dependencies:
      - dependency-name: pytest
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 7.0.0 to 7.0.1.
      - [Release notes](https://github.com/pytest-dev/pytest/releases)
      - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest/compare/7.0.0...7.0.1)

      ```
      updated-dependencies:
      - dependency-name: pytest
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pathlib2](https://github.com/jazzband/pathlib2) from 2.3.6 to 2.3.7.post1.
      - [Release notes](https://github.com/jazzband/pathlib2/releases)
      - [Changelog](https://github.com/jazzband/pathlib2/blob/develop/CHANGELOG.rst)
      - [Commits](https://github.com/jazzband/pathlib2/compare/2.3.6...2.3.7-post1)

      ```
      updated-dependencies:
      - dependency-name: pathlib2
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.4.2 to 3.6.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.4.2...3.6.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [websockets](https://github.com/aaugustin/websockets) from 10.1 to 10.2.
      - [Release notes](https://github.com/aaugustin/websockets/releases)
      - [Commits](https://github.com/aaugustin/websockets/compare/10.1...10.2)

      ```
      updated-dependencies:
      - dependency-name: websockets
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.65.0 to 2.66.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.65.0...v2.66.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [distro](https://github.com/python-distro/distro) from 1.6.0 to 1.7.0.
      - [Release notes](https://github.com/python-distro/distro/releases)
      - [Changelog](https://github.com/python-distro/distro/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/python-distro/distro/compare/v1.6.0...v1.7.0)

      ```
      updated-dependencies:
      - dependency-name: distro
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 4.0.1 to 4.0.2.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/4.0.2/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/4.0.1...4.0.2)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.66.0 to 2.67.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.66.0...v2.67.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.9.2 to 2.10.1.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.9.2...2.10.1)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 7.0.1 to 7.1.0.
      - [Release notes](https://github.com/pytest-dev/pytest/releases)
      - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest/compare/7.0.1...7.1.0)

      ```
      updated-dependencies:
      - dependency-name: pytest
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.10.1 to 2.10.2.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.10.1...2.10.2)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```


## Mender 3.2.2

_Released 04.21.2022_

### Security fixes

* Fixed CVE-2022-29555 - Cross-Origin WebSocket Hijacking in Mender deviceconnect.
  See the official announcement for more information:
  [mender.io/blog/cve-2022-29555-and-cve-2022-29556-vulnerabilities-in-iot-manager-and-deviceconnect](https://mender.io/blog/cve-2022-29555-and-cve-2022-29556-vulnerabilities-in-iot-manager-and-deviceconnect)
* Fixed CVE-2022-29556 - Server Side Request Forgery in Azure IoT Hub integration
  See the official announcement for more information:
  [mender.io/blog/cve-2022-29555-and-cve-2022-29556-vulnerabilities-in-iot-manager-and-deviceconnect](https://mender.io/blog/cve-2022-29555-and-cve-2022-29556-vulnerabilities-in-iot-manager-and-deviceconnect)

### Statistics

A total of 803 lines added, 358 removed (delta 445)

| Developers with the most changesets | |
|---|---|
| Kristian Amlie | 19 (65.5%) |
| Alf-Rune Siqveland | 6 (20.7%) |
| Lluis Campos | 4 (13.8%) |

| Developers with the most changed lines | |
|---|---|
| Kristian Amlie | 430 (48.8%) |
| Alf-Rune Siqveland | 303 (34.4%) |
| Lluis Campos | 148 (16.8%) |

| Developers with the most lines removed | |
|---|---|
| Lluis Campos | 52 (14.5%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 29 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 881 (100.0%) |

| Employers with the most hackers (total 3) | |
|---|---|
| Northern.tech | 3 (100.0%) |

### Changelogs

#### create-artifact-worker (1.1.1)

New changes in create-artifact-worker since 1.1.0:

* Switch to stable components in create-artifact-worker 1.1.x.

#### deviceconnect (1.3.1)

New changes in deviceconnect since 1.3.0:

* fix(security): Add cross-site origin checks for websocket endpoint ([CVE-2022-29555](https://mender.io/blog/cve-2022-29555-and-cve-2022-29556-vulnerabilities-in-iot-manager-and-deviceconnect))

#### integration (3.2.2)

New changes in integration since 3.2.1:

* Upgrade create-artifact-worker to 1.1.1.
* Upgrade deviceconnect to 1.3.1.
* Upgrade integration to 3.2.2.
* Upgrade iot-manager to 1.0.1.
* Upgrade mender-artifact to 3.7.1.

#### iot-manager (1.0.1)

New changes in iot-manager since 1.0.0:

* fix: Add domain whitelist configuration for authorizing external domains
* fix: Do not follow redirects serving integration hooks ([CVE-2022-29556](https://mender.io/blog/cve-2022-29555-and-cve-2022-29556-vulnerabilities-in-iot-manager-and-deviceconnect))

#### integration (3.2.2)

New changes in integration since 3.2.1:

* Upgrade create-artifact-worker to 1.1.1.
* Upgrade deviceconnect to 1.3.1.
* Upgrade integration to 3.2.2.
* Upgrade iot-manager to 1.0.1.
* Upgrade mender-artifact to 3.7.1.


## Mender 3.2.1

_Released 02.02.2022_

### Statistics

A total of 530 lines added, 162 removed (delta 368)

| Developers with the most changesets | |
|---|---|
| Ole Petter Orhagen | 10 (62.5%) |
| Kristian Amlie | 4 (25.0%) |
| Lluis Campos | 2 (12.5%) |

| Developers with the most changed lines | |
|---|---|
| Ole Petter Orhagen | 386 (71.0%) |
| Kristian Amlie | 120 (22.1%) |
| Lluis Campos | 38 (7.0%) |

| Developers with the most lines removed | |
|---|---|
| Lluis Campos | 14 (8.6%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 16 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 544 (100.0%) |

| Employers with the most hackers (total 3) | |
|---|---|
| Northern.tech | 3 (100.0%) |

### Changelogs

#### integration (3.2.1)

New changes in integration since 3.2.0:

* Upgrade integration to 3.2.1.
* Upgrade mender-connect to 2.0.1.
* Upgrade mender-convert to 2.6.2.
* Upgrade mender to 3.2.1.

## Mender 3.2.0

_Released 01.24.2022_

### Statistics

A total of 77976 lines added, 32213 removed (delta 45763)

| Developers with the most changesets | |
|---|---|
| Fabio Tranchitella | 193 (21.0%) |
| Manuel Zedel | 180 (19.6%) |
| Alf-Rune Siqveland | 148 (16.1%) |
| Lluis Campos | 105 (11.4%) |
| Kristian Amlie | 101 (11.0%) |
| Maciej Tomczuk | 56 (6.1%) |
| Peter Grzybowski | 54 (5.9%) |
| Ole Petter Orhagen | 52 (5.7%) |
| Krzysztof Jaskiewicz | 16 (1.7%) |
| Marcin Chalczynski | 10 (1.1%) |

| Developers with the most changed lines | |
|---|---|
| Alf-Rune Siqveland | 20360 (24.1%) |
| Kristian Amlie | 18209 (21.5%) |
| Fabio Tranchitella | 15243 (18.0%) |
| Peter Grzybowski | 8286 (9.8%) |
| Manuel Zedel | 7620 (9.0%) |
| Maciej Tomczuk | 7536 (8.9%) |
| Lluis Campos | 5304 (6.3%) |
| Ole Petter Orhagen | 861 (1.0%) |
| Marcin Chalczynski | 566 (0.7%) |
| Krzysztof Jaskiewicz | 551 (0.7%) |

| Developers with the most signoffs (total 5) | |
|---|---|
| Ole Petter Orhagen | 2 (40.0%) |
| Lluis Campos | 2 (40.0%) |
| Alf-Rune Siqveland | 1 (20.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 893 (97.1%) |
| RnDity | 26 (2.8%) |
| Sentinel.tech | 1 (0.1%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 83478 (98.7%) |
| RnDity | 1117 (1.3%) |
| Sentinel.tech | 14 (0.0%) |

| Employers with the most signoffs (total 5) | |
|---|---|
| Northern.tech | 5 (100.0%) |

| Employers with the most hackers (total 12) | |
|---|---|
| Northern.tech | 9 (75.0%) |
| RnDity | 2 (16.7%) |
| Sentinel.tech | 1 (8.3%) |

### Changelogs

#### auditlogs (3.0.0)

New changes in auditlogs since 2.0.0:

* Move the service to one database for all tenants
  ([MEN-4743](https://northerntech.atlassian.net/browse/MEN-4743))
* Remove the internal end-point for provisioning tenants
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.2 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.2...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### create-artifact-worker (1.1.0)

New changes in create-artifact-worker since 1.0.2:

* increase download and upload time-outs to 15 minutes
  ([MEN-3539](https://northerntech.atlassian.net/browse/MEN-3539))
* handle multiple device types as comma-separated values
  ([MEN-3771](https://northerntech.atlassian.net/browse/MEN-3771))
* bugfix to allow spaces in artifact names
  ([MEN-4179](https://northerntech.atlassian.net/browse/MEN-4179))
* upgrade mender-artifact to version 3.5.0.
  This enables the create-artifact-worker to generate artifacts that
  implement the provides and clear provides fields.
  ([MEN-4409](https://northerntech.atlassian.net/browse/MEN-4409))
* Rebuild to upgrade to the latest back-incompatible workflows
* Enhance the nats client, add logging for reconnection events
  ([MEN-5289](https://northerntech.atlassian.net/browse/MEN-5289))
* Aggregated Dependabot Changelogs:
  * Bumps [github.com/spf13/cobra](https://github.com/spf13/cobra) from 1.0.0 to 1.1.1.
      - [Release notes](https://github.com/spf13/cobra/releases)
      - [Changelog](https://github.com/spf13/cobra/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/spf13/cobra/compare/v1.0.0...v1.1.1)
  * Bumps [github.com/spf13/cobra](https://github.com/spf13/cobra) from 1.1.1 to 1.1.3.
      - [Release notes](https://github.com/spf13/cobra/releases)
      - [Changelog](https://github.com/spf13/cobra/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/spf13/cobra/compare/v1.1.1...v1.1.3)
  * Bumps golang from 1.14-alpine3.12 to 1.16.2-alpine3.12.
  * Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
      - [Release notes](https://github.com/stretchr/testify/releases)
      - [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.5-alpine3.12.

      ```
      updated-dependencies:
      - dependency-name: golang
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.7.1 to 1.8.0.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.7.1...v1.8.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.8.0 to 1.8.1.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.8.0...v1.8.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/spf13/cobra](https://github.com/spf13/cobra) from 1.1.3 to 1.2.1.
      - [Release notes](https://github.com/spf13/cobra/releases)
      - [Changelog](https://github.com/spf13/cobra/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/spf13/cobra/compare/v1.1.3...v1.2.1)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/cobra
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### deployments (4.1.0)

New changes in deployments since 4.0.0:

* deprecate `/deployments/releases` and `/artifacts` end-points
  ([MEN-5170](https://northerntech.atlassian.net/browse/MEN-5170))
* implement end-points to get a paginated list of releases and artifacts
  ([MEN-5170](https://northerntech.atlassian.net/browse/MEN-5170))
* add filtering of releases and artifacts by device type
  ([MEN-5170](https://northerntech.atlassian.net/browse/MEN-5170))
* fix single device deployment handling
* Fix bucket initialization
* add back /deployments/devices/{id} end-point to management
  ([MEN-5259](https://northerntech.atlassian.net/browse/MEN-5259))
* Add configuration option for the maximum artifact size
  ([MEN-4184](https://northerntech.atlassian.net/browse/MEN-4184))
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.2 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.2...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.40.37 to 1.40.59.
      - [Release notes](https://github.com/aws/aws-sdk-go/releases)
      - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.40.37...v1.40.59)

      ```
      updated-dependencies:
      - dependency-name: github.com/aws/aws-sdk-go
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### deployments-enterprise (4.1.0)

New changes in deployments-enterprise since 4.0.0:

* deprecate `/deployments/releases` and `/artifacts` end-points
  ([MEN-5170](https://northerntech.atlassian.net/browse/MEN-5170))
* implement end-points to get a paginated list of releases and artifacts
  ([MEN-5170](https://northerntech.atlassian.net/browse/MEN-5170))
* add filtering of releases and artifacts by device type
  ([MEN-5170](https://northerntech.atlassian.net/browse/MEN-5170))
* fix single device deployment handling
* Fix bucket initialization
* add back /deployments/devices/{id} end-point to management
  ([MEN-5259](https://northerntech.atlassian.net/browse/MEN-5259))
* Add configuration option for the maximum artifact size
  ([MEN-4184](https://northerntech.atlassian.net/browse/MEN-4184))
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.2 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.2...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.40.37 to 1.40.59.
      - [Release notes](https://github.com/aws/aws-sdk-go/releases)
      - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.40.37...v1.40.59)

      ```
      updated-dependencies:
      - dependency-name: github.com/aws/aws-sdk-go
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### deviceauth (3.2.0)

New changes in deviceauth since 3.1.0:

* do not hard-code the email sender, rely on workflows' default
  ([MEN-5124](https://northerntech.atlassian.net/browse/MEN-5124))
* [] Provision and accept device from external provider
  ([MEN-5148](https://northerntech.atlassian.net/browse/MEN-5148))
* add (optional) support for triggering reporting reindex
  ([MEN-4843](https://northerntech.atlassian.net/browse/MEN-4843))
* extend the internal end-point for searching devices to allow filtering by device IDs
  ([MEN-4843](https://northerntech.atlassian.net/browse/MEN-4843))
* Unused settings cleanup: SettingDevAdmAddr
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.0 to 3.14.2.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.2 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.2...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.11.0 to 8.11.4.
      - [Release notes](https://github.com/go-redis/redis/releases)
      - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/go-redis/redis/compare/v8.11.0...v8.11.4)

      ```
      updated-dependencies:
      - dependency-name: github.com/go-redis/redis/v8
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.7.4.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### deviceauth-enterprise (3.2.0)

_Released 20.01.2022_

#### deviceconfig (1.2.0)

New changes in deviceconfig since 1.1.0:

* Move to single db: go.mod, go.sum, vendor, LIC_FILES
  ([MEN-4746](https://northerntech.atlassian.net/browse/MEN-4746))
* Move to single db.
  ([MEN-4746](https://northerntech.atlassian.net/browse/MEN-4746))
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.7.2.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.7.2)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps alpine from 3.14.0 to 3.14.2.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.2 to 1.7.4.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.2...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.2.0 to 1.3.0.
      - [Release notes](https://github.com/google/uuid/releases)
      - [Commits](https://github.com/google/uuid/compare/v1.2.0...v1.3.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/google/uuid
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.2 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.2...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.7.4.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### deviceconnect (1.3.0)

New changes in deviceconnect since 1.2.1:

* store the correct offset in the recordings control messages
  ([MEN-4770](https://northerntech.atlassian.net/browse/MEN-4770))
* Move to single db.
  ([MEN-4747](https://northerntech.atlassian.net/browse/MEN-4747))
* Move to single db: go.mod, go.sum, vendor, LIC_FILES
  ([MEN-4747](https://northerntech.atlassian.net/browse/MEN-4747))
* Enhance the nats client, add logging for reconnection events
* Remove the internal end-point for provisioning tenants
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.6.0.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.6.0)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/nats-io/nats-server/v2](https://github.com/nats-io/nats-server) from 2.1.9 to 2.3.4.
      - [Release notes](https://github.com/nats-io/nats-server/releases)
      - [Changelog](https://github.com/nats-io/nats-server/blob/main/.goreleaser.yml)
      - [Commits](https://github.com/nats-io/nats-server/compare/v2.1.9...v2.3.4)

      ```
      updated-dependencies:
      - dependency-name: github.com/nats-io/nats-server/v2
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.6.0 to 1.7.2.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.6.0...v1.7.2)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/nats-io/nats-server/v2](https://github.com/nats-io/nats-server) from 2.3.4 to 2.4.0.
      - [Release notes](https://github.com/nats-io/nats-server/releases)
      - [Changelog](https://github.com/nats-io/nats-server/blob/main/.goreleaser.yml)
      - [Commits](https://github.com/nats-io/nats-server/compare/v2.3.4...v2.4.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/nats-io/nats-server/v2
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps alpine from 3.14.0 to 3.14.2.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.2 to 1.7.4.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.2...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.2.0 to 1.3.0.
      - [Release notes](https://github.com/google/uuid/releases)
      - [Commits](https://github.com/google/uuid/compare/v1.2.0...v1.3.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/google/uuid
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/nats-io/nats.go](https://github.com/nats-io/nats.go) from 1.12.0 to 1.13.0.
      - [Release notes](https://github.com/nats-io/nats.go/releases)
      - [Commits](https://github.com/nats-io/nats.go/compare/v1.12.0...v1.13.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/nats-io/nats.go
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.2 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.2...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/vmihailenco/msgpack/v5](https://github.com/vmihailenco/msgpack) from 5.3.4 to 5.3.5.
      - [Release notes](https://github.com/vmihailenco/msgpack/releases)
      - [Changelog](https://github.com/vmihailenco/msgpack/blob/v5/CHANGELOG.md)
      - [Commits](https://github.com/vmihailenco/msgpack/compare/v5.3.4...v5.3.5)

      ```
      updated-dependencies:
      - dependency-name: github.com/vmihailenco/msgpack/v5
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### devicemonitor (1.1.0)

New changes in devicemonitor since 1.0.0:

* do not hard-code the email sender, rely on workflows' default
  ([MEN-5124](https://northerntech.atlassian.net/browse/MEN-5124))
* add (optional) support for triggering reporting reindex
  ([MEN-4843](https://northerntech.atlassian.net/browse/MEN-4843))
* Store and retrieve device monitor configuration
  ([MEN-5184](https://northerntech.atlassian.net/browse/MEN-5184))
* [] Allow alerts to contain empty log lines
  ([MEN-5256](https://northerntech.atlassian.net/browse/MEN-5256))
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.0 to 3.14.2.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.2.0 to 1.3.0.
      - [Release notes](https://github.com/google/uuid/releases)
      - [Commits](https://github.com/google/uuid/compare/v1.2.0...v1.3.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/google/uuid
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.2 to 1.7.4.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.2...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### gui (3.2.0)

New changes in gui since 3.1.0:

* fixed an issue that prevented getting to devices based on their software in the overall device distribution
* fixed an issue that prevented filter selections from being persisted
* fixed an issue that prevented changes in monitoring issues from being reflected in the devicelist
  ([MEN-5113](https://northerntech.atlassian.net/browse/MEN-5113))
* fixed an issue that caused artifact downloads to only be available for a short time
* fixed an issue that could prevent newly uploaded releases to be available for deployment
* fixed an issue that prevented the 2fa qr code to show on email verification
* added device offline tag to device list to ease finding offline devices
* xtermjs interprets string as UTF-16
  ([MEN-4771](https://northerntech.atlassian.net/browse/MEN-4771))
* made offline devices filtering available in the device list for all professional and up users
* fixed an issue that could prevent creating phased deployments for dynamic groups
* improved static group removal to better support larger groups
* fixed an issue that prevented users from creating custom artifacts during onboarding
* refactored releases list to rely on release search backend
* made release selection on deployment creation use new release search backend to improve support of large numbers of releases
* fixed an issue that caused the release selection to crash when deploying to a single device
* Bump react and react-dom

  Bumps [react](https://github.com/facebook/react/tree/HEAD/packages/react) and [react-dom](https://github.com/facebook/react/tree/HEAD/packages/react-dom). These dependencies needed to be updated together.

  Updates `react` from 16.14.0 to 17.0.2
  - [Release notes](https://github.com/facebook/react/releases)
  - [Changelog](https://github.com/facebook/react/blob/main/CHANGELOG.md)
  - [Commits](https://github.com/facebook/react/commits/v17.0.2/packages/react)

  Updates `react-dom` from 16.14.0 to 17.0.2
  - [Release notes](https://github.com/facebook/react/releases)
  - [Changelog](https://github.com/facebook/react/blob/main/CHANGELOG.md)
  - [Commits](https://github.com/facebook/react/commits/v17.0.2/packages/react-dom)

  ```
  updated-dependencies:
  - dependency-name: react
    dependency-type: direct:production
    update-type: version-update:semver-major
  - dependency-name: react-dom
    dependency-type: direct:production
    update-type: version-update:semver-major
  ```
* Merge pull request #2261 from mendersoftware/dependabot/npm_and_yarn/react-and-react-dom-17.0.2

  Bump react and react-dom
* Restore support for Open Source Production setups in bash
  snippets used during on-boarding and on "Connect a Device" dialog.
  ([MEN-5107](https://northerntech.atlassian.net/browse/MEN-5107))
* fixed an issue that allowed proceeding with deployment creation without selecting a target device or group
* added scope information in filter selection to ease distinguishing duplicate attribute names
  ([MEN-5260](https://northerntech.atlassian.net/browse/MEN-5260))
* fixed an issue that prevented retrying deployments for single devices
* added sorting to list of device authsets, so that the most relevant should be at the top
* fixed an issue that limited profile edits to passwords, now editing the own email address is possible again
* added device twin display in device details
* added device monitor notification in device details to ease setting up monitors
  ([MEN-5292](https://northerntech.atlassian.net/browse/MEN-5292))
* Aggregated Dependabot Changelogs:
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.52.1 to 5.53.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.52.1...v5.53.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.25.1 to 7.25.2.
      - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
      - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.25.1...v7.25.2)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-react
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/eslint-parser](https://github.com/babel/babel/tree/HEAD/eslint/babel-eslint-parser) from 7.15.4 to 7.15.7.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.15.7/eslint/babel-eslint-parser)

      ```
      updated-dependencies:
      - dependency-name: "@babel/eslint-parser"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps node from 16.9.0-alpine to 16.9.1-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.25.2 to 7.25.3.
      - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
      - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.25.2...v7.25.3)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-react
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 6.2.0 to 6.3.0.
      - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/css-loader/compare/v6.2.0...v6.3.0)

      ```
      updated-dependencies:
      - dependency-name: css-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [victory](https://github.com/formidablelabs/victory) from 36.0.0 to 36.0.1.
      - [Release notes](https://github.com/formidablelabs/victory/releases)
      - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/formidablelabs/victory/compare/v36.0.0...v36.0.1)

      ```
      updated-dependencies:
      - dependency-name: victory
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.17.3 to 3.18.0.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.17.3...v3.18.0)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps node from 16.9.1-alpine to 16.10.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.14.1 to 1.15.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.14.1...v1.15.0)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.2.0 to 27.2.2.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.2.2/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.14.1 to 1.15.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.14.1...v1.15.0)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@stripe/react-stripe-js](https://github.com/stripe/react-stripe-js) from 1.4.1 to 1.5.0.
      - [Release notes](https://github.com/stripe/react-stripe-js/releases)
      - [Changelog](https://github.com/stripe/react-stripe-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/react-stripe-js/compare/v1.4.1...v1.5.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/react-stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps playwright from v1.14.1 to v1.15.0.

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:production
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.2.0 to 27.2.2.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.2.0...v27.2.2)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.18.0 to 3.18.1.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.18.0...v3.18.1)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.5.0 to 8.6.0.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.5.0...v8.6.0)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [react-dropzone](https://github.com/react-dropzone/react-dropzone) from 11.4.0 to 11.4.2.
      - [Release notes](https://github.com/react-dropzone/react-dropzone/releases)
      - [Commits](https://github.com/react-dropzone/react-dropzone/compare/v11.4.0...v11.4.2)

      ```
      updated-dependencies:
      - dependency-name: react-dropzone
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.25.3 to 7.26.0.
      - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
      - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.25.3...v7.26.0)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-react
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.14.1 to 1.15.0.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.14.1...v1.15.0)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.3.6 to 8.3.8.
      - [Release notes](https://github.com/postcss/postcss/releases)
      - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/postcss/compare/8.3.6...8.3.8)

      ```
      updated-dependencies:
      - dependency-name: postcss
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.53.0 to 5.54.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.53.0...v5.54.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest-junit](https://github.com/jest-community/jest-junit) from 12.2.0 to 12.3.0.
      - [Release notes](https://github.com/jest-community/jest-junit/releases)
      - [Commits](https://github.com/jest-community/jest-junit/compare/v12.2.0...v12.3.0)

      ```
      updated-dependencies:
      - dependency-name: jest-junit
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.3.4 to 10.3.6.
      - [Release notes](https://github.com/postcss/autoprefixer/releases)
      - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/autoprefixer/compare/10.3.4...10.3.6)

      ```
      updated-dependencies:
      - dependency-name: autoprefixer
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.35.0 to 0.36.0.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.35.0...v0.36.0)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [jest-watch-typeahead](https://github.com/jest-community/jest-watch-typeahead) from 0.6.4 to 1.0.0.
      - [Release notes](https://github.com/jest-community/jest-watch-typeahead/releases)
      - [Changelog](https://github.com/jest-community/jest-watch-typeahead/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/jest-community/jest-watch-typeahead/compare/v0.6.4...v1.0.0)

      ```
      updated-dependencies:
      - dependency-name: jest-watch-typeahead
        dependency-type: direct:development
        update-type: version-update:semver-major
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.6.0 to 8.7.0.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.6.0...v8.7.0)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.2.2 to 27.2.3.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.2.3/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [yarn](https://github.com/yarnpkg/yarn) from 1.22.11 to 1.22.13.
      - [Release notes](https://github.com/yarnpkg/yarn/releases)
      - [Changelog](https://github.com/yarnpkg/yarn/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yarnpkg/yarn/compare/1.22.11...v1.22.13)

      ```
      updated-dependencies:
      - dependency-name: yarn
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/react](https://github.com/testing-library/react-testing-library) from 12.1.0 to 12.1.1.
      - [Release notes](https://github.com/testing-library/react-testing-library/releases)
      - [Changelog](https://github.com/testing-library/react-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/react-testing-library/compare/v12.1.0...v12.1.1)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/react"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.54.0 to 5.55.1.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.54.0...v5.55.1)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.2.2 to 27.2.4.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.2.2...v27.2.4)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.2.3 to 27.2.4.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.2.4/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [yarn](https://github.com/yarnpkg/yarn) from 1.22.13 to 1.22.15.
      - [Release notes](https://github.com/yarnpkg/yarn/releases)
      - [Changelog](https://github.com/yarnpkg/yarn/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yarnpkg/yarn/compare/v1.22.13...v1.22.15)

      ```
      updated-dependencies:
      - dependency-name: yarn
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.21.4 to 0.22.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.21.4...v0.22.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.26.0 to 7.26.1.
      - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
      - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.26.0...v7.26.1)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-react
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.7.0 to 8.7.1.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.7.0...v8.7.1)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.15.0 to 1.15.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.15.0...v1.15.1)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mdi/js](https://github.com/Templarian/MaterialDesign-JS) from 6.1.95 to 6.2.95.
      - [Release notes](https://github.com/Templarian/MaterialDesign-JS/releases)
      - [Commits](https://github.com/Templarian/MaterialDesign-JS/compare/v6.1.95...v6.2.95)

      ```
      updated-dependencies:
      - dependency-name: "@mdi/js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [less](https://github.com/less/less.js) from 4.1.1 to 4.1.2.
      - [Release notes](https://github.com/less/less.js/releases)
      - [Changelog](https://github.com/less/less.js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/less/less.js/commits)

      ```
      updated-dependencies:
      - dependency-name: less
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.15.0 to 1.15.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.15.0...v1.15.1)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps playwright from v1.15.0 to v1.15.1.

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:production
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.21.4 to 0.22.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.21.4...v0.22.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.55.1 to 5.56.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.55.1...v5.56.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.18.0 to 1.19.0.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.18.0...v1.19.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.15.0 to 1.15.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.15.0...v1.15.1)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/react](https://github.com/testing-library/react-testing-library) from 12.1.1 to 12.1.2.
      - [Release notes](https://github.com/testing-library/react-testing-library/releases)
      - [Changelog](https://github.com/testing-library/react-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/react-testing-library/compare/v12.1.1...v12.1.2)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/react"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.36.0 to 0.36.1.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.36.0...v0.36.1)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.56.0 to 5.56.1.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.56.0...v5.56.1)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.15.1 to 1.15.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.15.1...v1.15.2)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 6.3.0 to 6.4.0.
      - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/css-loader/compare/v6.3.0...v6.4.0)

      ```
      updated-dependencies:
      - dependency-name: css-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.15.1 to 1.15.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.15.1...v1.15.2)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.2.4 to 27.2.5.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.2.5/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps playwright from v1.15.1 to v1.15.2.

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:production
      ```
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.3.8 to 8.3.9.
      - [Release notes](https://github.com/postcss/postcss/releases)
      - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/postcss/compare/8.3.8...8.3.9)

      ```
      updated-dependencies:
      - dependency-name: postcss
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.2.4 to 27.2.5.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.2.4...v27.2.5)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.15.5 to 7.15.8.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.15.8/packages/babel-core)

      ```
      updated-dependencies:
      - dependency-name: "@babel/core"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 13.2.1 to 13.3.0.
      - [Release notes](https://github.com/testing-library/user-event/releases)
      - [Changelog](https://github.com/testing-library/user-event/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/user-event/compare/v13.2.1...v13.3.0)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/user-event"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.15.1 to 1.15.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.15.1...v1.15.2)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.56.1 to 5.58.1.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.56.1...v5.58.1)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest-junit](https://github.com/jest-community/jest-junit) from 12.3.0 to 13.0.0.
      - [Release notes](https://github.com/jest-community/jest-junit/releases)
      - [Commits](https://github.com/jest-community/jest-junit/compare/v12.3.0...v13.0.0)

      ```
      updated-dependencies:
      - dependency-name: jest-junit
        dependency-type: direct:development
        update-type: version-update:semver-major
      ```
  * Bumps [@babel/eslint-parser](https://github.com/babel/babel/tree/HEAD/eslint/babel-eslint-parser) from 7.15.7 to 7.15.8.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.15.8/eslint/babel-eslint-parser)

      ```
      updated-dependencies:
      - dependency-name: "@babel/eslint-parser"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.15.1 to 2.16.0.
      - [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
      - [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.15.1...v2.16.0)

      ```
      updated-dependencies:
      - dependency-name: esbuild-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.3.6 to 10.3.7.
      - [Release notes](https://github.com/postcss/autoprefixer/releases)
      - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/autoprefixer/compare/10.3.6...10.3.7)

      ```
      updated-dependencies:
      - dependency-name: autoprefixer
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.15.6 to 7.15.8.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.15.8/packages/babel-preset-env)

      ```
      updated-dependencies:
      - dependency-name: "@babel/preset-env"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint-plugin-import](https://github.com/import-js/eslint-plugin-import) from 2.23.4 to 2.25.1.
      - [Release notes](https://github.com/import-js/eslint-plugin-import/releases)
      - [Changelog](https://github.com/import-js/eslint-plugin-import/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/import-js/eslint-plugin-import/compare/v2.23.4...v2.25.1)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-import
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@reduxjs/toolkit](https://github.com/reduxjs/redux-toolkit) from 1.6.1 to 1.6.2.
      - [Release notes](https://github.com/reduxjs/redux-toolkit/releases)
      - [Commits](https://github.com/reduxjs/redux-toolkit/compare/v1.6.1...v1.6.2)

      ```
      updated-dependencies:
      - dependency-name: "@reduxjs/toolkit"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.15.0 to 7.15.8.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.15.8/packages/babel-plugin-transform-runtime)

      ```
      updated-dependencies:
      - dependency-name: "@babel/plugin-transform-runtime"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.18.1 to 3.18.2.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.18.1...v3.18.2)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.19.0 to 1.19.1.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.19.0...v1.19.1)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 10.0.1 to 10.1.0.
      - [Release notes](https://github.com/webpack-contrib/less-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/less-loader/compare/v10.0.1...v10.1.0)

      ```
      updated-dependencies:
      - dependency-name: less-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.3.0 to 2.4.2.
      - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.3.0...v2.4.2)

      ```
      updated-dependencies:
      - dependency-name: mini-css-extract-plugin
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.7.1 to 8.7.2.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.7.1...v8.7.2)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 7.32.0 to 8.0.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v7.32.0...v8.0.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-major
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 11.1.2 to 11.2.3.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v11.1.2...v11.2.3)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@stripe/react-stripe-js](https://github.com/stripe/react-stripe-js) from 1.5.0 to 1.6.0.
      - [Release notes](https://github.com/stripe/react-stripe-js/releases)
      - [Changelog](https://github.com/stripe/react-stripe-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/react-stripe-js/compare/v1.5.0...v1.6.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/react-stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack-cli](https://github.com/webpack/webpack-cli) from 4.8.0 to 4.9.0.
      - [Release notes](https://github.com/webpack/webpack-cli/releases)
      - [Changelog](https://github.com/webpack/webpack-cli/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack/webpack-cli/compare/webpack-cli@4.8.0...webpack-cli@4.9.0)

      ```
      updated-dependencies:
      - dependency-name: webpack-cli
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps node from 16.10.0-alpine to 16.11.1-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.4.3 to 4.4.4.
      - [Release notes](https://github.com/Microsoft/TypeScript/releases)
      - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.4.3...v4.4.4)

      ```
      updated-dependencies:
      - dependency-name: typescript
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 13.3.0 to 13.4.1.
      - [Release notes](https://github.com/testing-library/user-event/releases)
      - [Changelog](https://github.com/testing-library/user-event/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/user-event/compare/v13.3.0...v13.4.1)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/user-event"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.22.0 to 0.23.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.22.0...v0.23.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.18.2 to 3.18.3.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.18.2...v3.18.3)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.0.0 to 8.0.1.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.0.0...v8.0.1)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.58.1 to 5.58.2.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.58.1...v5.58.2)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.2.5 to 27.3.0.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.3.0/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.2.5 to 27.3.0.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.3.0/packages/babel-jest)

      ```
      updated-dependencies:
      - dependency-name: babel-jest
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.2.5 to 27.3.0.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.2.5...v27.3.0)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [html-webpack-plugin](https://github.com/jantimon/html-webpack-plugin) from 5.3.2 to 5.4.0.
      - [Release notes](https://github.com/jantimon/html-webpack-plugin/releases)
      - [Changelog](https://github.com/jantimon/html-webpack-plugin/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/jantimon/html-webpack-plugin/compare/v5.3.2...v5.4.0)

      ```
      updated-dependencies:
      - dependency-name: html-webpack-plugin
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.19.1 to 1.20.2.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.19.1...v1.20.2)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-plugin-import](https://github.com/import-js/eslint-plugin-import) from 2.25.1 to 2.25.2.
      - [Release notes](https://github.com/import-js/eslint-plugin-import/releases)
      - [Changelog](https://github.com/import-js/eslint-plugin-import/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/import-js/eslint-plugin-import/compare/v2.25.1...v2.25.2)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-import
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [postcss-loader](https://github.com/webpack-contrib/postcss-loader) from 6.1.1 to 6.2.0.
      - [Release notes](https://github.com/webpack-contrib/postcss-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/postcss-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/postcss-loader/compare/v6.1.1...v6.2.0)

      ```
      updated-dependencies:
      - dependency-name: postcss-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [yarn](https://github.com/yarnpkg/yarn) from 1.22.15 to 1.22.17.
      - [Release notes](https://github.com/yarnpkg/yarn/releases)
      - [Changelog](https://github.com/yarnpkg/yarn/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yarnpkg/yarn/compare/v1.22.15...v1.22.17)

      ```
      updated-dependencies:
      - dependency-name: yarn
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.7.2 to 8.9.1.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.7.2...v8.9.1)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.22.0 to 0.23.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.22.0...v0.23.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@mdi/js](https://github.com/Templarian/MaterialDesign-JS) from 6.2.95 to 6.3.95.
      - [Release notes](https://github.com/Templarian/MaterialDesign-JS/releases)
      - [Commits](https://github.com/Templarian/MaterialDesign-JS/compare/v6.2.95...v6.3.95)

      ```
      updated-dependencies:
      - dependency-name: "@mdi/js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps node from 16.11.1-alpine to 16.12.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.15.2 to 1.16.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.15.2...v1.16.1)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.3.0 to 27.3.1.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.3.1/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 11.2.3 to 11.2.4.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v11.2.3...v11.2.4)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.0.1 to 8.1.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.0.1...v8.1.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.9.1 to 8.10.1.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.9.1...v8.10.1)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps playwright from v1.15.2 to v1.16.1.

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:production
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.15.2 to 1.16.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.15.2...v1.16.1)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [husky](https://github.com/typicode/husky) from 7.0.2 to 7.0.4.
      - [Release notes](https://github.com/typicode/husky/releases)
      - [Commits](https://github.com/typicode/husky/compare/v7.0.2...v7.0.4)

      ```
      updated-dependencies:
      - dependency-name: husky
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 13.4.1 to 13.5.0.
      - [Release notes](https://github.com/testing-library/user-event/releases)
      - [Changelog](https://github.com/testing-library/user-event/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/user-event/compare/v13.4.1...v13.5.0)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/user-event"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.58.2 to 5.59.1.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.58.2...v5.59.1)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.3.9 to 8.3.11.
      - [Release notes](https://github.com/postcss/postcss/releases)
      - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/postcss/compare/8.3.9...8.3.11)

      ```
      updated-dependencies:
      - dependency-name: postcss
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.15.2 to 1.16.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.15.2...v1.16.1)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.20.2 to 1.20.3.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.20.2...v1.20.3)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@mdi/js](https://github.com/Templarian/MaterialDesign-JS) from 6.3.95 to 6.4.95.
      - [Release notes](https://github.com/Templarian/MaterialDesign-JS/releases)
      - [Commits](https://github.com/Templarian/MaterialDesign-JS/compare/v6.3.95...v6.4.95)

      ```
      updated-dependencies:
      - dependency-name: "@mdi/js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.18.3 to 3.19.0.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.18.3...v3.19.0)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.3.0 to 27.3.1.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.3.1/packages/babel-jest)

      ```
      updated-dependencies:
      - dependency-name: babel-jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack-cli](https://github.com/webpack/webpack-cli) from 4.9.0 to 4.9.1.
      - [Release notes](https://github.com/webpack/webpack-cli/releases)
      - [Changelog](https://github.com/webpack/webpack-cli/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack/webpack-cli/compare/webpack-cli@4.9.0...webpack-cli@4.9.1)

      ```
      updated-dependencies:
      - dependency-name: webpack-cli
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 10.1.0 to 10.2.0.
      - [Release notes](https://github.com/webpack-contrib/less-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/less-loader/compare/v10.1.0...v10.2.0)

      ```
      updated-dependencies:
      - dependency-name: less-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.3.0 to 27.3.1.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.3.0...v27.3.1)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.36.1 to 0.38.0.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.36.1...v0.38.0)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.4.2 to 2.4.3.
      - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.4.2...v2.4.3)

      ```
      updated-dependencies:
      - dependency-name: mini-css-extract-plugin
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps node from 16.12.0-alpine to 17.0.1-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [react-redux](https://github.com/reduxjs/react-redux) from 7.2.5 to 7.2.6.
      - [Release notes](https://github.com/reduxjs/react-redux/releases)
      - [Changelog](https://github.com/reduxjs/react-redux/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/reduxjs/react-redux/compare/v7.2.5...v7.2.6)

      ```
      updated-dependencies:
      - dependency-name: react-redux
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.16.1 to 1.16.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.16.1...v1.16.2)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.15.8 to 7.16.0.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.0/packages/babel-preset-env)

      ```
      updated-dependencies:
      - dependency-name: "@babel/preset-env"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps playwright from v1.16.1 to v1.16.2.

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:production
      ```
  * Bumps [html-webpack-plugin](https://github.com/jantimon/html-webpack-plugin) from 5.4.0 to 5.5.0.
      - [Release notes](https://github.com/jantimon/html-webpack-plugin/releases)
      - [Changelog](https://github.com/jantimon/html-webpack-plugin/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/jantimon/html-webpack-plugin/compare/v5.4.0...v5.5.0)

      ```
      updated-dependencies:
      - dependency-name: html-webpack-plugin
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [victory](https://github.com/formidablelabs/victory) from 36.0.1 to 36.1.0.
      - [Release notes](https://github.com/formidablelabs/victory/releases)
      - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/formidablelabs/victory/compare/v36.0.1...v36.1.0)

      ```
      updated-dependencies:
      - dependency-name: victory
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 11.2.4 to 11.2.6.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v11.2.4...v11.2.6)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.23.0 to 0.24.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.23.0...v0.24.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.16.1 to 1.16.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.16.1...v1.16.2)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/eslint-parser](https://github.com/babel/babel/tree/HEAD/eslint/babel-eslint-parser) from 7.15.8 to 7.16.0.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.0/eslint/babel-eslint-parser)

      ```
      updated-dependencies:
      - dependency-name: "@babel/eslint-parser"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.3.7 to 10.4.0.
      - [Release notes](https://github.com/postcss/autoprefixer/releases)
      - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/autoprefixer/compare/10.3.7...10.4.0)

      ```
      updated-dependencies:
      - dependency-name: autoprefixer
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.59.1 to 5.61.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.59.1...v5.61.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.16.1 to 1.16.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.16.1...v1.16.2)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.15.8 to 7.16.0.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.0/packages/babel-core)

      ```
      updated-dependencies:
      - dependency-name: "@babel/core"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 6.4.0 to 6.5.0.
      - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/css-loader/compare/v6.4.0...v6.5.0)

      ```
      updated-dependencies:
      - dependency-name: css-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-webpack-plugin](https://github.com/webpack-contrib/eslint-webpack-plugin) from 3.0.1 to 3.1.0.
      - [Release notes](https://github.com/webpack-contrib/eslint-webpack-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/eslint-webpack-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/eslint-webpack-plugin/compare/v3.0.1...v3.1.0)

      ```
      updated-dependencies:
      - dependency-name: eslint-webpack-plugin
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.23.0 to 0.24.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.23.0...v0.24.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.15.8 to 7.16.0.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.0/packages/babel-plugin-transform-runtime)

      ```
      updated-dependencies:
      - dependency-name: "@babel/plugin-transform-runtime"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/preset-react](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-react) from 7.14.5 to 7.16.0.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.0/packages/babel-preset-react)

      ```
      updated-dependencies:
      - dependency-name: "@babel/preset-react"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [validator](https://github.com/validatorjs/validator.js) from 13.6.0 to 13.7.0.
      - [Release notes](https://github.com/validatorjs/validator.js/releases)
      - [Changelog](https://github.com/validatorjs/validator.js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/validatorjs/validator.js/compare/13.6.0...13.7.0)

      ```
      updated-dependencies:
      - dependency-name: validator
        dependency-type: direct:production
      ```
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.4.3 to 2.4.4.
      - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.4.3...v2.4.4)

      ```
      updated-dependencies:
      - dependency-name: mini-css-extract-plugin
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [victory](https://github.com/formidablelabs/victory) from 36.1.0 to 36.2.0.
      - [Release notes](https://github.com/formidablelabs/victory/releases)
      - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/formidablelabs/victory/compare/v36.1.0...v36.2.0)

      ```
      updated-dependencies:
      - dependency-name: victory
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.61.0 to 5.62.1.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.61.0...v5.62.1)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [xterm](https://github.com/xtermjs/xterm.js) from 4.13.0 to 4.15.0.
      - [Release notes](https://github.com/xtermjs/xterm.js/releases)
      - [Commits](https://github.com/xtermjs/xterm.js/compare/4.13.0...4.15.0)

      ```
      updated-dependencies:
      - dependency-name: xterm
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.20.3 to 1.21.1.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.20.3...v1.21.1)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 6.5.0 to 6.5.1.
      - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/css-loader/compare/v6.5.0...v6.5.1)

      ```
      updated-dependencies:
      - dependency-name: css-loader
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.10.1 to 8.11.0.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.10.1...v8.11.0)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.14.1 to 5.15.0.
      - [Release notes](https://github.com/testing-library/jest-dom/releases)
      - [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/jest-dom/compare/v5.14.1...v5.15.0)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/jest-dom"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.19.0 to 3.19.1.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.19.0...v3.19.1)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.1.0 to 8.2.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.1.0...v8.2.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.16.2 to 1.16.3.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.16.2...v1.16.3)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.16.2 to 1.16.3.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.16.2...v1.16.3)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps playwright from v1.16.2 to v1.16.3.

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:production
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.16.2 to 1.16.3.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.16.2...v1.16.3)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps node from 17.0.1-alpine to 17.1.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.26.1 to 7.27.0.
      - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
      - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.26.1...v7.27.0)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-react
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [generate-password](https://github.com/brendanashworth/generate-password) from 1.6.1 to 1.7.0.
      - [Release notes](https://github.com/brendanashworth/generate-password/releases)
      - [Changelog](https://github.com/brendanashworth/generate-password/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/brendanashworth/generate-password/commits)

      ```
      updated-dependencies:
      - dependency-name: generate-password
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.11.0 to 8.11.1.
      - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
      - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.11.0...v8.11.1)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/dom"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.38.0 to 0.38.1.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.38.0...v0.38.1)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.62.1 to 5.64.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.62.1...v5.64.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps nginx from 1.21.3-alpine to 1.21.4-alpine.

      ```
      updated-dependencies:
      - dependency-name: nginx
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 11.2.6 to 12.0.2.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v11.2.6...v12.0.2)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-major
      ```
  * Bumps [@babel/eslint-parser](https://github.com/babel/babel/tree/HEAD/eslint/babel-eslint-parser) from 7.16.0 to 7.16.3.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.3/eslint/babel-eslint-parser)

      ```
      updated-dependencies:
      - dependency-name: "@babel/eslint-parser"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@mdi/js](https://github.com/Templarian/MaterialDesign-JS) from 6.4.95 to 6.5.95.
      - [Release notes](https://github.com/Templarian/MaterialDesign-JS/releases)
      - [Commits](https://github.com/Templarian/MaterialDesign-JS/compare/v6.4.95...v6.5.95)

      ```
      updated-dependencies:
      - dependency-name: "@mdi/js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-plugin-import](https://github.com/import-js/eslint-plugin-import) from 2.25.2 to 2.25.3.
      - [Release notes](https://github.com/import-js/eslint-plugin-import/releases)
      - [Changelog](https://github.com/import-js/eslint-plugin-import/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/import-js/eslint-plugin-import/compare/v2.25.2...v2.25.3)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-import
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint-webpack-plugin](https://github.com/webpack-contrib/eslint-webpack-plugin) from 3.1.0 to 3.1.1.
      - [Release notes](https://github.com/webpack-contrib/eslint-webpack-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/eslint-webpack-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/eslint-webpack-plugin/compare/v3.1.0...v3.1.1)

      ```
      updated-dependencies:
      - dependency-name: eslint-webpack-plugin
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.4.4 to 4.5.2.
      - [Release notes](https://github.com/Microsoft/TypeScript/releases)
      - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.4.4...v4.5.2)

      ```
      updated-dependencies:
      - dependency-name: typescript
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.16.0 to 7.16.4.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.4/packages/babel-plugin-transform-runtime)

      ```
      updated-dependencies:
      - dependency-name: "@babel/plugin-transform-runtime"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.4.4 to 2.4.5.
      - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.4.4...v2.4.5)

      ```
      updated-dependencies:
      - dependency-name: mini-css-extract-plugin
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.27.0 to 7.27.1.
      - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
      - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.27.0...v7.27.1)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-react
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.64.0 to 5.64.1.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.64.0...v5.64.1)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.0.2 to 12.0.3.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.0.2...v12.0.3)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.16.0 to 7.16.4.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.4/packages/babel-preset-env)

      ```
      updated-dependencies:
      - dependency-name: "@babel/preset-env"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.0.3 to 12.1.1.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.0.3...v12.1.1)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.2.0 to 8.3.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.2.0...v8.3.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.64.1 to 5.64.2.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.64.1...v5.64.2)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.1.1 to 12.1.2.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.1.1...v12.1.2)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.15.0 to 5.15.1.
      - [Release notes](https://github.com/testing-library/jest-dom/releases)
      - [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/jest-dom/compare/v5.15.0...v5.15.1)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/jest-dom"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.64.2 to 5.64.4.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.64.2...v5.64.4)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.3.11 to 8.4.4.
      - [Release notes](https://github.com/postcss/postcss/releases)
      - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/postcss/compare/8.3.11...8.4.4)

      ```
      updated-dependencies:
      - dependency-name: postcss
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [postcss-loader](https://github.com/webpack-contrib/postcss-loader) from 6.2.0 to 6.2.1.
      - [Release notes](https://github.com/webpack-contrib/postcss-loader/releases)
      - [Changelog](https://github.com/webpack-contrib/postcss-loader/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/postcss-loader/compare/v6.2.0...v6.2.1)

      ```
      updated-dependencies:
      - dependency-name: postcss-loader
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [prettier](https://github.com/prettier/prettier) from 2.2.1 to 2.5.0.
      - [Release notes](https://github.com/prettier/prettier/releases)
      - [Changelog](https://github.com/prettier/prettier/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/prettier/prettier/compare/2.2.1...2.5.0)

      ```
      updated-dependencies:
      - dependency-name: prettier
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps node from 17.1.0-alpine to 17.2.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.19.1 to 3.19.2.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.19.1...v3.19.2)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.16.3 to 1.17.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.16.3...v1.17.1)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.16.3 to 1.17.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.16.3...v1.17.1)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [msw](https://github.com/mswjs/msw) from 0.35.0 to 0.36.0.
      - [Release notes](https://github.com/mswjs/msw/releases)
      - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mswjs/msw/compare/v0.35.0...v0.36.0)

      ```
      updated-dependencies:
      - dependency-name: msw
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-plugin-sonarjs](https://github.com/SonarSource/eslint-plugin-sonarjs) from 0.10.0 to 0.11.0.
      - [Release notes](https://github.com/SonarSource/eslint-plugin-sonarjs/releases)
      - [Commits](https://github.com/SonarSource/eslint-plugin-sonarjs/compare/0.10.0...0.11.0)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-sonarjs
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps playwright from v1.16.3 to v1.17.1.

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:production
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.3.1 to 27.4.3.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.3.1...v27.4.3)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.3.1 to 27.4.2.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.4.2/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.16.3 to 1.17.1.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.16.3...v1.17.1)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.15.1 to 5.16.0.
      - [Release notes](https://github.com/testing-library/jest-dom/releases)
      - [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/jest-dom/compare/v5.15.1...v5.16.0)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/jest-dom"
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.19.1 to 3.19.3.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.19.1...v3.19.3)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.3.1 to 27.4.2.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.4.2/packages/babel-jest)

      ```
      updated-dependencies:
      - dependency-name: babel-jest
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.21.1 to 1.21.2.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.21.1...v1.21.2)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.3.0 to 8.4.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.3.0...v8.4.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [prettier](https://github.com/prettier/prettier) from 2.5.0 to 2.5.1.
      - [Release notes](https://github.com/prettier/prettier/releases)
      - [Changelog](https://github.com/prettier/prettier/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/prettier/prettier/compare/2.5.0...2.5.1)

      ```
      updated-dependencies:
      - dependency-name: prettier
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.4.2 to 27.4.4.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.4.4/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.5.2 to 4.5.3.
      - [Release notes](https://github.com/Microsoft/TypeScript/releases)
      - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.5.2...v4.5.3)

      ```
      updated-dependencies:
      - dependency-name: typescript
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.16.0 to 2.17.0.
      - [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
      - [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.16.0...v2.17.0)

      ```
      updated-dependencies:
      - dependency-name: esbuild-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.4.4 to 8.4.5.
      - [Release notes](https://github.com/postcss/postcss/releases)
      - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/postcss/compare/8.4.4...8.4.5)

      ```
      updated-dependencies:
      - dependency-name: postcss
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.4.2 to 27.4.4.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.4.4/packages/babel-jest)

      ```
      updated-dependencies:
      - dependency-name: babel-jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.4.3 to 27.4.4.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.4.3...v27.4.4)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@reduxjs/toolkit](https://github.com/reduxjs/redux-toolkit) from 1.6.2 to 1.7.0.
      - [Release notes](https://github.com/reduxjs/redux-toolkit/releases)
      - [Commits](https://github.com/reduxjs/redux-toolkit/compare/v1.6.2...v1.7.0)

      ```
      updated-dependencies:
      - dependency-name: "@reduxjs/toolkit"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.4.0 to 8.4.1.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.4.0...v8.4.1)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.16.0 to 5.16.1.
      - [Release notes](https://github.com/testing-library/jest-dom/releases)
      - [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/testing-library/jest-dom/compare/v5.16.0...v5.16.1)

      ```
      updated-dependencies:
      - dependency-name: "@testing-library/jest-dom"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.21.2 to 1.22.0.
      - [Release notes](https://github.com/stripe/stripe-js/releases)
      - [Commits](https://github.com/stripe/stripe-js/compare/v1.21.2...v1.22.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.64.4 to 5.65.0.
      - [Release notes](https://github.com/webpack/webpack/releases)
      - [Commits](https://github.com/webpack/webpack/compare/v5.64.4...v5.65.0)

      ```
      updated-dependencies:
      - dependency-name: webpack
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [msw](https://github.com/mswjs/msw) from 0.36.0 to 0.36.3.
      - [Release notes](https://github.com/mswjs/msw/releases)
      - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/mswjs/msw/compare/v0.36.0...v0.36.3)

      ```
      updated-dependencies:
      - dependency-name: msw
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.16.4 to 7.16.5.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.5/packages/babel-preset-env)

      ```
      updated-dependencies:
      - dependency-name: "@babel/preset-env"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.5.3 to 4.5.4.
      - [Release notes](https://github.com/Microsoft/TypeScript/releases)
      - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.5.3...v4.5.4)

      ```
      updated-dependencies:
      - dependency-name: typescript
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/plugin-proposal-class-properties](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-proposal-class-properties) from 7.16.0 to 7.16.5.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.5/packages/babel-plugin-proposal-class-properties)

      ```
      updated-dependencies:
      - dependency-name: "@babel/plugin-proposal-class-properties"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.4.4 to 27.4.5.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.4.5/packages/babel-jest)

      ```
      updated-dependencies:
      - dependency-name: babel-jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.19.3 to 3.20.0.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.19.3...v3.20.0)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@stripe/react-stripe-js](https://github.com/stripe/react-stripe-js) from 1.6.0 to 1.7.0.
      - [Release notes](https://github.com/stripe/react-stripe-js/releases)
      - [Changelog](https://github.com/stripe/react-stripe-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/react-stripe-js/compare/v1.6.0...v1.7.0)

      ```
      updated-dependencies:
      - dependency-name: "@stripe/react-stripe-js"
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.4.4 to 27.4.5.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.4.5/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.17.0 to 2.18.0.
      - [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
      - [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.17.0...v2.18.0)

      ```
      updated-dependencies:
      - dependency-name: esbuild-loader
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/preset-react](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-react) from 7.16.0 to 7.16.5.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.5/packages/babel-preset-react)

      ```
      updated-dependencies:
      - dependency-name: "@babel/preset-react"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@reduxjs/toolkit](https://github.com/reduxjs/redux-toolkit) from 1.7.0 to 1.7.1.
      - [Release notes](https://github.com/reduxjs/redux-toolkit/releases)
      - [Commits](https://github.com/reduxjs/redux-toolkit/compare/v1.7.0...v1.7.1)

      ```
      updated-dependencies:
      - dependency-name: "@reduxjs/toolkit"
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.38.1 to 0.38.2.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.38.1...v0.38.2)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.1.2 to 12.1.3.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.1.2...v12.1.3)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/eslint-parser](https://github.com/babel/babel/tree/HEAD/eslint/babel-eslint-parser) from 7.16.3 to 7.16.5.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.5/eslint/babel-eslint-parser)

      ```
      updated-dependencies:
      - dependency-name: "@babel/eslint-parser"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.4.1 to 8.5.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.4.1...v8.5.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.16.4 to 7.16.5.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.5/packages/babel-plugin-transform-runtime)

      ```
      updated-dependencies:
      - dependency-name: "@babel/plugin-transform-runtime"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.4.4 to 27.4.5.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.4.4...v27.4.5)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.16.0 to 7.16.5.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.5/packages/babel-core)

      ```
      updated-dependencies:
      - dependency-name: "@babel/core"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps node from 17.2.0-alpine to 17.3.0-alpine.

      ```
      updated-dependencies:
      - dependency-name: node
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [xterm-addon-search](https://github.com/xtermjs/xterm.js) from 0.8.1 to 0.8.2.
      - [Release notes](https://github.com/xtermjs/xterm.js/releases)
      - [Commits](https://github.com/xtermjs/xterm.js/commits)

      ```
      updated-dependencies:
      - dependency-name: xterm-addon-search
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [xterm](https://github.com/xtermjs/xterm.js) from 4.15.0 to 4.16.0.
      - [Release notes](https://github.com/xtermjs/xterm.js/releases)
      - [Commits](https://github.com/xtermjs/xterm.js/compare/4.15.0...4.16.0)

      ```
      updated-dependencies:
      - dependency-name: xterm
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.27.1 to 7.28.0.
      - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
      - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.27.1...v7.28.0)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-react
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps nginx from 1.21.4-alpine to 1.21.5-alpine.

      ```
      updated-dependencies:
      - dependency-name: nginx
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.20.0 to 3.20.2.
      - [Release notes](https://github.com/zloirock/core-js/releases)
      - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/zloirock/core-js/compare/v3.20.0...v3.20.2)

      ```
      updated-dependencies:
      - dependency-name: core-js
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.16.5 to 7.16.7.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.7/packages/babel-preset-env)

      ```
      updated-dependencies:
      - dependency-name: "@babel/preset-env"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.4.0 to 10.4.1.
      - [Release notes](https://github.com/postcss/autoprefixer/releases)
      - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/autoprefixer/compare/10.4.0...10.4.1)

      ```
      updated-dependencies:
      - dependency-name: autoprefixer
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [xterm-addon-web-links](https://github.com/xtermjs/xterm.js) from 0.4.0 to 0.5.0.
      - [Release notes](https://github.com/xtermjs/xterm.js/releases)
      - [Commits](https://github.com/xtermjs/xterm.js/compare/0.4...0.5)

      ```
      updated-dependencies:
      - dependency-name: xterm-addon-web-links
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [eslint](https://github.com/eslint/eslint) from 8.5.0 to 8.6.0.
      - [Release notes](https://github.com/eslint/eslint/releases)
      - [Changelog](https://github.com/eslint/eslint/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/eslint/eslint/compare/v8.5.0...v8.6.0)

      ```
      updated-dependencies:
      - dependency-name: eslint
        dependency-type: direct:development
        update-type: version-update:semver-minor
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.1.3 to 12.1.5.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.1.3...v12.1.5)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.16.5 to 7.16.7.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.7/packages/babel-core)

      ```
      updated-dependencies:
      - dependency-name: "@babel/core"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/preset-react](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-react) from 7.16.5 to 7.16.7.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.7/packages/babel-preset-react)

      ```
      updated-dependencies:
      - dependency-name: "@babel/preset-react"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.16.5 to 7.16.7.
      - [Release notes](https://github.com/babel/babel/releases)
      - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/babel/babel/commits/v7.16.7/packages/babel-plugin-transform-runtime)

      ```
      updated-dependencies:
      - dependency-name: "@babel/plugin-transform-runtime"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [eslint-plugin-import](https://github.com/import-js/eslint-plugin-import) from 2.25.3 to 2.25.4.
      - [Release notes](https://github.com/import-js/eslint-plugin-import/releases)
      - [Changelog](https://github.com/import-js/eslint-plugin-import/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/import-js/eslint-plugin-import/compare/v2.25.3...v2.25.4)

      ```
      updated-dependencies:
      - dependency-name: eslint-plugin-import
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [react-dropzone](https://github.com/react-dropzone/react-dropzone) from 11.4.2 to 11.5.1.
      - [Release notes](https://github.com/react-dropzone/react-dropzone/releases)
      - [Commits](https://github.com/react-dropzone/react-dropzone/compare/v11.4.2...v11.5.1)

      ```
      updated-dependencies:
      - dependency-name: react-dropzone
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.17.1 to 1.17.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.17.1...v1.17.2)

      ```
      updated-dependencies:
      - dependency-name: "@playwright/test"
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.17.1 to 1.17.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.17.1...v1.17.2)

      ```
      updated-dependencies:
      - dependency-name: playwright
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.4.5 to 27.4.6.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/commits/v27.4.6/packages/jest-resolve)

      ```
      updated-dependencies:
      - dependency-name: jest-resolve
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.4.5 to 2.4.6.
      - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
      - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.4.5...v2.4.6)

      ```
      updated-dependencies:
      - dependency-name: mini-css-extract-plugin
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [jest](https://github.com/facebook/jest) from 27.4.5 to 27.4.7.
      - [Release notes](https://github.com/facebook/jest/releases)
      - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/facebook/jest/compare/v27.4.5...v27.4.7)

      ```
      updated-dependencies:
      - dependency-name: jest
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.17.1 to 1.17.2.
      - [Release notes](https://github.com/Microsoft/playwright/releases)
      - [Commits](https://github.com/Microsoft/playwright/compare/v1.17.1...v1.17.2)

      ```
      updated-dependencies:
      - dependency-name: playwright-chromium
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.38.2 to 0.38.4.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.38.2...v0.38.4)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.4.1 to 10.4.2.
      - [Release notes](https://github.com/postcss/autoprefixer/releases)
      - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
      - [Commits](https://github.com/postcss/autoprefixer/compare/10.4.1...10.4.2)

      ```
      updated-dependencies:
      - dependency-name: autoprefixer
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 12.1.5 to 12.1.7.
      - [Release notes](https://github.com/okonet/lint-staged/releases)
      - [Commits](https://github.com/okonet/lint-staged/compare/v12.1.5...v12.1.7)

      ```
      updated-dependencies:
      - dependency-name: lint-staged
        dependency-type: direct:development
        update-type: version-update:semver-patch
      ```
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.38.4 to 0.38.5.
      - [Release notes](https://github.com/jquense/react-big-calendar/releases)
      - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.38.4...v0.38.5)

      ```
      updated-dependencies:
      - dependency-name: react-big-calendar
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [axios](https://github.com/axios/axios) from 0.24.0 to 0.25.0.
      - [Release notes](https://github.com/axios/axios/releases)
      - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/axios/axios/compare/v0.24.0...v0.25.0)

      ```
      updated-dependencies:
      - dependency-name: axios
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### integration (3.2.0)

New changes in integration since 3.1.0:

* [] Fix demo script user creation race condition
  ([MEN-4852](https://northerntech.atlassian.net/browse/MEN-4852))
* Azure Get/Set settings backend integration test.
  ([MEN-5150](https://northerntech.atlassian.net/browse/MEN-5150))
* workflows requires nats, move the container to the main docker-compose.yml
* Unify the docker-compose version check through using the
  docker-compose version subcommand, as opposed to the --version flag when
  checking which docker-compose version is compatible with the current demo script.
* Upgrade auditlogs to 3.0.0.
* Upgrade create-artifact-worker to 1.1.0.
* Upgrade deployments-enterprise to 4.1.0.
* Upgrade deployments to 4.1.0.
* Add deviceauth-enterprise 3.2.0.
* Upgrade deviceauth to 3.2.0.
* Upgrade deviceconfig to 1.2.0.
* Upgrade deviceconnect to 1.3.0.
* Upgrade devicemonitor to 1.1.0.
* Upgrade gui to 3.2.0.
* Upgrade integration to 3.2.0.
* Upgrade inventory-enterprise to 4.1.0.
* Upgrade inventory to 4.1.0.
* Add iot-manager 1.0.0.
* Upgrade mender-artifact to 3.7.0.
* Add mender-binary-delta 1.3.0.
* Add mender-configure-module 1.0.3.
* Upgrade mender-connect to 2.0.0.
* Add mender-convert 2.6.1.
* Upgrade mender to 3.2.0.
* Upgrade monitor-client to 1.1.0.
* Upgrade mtls-ambassador to 1.0.1.
* Upgrade useradm-enterprise to 1.17.0.
* Upgrade useradm to 1.17.0.
* Upgrade workflows-enterprise to 2.2.0.
* Upgrade workflows to 2.2.0.
* Aggregated Dependabot Changelogs:
  * Bumps [websockets](https://github.com/aaugustin/websockets) from 9.1 to 10.0.
      - [Release notes](https://github.com/aaugustin/websockets/releases)
      - [Commits](https://github.com/aaugustin/websockets/compare/9.1...10.0)

      ```
      updated-dependencies:
      - dependency-name: websockets
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.0.12 to 3.1.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/v3.0.12...3.1.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest-xdist](https://github.com/pytest-dev/pytest-xdist) from 2.3.0 to 2.4.0.
      - [Release notes](https://github.com/pytest-dev/pytest-xdist/releases)
      - [Changelog](https://github.com/pytest-dev/pytest-xdist/blob/master/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest-xdist/compare/v2.3.0...v2.4.0)

      ```
      updated-dependencies:
      - dependency-name: pytest-xdist
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.6 to 1.26.7.
      - [Release notes](https://github.com/urllib3/urllib3/releases)
      - [Changelog](https://github.com/urllib3/urllib3/blob/main/CHANGES.rst)
      - [Commits](https://github.com/urllib3/urllib3/compare/1.26.6...1.26.7)

      ```
      updated-dependencies:
      - dependency-name: urllib3
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.0.12 to 3.1.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/v3.0.12...3.1.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [apipkg](https://github.com/pytest-dev/apipkg) from 1.5 to 2.0.0.
      - [Release notes](https://github.com/pytest-dev/apipkg/releases)
      - [Changelog](https://github.com/pytest-dev/apipkg/blob/main/CHANGELOG)
      - [Commits](https://github.com/pytest-dev/apipkg/compare/v1.5...v2.0.0)

      ```
      updated-dependencies:
      - dependency-name: apipkg
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.6 to 1.26.7.
      - [Release notes](https://github.com/urllib3/urllib3/releases)
      - [Changelog](https://github.com/urllib3/urllib3/blob/main/CHANGES.rst)
      - [Commits](https://github.com/urllib3/urllib3/compare/1.26.6...1.26.7)

      ```
      updated-dependencies:
      - dependency-name: urllib3
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.1.0 to 3.3.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.1.0...3.3.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.8 to 35.0.0.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/3.4.8...35.0.0)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.1.0 to 3.3.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.1.0...3.3.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.8 to 35.0.0.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/3.4.8...35.0.0)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps python from 3.9.7 to 3.10.0.

      ```
      updated-dependencies:
      - dependency-name: python
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [certifi](https://github.com/certifi/python-certifi) from 2021.5.30 to 2021.10.8.
      - [Release notes](https://github.com/certifi/python-certifi/releases)
      - [Commits](https://github.com/certifi/python-certifi/compare/2021.05.30...2021.10.08)

      ```
      updated-dependencies:
      - dependency-name: certifi
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [docker](https://github.com/docker/docker-py) from 5.0.2 to 5.0.3.
      - [Release notes](https://github.com/docker/docker-py/releases)
      - [Commits](https://github.com/docker/docker-py/compare/5.0.2...5.0.3)

      ```
      updated-dependencies:
      - dependency-name: docker
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.7.2 to 2.8.0.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.7.2...2.8.0)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest-timeout](https://github.com/pytest-dev/pytest-timeout) from 1.4.2 to 2.0.0.
      - [Release notes](https://github.com/pytest-dev/pytest-timeout/releases)
      - [Commits](https://github.com/pytest-dev/pytest-timeout/commits)

      ```
      updated-dependencies:
      - dependency-name: pytest-timeout
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [python-dotenv](https://github.com/theskumar/python-dotenv) from 0.19.0 to 0.19.1.
      - [Release notes](https://github.com/theskumar/python-dotenv/releases)
      - [Changelog](https://github.com/theskumar/python-dotenv/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/theskumar/python-dotenv/compare/v0.19.0...v0.19.1)

      ```
      updated-dependencies:
      - dependency-name: python-dotenv
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [apipkg](https://github.com/pytest-dev/apipkg) from 2.0.0 to 2.1.0.
      - [Release notes](https://github.com/pytest-dev/apipkg/releases)
      - [Changelog](https://github.com/pytest-dev/apipkg/blob/main/CHANGELOG)
      - [Commits](https://github.com/pytest-dev/apipkg/compare/v2.0.0...v2.1.0)

      ```
      updated-dependencies:
      - dependency-name: apipkg
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest-timeout](https://github.com/pytest-dev/pytest-timeout) from 2.0.0 to 2.0.1.
      - [Release notes](https://github.com/pytest-dev/pytest-timeout/releases)
      - [Commits](https://github.com/pytest-dev/pytest-timeout/commits)

      ```
      updated-dependencies:
      - dependency-name: pytest-timeout
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [idna](https://github.com/kjd/idna) from 2.10 to 3.3.
      - [Release notes](https://github.com/kjd/idna/releases)
      - [Changelog](https://github.com/kjd/idna/blob/master/HISTORY.rst)
      - [Commits](https://github.com/kjd/idna/compare/v2.10...v3.3)

      ```
      updated-dependencies:
      - dependency-name: idna
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [certifi](https://github.com/certifi/python-certifi) from 2021.5.30 to 2021.10.8.
      - [Release notes](https://github.com/certifi/python-certifi/releases)
      - [Commits](https://github.com/certifi/python-certifi/compare/2021.05.30...2021.10.08)

      ```
      updated-dependencies:
      - dependency-name: certifi
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [docker](https://github.com/docker/docker-py) from 5.0.2 to 5.0.3.
      - [Release notes](https://github.com/docker/docker-py/releases)
      - [Commits](https://github.com/docker/docker-py/compare/5.0.2...5.0.3)

      ```
      updated-dependencies:
      - dependency-name: docker
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.60.0 to 2.61.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.60.0...v2.61.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pyyaml](https://github.com/yaml/pyyaml) from 5.4.1 to 6.0.
      - [Release notes](https://github.com/yaml/pyyaml/releases)
      - [Changelog](https://github.com/yaml/pyyaml/blob/master/CHANGES)
      - [Commits](https://github.com/yaml/pyyaml/compare/5.4.1...6.0)

      ```
      updated-dependencies:
      - dependency-name: pyyaml
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [pillow](https://github.com/python-pillow/Pillow) from 8.3.2 to 8.4.0.
      - [Release notes](https://github.com/python-pillow/Pillow/releases)
      - [Changelog](https://github.com/python-pillow/Pillow/blob/main/CHANGES.rst)
      - [Commits](https://github.com/python-pillow/Pillow/compare/8.3.2...8.4.0)

      ```
      updated-dependencies:
      - dependency-name: pillow
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.0 to 3.3.1.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.0...3.3.1)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.0 to 3.3.1.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.0...3.3.1)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.60.0 to 2.61.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.60.0...v2.61.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [idna](https://github.com/kjd/idna) from 2.10 to 3.3.
      - [Release notes](https://github.com/kjd/idna/releases)
      - [Changelog](https://github.com/kjd/idna/blob/master/HISTORY.rst)
      - [Commits](https://github.com/kjd/idna/compare/v2.10...v3.3)

      ```
      updated-dependencies:
      - dependency-name: idna
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [cffi](http://cffi.readthedocs.org) from 1.14.6 to 1.15.0.

      ```
      updated-dependencies:
      - dependency-name: cffi
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [cffi](http://cffi.readthedocs.org) from 1.14.6 to 1.15.0.

      ```
      updated-dependencies:
      - dependency-name: cffi
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pyyaml](https://github.com/yaml/pyyaml) from 5.4.1 to 6.0.
      - [Release notes](https://github.com/yaml/pyyaml/releases)
      - [Changelog](https://github.com/yaml/pyyaml/blob/master/CHANGES)
      - [Commits](https://github.com/yaml/pyyaml/compare/5.4.1...6.0)

      ```
      updated-dependencies:
      - dependency-name: pyyaml
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.12.0 to 3.12.1.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/3.12.1/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.12.0...3.12.1)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.12.0 to 3.12.1.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/3.12.1/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.12.0...3.12.1)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pyparsing](https://github.com/pyparsing/pyparsing) from 2.4.7 to 3.0.1.
      - [Release notes](https://github.com/pyparsing/pyparsing/releases)
      - [Changelog](https://github.com/pyparsing/pyparsing/blob/master/CHANGES)
      - [Commits](https://github.com/pyparsing/pyparsing/compare/pyparsing_2.4.7...pyparsing_3.0.1)

      ```
      updated-dependencies:
      - dependency-name: pyparsing
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [pyparsing](https://github.com/pyparsing/pyparsing) from 2.4.7 to 3.0.1.
      - [Release notes](https://github.com/pyparsing/pyparsing/releases)
      - [Changelog](https://github.com/pyparsing/pyparsing/blob/master/CHANGES)
      - [Commits](https://github.com/pyparsing/pyparsing/compare/pyparsing_2.4.7...pyparsing_3.0.1)

      ```
      updated-dependencies:
      - dependency-name: pyparsing
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.1 to 3.3.2.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.1...3.3.2)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [cachecontrol](https://github.com/ionrock/cachecontrol) from 0.12.6 to 0.12.8.
      - [Release notes](https://github.com/ionrock/cachecontrol/releases)
      - [Changelog](https://github.com/ionrock/cachecontrol/blob/master/docs/release_notes.rst)
      - [Commits](https://github.com/ionrock/cachecontrol/compare/v0.12.6...v0.12.8)

      ```
      updated-dependencies:
      - dependency-name: cachecontrol
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.1 to 3.3.2.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.1...3.3.2)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [py](https://github.com/pytest-dev/py) from 1.10.0 to 1.11.0.
      - [Release notes](https://github.com/pytest-dev/py/releases)
      - [Changelog](https://github.com/pytest-dev/py/blob/master/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/py/compare/1.10.0...1.11.0)

      ```
      updated-dependencies:
      - dependency-name: py
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [cachecontrol](https://github.com/ionrock/cachecontrol) from 0.12.8 to 0.12.10.
      - [Release notes](https://github.com/ionrock/cachecontrol/releases)
      - [Changelog](https://github.com/ionrock/cachecontrol/blob/master/docs/release_notes.rst)
      - [Commits](https://github.com/ionrock/cachecontrol/compare/v0.12.8...v0.12.10)

      ```
      updated-dependencies:
      - dependency-name: cachecontrol
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pycparser](https://github.com/eliben/pycparser) from 2.20 to 2.21.
      - [Release notes](https://github.com/eliben/pycparser/releases)
      - [Changelog](https://github.com/eliben/pycparser/blob/master/CHANGES)
      - [Commits](https://github.com/eliben/pycparser/compare/release_v2.20...release_v2.21)

      ```
      updated-dependencies:
      - dependency-name: pycparser
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pycparser](https://github.com/eliben/pycparser) from 2.20 to 2.21.
      - [Release notes](https://github.com/eliben/pycparser/releases)
      - [Changelog](https://github.com/eliben/pycparser/blob/master/CHANGES)
      - [Commits](https://github.com/eliben/pycparser/compare/release_v2.20...release_v2.21)

      ```
      updated-dependencies:
      - dependency-name: pycparser
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [py](https://github.com/pytest-dev/py) from 1.10.0 to 1.11.0.
      - [Release notes](https://github.com/pytest-dev/py/releases)
      - [Changelog](https://github.com/pytest-dev/py/blob/master/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/py/compare/1.10.0...1.11.0)

      ```
      updated-dependencies:
      - dependency-name: py
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.61.0 to 2.62.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.61.0...v2.62.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.61.0 to 2.62.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.61.0...v2.62.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pyparsing](https://github.com/pyparsing/pyparsing) from 3.0.1 to 3.0.6.
      - [Release notes](https://github.com/pyparsing/pyparsing/releases)
      - [Changelog](https://github.com/pyparsing/pyparsing/blob/master/CHANGES)
      - [Commits](https://github.com/pyparsing/pyparsing/compare/pyparsing_3.0.1...pyparsing_3.0.6)

      ```
      updated-dependencies:
      - dependency-name: pyparsing
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pyparsing](https://github.com/pyparsing/pyparsing) from 3.0.1 to 3.0.6.
      - [Release notes](https://github.com/pyparsing/pyparsing/releases)
      - [Changelog](https://github.com/pyparsing/pyparsing/blob/master/CHANGES)
      - [Commits](https://github.com/pyparsing/pyparsing/compare/pyparsing_3.0.1...pyparsing_3.0.6)

      ```
      updated-dependencies:
      - dependency-name: pyparsing
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [websockets](https://github.com/aaugustin/websockets) from 10.0 to 10.1.
      - [Release notes](https://github.com/aaugustin/websockets/releases)
      - [Commits](https://github.com/aaugustin/websockets/compare/10.0...10.1)

      ```
      updated-dependencies:
      - dependency-name: websockets
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [python-dotenv](https://github.com/theskumar/python-dotenv) from 0.19.1 to 0.19.2.
      - [Release notes](https://github.com/theskumar/python-dotenv/releases)
      - [Changelog](https://github.com/theskumar/python-dotenv/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/theskumar/python-dotenv/compare/v0.19.1...v0.19.2)

      ```
      updated-dependencies:
      - dependency-name: python-dotenv
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.62.0 to 2.63.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.62.0...v2.63.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.62.0 to 2.63.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.62.0...v2.63.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [packaging](https://github.com/pypa/packaging) from 21.0 to 21.3.
      - [Release notes](https://github.com/pypa/packaging/releases)
      - [Changelog](https://github.com/pypa/packaging/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pypa/packaging/compare/21.0...21.3)

      ```
      updated-dependencies:
      - dependency-name: packaging
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.2 to 3.4.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.2...3.4.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.2 to 3.4.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.2...3.4.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 35.0.0 to 36.0.0.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/35.0.0...36.0.0)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 35.0.0 to 36.0.0.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/35.0.0...36.0.0)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.8.0 to 2.8.1.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.8.0...2.8.1)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [msgpack](https://github.com/msgpack/msgpack-python) from 1.0.2 to 1.0.3.
      - [Release notes](https://github.com/msgpack/msgpack-python/releases)
      - [Changelog](https://github.com/msgpack/msgpack-python/blob/main/ChangeLog.rst)
      - [Commits](https://github.com/msgpack/msgpack-python/compare/v1.0.2...v1.0.3)

      ```
      updated-dependencies:
      - dependency-name: msgpack
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.12.1 to 4.0.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/master/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.12.1...4.0)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.12.1 to 4.0.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/master/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.12.1...4.0)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps python from 3.10.0 to 3.10.1.

      ```
      updated-dependencies:
      - dependency-name: python
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pytest-xdist](https://github.com/pytest-dev/pytest-xdist) from 2.4.0 to 2.5.0.
      - [Release notes](https://github.com/pytest-dev/pytest-xdist/releases)
      - [Changelog](https://github.com/pytest-dev/pytest-xdist/blob/master/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest-xdist/compare/v2.4.0...v2.5.0)

      ```
      updated-dependencies:
      - dependency-name: pytest-xdist
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 4.0 to 4.0.1.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/4.0.1/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/4.0...4.0.1)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pytest-forked](https://github.com/pytest-dev/pytest-forked) from 1.3.0 to 1.4.0.
      - [Release notes](https://github.com/pytest-dev/pytest-forked/releases)
      - [Changelog](https://github.com/pytest-dev/pytest-forked/blob/master/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest-forked/compare/v1.3.0...v1.4.0)

      ```
      updated-dependencies:
      - dependency-name: pytest-forked
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 4.0 to 4.0.1.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/4.0.1/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/4.0...4.0.1)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 36.0.0 to 36.0.1.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/36.0.0...36.0.1)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pytest-timeout](https://github.com/pytest-dev/pytest-timeout) from 2.0.1 to 2.0.2.
      - [Release notes](https://github.com/pytest-dev/pytest-timeout/releases)
      - [Commits](https://github.com/pytest-dev/pytest-timeout/compare/2.0.1...2.0.2)

      ```
      updated-dependencies:
      - dependency-name: pytest-timeout
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 36.0.0 to 36.0.1.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/36.0.0...36.0.1)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.63.0 to 2.64.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.63.0...v2.64.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest-httpserver](https://github.com/csernazs/pytest-httpserver) from 1.0.2 to 1.0.3.
      - [Release notes](https://github.com/csernazs/pytest-httpserver/releases)
      - [Changelog](https://github.com/csernazs/pytest-httpserver/blob/master/CHANGES.rst)
      - [Commits](https://github.com/csernazs/pytest-httpserver/compare/1.0.2...1.0.3)

      ```
      updated-dependencies:
      - dependency-name: pytest-httpserver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.4.0 to 3.4.2.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.4.0...3.4.2)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.8.1 to 2.9.1.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.8.1...2.9.1)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.63.0 to 2.64.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.63.0...v2.64.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.4.0 to 3.4.2.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.4.0...3.4.2)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pillow](https://github.com/python-pillow/Pillow) from 8.4.0 to 9.0.0.
      - [Release notes](https://github.com/python-pillow/Pillow/releases)
      - [Changelog](https://github.com/python-pillow/Pillow/blob/main/CHANGES.rst)
      - [Commits](https://github.com/python-pillow/Pillow/compare/8.4.0...9.0.0)

      ```
      updated-dependencies:
      - dependency-name: pillow
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [attrs](https://github.com/python-attrs/attrs) from 21.2.0 to 21.4.0.
      - [Release notes](https://github.com/python-attrs/attrs/releases)
      - [Changelog](https://github.com/python-attrs/attrs/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/python-attrs/attrs/compare/21.2.0...21.4.0)

      ```
      updated-dependencies:
      - dependency-name: attrs
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [psutil](https://github.com/giampaolo/psutil) from 5.8.0 to 5.9.0.
      - [Release notes](https://github.com/giampaolo/psutil/releases)
      - [Changelog](https://github.com/giampaolo/psutil/blob/master/HISTORY.rst)
      - [Commits](https://github.com/giampaolo/psutil/compare/release-5.8.0...release-5.9.0)

      ```
      updated-dependencies:
      - dependency-name: psutil
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [attrs](https://github.com/python-attrs/attrs) from 21.2.0 to 21.4.0.
      - [Release notes](https://github.com/python-attrs/attrs/releases)
      - [Changelog](https://github.com/python-attrs/attrs/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/python-attrs/attrs/compare/21.2.0...21.4.0)

      ```
      updated-dependencies:
      - dependency-name: attrs
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pynacl](https://github.com/pyca/pynacl) from 1.4.0 to 1.5.0.
      - [Release notes](https://github.com/pyca/pynacl/releases)
      - [Changelog](https://github.com/pyca/pynacl/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/pynacl/compare/1.4.0...1.5.0)

      ```
      updated-dependencies:
      - dependency-name: pynacl
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [requests](https://github.com/psf/requests) from 2.26.0 to 2.27.1.
      - [Release notes](https://github.com/psf/requests/releases)
      - [Changelog](https://github.com/psf/requests/blob/main/HISTORY.md)
      - [Commits](https://github.com/psf/requests/compare/v2.26.0...v2.27.1)

      ```
      updated-dependencies:
      - dependency-name: requests
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.7 to 1.26.8.
      - [Release notes](https://github.com/urllib3/urllib3/releases)
      - [Changelog](https://github.com/urllib3/urllib3/blob/1.26.8/CHANGES.rst)
      - [Commits](https://github.com/urllib3/urllib3/compare/1.26.7...1.26.8)

      ```
      updated-dependencies:
      - dependency-name: urllib3
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.7 to 1.26.8.
      - [Release notes](https://github.com/urllib3/urllib3/releases)
      - [Changelog](https://github.com/urllib3/urllib3/blob/1.26.8/CHANGES.rst)
      - [Commits](https://github.com/urllib3/urllib3/compare/1.26.7...1.26.8)

      ```
      updated-dependencies:
      - dependency-name: urllib3
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.9.1 to 2.9.2.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.9.1...2.9.2)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [requests](https://github.com/psf/requests) from 2.26.0 to 2.27.1.
      - [Release notes](https://github.com/psf/requests/releases)
      - [Changelog](https://github.com/psf/requests/blob/main/HISTORY.md)
      - [Commits](https://github.com/psf/requests/compare/v2.26.0...v2.27.1)

      ```
      updated-dependencies:
      - dependency-name: requests
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pyrsistent](https://github.com/tobgu/pyrsistent) from 0.18.0 to 0.18.1.
      - [Release notes](https://github.com/tobgu/pyrsistent/releases)
      - [Changelog](https://github.com/tobgu/pyrsistent/blob/master/CHANGES.txt)
      - [Commits](https://github.com/tobgu/pyrsistent/compare/v0.18.0...v0.18.1)

      ```
      updated-dependencies:
      - dependency-name: pyrsistent
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```

#### inventory (4.1.0)

New changes in inventory since 4.0.0:

* add support for filtering datetimes (e.g. `updated_ts`)
  ([MEN-4644](https://northerntech.atlassian.net/browse/MEN-4644))
* new API end-point to remove a static group
  ([MEN-4826](https://northerntech.atlassian.net/browse/MEN-4826))
* Aggregated Dependabot Changelogs:
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.8.1 to 1.9.0.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.8.1...v1.9.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.2 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.2...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.7.4.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### inventory-enterprise (4.1.0)

New changes in inventory-enterprise since 4.0.0:

* new API end-point to remove a static group
  ([MEN-4826](https://northerntech.atlassian.net/browse/MEN-4826))
* fix filtering by datetime values (e.g. `updated_ts`)
  ([MEN-4644](https://northerntech.atlassian.net/browse/MEN-4644))
* Aggregated Dependabot Changelogs:
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.8.1 to 1.9.0.
      - [Release notes](https://github.com/spf13/viper/releases)
      - [Commits](https://github.com/spf13/viper/compare/v1.8.1...v1.9.0)

      ```
      updated-dependencies:
      - dependency-name: github.com/spf13/viper
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.11.0 to 8.11.4.
      - [Release notes](https://github.com/go-redis/redis/releases)
      - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/go-redis/redis/compare/v8.11.0...v8.11.4)

      ```
      updated-dependencies:
      - dependency-name: github.com/go-redis/redis/v8
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.2 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.2...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.7.4.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### iot-manager (1.0.0)

First release of iot-manager

_Released 20.01.22_

#### mtls-ambassador (1.0.1)

New changes in mtls-ambassador since 1.0.0:

* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### useradm (1.17.0)

New changes in useradm since 1.16.0:

* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.0 to 3.14.2.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.7.4.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### useradm-enterprise (1.17.0)

New changes in useradm-enterprise since 1.16.0:

* do not hard-code the email sender, rely on workflows' default
  ([MEN-5124](https://northerntech.atlassian.net/browse/MEN-5124))
* [] Implement OpenID Connect authentication flow
  ([MEN-5117](https://northerntech.atlassian.net/browse/MEN-5117))
* Upgrade from deprecated `golang.org/x/crypto/ssh/terminal` to
  `golang.org/x/term`
  ([QA-235](https://northerntech.atlassian.net/browse/QA-235))
* invalidate active JWT tokens on password reset
  ([MEN-5266](https://northerntech.atlassian.net/browse/MEN-5266))
* fix: extend the RBAC roles to support iot-manager
  ([MEN-5386](https://northerntech.atlassian.net/browse/MEN-5386))
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.0 to 3.14.2.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.11.0 to 8.11.4.
      - [Release notes](https://github.com/go-redis/redis/releases)
      - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/go-redis/redis/compare/v8.11.0...v8.11.4)

      ```
      updated-dependencies:
      - dependency-name: github.com/go-redis/redis/v8
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.7.4.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### workflows (2.2.0)

New changes in workflows since 2.1.0:

* add support for `Name <email@example.com>` mail sender/recipients
  ([MEN-5124](https://northerntech.atlassian.net/browse/MEN-5124))
* Version as optional parameter via X-Workflows-Min-Version.
  ([MEN-4554](https://northerntech.atlassian.net/browse/MEN-4554))
* Fix: do not add empty RFC822 headers (To, Cc, Bcc) in email messages
* Explicitly set type of Job.Status to int32 to avoid document growth
* new end-point to start a batch of workflow's jobs
  ([MEN-4843](https://northerntech.atlassian.net/browse/MEN-4843))
* new task type "NATS" to send messages over a NATS stream
  ([MEN-4843](https://northerntech.atlassian.net/browse/MEN-4843))
* Aggregated Dependabot Changelogs:
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.2 to 1.7.4.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.2...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.0 to 3.14.2.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.7.4.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### workflows-enterprise (2.2.0)

New changes in workflows-enterprise since 2.1.0:

* do not hard-code the email sender, use env WORKFLOWS_EMAIL_SENDER
  ([MEN-5124](https://northerntech.atlassian.net/browse/MEN-5124))
* add support for `Name <email@example.com>` mail sender/recipients
  ([MEN-5124](https://northerntech.atlassian.net/browse/MEN-5124))
* Version as optional parameter via X-Workflows-Min-Version.
  ([MEN-4554](https://northerntech.atlassian.net/browse/MEN-4554))
* Unit tests alignment.
  ([MEN-4554](https://northerntech.atlassian.net/browse/MEN-4554))
* Fix: do not add empty RFC822 headers (To, Cc, Bcc) in email messages
* Explicitly set type of Job.Status to int32 to avoid document growth
* new end-point to start a batch of workflow's jobs
  ([MEN-4843](https://northerntech.atlassian.net/browse/MEN-4843))
* new task type "NATS" to send messages over a NATS stream
  ([MEN-4843](https://northerntech.atlassian.net/browse/MEN-4843))
* Remove provisioning of tenants for deviceconnect and auditlogs
* Aggregated Dependabot Changelogs:
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.2 to 1.7.4.
      - [Release notes](https://github.com/gin-gonic/gin/releases)
      - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.2...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: github.com/gin-gonic/gin
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.0 to 3.14.2.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [google.golang.org/api](https://github.com/googleapis/google-api-go-client) from 0.48.0 to 0.58.0.
      - [Release notes](https://github.com/googleapis/google-api-go-client/releases)
      - [Changelog](https://github.com/googleapis/google-api-go-client/blob/master/CHANGES.md)
      - [Commits](https://github.com/googleapis/google-api-go-client/compare/v0.48.0...v0.58.0)

      ```
      updated-dependencies:
      - dependency-name: google.golang.org/api
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.7.3.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.7.3)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [google.golang.org/api](https://github.com/googleapis/google-api-go-client) from 0.58.0 to 0.60.0.
      - [Release notes](https://github.com/googleapis/google-api-go-client/releases)
      - [Changelog](https://github.com/googleapis/google-api-go-client/blob/master/CHANGES.md)
      - [Commits](https://github.com/googleapis/google-api-go-client/compare/v0.58.0...v0.60.0)

      ```
      updated-dependencies:
      - dependency-name: google.golang.org/api
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.7.3 to 1.7.4.
      - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
      - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.7.3...v1.7.4)

      ```
      updated-dependencies:
      - dependency-name: go.mongodb.org/mongo-driver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps alpine from 3.14.2 to 3.15.0.

      ```
      updated-dependencies:
      - dependency-name: alpine
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```

#### integration (3.2.0)

New changes in integration since 3.1.0:

* [] Fix demo script user creation race condition
  ([MEN-4852](https://northerntech.atlassian.net/browse/MEN-4852))
* Azure Get/Set settings backend integration test.
  ([MEN-5150](https://northerntech.atlassian.net/browse/MEN-5150))
* workflows requires nats, move the container to the main docker-compose.yml
* Unify the docker-compose version check through using the
  docker-compose version subcommand, as opposed to the --version flag when
  checking which docker-compose version is compatible with the current demo script.
* Upgrade auditlogs to 3.0.0.
* Upgrade create-artifact-worker to 1.1.0.
* Upgrade deployments-enterprise to 4.1.0.
* Upgrade deployments to 4.1.0.
* Add deviceauth-enterprise 3.2.0.
* Upgrade deviceauth to 3.2.0.
* Upgrade deviceconfig to 1.2.0.
* Upgrade deviceconnect to 1.3.0.
* Upgrade devicemonitor to 1.1.0.
* Upgrade gui to 3.2.0.
* Upgrade integration to 3.2.0.
* Upgrade inventory-enterprise to 4.1.0.
* Upgrade inventory to 4.1.0.
* Add iot-manager 1.0.0.
* Upgrade mender-artifact to 3.7.0.
* Add mender-binary-delta 1.3.0.
* Add mender-configure-module 1.0.3.
* Upgrade mender-connect to 2.0.0.
* Add mender-convert 2.6.1.
* Upgrade mender to 3.2.0.
* Upgrade monitor-client to 1.1.0.
* Upgrade mtls-ambassador to 1.0.1.
* Upgrade useradm-enterprise to 1.17.0.
* Upgrade useradm to 1.17.0.
* Upgrade workflows-enterprise to 2.2.0.
* Upgrade workflows to 2.2.0.
* Aggregated Dependabot Changelogs:
  * Bumps [websockets](https://github.com/aaugustin/websockets) from 9.1 to 10.0.
      - [Release notes](https://github.com/aaugustin/websockets/releases)
      - [Commits](https://github.com/aaugustin/websockets/compare/9.1...10.0)

      ```
      updated-dependencies:
      - dependency-name: websockets
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.0.12 to 3.1.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/v3.0.12...3.1.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest-xdist](https://github.com/pytest-dev/pytest-xdist) from 2.3.0 to 2.4.0.
      - [Release notes](https://github.com/pytest-dev/pytest-xdist/releases)
      - [Changelog](https://github.com/pytest-dev/pytest-xdist/blob/master/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest-xdist/compare/v2.3.0...v2.4.0)

      ```
      updated-dependencies:
      - dependency-name: pytest-xdist
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.6 to 1.26.7.
      - [Release notes](https://github.com/urllib3/urllib3/releases)
      - [Changelog](https://github.com/urllib3/urllib3/blob/main/CHANGES.rst)
      - [Commits](https://github.com/urllib3/urllib3/compare/1.26.6...1.26.7)

      ```
      updated-dependencies:
      - dependency-name: urllib3
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.0.12 to 3.1.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/v3.0.12...3.1.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [apipkg](https://github.com/pytest-dev/apipkg) from 1.5 to 2.0.0.
      - [Release notes](https://github.com/pytest-dev/apipkg/releases)
      - [Changelog](https://github.com/pytest-dev/apipkg/blob/main/CHANGELOG)
      - [Commits](https://github.com/pytest-dev/apipkg/compare/v1.5...v2.0.0)

      ```
      updated-dependencies:
      - dependency-name: apipkg
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.6 to 1.26.7.
      - [Release notes](https://github.com/urllib3/urllib3/releases)
      - [Changelog](https://github.com/urllib3/urllib3/blob/main/CHANGES.rst)
      - [Commits](https://github.com/urllib3/urllib3/compare/1.26.6...1.26.7)

      ```
      updated-dependencies:
      - dependency-name: urllib3
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.1.0 to 3.3.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.1.0...3.3.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.8 to 35.0.0.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/3.4.8...35.0.0)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.1.0 to 3.3.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.1.0...3.3.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.8 to 35.0.0.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/3.4.8...35.0.0)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps python from 3.9.7 to 3.10.0.

      ```
      updated-dependencies:
      - dependency-name: python
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [certifi](https://github.com/certifi/python-certifi) from 2021.5.30 to 2021.10.8.
      - [Release notes](https://github.com/certifi/python-certifi/releases)
      - [Commits](https://github.com/certifi/python-certifi/compare/2021.05.30...2021.10.08)

      ```
      updated-dependencies:
      - dependency-name: certifi
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [docker](https://github.com/docker/docker-py) from 5.0.2 to 5.0.3.
      - [Release notes](https://github.com/docker/docker-py/releases)
      - [Commits](https://github.com/docker/docker-py/compare/5.0.2...5.0.3)

      ```
      updated-dependencies:
      - dependency-name: docker
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.7.2 to 2.8.0.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.7.2...2.8.0)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest-timeout](https://github.com/pytest-dev/pytest-timeout) from 1.4.2 to 2.0.0.
      - [Release notes](https://github.com/pytest-dev/pytest-timeout/releases)
      - [Commits](https://github.com/pytest-dev/pytest-timeout/commits)

      ```
      updated-dependencies:
      - dependency-name: pytest-timeout
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [python-dotenv](https://github.com/theskumar/python-dotenv) from 0.19.0 to 0.19.1.
      - [Release notes](https://github.com/theskumar/python-dotenv/releases)
      - [Changelog](https://github.com/theskumar/python-dotenv/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/theskumar/python-dotenv/compare/v0.19.0...v0.19.1)

      ```
      updated-dependencies:
      - dependency-name: python-dotenv
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [apipkg](https://github.com/pytest-dev/apipkg) from 2.0.0 to 2.1.0.
      - [Release notes](https://github.com/pytest-dev/apipkg/releases)
      - [Changelog](https://github.com/pytest-dev/apipkg/blob/main/CHANGELOG)
      - [Commits](https://github.com/pytest-dev/apipkg/compare/v2.0.0...v2.1.0)

      ```
      updated-dependencies:
      - dependency-name: apipkg
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest-timeout](https://github.com/pytest-dev/pytest-timeout) from 2.0.0 to 2.0.1.
      - [Release notes](https://github.com/pytest-dev/pytest-timeout/releases)
      - [Commits](https://github.com/pytest-dev/pytest-timeout/commits)

      ```
      updated-dependencies:
      - dependency-name: pytest-timeout
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [idna](https://github.com/kjd/idna) from 2.10 to 3.3.
      - [Release notes](https://github.com/kjd/idna/releases)
      - [Changelog](https://github.com/kjd/idna/blob/master/HISTORY.rst)
      - [Commits](https://github.com/kjd/idna/compare/v2.10...v3.3)

      ```
      updated-dependencies:
      - dependency-name: idna
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [certifi](https://github.com/certifi/python-certifi) from 2021.5.30 to 2021.10.8.
      - [Release notes](https://github.com/certifi/python-certifi/releases)
      - [Commits](https://github.com/certifi/python-certifi/compare/2021.05.30...2021.10.08)

      ```
      updated-dependencies:
      - dependency-name: certifi
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [docker](https://github.com/docker/docker-py) from 5.0.2 to 5.0.3.
      - [Release notes](https://github.com/docker/docker-py/releases)
      - [Commits](https://github.com/docker/docker-py/compare/5.0.2...5.0.3)

      ```
      updated-dependencies:
      - dependency-name: docker
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.60.0 to 2.61.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.60.0...v2.61.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pyyaml](https://github.com/yaml/pyyaml) from 5.4.1 to 6.0.
      - [Release notes](https://github.com/yaml/pyyaml/releases)
      - [Changelog](https://github.com/yaml/pyyaml/blob/master/CHANGES)
      - [Commits](https://github.com/yaml/pyyaml/compare/5.4.1...6.0)

      ```
      updated-dependencies:
      - dependency-name: pyyaml
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [pillow](https://github.com/python-pillow/Pillow) from 8.3.2 to 8.4.0.
      - [Release notes](https://github.com/python-pillow/Pillow/releases)
      - [Changelog](https://github.com/python-pillow/Pillow/blob/main/CHANGES.rst)
      - [Commits](https://github.com/python-pillow/Pillow/compare/8.3.2...8.4.0)

      ```
      updated-dependencies:
      - dependency-name: pillow
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.0 to 3.3.1.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.0...3.3.1)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.0 to 3.3.1.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.0...3.3.1)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.60.0 to 2.61.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.60.0...v2.61.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [idna](https://github.com/kjd/idna) from 2.10 to 3.3.
      - [Release notes](https://github.com/kjd/idna/releases)
      - [Changelog](https://github.com/kjd/idna/blob/master/HISTORY.rst)
      - [Commits](https://github.com/kjd/idna/compare/v2.10...v3.3)

      ```
      updated-dependencies:
      - dependency-name: idna
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [cffi](http://cffi.readthedocs.org) from 1.14.6 to 1.15.0.

      ```
      updated-dependencies:
      - dependency-name: cffi
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [cffi](http://cffi.readthedocs.org) from 1.14.6 to 1.15.0.

      ```
      updated-dependencies:
      - dependency-name: cffi
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pyyaml](https://github.com/yaml/pyyaml) from 5.4.1 to 6.0.
      - [Release notes](https://github.com/yaml/pyyaml/releases)
      - [Changelog](https://github.com/yaml/pyyaml/blob/master/CHANGES)
      - [Commits](https://github.com/yaml/pyyaml/compare/5.4.1...6.0)

      ```
      updated-dependencies:
      - dependency-name: pyyaml
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.12.0 to 3.12.1.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/3.12.1/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.12.0...3.12.1)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.12.0 to 3.12.1.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/3.12.1/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.12.0...3.12.1)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pyparsing](https://github.com/pyparsing/pyparsing) from 2.4.7 to 3.0.1.
      - [Release notes](https://github.com/pyparsing/pyparsing/releases)
      - [Changelog](https://github.com/pyparsing/pyparsing/blob/master/CHANGES)
      - [Commits](https://github.com/pyparsing/pyparsing/compare/pyparsing_2.4.7...pyparsing_3.0.1)

      ```
      updated-dependencies:
      - dependency-name: pyparsing
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [pyparsing](https://github.com/pyparsing/pyparsing) from 2.4.7 to 3.0.1.
      - [Release notes](https://github.com/pyparsing/pyparsing/releases)
      - [Changelog](https://github.com/pyparsing/pyparsing/blob/master/CHANGES)
      - [Commits](https://github.com/pyparsing/pyparsing/compare/pyparsing_2.4.7...pyparsing_3.0.1)

      ```
      updated-dependencies:
      - dependency-name: pyparsing
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.1 to 3.3.2.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.1...3.3.2)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [cachecontrol](https://github.com/ionrock/cachecontrol) from 0.12.6 to 0.12.8.
      - [Release notes](https://github.com/ionrock/cachecontrol/releases)
      - [Changelog](https://github.com/ionrock/cachecontrol/blob/master/docs/release_notes.rst)
      - [Commits](https://github.com/ionrock/cachecontrol/compare/v0.12.6...v0.12.8)

      ```
      updated-dependencies:
      - dependency-name: cachecontrol
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.1 to 3.3.2.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.1...3.3.2)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [py](https://github.com/pytest-dev/py) from 1.10.0 to 1.11.0.
      - [Release notes](https://github.com/pytest-dev/py/releases)
      - [Changelog](https://github.com/pytest-dev/py/blob/master/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/py/compare/1.10.0...1.11.0)

      ```
      updated-dependencies:
      - dependency-name: py
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [cachecontrol](https://github.com/ionrock/cachecontrol) from 0.12.8 to 0.12.10.
      - [Release notes](https://github.com/ionrock/cachecontrol/releases)
      - [Changelog](https://github.com/ionrock/cachecontrol/blob/master/docs/release_notes.rst)
      - [Commits](https://github.com/ionrock/cachecontrol/compare/v0.12.8...v0.12.10)

      ```
      updated-dependencies:
      - dependency-name: cachecontrol
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pycparser](https://github.com/eliben/pycparser) from 2.20 to 2.21.
      - [Release notes](https://github.com/eliben/pycparser/releases)
      - [Changelog](https://github.com/eliben/pycparser/blob/master/CHANGES)
      - [Commits](https://github.com/eliben/pycparser/compare/release_v2.20...release_v2.21)

      ```
      updated-dependencies:
      - dependency-name: pycparser
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pycparser](https://github.com/eliben/pycparser) from 2.20 to 2.21.
      - [Release notes](https://github.com/eliben/pycparser/releases)
      - [Changelog](https://github.com/eliben/pycparser/blob/master/CHANGES)
      - [Commits](https://github.com/eliben/pycparser/compare/release_v2.20...release_v2.21)

      ```
      updated-dependencies:
      - dependency-name: pycparser
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [py](https://github.com/pytest-dev/py) from 1.10.0 to 1.11.0.
      - [Release notes](https://github.com/pytest-dev/py/releases)
      - [Changelog](https://github.com/pytest-dev/py/blob/master/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/py/compare/1.10.0...1.11.0)

      ```
      updated-dependencies:
      - dependency-name: py
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.61.0 to 2.62.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.61.0...v2.62.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.61.0 to 2.62.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.61.0...v2.62.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pyparsing](https://github.com/pyparsing/pyparsing) from 3.0.1 to 3.0.6.
      - [Release notes](https://github.com/pyparsing/pyparsing/releases)
      - [Changelog](https://github.com/pyparsing/pyparsing/blob/master/CHANGES)
      - [Commits](https://github.com/pyparsing/pyparsing/compare/pyparsing_3.0.1...pyparsing_3.0.6)

      ```
      updated-dependencies:
      - dependency-name: pyparsing
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pyparsing](https://github.com/pyparsing/pyparsing) from 3.0.1 to 3.0.6.
      - [Release notes](https://github.com/pyparsing/pyparsing/releases)
      - [Changelog](https://github.com/pyparsing/pyparsing/blob/master/CHANGES)
      - [Commits](https://github.com/pyparsing/pyparsing/compare/pyparsing_3.0.1...pyparsing_3.0.6)

      ```
      updated-dependencies:
      - dependency-name: pyparsing
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [websockets](https://github.com/aaugustin/websockets) from 10.0 to 10.1.
      - [Release notes](https://github.com/aaugustin/websockets/releases)
      - [Commits](https://github.com/aaugustin/websockets/compare/10.0...10.1)

      ```
      updated-dependencies:
      - dependency-name: websockets
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [python-dotenv](https://github.com/theskumar/python-dotenv) from 0.19.1 to 0.19.2.
      - [Release notes](https://github.com/theskumar/python-dotenv/releases)
      - [Changelog](https://github.com/theskumar/python-dotenv/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/theskumar/python-dotenv/compare/v0.19.1...v0.19.2)

      ```
      updated-dependencies:
      - dependency-name: python-dotenv
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.62.0 to 2.63.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.62.0...v2.63.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.62.0 to 2.63.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.62.0...v2.63.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [packaging](https://github.com/pypa/packaging) from 21.0 to 21.3.
      - [Release notes](https://github.com/pypa/packaging/releases)
      - [Changelog](https://github.com/pypa/packaging/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pypa/packaging/compare/21.0...21.3)

      ```
      updated-dependencies:
      - dependency-name: packaging
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.2 to 3.4.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.2...3.4.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.3.2 to 3.4.0.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.3.2...3.4.0)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 35.0.0 to 36.0.0.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/35.0.0...36.0.0)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 35.0.0 to 36.0.0.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/35.0.0...36.0.0)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.8.0 to 2.8.1.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.8.0...2.8.1)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [msgpack](https://github.com/msgpack/msgpack-python) from 1.0.2 to 1.0.3.
      - [Release notes](https://github.com/msgpack/msgpack-python/releases)
      - [Changelog](https://github.com/msgpack/msgpack-python/blob/main/ChangeLog.rst)
      - [Commits](https://github.com/msgpack/msgpack-python/compare/v1.0.2...v1.0.3)

      ```
      updated-dependencies:
      - dependency-name: msgpack
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.12.1 to 4.0.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/master/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.12.1...4.0)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.12.1 to 4.0.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/master/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.12.1...4.0)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps python from 3.10.0 to 3.10.1.

      ```
      updated-dependencies:
      - dependency-name: python
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pytest-xdist](https://github.com/pytest-dev/pytest-xdist) from 2.4.0 to 2.5.0.
      - [Release notes](https://github.com/pytest-dev/pytest-xdist/releases)
      - [Changelog](https://github.com/pytest-dev/pytest-xdist/blob/master/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest-xdist/compare/v2.4.0...v2.5.0)

      ```
      updated-dependencies:
      - dependency-name: pytest-xdist
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 4.0 to 4.0.1.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/4.0.1/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/4.0...4.0.1)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pytest-forked](https://github.com/pytest-dev/pytest-forked) from 1.3.0 to 1.4.0.
      - [Release notes](https://github.com/pytest-dev/pytest-forked/releases)
      - [Changelog](https://github.com/pytest-dev/pytest-forked/blob/master/CHANGELOG.rst)
      - [Commits](https://github.com/pytest-dev/pytest-forked/compare/v1.3.0...v1.4.0)

      ```
      updated-dependencies:
      - dependency-name: pytest-forked
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 4.0 to 4.0.1.
      - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
      - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/4.0.1/doc/changelog.rst)
      - [Commits](https://github.com/mongodb/mongo-python-driver/compare/4.0...4.0.1)

      ```
      updated-dependencies:
      - dependency-name: pymongo
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 36.0.0 to 36.0.1.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/36.0.0...36.0.1)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pytest-timeout](https://github.com/pytest-dev/pytest-timeout) from 2.0.1 to 2.0.2.
      - [Release notes](https://github.com/pytest-dev/pytest-timeout/releases)
      - [Commits](https://github.com/pytest-dev/pytest-timeout/compare/2.0.1...2.0.2)

      ```
      updated-dependencies:
      - dependency-name: pytest-timeout
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 36.0.0 to 36.0.1.
      - [Release notes](https://github.com/pyca/cryptography/releases)
      - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/cryptography/compare/36.0.0...36.0.1)

      ```
      updated-dependencies:
      - dependency-name: cryptography
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.63.0 to 2.64.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.63.0...v2.64.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pytest-httpserver](https://github.com/csernazs/pytest-httpserver) from 1.0.2 to 1.0.3.
      - [Release notes](https://github.com/csernazs/pytest-httpserver/releases)
      - [Changelog](https://github.com/csernazs/pytest-httpserver/blob/master/CHANGES.rst)
      - [Commits](https://github.com/csernazs/pytest-httpserver/compare/1.0.2...1.0.3)

      ```
      updated-dependencies:
      - dependency-name: pytest-httpserver
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.4.0 to 3.4.2.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.4.0...3.4.2)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.8.1 to 2.9.1.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.8.1...2.9.1)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.63.0 to 2.64.0.
      - [Release notes](https://github.com/stripe/stripe-python/releases)
      - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
      - [Commits](https://github.com/stripe/stripe-python/compare/v2.63.0...v2.64.0)

      ```
      updated-dependencies:
      - dependency-name: stripe
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [filelock](https://github.com/tox-dev/py-filelock) from 3.4.0 to 3.4.2.
      - [Release notes](https://github.com/tox-dev/py-filelock/releases)
      - [Changelog](https://github.com/tox-dev/py-filelock/blob/main/docs/changelog.rst)
      - [Commits](https://github.com/tox-dev/py-filelock/compare/3.4.0...3.4.2)

      ```
      updated-dependencies:
      - dependency-name: filelock
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [pillow](https://github.com/python-pillow/Pillow) from 8.4.0 to 9.0.0.
      - [Release notes](https://github.com/python-pillow/Pillow/releases)
      - [Changelog](https://github.com/python-pillow/Pillow/blob/main/CHANGES.rst)
      - [Commits](https://github.com/python-pillow/Pillow/compare/8.4.0...9.0.0)

      ```
      updated-dependencies:
      - dependency-name: pillow
        dependency-type: direct:production
        update-type: version-update:semver-major
      ```
  * Bumps [attrs](https://github.com/python-attrs/attrs) from 21.2.0 to 21.4.0.
      - [Release notes](https://github.com/python-attrs/attrs/releases)
      - [Changelog](https://github.com/python-attrs/attrs/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/python-attrs/attrs/compare/21.2.0...21.4.0)

      ```
      updated-dependencies:
      - dependency-name: attrs
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [psutil](https://github.com/giampaolo/psutil) from 5.8.0 to 5.9.0.
      - [Release notes](https://github.com/giampaolo/psutil/releases)
      - [Changelog](https://github.com/giampaolo/psutil/blob/master/HISTORY.rst)
      - [Commits](https://github.com/giampaolo/psutil/compare/release-5.8.0...release-5.9.0)

      ```
      updated-dependencies:
      - dependency-name: psutil
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [attrs](https://github.com/python-attrs/attrs) from 21.2.0 to 21.4.0.
      - [Release notes](https://github.com/python-attrs/attrs/releases)
      - [Changelog](https://github.com/python-attrs/attrs/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/python-attrs/attrs/compare/21.2.0...21.4.0)

      ```
      updated-dependencies:
      - dependency-name: attrs
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pynacl](https://github.com/pyca/pynacl) from 1.4.0 to 1.5.0.
      - [Release notes](https://github.com/pyca/pynacl/releases)
      - [Changelog](https://github.com/pyca/pynacl/blob/main/CHANGELOG.rst)
      - [Commits](https://github.com/pyca/pynacl/compare/1.4.0...1.5.0)

      ```
      updated-dependencies:
      - dependency-name: pynacl
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [requests](https://github.com/psf/requests) from 2.26.0 to 2.27.1.
      - [Release notes](https://github.com/psf/requests/releases)
      - [Changelog](https://github.com/psf/requests/blob/main/HISTORY.md)
      - [Commits](https://github.com/psf/requests/compare/v2.26.0...v2.27.1)

      ```
      updated-dependencies:
      - dependency-name: requests
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.7 to 1.26.8.
      - [Release notes](https://github.com/urllib3/urllib3/releases)
      - [Changelog](https://github.com/urllib3/urllib3/blob/1.26.8/CHANGES.rst)
      - [Commits](https://github.com/urllib3/urllib3/compare/1.26.7...1.26.8)

      ```
      updated-dependencies:
      - dependency-name: urllib3
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.7 to 1.26.8.
      - [Release notes](https://github.com/urllib3/urllib3/releases)
      - [Changelog](https://github.com/urllib3/urllib3/blob/1.26.8/CHANGES.rst)
      - [Commits](https://github.com/urllib3/urllib3/compare/1.26.7...1.26.8)

      ```
      updated-dependencies:
      - dependency-name: urllib3
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [paramiko](https://github.com/paramiko/paramiko) from 2.9.1 to 2.9.2.
      - [Release notes](https://github.com/paramiko/paramiko/releases)
      - [Changelog](https://github.com/paramiko/paramiko/blob/main/NEWS)
      - [Commits](https://github.com/paramiko/paramiko/compare/2.9.1...2.9.2)

      ```
      updated-dependencies:
      - dependency-name: paramiko
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```
  * Bumps [requests](https://github.com/psf/requests) from 2.26.0 to 2.27.1.
      - [Release notes](https://github.com/psf/requests/releases)
      - [Changelog](https://github.com/psf/requests/blob/main/HISTORY.md)
      - [Commits](https://github.com/psf/requests/compare/v2.26.0...v2.27.1)

      ```
      updated-dependencies:
      - dependency-name: requests
        dependency-type: direct:production
        update-type: version-update:semver-minor
      ```
  * Bumps [pyrsistent](https://github.com/tobgu/pyrsistent) from 0.18.0 to 0.18.1.
      - [Release notes](https://github.com/tobgu/pyrsistent/releases)
      - [Changelog](https://github.com/tobgu/pyrsistent/blob/master/CHANGES.txt)
      - [Commits](https://github.com/tobgu/pyrsistent/compare/v0.18.0...v0.18.1)

      ```
      updated-dependencies:
      - dependency-name: pyrsistent
        dependency-type: direct:production
        update-type: version-update:semver-patch
      ```


## Mender 3.1.1

_Released 02.09.2022_

### Statistics

A total of 733 lines added, 495 removed (delta 238)

| Developers with the most changesets | |
|---|---|
| Lluis Campos | 12 (34.3%) |
| Ole Petter Orhagen | 6 (17.1%) |
| Alf-Rune Siqveland | 5 (14.3%) |
| Fabio Tranchitella | 4 (11.4%) |
| Manuel Zedel | 4 (11.4%) |
| Peter Grzybowski | 2 (5.7%) |
| Emilio Rodríguez | 1 (2.9%) |
| Krzysztof Jaskiewicz | 1 (2.9%) |

| Developers with the most changed lines | |
|---|---|
| Alf-Rune Siqveland | 307 (33.2%) |
| Fabio Tranchitella | 195 (21.1%) |
| Lluis Campos | 160 (17.3%) |
| Ole Petter Orhagen | 120 (13.0%) |
| Manuel Zedel | 65 (7.0%) |
| Peter Grzybowski | 50 (5.4%) |
| Emilio Rodríguez | 14 (1.5%) |
| Krzysztof Jaskiewicz | 13 (1.4%) |

| Developers with the most lines removed | |
|---|---|
| Alf-Rune Siqveland | 97 (19.6%) |
| Manuel Zedel | 34 (6.9%) |
| Krzysztof Jaskiewicz | 13 (2.6%) |

| Developers with the most signoffs (total 6) | |
|---|---|
| Ole Petter Orhagen | 3 (50.0%) |
| Lluis Campos | 2 (33.3%) |
| Fabio Tranchitella | 1 (16.7%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 33 (94.3%) |
| RnDity | 1 (2.9%) |
| Sentinel.tech | 1 (2.9%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 897 (97.1%) |
| Sentinel.tech | 14 (1.5%) |
| RnDity | 13 (1.4%) |

| Employers with the most signoffs (total 6) | |
|---|---|
| Northern.tech | 6 (100.0%) |

| Employers with the most hackers (total 8) | |
|---|---|
| Northern.tech | 6 (75.0%) |
| Sentinel.tech | 1 (12.5%) |
| RnDity | 1 (12.5%) |

## Changelogs

#### create-artifact-worker (1.0.3)

New changes in create-artifact-worker since 1.0.2:

* Dockerfile: lock base image mendersoftware/workflows to mender-3.1.x

#### deployments (4.0.1)

New changes in deployments since 4.0.0:

* Fix bucket initialization
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.2 to 3.15.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### deployments-enterprise (4.0.1)

New changes in deployments-enterprise since 4.0.0:

* Fix bucket initialization
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.2 to 3.15.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### devicemonitor (1.0.1)

New changes in devicemonitor since 1.0.0:

* [] Allow alerts to contain empty log lines
  ([MEN-5256](https://northerntech.atlassian.net/browse/MEN-5256))

#### gui (3.1.1)

New changes in gui since 3.1.0:

* xtermjs interprets string as UTF-16
  ([MEN-4771](https://northerntech.atlassian.net/browse/MEN-4771))
* fixed an issue that could prevent creating phased deployments for dynamic groups
* Restore support for Open Source Production setups in bash
  snippets used during on-boarding and on "Connect a Device" dialog.
  ([MEN-5107](https://northerntech.atlassian.net/browse/MEN-5107))
* fixed an issue that limited profile edits to passwords, now editing the own email address is possible again

#### inventory-enterprise (4.0.1)

New changes in inventory-enterprise since 4.0.0:

* fix filtering by datetime values (e.g. `updated_ts`)
  ([MEN-4644](https://northerntech.atlassian.net/browse/MEN-4644))

#### mtls-ambassador (1.0.1)

New changes in mtls-ambassador since 1.0.0:

* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.2 to 3.15.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### integration (3.1.1)

New changes in integration since 3.1.0:

* [] Fix demo script user creation race condition
  ([MEN-4852](https://northerntech.atlassian.net/browse/MEN-4852))
* Unify the docker-compose version check through using the
  docker-compose version subcommand, as opposed to the --version flag when
  checking which docker-compose version is compatible with the current demo script.
* Upgrade create-artifact-worker to 1.0.3.
* Upgrade deployments-enterprise to 4.0.1.
* Upgrade deployments to 4.0.1.
* Upgrade devicemonitor to 1.0.1.
* Upgrade gui to 3.1.1.
* Upgrade integration to 3.1.1.
* Upgrade inventory-enterprise to 4.0.1.
* Upgrade inventory to 4.0.1.
* Upgrade mender-connect to 1.2.1.
* Upgrade mender to 3.1.1.
* Upgrade monitor-client to 1.0.1.
* Upgrade mtls-ambassador to 1.0.1.


## Mender 3.1.0

_Released 09.28.2021_

### Statistics

A total of 19873 lines added, 7222 removed (delta 12651)

| Developers with the most changesets | |
|---|---|
| Manuel Zedel | 125 (33.4%) |
| Fabio Tranchitella | 90 (24.1%) |
| Lluis Campos | 44 (11.8%) |
| Alf-Rune Siqveland | 27 (7.2%) |
| Peter Grzybowski | 21 (5.6%) |
| Alex Miliukov | 19 (5.1%) |
| Marcin Chalczynski | 14 (3.7%) |
| Krzysztof Jaskiewicz | 13 (3.5%) |
| Kristian Amlie | 10 (2.7%) |
| Ole Petter Orhagen | 9 (2.4%) |

| Developers with the most changed lines | |
|---|---|
| Manuel Zedel | 5139 (23.8%) |
| Fabio Tranchitella | 4770 (22.1%) |
| Alex Miliukov | 2673 (12.4%) |
| Alf-Rune Siqveland | 2337 (10.8%) |
| Krzysztof Jaskiewicz | 2186 (10.1%) |
| Peter Grzybowski | 1594 (7.4%) |
| Ole Petter Orhagen | 1365 (6.3%) |
| Lluis Campos | 729 (3.4%) |
| Marcin Chalczynski | 637 (3.0%) |
| Kristian Amlie | 109 (0.5%) |

| Developers with the most lines removed | |
|---|---|
| Lluis Campos | 133 (1.8%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 346 (92.5%) |
| RnDity | 27 (7.2%) |
| prashanthjbabu@gmail.com | 1 (0.3%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 18741 (86.9%) |
| RnDity | 2823 (13.1%) |
| prashanthjbabu@gmail.com | 2 (0.0%) |

| Employers with the most hackers (total 12) | |
|---|---|
| Northern.tech | 9 (75.0%) |
| RnDity | 2 (16.7%) |
| prashanthjbabu@gmail.com | 1 (8.3%) |

## Changelogs

#### auditlogs (2.0.0)

New changes in auditlogs since 1.2.0:

* Internal API end-point, move /health/alive to /alive to match code base
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.7.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.7.2)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps alpine from 3.14.0 to 3.14.2.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.2 to 1.7.4.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.2...v1.7.4)
    ---
    updated-dependencies:
    - dependency-name: github.com/gin-gonic/gin
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...

#### deployments (4.0.0)

New changes in deployments since 3.0.0:

* datastore_mongo: fix nil pointer dereference
* remove the CORS middleware, rely on the API gateway instead
  ([MEN-4921](https://northerntech.atlassian.net/browse/MEN-4921))
* move the /deployments/devices/{id} end-point to internal
  ([MEN-4525](https://northerntech.atlassian.net/browse/MEN-4525))
* [] Listing devices in deployment sorts by statuses
  ([MEN-4847](https://northerntech.atlassian.net/browse/MEN-4847))
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.6.0.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.6.0)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.38.17 to 1.39.4.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.38.17...v1.39.4)
    ---
    updated-dependencies:
    - dependency-name: github.com/aws/aws-sdk-go
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps golang from 1.14-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.2.0 to 1.3.0.
    - [Release notes](https://github.com/google/uuid/releases)
    - [Commits](https://github.com/google/uuid/compare/v1.2.0...v1.3.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/google/uuid
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps alpine from 3.14.0 to 3.14.2.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.39.4 to 1.40.37.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.39.4...v1.40.37)
    ---
    updated-dependencies:
    - dependency-name: github.com/aws/aws-sdk-go
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.6.0 to 1.7.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.6.0...v1.7.2)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### deployments-enterprise (4.0.0)

New changes in deployments-enterprise since 3.0.0:

* datastore_mongo: fix nil pointer dereference
* add update control map evaluation
  ([MEN-4906](https://northerntech.atlassian.net/browse/MEN-4906))
* remove the CORS middleware, rely on the API gateway instead
  ([MEN-4921](https://northerntech.atlassian.net/browse/MEN-4921))
* move the /deployments/devices/{id} end-point to internal
  ([MEN-4525](https://northerntech.atlassian.net/browse/MEN-4525))
* [] Listing devices in deployment sorts by statuses
  ([MEN-4847](https://northerntech.atlassian.net/browse/MEN-4847))
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.6.0.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.6.0)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.38.17 to 1.39.4.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.38.17...v1.39.4)
    ---
    updated-dependencies:
    - dependency-name: github.com/aws/aws-sdk-go
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.38.17 to 1.39.5.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.38.17...v1.39.5)
    ---
    updated-dependencies:
    - dependency-name: github.com/aws/aws-sdk-go
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.6.0.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.6.0)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps golang from 1.14-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.2.0 to 1.3.0.
    - [Release notes](https://github.com/google/uuid/releases)
    - [Commits](https://github.com/google/uuid/compare/v1.2.0...v1.3.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/google/uuid
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps alpine from 3.14.0 to 3.14.2.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.39.4 to 1.40.37.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.39.4...v1.40.37)
    ---
    updated-dependencies:
    - dependency-name: github.com/aws/aws-sdk-go
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.6.0 to 1.7.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.6.0...v1.7.2)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### deviceauth (3.1.0)

New changes in deviceauth since 3.0.0:

* add support for fallback RSA private key
  ([MEN-3152](https://northerntech.atlassian.net/browse/MEN-3152))
* remove the CORS middleware, rely on the API gateway instead
  ([MEN-4921](https://northerntech.atlassian.net/browse/MEN-4921))
* [] Restrict access to monitor APIs to devices with monitor add-on
  ([MEN-5077](https://northerntech.atlassian.net/browse/MEN-5077))
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.10.0 to 8.11.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.10.0...v8.11.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/go-redis/redis/v8
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### deviceconnect (1.2.1)

New changes in deviceconnect since 1.2.0:

* store the correct offset in the recordings control messages
  ([MEN-4770](https://northerntech.atlassian.net/browse/MEN-4770))

#### devicemonitor (1.0.0)

* First release of devicemonitor

#### gui (3.1.0)

New changes in gui since 3.0.0:

* added copy capabilities & sha checksum to device authset information
  ([MEN-4791](https://northerntech.atlassian.net/browse/MEN-4791))
* fixed an issue that caused the deployment report to crash due to missing update control information
* added role dependent (admin only) notification muting to global settings
  ([MEN-4757](https://northerntech.atlassian.net/browse/MEN-4757))
* device details now show monitoring information if monitor add-on is enabled
  ([MEN-4787](https://northerntech.atlassian.net/browse/MEN-4787))
* added monitor to addon selection
  ([MEN-4836](https://northerntech.atlassian.net/browse/MEN-4836))
* fixed an issue that caused the page selection in the device list to change unintended
* fixed an issue that caused release tab to crash when release generation takes longer than releases retrieval
* added device list tag display & editing capabilties to device details
  ([MEN-4755](https://northerntech.atlassian.net/browse/MEN-4755))
* made artifact creation more restrictive to not allow creation without device types or invalid paths
  ([MEN-4933](https://northerntech.atlassian.net/browse/MEN-4933))
* fixed an issue that caused the device list to misbehave when quickly changing pages
  ([MEN-4932](https://northerntech.atlassian.net/browse/MEN-4932))
* Adjust help text to say that RPi image is merely Mender ready.
* require the current one when updating the user's password
  ([MEN-4922](https://northerntech.atlassian.net/browse/MEN-4922))
* Install Mender commercial add-ons (namely: mender-monitor)
  during user on-boarding.
  ([MEN-4759](https://northerntech.atlassian.net/browse/MEN-4759))
* switched device deployment progress to no longer show assumed progress
  ([MEN-5025](https://northerntech.atlassian.net/browse/MEN-5025))
* ensure copied authset pubkey contains empty newline if it exists already
* fixed an issue that prevented getting to devices based on their software in the overall device distribution
* fixed an issue that prevented filter selections from being persisted
* fixed an issue that prevented changes in monitoring issues from being reflected in the devicelist
  ([MEN-5113](https://northerntech.atlassian.net/browse/MEN-5113))
* Aggregated Dependabot Changelogs:
  * Bumps nginx from 1.21.0-alpine to 1.21.1-alpine.
    ---
    updated-dependencies:
    - dependency-name: nginx
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps node from 16.3.0-alpine to 16.4.2-alpine.
    ---
    updated-dependencies:
    - dependency-name: node
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [dayjs](https://github.com/iamkun/dayjs) from 1.10.5 to 1.10.6.
    - [Release notes](https://github.com/iamkun/dayjs/releases)
    - [Changelog](https://github.com/iamkun/dayjs/blob/v1.10.6/CHANGELOG.md)
    - [Commits](https://github.com/iamkun/dayjs/compare/v1.10.5...v1.10.6)
    ---
    updated-dependencies:
    - dependency-name: dayjs
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [msw](https://github.com/mswjs/msw) from 0.30.1 to 0.31.0.
    - [Release notes](https://github.com/mswjs/msw/releases)
    - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/mswjs/msw/compare/v0.30.1...v0.31.0)
    ---
    updated-dependencies:
    - dependency-name: msw
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.15.1 to 1.16.0.
    - [Release notes](https://github.com/stripe/stripe-js/releases)
    - [Commits](https://github.com/stripe/stripe-js/compare/v1.15.1...v1.16.0)
    ---
    updated-dependencies:
    - dependency-name: "@stripe/stripe-js"
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.2.6 to 10.3.0.
    - [Release notes](https://github.com/postcss/autoprefixer/releases)
    - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/autoprefixer/compare/10.2.6...10.3.0)
    ---
    updated-dependencies:
    - dependency-name: autoprefixer
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.43.0 to 5.44.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.43.0...v5.44.0)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 11.0.0 to 11.0.1.
    - [Release notes](https://github.com/okonet/lint-staged/releases)
    - [Commits](https://github.com/okonet/lint-staged/compare/v11.0.0...v11.0.1)
    ---
    updated-dependencies:
    - dependency-name: lint-staged
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.3.0 to 10.3.1.
    - [Release notes](https://github.com/postcss/autoprefixer/releases)
    - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/autoprefixer/compare/10.3.0...10.3.1)
    ---
    updated-dependencies:
    - dependency-name: autoprefixer
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps node from 16.4.2-alpine to 16.5.0-alpine.
    ---
    updated-dependencies:
    - dependency-name: node
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 13.1.9 to 13.2.0.
    - [Release notes](https://github.com/testing-library/user-event/releases)
    - [Changelog](https://github.com/testing-library/user-event/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/user-event/compare/v13.1.9...v13.2.0)
    ---
    updated-dependencies:
    - dependency-name: "@testing-library/user-event"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [eslint](https://github.com/eslint/eslint) from 7.30.0 to 7.31.0.
    - [Release notes](https://github.com/eslint/eslint/releases)
    - [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/eslint/eslint/compare/v7.30.0...v7.31.0)
    ---
    updated-dependencies:
    - dependency-name: eslint
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [msw](https://github.com/mswjs/msw) from 0.31.0 to 0.32.0.
    - [Release notes](https://github.com/mswjs/msw/releases)
    - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/mswjs/msw/compare/v0.31.0...v0.32.0)
    ---
    updated-dependencies:
    - dependency-name: msw
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@reduxjs/toolkit](https://github.com/reduxjs/redux-toolkit) from 1.6.0 to 1.6.1.
    - [Release notes](https://github.com/reduxjs/redux-toolkit/releases)
    - [Commits](https://github.com/reduxjs/redux-toolkit/compare/v1.6.0...v1.6.1)
    ---
    updated-dependencies:
    - dependency-name: "@reduxjs/toolkit"
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 5.2.6 to 6.1.0.
    - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/css-loader/compare/v5.2.6...v6.1.0)
    ---
    updated-dependencies:
    - dependency-name: css-loader
      dependency-type: direct:development
      update-type: version-update:semver-major
    ...
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.9.0 to 35.9.1.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.9.0...v35.9.1)
    ---
    updated-dependencies:
    - dependency-name: victory
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.44.0 to 5.45.1.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.44.0...v5.45.1)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.12.3 to 1.13.0.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.12.3...v1.13.0)
    ---
    updated-dependencies:
    - dependency-name: playwright
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 6.1.0 to 6.2.0.
    - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/css-loader/compare/v6.1.0...v6.2.0)
    ---
    updated-dependencies:
    - dependency-name: css-loader
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [generate-password](https://github.com/brendanashworth/generate-password) from 1.6.0 to 1.6.1.
    - [Release notes](https://github.com/brendanashworth/generate-password/releases)
    - [Changelog](https://github.com/brendanashworth/generate-password/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/brendanashworth/generate-password/compare/v1.6.0...v1.6.1)
    ---
    updated-dependencies:
    - dependency-name: generate-password
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.9.1 to 35.9.3.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.9.1...v35.9.3)
    ---
    updated-dependencies:
    - dependency-name: victory
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps playwright from v1.12.3 to v1.13.0.
    ---
    updated-dependencies:
    - dependency-name: playwright
      dependency-type: direct:production
    ...
  * Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 13.2.0 to 13.2.1.
    - [Release notes](https://github.com/testing-library/user-event/releases)
    - [Changelog](https://github.com/testing-library/user-event/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/user-event/compare/v13.2.0...v13.2.1)
    ---
    updated-dependencies:
    - dependency-name: "@testing-library/user-event"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.45.1 to 5.46.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.45.1...v5.46.0)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.14.7 to 7.14.8.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.8/packages/babel-preset-env)
    ---
    updated-dependencies:
    - dependency-name: "@babel/preset-env"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.14.6 to 7.14.8.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.8/packages/babel-core)
    ---
    updated-dependencies:
    - dependency-name: "@babel/core"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [msw](https://github.com/mswjs/msw) from 0.32.0 to 0.33.0.
    - [Release notes](https://github.com/mswjs/msw/releases)
    - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/mswjs/msw/compare/v0.32.0...v0.33.0)
    ---
    updated-dependencies:
    - dependency-name: msw
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [eslint-webpack-plugin](https://github.com/webpack-contrib/eslint-webpack-plugin) from 2.5.4 to 3.0.1.
    - [Release notes](https://github.com/webpack-contrib/eslint-webpack-plugin/releases)
    - [Changelog](https://github.com/webpack-contrib/eslint-webpack-plugin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/eslint-webpack-plugin/compare/v2.5.4...v3.0.1)
    ---
    updated-dependencies:
    - dependency-name: eslint-webpack-plugin
      dependency-type: direct:development
      update-type: version-update:semver-major
    ...
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.3.5 to 8.3.6.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.3.5...8.3.6)
    ---
    updated-dependencies:
    - dependency-name: postcss
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 11.0.1 to 11.1.1.
    - [Release notes](https://github.com/okonet/lint-staged/releases)
    - [Commits](https://github.com/okonet/lint-staged/compare/v11.0.1...v11.1.1)
    ---
    updated-dependencies:
    - dependency-name: lint-staged
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.46.0 to 5.47.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.46.0...v5.47.0)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [yarn](https://github.com/yarnpkg/yarn) from 1.22.10 to 1.22.11.
    - [Release notes](https://github.com/yarnpkg/yarn/releases)
    - [Changelog](https://github.com/yarnpkg/yarn/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/yarnpkg/yarn/compare/1.22.10...1.22.11)
    ---
    updated-dependencies:
    - dependency-name: yarn
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.33.5 to 0.33.6.
    - [Release notes](https://github.com/jquense/react-big-calendar/releases)
    - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.33.5...v0.33.6)
    ---
    updated-dependencies:
    - dependency-name: react-big-calendar
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [msw](https://github.com/mswjs/msw) from 0.33.0 to 0.33.1.
    - [Release notes](https://github.com/mswjs/msw/releases)
    - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/mswjs/msw/compare/v0.33.0...v0.33.1)
    ---
    updated-dependencies:
    - dependency-name: msw
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.15.2 to 3.16.0.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/compare/v3.15.2...v3.16.0)
    ---
    updated-dependencies:
    - dependency-name: core-js
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.47.0 to 5.47.1.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.47.0...v5.47.1)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps node from 16.5.0-alpine to 16.6.0-alpine.
    ---
    updated-dependencies:
    - dependency-name: node
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.13.0 to 1.13.1.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.13.0...v1.13.1)
    ---
    updated-dependencies:
    - dependency-name: playwright
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.12.3 to 1.13.1.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.12.3...v1.13.1)
    ---
    updated-dependencies:
    - dependency-name: "@playwright/test"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [eslint](https://github.com/eslint/eslint) from 7.31.0 to 7.32.0.
    - [Release notes](https://github.com/eslint/eslint/releases)
    - [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/eslint/eslint/compare/v7.31.0...v7.32.0)
    ---
    updated-dependencies:
    - dependency-name: eslint
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@babel/eslint-parser](https://github.com/babel/babel/tree/HEAD/eslint/babel-eslint-parser) from 7.14.7 to 7.14.9.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.9/eslint/babel-eslint-parser)
    ---
    updated-dependencies:
    - dependency-name: "@babel/eslint-parser"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps playwright from v1.13.0 to v1.13.1.
    ---
    updated-dependencies:
    - dependency-name: playwright
      dependency-type: direct:production
    ...
  * Bumps [msw](https://github.com/mswjs/msw) from 0.33.1 to 0.33.2.
    - [Release notes](https://github.com/mswjs/msw/releases)
    - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/mswjs/msw/compare/v0.33.1...v0.33.2)
    ---
    updated-dependencies:
    - dependency-name: msw
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.14.8 to 7.14.9.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.9/packages/babel-preset-env)
    ---
    updated-dependencies:
    - dependency-name: "@babel/preset-env"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.12.3 to 1.13.1.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.12.3...v1.13.1)
    ---
    updated-dependencies:
    - dependency-name: playwright-chromium
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.14.9 to 7.15.0.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.15.0/packages/babel-preset-env)
    ---
    updated-dependencies:
    - dependency-name: "@babel/preset-env"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 11.1.1 to 11.1.2.
    - [Release notes](https://github.com/okonet/lint-staged/releases)
    - [Commits](https://github.com/okonet/lint-staged/compare/v11.1.1...v11.1.2)
    ---
    updated-dependencies:
    - dependency-name: lint-staged
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps node from 16.6.0-alpine to 16.7.0-alpine.
    ---
    updated-dependencies:
    - dependency-name: node
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [msw](https://github.com/mswjs/msw) from 0.33.2 to 0.35.0.
    - [Release notes](https://github.com/mswjs/msw/releases)
    - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/mswjs/msw/compare/v0.33.2...v0.35.0)
    ---
    updated-dependencies:
    - dependency-name: msw
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.13.1 to 2.15.1.
    - [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
    - [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.13.1...v2.15.1)
    ---
    updated-dependencies:
    - dependency-name: esbuild-loader
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.16.0 to 3.16.2.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/compare/v3.16.0...v3.16.2)
    ---
    updated-dependencies:
    - dependency-name: core-js
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.1.0 to 2.2.0.
    - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
    - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.1.0...v2.2.0)
    ---
    updated-dependencies:
    - dependency-name: mini-css-extract-plugin
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [eslint-plugin-prettier](https://github.com/prettier/eslint-plugin-prettier) from 3.4.0 to 3.4.1.
    - [Release notes](https://github.com/prettier/eslint-plugin-prettier/releases)
    - [Changelog](https://github.com/prettier/eslint-plugin-prettier/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/prettier/eslint-plugin-prettier/commits)
    ---
    updated-dependencies:
    - dependency-name: eslint-plugin-prettier
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.3.1 to 10.3.2.
    - [Release notes](https://github.com/postcss/autoprefixer/releases)
    - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/autoprefixer/compare/10.3.1...10.3.2)
    ---
    updated-dependencies:
    - dependency-name: autoprefixer
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.16.0 to 1.17.1.
    - [Release notes](https://github.com/stripe/stripe-js/releases)
    - [Commits](https://github.com/stripe/stripe-js/compare/v1.16.0...v1.17.1)
    ---
    updated-dependencies:
    - dependency-name: "@stripe/stripe-js"
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.33.6 to 0.35.0.
    - [Release notes](https://github.com/jquense/react-big-calendar/releases)
    - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.33.6...v0.35.0)
    ---
    updated-dependencies:
    - dependency-name: react-big-calendar
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [webpack-cli](https://github.com/webpack/webpack-cli) from 4.7.2 to 4.8.0.
    - [Release notes](https://github.com/webpack/webpack-cli/releases)
    - [Changelog](https://github.com/webpack/webpack-cli/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack/webpack-cli/compare/webpack-cli@4.7.2...webpack-cli@4.8.0)
    ---
    updated-dependencies:
    - dependency-name: webpack-cli
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [axios-mock-adapter](https://github.com/ctimmerm/axios-mock-adapter) from 1.19.0 to 1.20.0.
    - [Release notes](https://github.com/ctimmerm/axios-mock-adapter/releases)
    - [Changelog](https://github.com/ctimmerm/axios-mock-adapter/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/ctimmerm/axios-mock-adapter/compare/v1.19.0...v1.20.0)
    ---
    updated-dependencies:
    - dependency-name: axios-mock-adapter
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [react-copy-to-clipboard](https://github.com/nkbt/react-copy-to-clipboard) from 5.0.3 to 5.0.4.
    - [Release notes](https://github.com/nkbt/react-copy-to-clipboard/releases)
    - [Commits](https://github.com/nkbt/react-copy-to-clipboard/compare/v5.0.3...v5.0.4)
    ---
    updated-dependencies:
    - dependency-name: react-copy-to-clipboard
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [@babel/eslint-parser](https://github.com/babel/babel/tree/HEAD/eslint/babel-eslint-parser) from 7.14.9 to 7.15.0.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.15.0/eslint/babel-eslint-parser)
    ---
    updated-dependencies:
    - dependency-name: "@babel/eslint-parser"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.9.3 to 35.10.1.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.9.3...v35.10.1)
    ---
    updated-dependencies:
    - dependency-name: victory
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.14.5 to 7.15.0.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.15.0/packages/babel-plugin-transform-runtime)
    ---
    updated-dependencies:
    - dependency-name: "@babel/plugin-transform-runtime"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.14.8 to 7.15.0.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.15.0/packages/babel-core)
    ---
    updated-dependencies:
    - dependency-name: "@babel/core"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.47.1 to 5.51.1.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.47.1...v5.51.1)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [eslint-plugin-sonarjs](https://github.com/SonarSource/eslint-plugin-sonarjs) from 0.9.1 to 0.10.0.
    - [Release notes](https://github.com/SonarSource/eslint-plugin-sonarjs/releases)
    - [Commits](https://github.com/SonarSource/eslint-plugin-sonarjs/compare/0.9.1...0.10.0)
    ---
    updated-dependencies:
    - dependency-name: eslint-plugin-sonarjs
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.16.2 to 3.16.3.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/compare/v3.16.2...v3.16.3)
    ---
    updated-dependencies:
    - dependency-name: core-js
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [husky](https://github.com/typicode/husky) from 7.0.1 to 7.0.2.
    - [Release notes](https://github.com/typicode/husky/releases)
    - [Commits](https://github.com/typicode/husky/compare/v7.0.1...v7.0.2)
    ---
    updated-dependencies:
    - dependency-name: husky
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.10.1 to 35.11.0.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.10.1...v35.11.0)
    ---
    updated-dependencies:
    - dependency-name: victory
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.1.0 to 8.1.1.
    - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
    - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.1.0...v8.1.1)
    ---
    updated-dependencies:
    - dependency-name: "@testing-library/dom"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps node from 16.7.0-alpine to 16.8.0-alpine.
    ---
    updated-dependencies:
    - dependency-name: node
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.14.0 to 1.14.1.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.14.0...v1.14.1)
    ---
    updated-dependencies:
    - dependency-name: playwright-chromium
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@playwright/test](https://github.com/Microsoft/playwright) from 1.14.0 to 1.14.1.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.14.0...v1.14.1)
    ---
    updated-dependencies:
    - dependency-name: "@playwright/test"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.1.1 to 8.2.0.
    - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
    - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.1.1...v8.2.0)
    ---
    updated-dependencies:
    - dependency-name: "@testing-library/dom"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps playwright from v1.14.0 to v1.14.1.
    ---
    updated-dependencies:
    - dependency-name: playwright
      dependency-type: direct:production
    ...
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.3.2 to 10.3.3.
    - [Release notes](https://github.com/postcss/autoprefixer/releases)
    - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/autoprefixer/compare/10.3.2...10.3.3)
    ---
    updated-dependencies:
    - dependency-name: autoprefixer
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.0.6 to 27.1.0.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/commits/v27.1.0/packages/jest-resolve)
    ---
    updated-dependencies:
    - dependency-name: jest-resolve
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [react-router-dom](https://github.com/ReactTraining/react-router) from 5.2.0 to 5.2.1.
    - [Release notes](https://github.com/ReactTraining/react-router/releases)
    - [Changelog](https://github.com/remix-run/react-router/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/ReactTraining/react-router/compare/v5.2.0...v5.2.1)
    ---
    updated-dependencies:
    - dependency-name: react-router-dom
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.3.5 to 4.4.2.
    - [Release notes](https://github.com/Microsoft/TypeScript/releases)
    - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.3.5...v4.4.2)
    ---
    updated-dependencies:
    - dependency-name: typescript
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.14.0 to 1.14.1.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.14.0...v1.14.1)
    ---
    updated-dependencies:
    - dependency-name: playwright
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.24.0 to 7.25.1.
    - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
    - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.24.0...v7.25.1)
    ---
    updated-dependencies:
    - dependency-name: eslint-plugin-react
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.16.3 to 3.16.4.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/compare/v3.16.3...v3.16.4)
    ---
    updated-dependencies:
    - dependency-name: core-js
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.0.6 to 27.1.0.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/commits/v27.1.0/packages/babel-jest)
    ---
    updated-dependencies:
    - dependency-name: babel-jest
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [jest](https://github.com/facebook/jest) from 27.0.6 to 27.1.0.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/compare/v27.0.6...v27.1.0)
    ---
    updated-dependencies:
    - dependency-name: jest
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [axios](https://github.com/axios/axios) from 0.21.1 to 0.21.3.
    - [Release notes](https://github.com/axios/axios/releases)
    - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/axios/axios/compare/v0.21.1...0.21.3)
    ---
    updated-dependencies:
    - dependency-name: axios
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.15.0 to 7.15.5.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.15.5/packages/babel-core)
    ---
    updated-dependencies:
    - dependency-name: "@babel/core"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [eslint-plugin-prettier](https://github.com/prettier/eslint-plugin-prettier) from 3.4.1 to 4.0.0.
    - [Release notes](https://github.com/prettier/eslint-plugin-prettier/releases)
    - [Changelog](https://github.com/prettier/eslint-plugin-prettier/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/prettier/eslint-plugin-prettier/commits/v4.0.0)
    ---
    updated-dependencies:
    - dependency-name: eslint-plugin-prettier
      dependency-type: direct:development
      update-type: version-update:semver-major
    ...
  * Bumps [react-redux](https://github.com/reduxjs/react-redux) from 7.2.4 to 7.2.5.
    - [Release notes](https://github.com/reduxjs/react-redux/releases)
    - [Changelog](https://github.com/reduxjs/react-redux/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/reduxjs/react-redux/compare/v7.2.4...v7.2.5)
    ---
    updated-dependencies:
    - dependency-name: react-redux
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.2.0 to 2.2.2.
    - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
    - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.2.0...v2.2.2)
    ---
    updated-dependencies:
    - dependency-name: mini-css-extract-plugin
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.51.1 to 5.52.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.51.1...v5.52.0)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [axios](https://github.com/axios/axios) from 0.21.1 to 0.21.3.
    - [Release notes](https://github.com/axios/axios/releases)
    - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/axios/axios/compare/v0.21.1...0.21.3)
    ---
    updated-dependencies:
    - dependency-name: axios
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [@babel/eslint-parser](https://github.com/babel/babel/tree/HEAD/eslint/babel-eslint-parser) from 7.15.0 to 7.15.4.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.15.4/eslint/babel-eslint-parser)
    ---
    updated-dependencies:
    - dependency-name: "@babel/eslint-parser"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.15.0 to 7.15.4.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.15.4/packages/babel-preset-env)
    ---
    updated-dependencies:
    - dependency-name: "@babel/preset-env"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.11.0 to 35.11.4.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.11.0...v35.11.4)
    ---
    updated-dependencies:
    - dependency-name: victory
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [react-router-dom](https://github.com/ReactTraining/react-router) from 5.2.1 to 5.3.0.
    - [Release notes](https://github.com/ReactTraining/react-router/releases)
    - [Changelog](https://github.com/remix-run/react-router/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/ReactTraining/react-router/compare/v5.2.1...v5.3.0)
    ---
    updated-dependencies:
    - dependency-name: react-router-dom
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.16.4 to 3.17.2.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/compare/v3.16.4...v3.17.2)
    ---
    updated-dependencies:
    - dependency-name: core-js
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.3.3 to 10.3.4.
    - [Release notes](https://github.com/postcss/autoprefixer/releases)
    - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/autoprefixer/compare/10.3.3...10.3.4)
    ---
    updated-dependencies:
    - dependency-name: autoprefixer
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [clean-webpack-plugin](https://github.com/johnagan/clean-webpack-plugin) from 3.0.0 to 4.0.0.
    - [Release notes](https://github.com/johnagan/clean-webpack-plugin/releases)
    - [Commits](https://github.com/johnagan/clean-webpack-plugin/compare/v3.0.0...v4.0.0)
    ---
    updated-dependencies:
    - dependency-name: clean-webpack-plugin
      dependency-type: direct:development
      update-type: version-update:semver-major
    ...
  * Bumps nginx from 1.21.1-alpine to 1.21.3-alpine.
    ---
    updated-dependencies:
    - dependency-name: nginx
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps node from 16.8.0-alpine to 16.9.0-alpine.
    ---
    updated-dependencies:
    - dependency-name: node
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [dayjs](https://github.com/iamkun/dayjs) from 1.10.6 to 1.10.7.
    - [Release notes](https://github.com/iamkun/dayjs/releases)
    - [Changelog](https://github.com/iamkun/dayjs/blob/v1.10.7/CHANGELOG.md)
    - [Commits](https://github.com/iamkun/dayjs/compare/v1.10.6...v1.10.7)
    ---
    updated-dependencies:
    - dependency-name: dayjs
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.1.0 to 27.1.1.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/commits/v27.1.1/packages/babel-jest)
    ---
    updated-dependencies:
    - dependency-name: babel-jest
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.4.2 to 4.4.3.
    - [Release notes](https://github.com/Microsoft/TypeScript/releases)
    - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.4.2...v4.4.3)
    ---
    updated-dependencies:
    - dependency-name: typescript
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.15.4 to 7.15.6.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.15.6/packages/babel-preset-env)
    ---
    updated-dependencies:
    - dependency-name: "@babel/preset-env"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@testing-library/react](https://github.com/testing-library/react-testing-library) from 12.0.0 to 12.1.0.
    - [Release notes](https://github.com/testing-library/react-testing-library/releases)
    - [Changelog](https://github.com/testing-library/react-testing-library/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/react-testing-library/compare/v12.0.0...v12.1.0)
    ---
    updated-dependencies:
    - dependency-name: "@testing-library/react"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@mdi/js](https://github.com/Templarian/MaterialDesign-JS) from 5.9.55 to 6.1.95.
    - [Release notes](https://github.com/Templarian/MaterialDesign-JS/releases)
    - [Commits](https://github.com/Templarian/MaterialDesign-JS/compare/v5.9.55...v6.1.95)
    ---
    updated-dependencies:
    - dependency-name: "@mdi/js"
      dependency-type: direct:production
      update-type: version-update:semver-major
    ...
  * Bumps [axios](https://github.com/axios/axios) from 0.21.3 to 0.21.4.
    - [Release notes](https://github.com/axios/axios/releases)
    - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/axios/axios/compare/0.21.3...v0.21.4)
    ---
    updated-dependencies:
    - dependency-name: axios
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 8.2.0 to 8.5.0.
    - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
    - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/dom-testing-library/compare/v8.2.0...v8.5.0)
    ---
    updated-dependencies:
    - dependency-name: "@testing-library/dom"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [axios](https://github.com/axios/axios) from 0.21.3 to 0.21.4.
    - [Release notes](https://github.com/axios/axios/releases)
    - [Changelog](https://github.com/axios/axios/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/axios/axios/compare/0.21.3...v0.21.4)
    ---
    updated-dependencies:
    - dependency-name: axios
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [jest](https://github.com/facebook/jest) from 27.1.0 to 27.2.0.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/compare/v27.1.0...v27.2.0)
    ---
    updated-dependencies:
    - dependency-name: jest
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.52.0 to 5.52.1.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.52.0...v5.52.1)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 27.1.1 to 27.2.0.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/commits/v27.2.0/packages/babel-jest)
    ---
    updated-dependencies:
    - dependency-name: babel-jest
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.1.0 to 27.2.0.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/commits/v27.2.0/packages/jest-resolve)
    ---
    updated-dependencies:
    - dependency-name: jest-resolve
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.2.2 to 2.3.0.
    - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
    - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.2.2...v2.3.0)
    ---
    updated-dependencies:
    - dependency-name: mini-css-extract-plugin
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.11.4 to 36.0.0.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.11.4...v36.0.0)
    ---
    updated-dependencies:
    - dependency-name: victory
      dependency-type: direct:production
      update-type: version-update:semver-major
    ...
  * Bumps [core-js](https://github.com/zloirock/core-js) from 3.17.2 to 3.17.3.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/compare/v3.17.2...v3.17.3)
    ---
    updated-dependencies:
    - dependency-name: core-js
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [xterm-addon-search](https://github.com/xtermjs/xterm.js) from 0.8.0 to 0.8.1.
    - [Release notes](https://github.com/xtermjs/xterm.js/releases)
    - [Commits](https://github.com/xtermjs/xterm.js/commits)
    ---
    updated-dependencies:
    - dependency-name: xterm-addon-search
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [react-dropzone](https://github.com/react-dropzone/react-dropzone) from 11.3.4 to 11.4.0.
    - [Release notes](https://github.com/react-dropzone/react-dropzone/releases)
    - [Commits](https://github.com/react-dropzone/react-dropzone/compare/v11.3.4...v11.4.0)
    ---
    updated-dependencies:
    - dependency-name: react-dropzone
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### inventory (4.0.0)

New changes in inventory since 3.0.0:

* PUT and PATCH device tags management endpoints
  ([MEN-2342](https://northerntech.atlassian.net/browse/MEN-2342))
* apply configurable limits to tags (20) and inventory (100)
  ([MEN-4781](https://northerntech.atlassian.net/browse/MEN-4781))
* remove the CORS middleware, rely on the API gateway instead
  ([MEN-4921](https://northerntech.atlassian.net/browse/MEN-4921))
* improve device decommissioning and inventory data reset
  ([MEN-4525](https://northerntech.atlassian.net/browse/MEN-4525))
* internal endpoint for reindexing monitor data
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.8.0 to 1.8.1.
    - [Release notes](https://github.com/spf13/viper/releases)
    - [Commits](https://github.com/spf13/viper/compare/v1.8.0...v1.8.1)
    ---
    updated-dependencies:
    - dependency-name: github.com/spf13/viper
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.7.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.7.2)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps alpine from 3.14.0 to 3.14.2.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.2.0 to 1.3.0.
    - [Release notes](https://github.com/google/uuid/releases)
    - [Commits](https://github.com/google/uuid/compare/v1.2.0...v1.3.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/google/uuid
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### inventory-enterprise (4.0.0)

New changes in inventory-enterprise since 3.0.0:

* PUT and PATCH device tags management endpoints
  ([MEN-2342](https://northerntech.atlassian.net/browse/MEN-2342))
* apply configurable limits to tags (20) and inventory (100)
  ([MEN-4781](https://northerntech.atlassian.net/browse/MEN-4781))
* remove the CORS middleware, rely on the API gateway instead
  ([MEN-4921](https://northerntech.atlassian.net/browse/MEN-4921))
* improve device decommissioning and inventory data reset
  ([MEN-4525](https://northerntech.atlassian.net/browse/MEN-4525))
* internal endpoint for reindexing monitor data
* Aggregated Dependabot Changelogs:
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.8.0 to 1.8.1.
    - [Release notes](https://github.com/spf13/viper/releases)
    - [Commits](https://github.com/spf13/viper/compare/v1.8.0...v1.8.1)
    ---
    updated-dependencies:
    - dependency-name: github.com/spf13/viper
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.8.0 to 1.8.1.
    - [Release notes](https://github.com/spf13/viper/releases)
    - [Commits](https://github.com/spf13/viper/compare/v1.8.0...v1.8.1)
    ---
    updated-dependencies:
    - dependency-name: github.com/spf13/viper
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.10.0 to 8.11.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.10.0...v8.11.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/go-redis/redis/v8
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.6.0.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.6.0)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.2.0 to 1.3.0.
    - [Release notes](https://github.com/google/uuid/releases)
    - [Commits](https://github.com/google/uuid/compare/v1.2.0...v1.3.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/google/uuid
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps alpine from 3.14.0 to 3.14.1.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps alpine from 3.14.1 to 3.14.2.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.7.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.7.2)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps alpine from 3.14.0 to 3.14.2.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.2.0 to 1.3.0.
    - [Release notes](https://github.com/google/uuid/releases)
    - [Commits](https://github.com/google/uuid/compare/v1.2.0...v1.3.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/google/uuid
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### tenantadm (3.3.0)

New changes in tenantadm since 3.2.0:

* update API docs and/or API implementation to make it congruent
  ([MEN-4670](https://northerntech.atlassian.net/browse/MEN-4670))
* default tenant API limits, overridable with env variable
  ([MEN-4661](https://northerntech.atlassian.net/browse/MEN-4661))
* add-on plan change requests saved data to spreadsheet
  ([MEN-4890](https://northerntech.atlassian.net/browse/MEN-4890))
* add support for the monitor add-on
  ([MEN-4831](https://northerntech.atlassian.net/browse/MEN-4831))
* remove the CORS middleware, rely on the API gateway instead
  ([MEN-4921](https://northerntech.atlassian.net/browse/MEN-4921))
* FIX: Token invalidation when updating add-ons
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.7.1 to 1.8.1.
    - [Release notes](https://github.com/spf13/viper/releases)
    - [Commits](https://github.com/spf13/viper/compare/v1.7.1...v1.8.1)
    ---
    updated-dependencies:
    - dependency-name: github.com/spf13/viper
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...

#### useradm (1.16.0)

New changes in useradm since 1.15.0:

* add support for fallback RSA private key
  ([MEN-3153](https://northerntech.atlassian.net/browse/MEN-3153))
* remove the CORS middleware, rely on the API gateway instead
  ([MEN-4921](https://northerntech.atlassian.net/browse/MEN-4921))
* require the current one when updating the user's password
  ([MEN-4922](https://northerntech.atlassian.net/browse/MEN-4922))
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...

#### useradm-enterprise (1.16.0)

New changes in useradm-enterprise since 1.15.0:

* update the RemoteTerminal role, fix download url whitelisting
  ([MEN-4675](https://northerntech.atlassian.net/browse/MEN-4675))
* add rate limit protection to the password reset end-point
  ([MEN-4884](https://northerntech.atlassian.net/browse/MEN-4884))
* add rate limit protection to the email verification end-point
  ([MEN-4884](https://northerntech.atlassian.net/browse/MEN-4884))
* new internal endpoint for getting users' email addresses of users with access to a given device
  ([MEN-4833](https://northerntech.atlassian.net/browse/MEN-4833))
* Fix authorization control in useradm (read-only role)
  ([MEN-4918](https://northerntech.atlassian.net/browse/MEN-4918))
* add support for fallback RSA private key
  ([MEN-3153](https://northerntech.atlassian.net/browse/MEN-3153))
* remove the CORS middleware, rely on the API gateway instead
  ([MEN-4921](https://northerntech.atlassian.net/browse/MEN-4921))
* require the current one when updating the user's password
  ([MEN-4922](https://northerntech.atlassian.net/browse/MEN-4922))
* forbid updates to OAuth 2 users
  ([MEN-4920](https://northerntech.atlassian.net/browse/MEN-4920))
* make it possible to re-enable 2FA
  It is possible to enable 2FA and leave the page (or refresh) without
  finishing the process. In that case the 2FA will stuck in the unverified
  state. Attempt to re-enabling 2FA will be unsuccessfull (the server will
  return HTTP 400 Bad Request).
  With this change it will be possible to easily recover from 2FA unverified
  state. ([MEN-5026](https://northerntech.atlassian.net/browse/MEN-5026))
* [] Restrict access to monitor APIs to users with monitor add-on
  ([MEN-5071](https://northerntech.atlassian.net/browse/MEN-5071))
* extend observer role with permission to access devicemonitor endpoints
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.10.0 to 8.11.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.10.0...v8.11.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/go-redis/redis/v8
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### workflows (2.1.0)

New changes in workflows since 2.0.0:

* do not use upsert when acquiring jobs
  ([MEN-4923](https://northerntech.atlassian.net/browse/MEN-4923))
* BCC support and CC fixes
  ([MEN-4998](https://northerntech.atlassian.net/browse/MEN-4998))
* use internal end-points to provision and decommission devices
  ([MEN-4525](https://northerntech.atlassian.net/browse/MEN-4525))
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...

#### workflows-enterprise (2.1.0)

New changes in workflows-enterprise since 2.0.0:

* do not use upsert when acquiring jobs
  ([MEN-4923](https://northerntech.atlassian.net/browse/MEN-4923))
* Year increment in the emails footers
* Monitoring: official email templates.
  ([MEN-4935](https://northerntech.atlassian.net/browse/MEN-4935))
* BCC support and CC fixes
  ([MEN-4998](https://northerntech.atlassian.net/browse/MEN-4998))
* use internal end-points to provision and decommission devices
  ([MEN-4525](https://northerntech.atlassian.net/browse/MEN-4525))
* Monitoring align the email templates.
  ([MEN-5036](https://northerntech.atlassian.net/browse/MEN-5036))
* Monitoring: log pattern and file path in the emails
  ([MEN-4979](https://northerntech.atlassian.net/browse/MEN-4979))
* Aggregated Dependabot Changelogs:
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.3 to 1.5.4.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.3...v1.5.4)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.4 to 1.6.0.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.4...v1.6.0)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### integration (3.1.0)

New changes in integration since 3.0.0:

* update RBAC tests for configuration deployments
  With new, simplified RBAC we do not support any other actions than
  VIEW_DEVICE when it comes to group permissions.
  If user can view the device then user is allowed to deploy to the
  device too.
* [ENT] Enable Redis for JWT and tenant settings cache by default
* Fix: Traefik is proxying minio requests on (80,443) ports, not on 9000
* Bumped Traefik from 2.4 to 2.5
* New demo certificate with Subject Alternative Names field
* Updated keygen script, replaced env parameters
  CERT_(API|STORAGE)_CN with CERT_CN and CERT_SAN for setting certificate
  Common Name and Subject Alternative Name.
* API gateway requires TLS 1.2 or later
* Upgrade auditlogs to 2.0.0.
* Upgrade deployments-enterprise to 4.0.0.
* Upgrade deployments to 4.0.0.
* Upgrade deviceauth to 3.1.0.
* Upgrade deviceconnect to 1.2.1.
* Upgrade devicemonitor to 1.0.0.
* Upgrade gui to 3.1.0.
* Upgrade integration to 3.1.0.
* Upgrade inventory-enterprise to 4.0.0.
* Upgrade inventory to 4.0.0.
* Upgrade mender-artifact to 3.6.1.
* Upgrade mender to 3.1.0.
* Add monitor-client 1.0.0.
* Upgrade tenantadm to 3.3.0.
* Upgrade useradm-enterprise to 1.16.0.
* Upgrade useradm to 1.16.0.
* Upgrade workflows-enterprise to 2.1.0.
* Upgrade workflows to 2.1.0.
* Aggregated Dependabot Changelogs:
  * Bumps python from 3.9.5 to 3.9.6.
    ---
    updated-dependencies:
    - dependency-name: python
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [packaging](https://github.com/pypa/packaging) from 20.9 to 21.0.
    - [Release notes](https://github.com/pypa/packaging/releases)
    - [Changelog](https://github.com/pypa/packaging/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pypa/packaging/compare/20.9...21.0)
    ---
    updated-dependencies:
    - dependency-name: packaging
      dependency-type: direct:production
      update-type: version-update:semver-major
    ...
  * Bumps [pillow](https://github.com/python-pillow/Pillow) from 8.2.0 to 8.3.0.
    - [Release notes](https://github.com/python-pillow/Pillow/releases)
    - [Changelog](https://github.com/python-pillow/Pillow/blob/master/CHANGES.rst)
    - [Commits](https://github.com/python-pillow/Pillow/compare/8.2.0...8.3.0)
    ---
    updated-dependencies:
    - dependency-name: pillow
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [pyrsistent](https://github.com/tobgu/pyrsistent) from 0.17.3 to 0.18.0.
    - [Release notes](https://github.com/tobgu/pyrsistent/releases)
    - [Changelog](https://github.com/tobgu/pyrsistent/blob/master/CHANGES.txt)
    - [Commits](https://github.com/tobgu/pyrsistent/compare/v0.17.3...v0.18.0)
    ---
    updated-dependencies:
    - dependency-name: pyrsistent
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [pathlib2](https://github.com/mcmtroffaes/pathlib2) from 2.3.5 to 2.3.6.
    - [Release notes](https://github.com/mcmtroffaes/pathlib2/releases)
    - [Changelog](https://github.com/mcmtroffaes/pathlib2/blob/develop/CHANGELOG.rst)
    - [Commits](https://github.com/mcmtroffaes/pathlib2/compare/2.3.5...2.3.6)
    ---
    updated-dependencies:
    - dependency-name: pathlib2
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [cffi](http://cffi.readthedocs.org) from 1.14.5 to 1.14.6.
    ---
    updated-dependencies:
    - dependency-name: cffi
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [invoke](https://github.com/bitprophet/alabaster) from 1.5.0 to 1.6.0.
    - [Release notes](https://github.com/bitprophet/alabaster/releases)
    - [Changelog](https://github.com/bitprophet/alabaster/blob/master/docs/changelog.rst)
    - [Commits](https://github.com/bitprophet/alabaster/commits)
    ---
    updated-dependencies:
    - dependency-name: invoke
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [cffi](http://cffi.readthedocs.org) from 1.14.5 to 1.14.6.
    ---
    updated-dependencies:
    - dependency-name: cffi
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [pillow](https://github.com/python-pillow/Pillow) from 8.3.0 to 8.3.1.
    - [Release notes](https://github.com/python-pillow/Pillow/releases)
    - [Changelog](https://github.com/python-pillow/Pillow/blob/master/CHANGES.rst)
    - [Commits](https://github.com/python-pillow/Pillow/compare/8.3.0...8.3.1)
    ---
    updated-dependencies:
    - dependency-name: pillow
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [requests](https://github.com/psf/requests) from 2.25.1 to 2.26.0.
    - [Release notes](https://github.com/psf/requests/releases)
    - [Changelog](https://github.com/psf/requests/blob/master/HISTORY.md)
    - [Commits](https://github.com/psf/requests/compare/v2.25.1...v2.26.0)
    ---
    updated-dependencies:
    - dependency-name: requests
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [texttable](https://github.com/foutaise/texttable) from 1.6.3 to 1.6.4.
    - [Release notes](https://github.com/foutaise/texttable/releases)
    - [Changelog](https://github.com/foutaise/texttable/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/foutaise/texttable/compare/v1.6.3...v1.6.4)
    ---
    updated-dependencies:
    - dependency-name: texttable
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.58.0 to 2.60.0.
    - [Release notes](https://github.com/stripe/stripe-python/releases)
    - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/stripe/stripe-python/compare/v2.58.0...v2.60.0)
    ---
    updated-dependencies:
    - dependency-name: stripe
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.58.0 to 2.60.0.
    - [Release notes](https://github.com/stripe/stripe-python/releases)
    - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/stripe/stripe-python/compare/v2.58.0...v2.60.0)
    ---
    updated-dependencies:
    - dependency-name: stripe
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.11.4 to 3.12.0.
    - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
    - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/3.12.0/doc/changelog.rst)
    - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.11.4...3.12.0)
    ---
    updated-dependencies:
    - dependency-name: pymongo
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [requests](https://github.com/psf/requests) from 2.25.1 to 2.26.0.
    - [Release notes](https://github.com/psf/requests/releases)
    - [Changelog](https://github.com/psf/requests/blob/master/HISTORY.md)
    - [Commits](https://github.com/psf/requests/compare/v2.25.1...v2.26.0)
    ---
    updated-dependencies:
    - dependency-name: requests
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.11.4 to 3.12.0.
    - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
    - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/3.12.0/doc/changelog.rst)
    - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.11.4...3.12.0)
    ---
    updated-dependencies:
    - dependency-name: pymongo
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [python-dotenv](https://github.com/theskumar/python-dotenv) from 0.18.0 to 0.19.0.
    - [Release notes](https://github.com/theskumar/python-dotenv/releases)
    - [Changelog](https://github.com/theskumar/python-dotenv/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/theskumar/python-dotenv/compare/v0.18.0...v0.19.0)
    ---
    updated-dependencies:
    - dependency-name: python-dotenv
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [distro](https://github.com/python-distro/distro) from 1.5.0 to 1.6.0.
    - [Release notes](https://github.com/python-distro/distro/releases)
    - [Changelog](https://github.com/python-distro/distro/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/python-distro/distro/compare/v1.5.0...v1.6.0)
    ---
    updated-dependencies:
    - dependency-name: distro
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [progress](https://github.com/verigak/progress) from 1.5 to 1.6.
    - [Release notes](https://github.com/verigak/progress/releases)
    - [Commits](https://github.com/verigak/progress/compare/1.5...1.6)
    ---
    updated-dependencies:
    - dependency-name: progress
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.7 to 3.4.8.
    - [Release notes](https://github.com/pyca/cryptography/releases)
    - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pyca/cryptography/compare/3.4.7...3.4.8)
    ---
    updated-dependencies:
    - dependency-name: cryptography
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.7 to 3.4.8.
    - [Release notes](https://github.com/pyca/cryptography/releases)
    - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pyca/cryptography/compare/3.4.7...3.4.8)
    ---
    updated-dependencies:
    - dependency-name: cryptography
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.2.4 to 6.2.5.
    - [Release notes](https://github.com/pytest-dev/pytest/releases)
    - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/pytest/compare/6.2.4...6.2.5)
    ---
    updated-dependencies:
    - dependency-name: pytest
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.2.4 to 6.2.5.
    - [Release notes](https://github.com/pytest-dev/pytest/releases)
    - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/pytest/compare/6.2.4...6.2.5)
    ---
    updated-dependencies:
    - dependency-name: pytest
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [pluggy](https://github.com/pytest-dev/pluggy) from 0.13.1 to 1.0.0.
    - [Release notes](https://github.com/pytest-dev/pluggy/releases)
    - [Changelog](https://github.com/pytest-dev/pluggy/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/pluggy/compare/0.13.1...1.0.0)
    ---
    updated-dependencies:
    - dependency-name: pluggy
      dependency-type: direct:production
      update-type: version-update:semver-major
    ...
  * Bumps [pluggy](https://github.com/pytest-dev/pluggy) from 0.13.1 to 1.0.0.
    - [Release notes](https://github.com/pytest-dev/pluggy/releases)
    - [Changelog](https://github.com/pytest-dev/pluggy/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/pluggy/compare/0.13.1...1.0.0)
    ---
    updated-dependencies:
    - dependency-name: pluggy
      dependency-type: direct:production
      update-type: version-update:semver-major
    ...
  * Bumps python from 3.9.6 to 3.9.7.
    ---
    updated-dependencies:
    - dependency-name: python
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [docker](https://github.com/docker/docker-py) from 5.0.0 to 5.0.2.
    - [Release notes](https://github.com/docker/docker-py/releases)
    - [Commits](https://github.com/docker/docker-py/compare/5.0.0...5.0.2)
    ---
    updated-dependencies:
    - dependency-name: docker
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [pillow](https://github.com/python-pillow/Pillow) from 8.3.1 to 8.3.2.
    - [Release notes](https://github.com/python-pillow/Pillow/releases)
    - [Changelog](https://github.com/python-pillow/Pillow/blob/master/CHANGES.rst)
    - [Commits](https://github.com/python-pillow/Pillow/compare/8.3.1...8.3.2)
    ---
    updated-dependencies:
    - dependency-name: pillow
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [docker](https://github.com/docker/docker-py) from 5.0.0 to 5.0.2.
    - [Release notes](https://github.com/docker/docker-py/releases)
    - [Commits](https://github.com/docker/docker-py/compare/5.0.0...5.0.2)
    ---
    updated-dependencies:
    - dependency-name: docker
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...


## Mender 3.0.2

_Released 02.09.2022_

### Statistics

A total of 568 lines added, 460 removed (delta 108)

| Developers with the most changesets | |
|---|---|
| Lluis Campos | 9 (31.0%) |
| Ole Petter Orhagen | 7 (24.1%) |
| Fabio Tranchitella | 5 (17.2%) |
| Manuel Zedel | 3 (10.3%) |
| Alf-Rune Siqveland | 3 (10.3%) |
| Peter Grzybowski | 1 (3.4%) |
| Krzysztof Jaskiewicz | 1 (3.4%) |

| Developers with the most changed lines | |
|---|---|
| Alf-Rune Siqveland | 249 (32.8%) |
| Fabio Tranchitella | 220 (29.0%) |
| Ole Petter Orhagen | 123 (16.2%) |
| Lluis Campos | 100 (13.2%) |
| Manuel Zedel | 53 (7.0%) |
| Krzysztof Jaskiewicz | 13 (1.7%) |
| Peter Grzybowski | 1 (0.1%) |

| Developers with the most lines removed | |
|---|---|
| Alf-Rune Siqveland | 134 (29.1%) |
| Manuel Zedel | 35 (7.6%) |
| Krzysztof Jaskiewicz | 13 (2.8%) |

| Developers with the most signoffs (total 5) | |
|---|---|
| Ole Petter Orhagen | 3 (60.0%) |
| Lluis Campos | 2 (40.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 28 (96.6%) |
| RnDity | 1 (3.4%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 746 (98.3%) |
| RnDity | 13 (1.7%) |

| Employers with the most signoffs (total 5) | |
|---|---|
| Northern.tech | 5 (100.0%) |

| Employers with the most hackers (total 7) | |
|---|---|
| Northern.tech | 6 (85.7%) |
| RnDity | 1 (14.3%) |

### Changelogs

#### create-artifact-worker (1.0.3)

New changes in create-artifact-worker since 1.0.2:

* Dockerfile: lock base image mendersoftware/workflows to mender-3.1.x

#### gui (3.0.2)

New changes in gui since 3.0.1:

* xtermjs interprets string as UTF-16
  ([MEN-4771](https://northerntech.atlassian.net/browse/MEN-4771))
* fixed an issue that could prevent creating phased deployments for dynamic groups

#### inventory-enterprise (3.0.1)

New changes in inventory-enterprise since 3.0.0:

* fix filtering by datetime values (e.g. `updated_ts`)
  ([MEN-4644](https://northerntech.atlassian.net/browse/MEN-4644))

#### mtls-ambassador (1.0.1)

New changes in mtls-ambassador since 1.0.0:

* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.2 to 3.15.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### integration (3.0.2)

New changes in integration since 3.0.1:

* Unify the docker-compose version check through using the
  docker-compose version subcommand, as opposed to the --version flag when
  checking which docker-compose version is compatible with the current demo script.
* Upgrade create-artifact-worker to 1.0.3.
* Upgrade gui to 3.0.2.
* Upgrade integration to 3.0.2.
* Upgrade inventory-enterprise to 3.0.1.
* Upgrade inventory to 3.0.1.
* Upgrade mender-connect to 1.2.1.
* Upgrade mender to 3.0.2.
* Upgrade mtls-ambassador to 1.0.1.


## Mender 3.0.1

_Release date 09.29.2021_

### Statistics

A total of 585 lines added, 265 removed (delta 320)

| Developers with the most changesets | |
|---|---|
| Manuel Zedel | 9 (42.9%) |
| Fabio Tranchitella | 6 (28.6%) |
| Kristian Amlie | 4 (19.0%) |
| Ole Petter Orhagen | 1 (4.8%) |
| Alf-Rune Siqveland | 1 (4.8%) |

| Developers with the most changed lines | |
|---|---|
| Fabio Tranchitella | 437 (72.2%) |
| Alf-Rune Siqveland | 55 (9.1%) |
| Manuel Zedel | 51 (8.4%) |
| Ole Petter Orhagen | 43 (7.1%) |
| Kristian Amlie | 19 (3.1%) |

| Developers with the most lines removed | |
|---|---|
| Kristian Amlie | 3 (1.1%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 21 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 605 (100.0%) |

| Employers with the most hackers (total 5) | |
|---|---|
| Northern.tech | 5 (100.0%) |

### Changelogs


#### deployments (3.0.1)

Bumped version to align with the enterprise fork.

#### deployments-enterprise (3.0.1)

New changes in deployments-enterprise since 3.0.0:

* add update control map evaluation
  ([MEN-4906](https://northerntech.atlassian.net/browse/MEN-4906))

#### deviceconnect (1.2.1)

New changes in deviceconnect since 1.2.0:

* store the correct offset in the recordings control messages
  ([MEN-4770](https://northerntech.atlassian.net/browse/MEN-4770))

#### gui (3.0.1)

New changes in gui since 3.0.0:

* Adjust help text to say that RPi image is merely Mender ready.
* fixed an issue that caused the deployment report to crash due to missing update control information
* fixed an issue that caused the page selection in the device list to change unintended
* require the current one when updating the user's password
  ([MEN-4922](https://northerntech.atlassian.net/browse/MEN-4922))
* fixed an issue that prevented getting to devices based on their software in the overall device distribution

#### integration (3.0.1)

New changes in integration since 3.0.0:

* Fix: Traefik is proxying minio requests on (80,443) ports, not on 9000
* [] Fix demo script user creation race condition
  ([MEN-4852](https://northerntech.atlassian.net/browse/MEN-4852))
* Upgrade deployments-enterprise to 3.0.1.
* Upgrade deployments to 3.0.1.
* Upgrade deviceconnect to 1.2.1.
* Upgrade gui to 3.0.1.
* Upgrade integration to 3.0.1.
* Upgrade mender-artifact to 3.6.1.
* Upgrade mender to 3.0.1.



## Mender 3.0.0

_Released 07.14.2021_

### Statistics

A total of 33744 lines added, 22372 removed (delta 11372)

| Developers with the most changesets | |
|---|---|
| Manuel Zedel | 162 (32.7%) |
| Fabio Tranchitella | 88 (17.7%) |
| Marcin Chalczynski | 66 (13.3%) |
| Krzysztof Jaskiewicz | 40 (8.1%) |
| Lluis Campos | 34 (6.9%) |
| Alex Miliukov | 27 (5.4%) |
| Kristian Amlie | 25 (5.0%) |
| Alf-Rune Siqveland | 22 (4.4%) |
| Ole Petter Orhagen | 14 (2.8%) |
| Peter Grzybowski | 12 (2.4%) |

| Developers with the most changed lines | |
|---|---|
| Manuel Zedel | 18950 (43.9%) |
| Fabio Tranchitella | 4826 (11.2%) |
| Ole Petter Orhagen | 4664 (10.8%) |
| Krzysztof Jaskiewicz | 4326 (10.0%) |
| Marcin Chalczynski | 3583 (8.3%) |
| Alex Miliukov | 2847 (6.6%) |
| Alf-Rune Siqveland | 1902 (4.4%) |
| Lluis Campos | 983 (2.3%) |
| Peter Grzybowski | 618 (1.4%) |
| Kristian Amlie | 429 (1.0%) |

| Developers with the most lines removed | |
|---|---|
| Ole Petter Orhagen | 4102 (18.3%) |

| Developers with the most signoffs (total 1) | |
|---|---|
| Alf-Rune Siqveland | 1 (100.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 390 (78.6%) |
| RnDity | 106 (21.4%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 35298 (81.7%) |
| RnDity | 7909 (18.3%) |

| Employers with the most signoffs (total 1) | |
|---|---|
| Northern.tech | 1 (100.0%) |

| Employers with the most hackers (total 13) | |
|---|---|
| Northern.tech | 11 (84.6%) |
| RnDity | 2 (15.4%) |

### Changelogs

#### auditlogs (1.2.0)

New changes in auditlogs since 1.1.0:

* Redact sensitive information from logs
  ([MEN-4332](https://northerntech.atlassian.net/browse/MEN-4332), [MEN-4491](https://northerntech.atlassian.net/browse/MEN-4491))
* Allow filtering logs by object_type='device'
  ([MEN-4332](https://northerntech.atlassian.net/browse/MEN-4332), [MEN-4491](https://northerntech.atlassian.net/browse/MEN-4491))
* New audit log actions: 'open_portforward',
  'close_portforward', 'download_file', 'upload_file',
  'set_configuration', 'deploy_configuration'.
  ([MEN-4332](https://northerntech.atlassian.net/browse/MEN-4332), [MEN-4491](https://northerntech.atlassian.net/browse/MEN-4491))
* Audit log uploading and deleting atifacts
  ([MEN-4047](https://northerntech.atlassian.net/browse/MEN-4047))
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.0 to 3.13.3.
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.6.3 to 1.7.1.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.6.3...v1.7.1)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps alpine from 3.13.3 to 3.13.5.
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.1 to 1.7.2.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.1...v1.7.2)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...

#### deployments (3.0.0)

New changes in deployments since 2.3.0:

* device status update handles 'pause' states
  ([MEN-4570](https://northerntech.atlassian.net/browse/MEN-4570))
* Sort parameter for get deployments endpoint
  ([MEN-4665](https://northerntech.atlassian.net/browse/MEN-4665))
* add support for AWS S3 Transfer Acceleration
  ([MEN-3966](https://northerntech.atlassian.net/browse/MEN-3966))
* Deployments devices endpoint deprecation
  ([MEN-3993](https://northerntech.atlassian.net/browse/MEN-3993))
* new deployment devices list endpoint
  ([MEN-3993](https://northerntech.atlassian.net/browse/MEN-3993))
* store information about device groups with the deployment
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.1 to 3.13.3.
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.30 to 1.38.7.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.30...v1.38.7)
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.38.7 to 1.38.12.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.38.7...v1.38.12)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.38.12 to 1.38.17.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.38.12...v1.38.17)
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...

#### deployments-enterprise (3.0.0)

New changes in deployments-enterprise since 2.3.0:

* docs: Fix naming conflict in v1 and v2 NewDeployment definitions.
* docs: Document missing parameters for NewDeploymentForGroup schema.
* device status update handles 'pause' states
  ([MEN-4570](https://northerntech.atlassian.net/browse/MEN-4570))
* introduce audit log for deployment aborting
* Added new PATCH endpoint for updating update_control_map
* [] Support update_control_map in /deployments/next devices API
  ([MEN-4555](https://northerntech.atlassian.net/browse/MEN-4555))
* extend configuration deployment with update control map
* Sort parameter for get deployments endpoint
  ([MEN-4665](https://northerntech.atlassian.net/browse/MEN-4665))
* add support for AWS S3 Transfer Acceleration
  ([MEN-3966](https://northerntech.atlassian.net/browse/MEN-3966))
* Sort parameter for get deployments endpoint
  ([MEN-4665](https://northerntech.atlassian.net/browse/MEN-4665))
* Deployments devices endpoint deprecation
  ([MEN-3993](https://northerntech.atlassian.net/browse/MEN-3993))
* new deployment devices list endpoint
  ([MEN-3993](https://northerntech.atlassian.net/browse/MEN-3993))
* new end-point: deployments/next v2
  ([MEN-4784](https://northerntech.atlassian.net/browse/MEN-4784))
* store information about device groups with the deployment
* extend RBAC support
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.1 to 3.13.3.
  * Bumps alpine from 3.13.2 to 3.13.3.
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.30 to 1.38.7.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.30...v1.38.7)
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.30 to 1.38.7.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.30...v1.38.7)
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.38.7 to 1.38.12.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.38.7...v1.38.12)
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.38.7 to 1.38.12.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.38.7...v1.38.12)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.38.12 to 1.38.17.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.38.12...v1.38.17)
  * Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.38.12 to 1.38.17.
    - [Release notes](https://github.com/aws/aws-sdk-go/releases)
    - [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/aws/aws-sdk-go/compare/v1.38.12...v1.38.17)
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### deviceauth (3.0.0)

New changes in deviceauth since 2.6.0:

* inventory client: update the path of the status endpoint
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.1 to 3.13.3.
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.7.1 to 8.8.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.7.1...v8.8.0)
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps golang from 1.15.8-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.8.0 to 8.8.2.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.8.0...v8.8.2)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.8.2 to 8.9.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.8.2...v8.9.0)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.9.0 to 8.10.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.9.0...v8.10.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/go-redis/redis/v8
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### deviceconfig (1.1.0)

New changes in deviceconfig since 1.0.0:

* docs: Fix name conflict in Configuration schema.
* extend endpoint for deploying configuration with support for optional update control map parameter
* remove RBAC support; RBAC for this service is handled by the useradm-enterprise serivce
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.2 to 3.13.3.
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.6.3 to 1.7.1.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.6.3...v1.7.1)
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.1 to 1.7.2.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.1...v1.7.2)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### deviceconnect (1.2.0)

New changes in deviceconnect since 1.1.0:

* [] Limit size of messages transferred over websockets
  ([MEN-4803](https://northerntech.atlassian.net/browse/MEN-4803))
* Delay HTTP 200 response to the first file chunk received to
  support errors due to file transfer limits set on the device.
* Aggregated Dependabot Changelogs:
  * Bumps golang from 1.15-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps [github.com/vmihailenco/msgpack/v5](https://github.com/vmihailenco/msgpack) from 5.1.0 to 5.3.1.
    - [Release notes](https://github.com/vmihailenco/msgpack/releases)
    - [Commits](https://github.com/vmihailenco/msgpack/compare/v5.1.0...v5.3.1)
  * Bumps alpine from 3.13.0 to 3.13.4.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.6.3 to 1.7.1.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.6.3...v1.7.1)
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [github.com/nats-io/nats.go](https://github.com/nats-io/nats.go) from 1.10.0 to 1.11.0.
    - [Release notes](https://github.com/nats-io/nats.go/releases)
    - [Commits](https://github.com/nats-io/nats.go/compare/v1.10.0...v1.11.0)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.1 to 1.7.2.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.1...v1.7.2)
  * Bumps [github.com/vmihailenco/msgpack/v5](https://github.com/vmihailenco/msgpack) from 5.3.1 to 5.3.4.
    - [Release notes](https://github.com/vmihailenco/msgpack/releases)
    - [Commits](https://github.com/vmihailenco/msgpack/compare/v5.3.1...v5.3.4)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### gui (3.0.0)

New changes in gui since 2.7.0:

* refactored upgrade page + added support for plan & addon changes
* ensured ungrouped group won't suggest removing device from group
  ([MEN-4609](https://northerntech.atlassian.net/browse/MEN-4609))
* fixed an issue that could prevent cleaning up an expanded device + leak memory
* limited processing of retrieved device attributes to 100
* added port forwarding tooltip to ease access to the feature
  ([MEN-4477](https://northerntech.atlassian.net/browse/MEN-4477))
* made initial past deployment time frame selection depend on most recent deployments
* fixed an issue that prevented automatic redirect to pending/ inprogress deployments after deployment creation
* fixed an issue that caused releases to disappear on deployment creation
* fixed an issue that prevented single device deployment recreation
* fixed an issue that prevented the deployment device list from being updated
* fixed an issue that could crash the deployment page when closing
* fixed a potential memory leak in the deployments list
* fixed an issue that prevented RBAC group based role modifications
  ([MEN-4713](https://northerntech.atlassian.net/browse/MEN-4713))
* made deployments fitlerable by deployment type
  ([MEN-4667](https://northerntech.atlassian.net/browse/MEN-4667))
* Adjustments to height and signup/login padding for display on small screens
* fixed an issue that caused deployment type selection to reset by itself
* fixed an issue that could prevent deployment creation after switching to a lower plan
  ([MEN-4765](https://northerntech.atlassian.net/browse/MEN-4765))
* fixed an issue that might prevent importing a default configuration
  ([MEN-4750](https://northerntech.atlassian.net/browse/MEN-4750))
* added support for synchronized deployments and deployment pause states
  ([MEN-4711](https://northerntech.atlassian.net/browse/MEN-4711))
* fixed an issue that could prevent enterprise users from setting up a phased deployment
* fixed an issue that prevented a previously set default retry value from being used
* fixed an issue that prevented running deployments from being updated
  ([MEN-4802](https://northerntech.atlassian.net/browse/MEN-4802))
* enabled device filtering with multiple values for the same attribute
  ([MEN-4674](https://northerntech.atlassian.net/browse/MEN-4674))
* added device list shortcut filter to ease device list filtering on id-attributes
* migrated tab based device list layout to single filtered list layout
  ([MEN-4662](https://northerntech.atlassian.net/browse/MEN-4662))
* fixed an issue that prevented automatic update of detailed device info
* restored individual scrolling in device list etc.
  ([MEN-4828](https://northerntech.atlassian.net/browse/MEN-4828))
* Aggregated Dependabot Changelogs:
  * Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.10.0 to 3.10.1.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/commits/v3.10.1/packages/core-js)
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.13.10 to 7.13.15.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.13.15/packages/babel-plugin-transform-runtime)
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.2.9 to 8.2.10.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.2.9...8.2.10)
  * Bumps node from 15.13.0-alpine to 15.14.0-alpine.
  * Bumps [cypress-file-upload](https://github.com/abramenal/cypress-file-upload) from 5.0.3 to 5.0.5.
    - [Release notes](https://github.com/abramenal/cypress-file-upload/releases)
    - [Commits](https://github.com/abramenal/cypress-file-upload/compare/v5.0.3...v5.0.5)
  * Bumps [cypress-localstorage-commands](https://github.com/javierbrea/cypress-localstorage-commands) from 1.4.2 to 1.4.3.
    - [Release notes](https://github.com/javierbrea/cypress-localstorage-commands/releases)
    - [Changelog](https://github.com/javierbrea/cypress-localstorage-commands/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/javierbrea/cypress-localstorage-commands/compare/v1.4.2...v1.4.3)
  * Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 13.0.16 to 13.1.2.
    - [Release notes](https://github.com/testing-library/user-event/releases)
    - [Changelog](https://github.com/testing-library/user-event/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/user-event/compare/v13.0.16...v13.1.2)
  * Bumps cypress/included from 6.8.0 to 7.0.1.
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.13.12 to 7.13.15.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.13.15/packages/babel-preset-env)
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 1.4.0 to 1.4.1.
    - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
    - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v1.4.0...v1.4.1)
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.30.0 to 5.32.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.30.0...v5.32.0)
  * Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 8.0.0 to 8.1.0.
    - [Release notes](https://github.com/webpack-contrib/less-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/less-loader/compare/v8.0.0...v8.1.0)
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.23.1 to 7.23.2.
    - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
    - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.23.1...v7.23.2)
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 5.2.0 to 5.2.1.
    - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/css-loader/compare/v5.2.0...v5.2.1)
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.4.13 to 35.5.1.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.4.13...v35.5.1)
  * Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.11.0 to 2.11.1.
    - [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
    - [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.11.0...v2.11.1)
  * Bumps [react-idle-timer](https://github.com/supremetechnopriest/react-idle-timer) from 4.5.6 to 4.6.0.
    - [Release notes](https://github.com/supremetechnopriest/react-idle-timer/releases)
    - [Changelog](https://github.com/SupremeTechnopriest/react-idle-timer/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/supremetechnopriest/react-idle-timer/compare/4.5.6...4.6.0)
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.13.14 to 7.13.15.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.13.15/packages/babel-core)
  * Bumps [eslint](https://github.com/eslint/eslint) from 7.23.0 to 7.24.0.
    - [Release notes](https://github.com/eslint/eslint/releases)
    - [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/eslint/eslint/compare/v7.23.0...v7.24.0)
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.32.0 to 5.33.2.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.32.0...v5.33.2)
  * Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.11.1 to 2.12.0.
    - [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
    - [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.11.1...v2.12.0)
  * Bumps [eslint-plugin-prettier](https://github.com/prettier/eslint-plugin-prettier) from 3.3.1 to 3.4.0.
    - [Release notes](https://github.com/prettier/eslint-plugin-prettier/releases)
    - [Changelog](https://github.com/prettier/eslint-plugin-prettier/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/prettier/eslint-plugin-prettier/commits)
  * Bumps nginx from 1.19.9-alpine to 1.19.10-alpine.
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 1.4.1 to 1.5.0.
    - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
    - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v1.4.1...v1.5.0)
  * Bumps [cypress-file-upload](https://github.com/abramenal/cypress-file-upload) from 5.0.5 to 5.0.6.
    - [Release notes](https://github.com/abramenal/cypress-file-upload/releases)
    - [Commits](https://github.com/abramenal/cypress-file-upload/compare/v5.0.5...v5.0.6)
  * Bumps cypress/included from 7.0.1 to 7.1.0.
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 5.2.1 to 5.2.2.
    - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/css-loader/compare/v5.2.1...v5.2.2)
  * Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 8.1.0 to 8.1.1.
    - [Release notes](https://github.com/webpack-contrib/less-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/less-loader/compare/v8.1.0...v8.1.1)
  * Bumps [react-idle-timer](https://github.com/supremetechnopriest/react-idle-timer) from 4.6.0 to 4.6.1.
    - [Release notes](https://github.com/supremetechnopriest/react-idle-timer/releases)
    - [Changelog](https://github.com/SupremeTechnopriest/react-idle-timer/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/supremetechnopriest/react-idle-timer/compare/4.6.0...4.6.1)
  * Bumps [validator](https://github.com/validatorjs/validator.js) from 13.5.2 to 13.6.0.
    - [Release notes](https://github.com/validatorjs/validator.js/releases)
    - [Changelog](https://github.com/validatorjs/validator.js/blob/13.6.0/CHANGELOG.md)
    - [Commits](https://github.com/validatorjs/validator.js/compare/13.5.2...13.6.0)
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.33.2 to 5.35.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.33.2...v5.35.0)
  * Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.10.1 to 3.10.2.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/commits/v3.10.2/packages/core-js)
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.13.15 to 7.13.16.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.13.16/packages/babel-core)
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 5.2.2 to 5.2.4.
    - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/css-loader/compare/v5.2.2...v5.2.4)
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.2.10 to 8.2.12.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.2.10...8.2.12)
  * Bumps [eslint](https://github.com/eslint/eslint) from 7.24.0 to 7.25.0.
    - [Release notes](https://github.com/eslint/eslint/releases)
    - [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/eslint/eslint/compare/v7.24.0...v7.25.0)
  * Bumps [msw](https://github.com/mswjs/msw) from 0.28.1 to 0.28.2.
    - [Release notes](https://github.com/mswjs/msw/releases)
    - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/mswjs/msw/compare/v0.28.1...v0.28.2)
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 7.30.3 to 7.30.4.
    - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
    - [Changelog](https://github.com/testing-library/dom-testing-library/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/dom-testing-library/compare/v7.30.3...v7.30.4)
  * Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.10.2 to 3.11.0.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/commits/v3.11.0/packages/core-js)
  * Bumps [jest-watch-typeahead](https://github.com/jest-community/jest-watch-typeahead) from 0.6.2 to 0.6.3.
    - [Release notes](https://github.com/jest-community/jest-watch-typeahead/releases)
    - [Changelog](https://github.com/jest-community/jest-watch-typeahead/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/jest-community/jest-watch-typeahead/compare/v0.6.2...v0.6.3)
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.35.0 to 5.35.1.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.35.0...v5.35.1)
  * Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.11.10 to 5.12.0.
    - [Release notes](https://github.com/testing-library/jest-dom/releases)
    - [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/jest-dom/compare/v5.11.10...v5.12.0)
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.2.12 to 8.2.13.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.2.12...8.2.13)
  * Bumps [react-redux](https://github.com/reduxjs/react-redux) from 7.2.3 to 7.2.4.
    - [Release notes](https://github.com/reduxjs/react-redux/releases)
    - [Changelog](https://github.com/reduxjs/react-redux/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/reduxjs/react-redux/compare/v7.2.3...v7.2.4)
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.13.2 to 1.14.0.
    - [Release notes](https://github.com/stripe/stripe-js/releases)
    - [Commits](https://github.com/stripe/stripe-js/compare/v1.13.2...v1.14.0)
  * Bumps [@material-ui/core](https://github.com/mui-org/material-ui/tree/HEAD/packages/material-ui) from 4.11.3 to 4.11.4.
    - [Release notes](https://github.com/mui-org/material-ui/releases)
    - [Changelog](https://github.com/mui-org/material-ui/blob/v4.11.4/CHANGELOG.md)
    - [Commits](https://github.com/mui-org/material-ui/commits/v4.11.4/packages/material-ui)
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 1.5.0 to 1.6.0.
    - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
    - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v1.5.0...v1.6.0)
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.13.16 to 7.14.0.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.0/packages/babel-core)
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.35.1 to 5.36.2.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.35.1...v5.36.2)
  * Bumps [@material-ui/lab](https://github.com/mui-org/material-ui/tree/HEAD/packages/material-ui-lab) from 4.0.0-alpha.57 to 4.0.0-alpha.58.
    - [Release notes](https://github.com/mui-org/material-ui/releases)
    - [Changelog](https://github.com/mui-org/material-ui/blob/next/CHANGELOG.md)
    - [Commits](https://github.com/mui-org/material-ui/commits/HEAD/packages/material-ui-lab)
  * Bumps [react-idle-timer](https://github.com/supremetechnopriest/react-idle-timer) from 4.6.1 to 4.6.2.
    - [Release notes](https://github.com/supremetechnopriest/react-idle-timer/releases)
    - [Changelog](https://github.com/SupremeTechnopriest/react-idle-timer/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/supremetechnopriest/react-idle-timer/compare/4.6.1...4.6.2)
  * Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.11.0 to 3.11.1.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/commits/v3.11.1/packages/core-js)
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.13.15 to 7.14.0.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.0/packages/babel-preset-env)
  * Bumps node from 15.14.0-alpine to 16.0.0-alpine.
  * Bumps [cypress-file-upload](https://github.com/abramenal/cypress-file-upload) from 5.0.6 to 5.0.7.
    - [Release notes](https://github.com/abramenal/cypress-file-upload/releases)
    - [Commits](https://github.com/abramenal/cypress-file-upload/commits)
  * Bumps [cypress-localstorage-commands](https://github.com/javierbrea/cypress-localstorage-commands) from 1.4.3 to 1.4.4.
    - [Release notes](https://github.com/javierbrea/cypress-localstorage-commands/releases)
    - [Changelog](https://github.com/javierbrea/cypress-localstorage-commands/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/javierbrea/cypress-localstorage-commands/compare/v1.4.3...v1.4.4)
  * Bumps cypress/included from 7.1.0 to 7.2.0.
  * Bumps [lodash](https://github.com/lodash/lodash) from 4.17.19 to 4.17.21.
    - [Release notes](https://github.com/lodash/lodash/releases)
    - [Commits](https://github.com/lodash/lodash/compare/4.17.19...4.17.21)
  * Bumps [lodash](https://github.com/lodash/lodash) from 4.17.20 to 4.17.21.
    - [Release notes](https://github.com/lodash/lodash/releases)
    - [Commits](https://github.com/lodash/lodash/compare/4.17.20...4.17.21)
  * Bumps [ua-parser-js](https://github.com/faisalman/ua-parser-js) from 0.7.20 to 0.7.28.
    - [Release notes](https://github.com/faisalman/ua-parser-js/releases)
    - [Commits](https://github.com/faisalman/ua-parser-js/compare/0.7.20...0.7.28)
  * Bumps [hosted-git-info](https://github.com/npm/hosted-git-info) from 2.8.2 to 2.8.9.
    - [Release notes](https://github.com/npm/hosted-git-info/releases)
    - [Changelog](https://github.com/npm/hosted-git-info/blob/v2.8.9/CHANGELOG.md)
    - [Commits](https://github.com/npm/hosted-git-info/compare/v2.8.2...v2.8.9)
  * Bumps [webpack-cli](https://github.com/webpack/webpack-cli) from 4.6.0 to 4.7.0.
    - [Release notes](https://github.com/webpack/webpack-cli/releases)
    - [Changelog](https://github.com/webpack/webpack-cli/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack/webpack-cli/compare/webpack-cli@4.6.0...webpack-cli@4.7.0)
  * Bumps node from 16.0.0-alpine to 16.1.0-alpine.
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.5.1 to 35.6.2.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.5.1...v35.6.2)
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.2.13 to 8.2.14.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.2.13...8.2.14)
  * Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.12.0 to 2.13.0.
    - [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
    - [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.12.0...v2.13.0)
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 7.30.4 to 7.31.0.
    - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
    - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/dom-testing-library/compare/v7.30.4...v7.31.0)
  * Bumps [eslint](https://github.com/eslint/eslint) from 7.25.0 to 7.26.0.
    - [Release notes](https://github.com/eslint/eslint/releases)
    - [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/eslint/eslint/compare/v7.25.0...v7.26.0)
  * Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.11.1 to 3.12.1.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/commits/v3.12.1/packages/core-js)
  * Bumps [lint-staged](https://github.com/okonet/lint-staged) from 10.5.4 to 11.0.0.
    - [Release notes](https://github.com/okonet/lint-staged/releases)
    - [Commits](https://github.com/okonet/lint-staged/compare/v10.5.4...v11.0.0)
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.14.0 to 7.14.1.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.1/packages/babel-preset-env)
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.36.2 to 5.37.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.36.2...v5.37.0)
  * Bumps [@testing-library/react](https://github.com/testing-library/react-testing-library) from 11.2.6 to 11.2.7.
    - [Release notes](https://github.com/testing-library/react-testing-library/releases)
    - [Changelog](https://github.com/testing-library/react-testing-library/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/react-testing-library/compare/v11.2.6...v11.2.7)
  * Bumps [postcss-loader](https://github.com/webpack-contrib/postcss-loader) from 5.2.0 to 5.3.0.
    - [Release notes](https://github.com/webpack-contrib/postcss-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/postcss-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/postcss-loader/compare/v5.2.0...v5.3.0)
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.14.0 to 7.14.2.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.2/packages/babel-core)
  * Bumps [xterm](https://github.com/xtermjs/xterm.js) from 4.11.0 to 4.12.0.
    - [Release notes](https://github.com/xtermjs/xterm.js/releases)
    - [Commits](https://github.com/xtermjs/xterm.js/compare/4.11.0...4.12.0)
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.2.14 to 8.2.15.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.2.14...8.2.15)
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.13.15 to 7.14.2.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.2/packages/babel-plugin-transform-runtime)
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.6.2 to 35.7.1.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.6.2...v35.7.1)
  * Bumps [eslint-plugin-import](https://github.com/benmosher/eslint-plugin-import) from 2.22.1 to 2.23.2.
    - [Release notes](https://github.com/benmosher/eslint-plugin-import/releases)
    - [Changelog](https://github.com/benmosher/eslint-plugin-import/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/benmosher/eslint-plugin-import/compare/v2.22.1...v2.23.2)
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.14.1 to 7.14.2.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.2/packages/babel-preset-env)
  * Bumps playwright from v1.10.0 to v1.11.0.
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.10.0 to 1.11.0.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.10.0...v1.11.0)
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.10.0 to 1.11.0.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.10.0...v1.11.0)
  * Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.13.0 to 2.13.1.
    - [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
    - [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.13.0...v2.13.1)
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.11.0 to 1.11.1.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.11.0...v1.11.1)
  * Bumps playwright from v1.11.0 to v1.11.1.
  * Bumps [browserslist](https://github.com/browserslist/browserslist) from 4.16.3 to 4.16.6.
    - [Release notes](https://github.com/browserslist/browserslist/releases)
    - [Changelog](https://github.com/browserslist/browserslist/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/browserslist/browserslist/compare/4.16.3...4.16.6)
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.11.0 to 1.11.1.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.11.0...v1.11.1)
  * Bumps node from 16.1.0-alpine to 16.2.0-alpine.
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.14.0 to 1.15.0.
    - [Release notes](https://github.com/stripe/stripe-js/releases)
    - [Commits](https://github.com/stripe/stripe-js/compare/v1.14.0...v1.15.0)
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.14.2 to 7.14.3.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.3/packages/babel-core)
  * Bumps [ws](https://github.com/websockets/ws) from 7.4.4 to 7.4.6.
    - [Release notes](https://github.com/websockets/ws/releases)
    - [Commits](https://github.com/websockets/ws/compare/7.4.4...7.4.6)
  * Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 5.2.4 to 5.2.6.
    - [Release notes](https://github.com/webpack-contrib/css-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/css-loader/compare/v5.2.4...v5.2.6)
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.37.0 to 5.38.1.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.37.0...v5.38.1)
  * Bumps nginx from 1.19.10-alpine to 1.21.0-alpine.
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.2.4 to 4.3.2.
    - [Release notes](https://github.com/Microsoft/TypeScript/releases)
    - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.2.4...v4.3.2)
  * Bumps [dayjs](https://github.com/iamkun/dayjs) from 1.10.4 to 1.10.5.
    - [Release notes](https://github.com/iamkun/dayjs/releases)
    - [Changelog](https://github.com/iamkun/dayjs/blob/dev/CHANGELOG.md)
    - [Commits](https://github.com/iamkun/dayjs/compare/v1.10.4...v1.10.5)
  * Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 8.1.1 to 9.0.0.
    - [Release notes](https://github.com/webpack-contrib/less-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/less-loader/compare/v8.1.1...v9.0.0)
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.14.2 to 7.14.4.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.4/packages/babel-preset-env)
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 26.6.2 to 27.0.2.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/commits/v27.0.2/packages/jest-resolve)
  * Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.23.2 to 7.24.0.
    - [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
    - [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.23.2...v7.24.0)
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.2.15 to 8.3.0.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.2.15...8.3.0)
  * Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.12.1 to 3.13.1.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/commits/v3.13.1/packages/core-js)
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.33.2 to 0.33.4.
    - [Release notes](https://github.com/jquense/react-big-calendar/releases)
    - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.33.2...v0.33.4)
  * Bumps [eslint-plugin-import](https://github.com/benmosher/eslint-plugin-import) from 2.23.2 to 2.23.4.
    - [Release notes](https://github.com/benmosher/eslint-plugin-import/releases)
    - [Changelog](https://github.com/benmosher/eslint-plugin-import/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/benmosher/eslint-plugin-import/compare/v2.23.2...v2.23.4)
  * Bumps [msw](https://github.com/mswjs/msw) from 0.28.2 to 0.29.0.
    - [Release notes](https://github.com/mswjs/msw/releases)
    - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/mswjs/msw/compare/v0.28.2...v0.29.0)
  * Bumps [jest-watch-typeahead](https://github.com/jest-community/jest-watch-typeahead) from 0.6.3 to 0.6.4.
    - [Release notes](https://github.com/jest-community/jest-watch-typeahead/releases)
    - [Changelog](https://github.com/jest-community/jest-watch-typeahead/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/jest-community/jest-watch-typeahead/compare/v0.6.3...v0.6.4)
  * Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.2.5 to 10.2.6.
    - [Release notes](https://github.com/postcss/autoprefixer/releases)
    - [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/autoprefixer/compare/10.2.5...10.2.6)
  * Bumps [jest-junit](https://github.com/jest-community/jest-junit) from 12.0.0 to 12.1.0.
    - [Release notes](https://github.com/jest-community/jest-junit/releases)
    - [Commits](https://github.com/jest-community/jest-junit/compare/v12.0.0...v12.1.0)
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.7.1 to 35.8.2.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.7.1...v35.8.2)
  * Bumps [@stripe/react-stripe-js](https://github.com/stripe/react-stripe-js) from 1.4.0 to 1.4.1.
    - [Release notes](https://github.com/stripe/react-stripe-js/releases)
    - [Changelog](https://github.com/stripe/react-stripe-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/stripe/react-stripe-js/compare/v1.4.0...v1.4.1)
  * Bumps [babel-jest](https://github.com/facebook/jest/tree/HEAD/packages/babel-jest) from 26.6.3 to 27.0.2.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/commits/v27.0.2/packages/babel-jest)
  * Bumps [util](https://github.com/browserify/node-util) from 0.12.3 to 0.12.4.
    - [Release notes](https://github.com/browserify/node-util/releases)
    - [Changelog](https://github.com/browserify/node-util/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/browserify/node-util/compare/v0.12.3...v0.12.4)
  * Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.33.4 to 0.33.5.
    - [Release notes](https://github.com/jquense/react-big-calendar/releases)
    - [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/jquense/react-big-calendar/compare/v0.33.4...v0.33.5)
  * Bumps [react-idle-timer](https://github.com/supremetechnopriest/react-idle-timer) from 4.6.2 to 4.6.4.
    - [Release notes](https://github.com/supremetechnopriest/react-idle-timer/releases)
    - [Changelog](https://github.com/SupremeTechnopriest/react-idle-timer/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/supremetechnopriest/react-idle-timer/compare/4.6.2...4.6.4)
  * Bumps [eslint](https://github.com/eslint/eslint) from 7.26.0 to 7.27.0.
    - [Release notes](https://github.com/eslint/eslint/releases)
    - [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/eslint/eslint/compare/v7.26.0...v7.27.0)
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.8.2 to 35.8.3.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.8.2...v35.8.3)
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.8.3 to 35.8.4.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.8.3...v35.8.4)
    ---
    updated-dependencies:
    - dependency-name: victory
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps node from 16.2.0-alpine to 16.3.0-alpine.
    ---
    updated-dependencies:
    - dependency-name: node
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [eslint](https://github.com/eslint/eslint) from 7.27.0 to 7.28.0.
    - [Release notes](https://github.com/eslint/eslint/releases)
    - [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/eslint/eslint/compare/v7.27.0...v7.28.0)
    ---
    updated-dependencies:
    - dependency-name: eslint
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 7.31.0 to 7.31.2.
    - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
    - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/dom-testing-library/compare/v7.31.0...v7.31.2)
    ---
    updated-dependencies:
    - dependency-name: "@testing-library/dom"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.0.2 to 27.0.4.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/commits/v27.0.4/packages/jest-resolve)
    ---
    updated-dependencies:
    - dependency-name: jest-resolve
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.13.1 to 3.14.0.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/commits/v3.14.0/packages/core-js)
    ---
    updated-dependencies:
    - dependency-name: core-js
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.12.0 to 5.13.0.
    - [Release notes](https://github.com/testing-library/jest-dom/releases)
    - [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/jest-dom/compare/v5.12.0...v5.13.0)
    ---
    updated-dependencies:
    - dependency-name: "@testing-library/jest-dom"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [webpack-cli](https://github.com/webpack/webpack-cli) from 4.7.0 to 4.7.2.
    - [Release notes](https://github.com/webpack/webpack-cli/releases)
    - [Changelog](https://github.com/webpack/webpack-cli/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack/webpack-cli/compare/webpack-cli@4.7.0...webpack-cli@4.7.2)
    ---
    updated-dependencies:
    - dependency-name: webpack-cli
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@reduxjs/toolkit](https://github.com/reduxjs/redux-toolkit) from 1.5.1 to 1.6.0.
    - [Release notes](https://github.com/reduxjs/redux-toolkit/releases)
    - [Commits](https://github.com/reduxjs/redux-toolkit/compare/v1.5.1...v1.6.0)
    ---
    updated-dependencies:
    - dependency-name: "@reduxjs/toolkit"
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [@babel/plugin-proposal-class-properties](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-proposal-class-properties) from 7.13.0 to 7.14.5.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.5/packages/babel-plugin-proposal-class-properties)
    ---
    updated-dependencies:
    - dependency-name: "@babel/plugin-proposal-class-properties"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.3.0 to 8.3.1.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.3.0...8.3.1)
    ---
    updated-dependencies:
    - dependency-name: postcss
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.14.4 to 7.14.5.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.5/packages/babel-preset-env)
    ---
    updated-dependencies:
    - dependency-name: "@babel/preset-env"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.14.3 to 7.14.5.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.5/packages/babel-core)
    ---
    updated-dependencies:
    - dependency-name: "@babel/core"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [jest-junit](https://github.com/jest-community/jest-junit) from 12.1.0 to 12.2.0.
    - [Release notes](https://github.com/jest-community/jest-junit/releases)
    - [Commits](https://github.com/jest-community/jest-junit/compare/v12.1.0...v12.2.0)
    ---
    updated-dependencies:
    - dependency-name: jest-junit
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.14.2 to 7.14.5.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.5/packages/babel-plugin-transform-runtime)
    ---
    updated-dependencies:
    - dependency-name: "@babel/plugin-transform-runtime"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 9.0.0 to 9.1.0.
    - [Release notes](https://github.com/webpack-contrib/less-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/less-loader/compare/v9.0.0...v9.1.0)
    ---
    updated-dependencies:
    - dependency-name: less-loader
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@babel/preset-react](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-react) from 7.13.13 to 7.14.5.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.5/packages/babel-preset-react)
    ---
    updated-dependencies:
    - dependency-name: "@babel/preset-react"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.3.1 to 8.3.2.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.3.1...8.3.2)
    ---
    updated-dependencies:
    - dependency-name: postcss
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [postcss-loader](https://github.com/webpack-contrib/postcss-loader) from 5.3.0 to 6.1.0.
    - [Release notes](https://github.com/webpack-contrib/postcss-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/postcss-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/postcss-loader/compare/v5.3.0...v6.1.0)
    ---
    updated-dependencies:
    - dependency-name: postcss-loader
      dependency-type: direct:development
      update-type: version-update:semver-major
    ...
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.8.4 to 35.8.5.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.8.4...v35.8.5)
    ---
    updated-dependencies:
    - dependency-name: victory
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.13.0 to 5.14.1.
    - [Release notes](https://github.com/testing-library/jest-dom/releases)
    - [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/jest-dom/compare/v5.13.0...v5.14.1)
    ---
    updated-dependencies:
    - dependency-name: "@testing-library/jest-dom"
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [xterm](https://github.com/xtermjs/xterm.js) from 4.12.0 to 4.13.0.
    - [Release notes](https://github.com/xtermjs/xterm.js/releases)
    - [Commits](https://github.com/xtermjs/xterm.js/compare/4.12.0...4.13.0)
    ---
    updated-dependencies:
    - dependency-name: xterm
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.11.1 to 1.12.2.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.11.1...v1.12.2)
    ---
    updated-dependencies:
    - dependency-name: playwright
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps playwright from v1.11.1 to v1.12.2.
    ---
    updated-dependencies:
    - dependency-name: playwright
      dependency-type: direct:production
    ...
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.11.1 to 1.12.2.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.11.1...v1.12.2)
    ---
    updated-dependencies:
    - dependency-name: playwright-chromium
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.8.5 to 35.8.6.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.8.5...v35.8.6)
    ---
    updated-dependencies:
    - dependency-name: victory
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.14.5 to 7.14.6.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.6/packages/babel-core)
    ---
    updated-dependencies:
    - dependency-name: "@babel/core"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.3.2 to 8.3.4.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.3.2...8.3.4)
    ---
    updated-dependencies:
    - dependency-name: postcss
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.38.1 to 5.39.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.38.1...v5.39.0)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.3.2 to 4.3.4.
    - [Release notes](https://github.com/Microsoft/TypeScript/releases)
    - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.3.2...v4.3.4)
    ---
    updated-dependencies:
    - dependency-name: typescript
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [postcss](https://github.com/postcss/postcss) from 8.3.4 to 8.3.5.
    - [Release notes](https://github.com/postcss/postcss/releases)
    - [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/postcss/postcss/compare/8.3.4...8.3.5)
    ---
    updated-dependencies:
    - dependency-name: postcss
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 9.1.0 to 10.0.0.
    - [Release notes](https://github.com/webpack-contrib/less-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/less-loader/compare/v9.1.0...v10.0.0)
    ---
    updated-dependencies:
    - dependency-name: less-loader
      dependency-type: direct:development
      update-type: version-update:semver-major
    ...
  * Bumps [eslint](https://github.com/eslint/eslint) from 7.28.0 to 7.29.0.
    - [Release notes](https://github.com/eslint/eslint/releases)
    - [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/eslint/eslint/compare/v7.28.0...v7.29.0)
    ---
    updated-dependencies:
    - dependency-name: eslint
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.39.0 to 5.39.1.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.39.0...v5.39.1)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.15.0 to 1.15.1.
    - [Release notes](https://github.com/stripe/stripe-js/releases)
    - [Commits](https://github.com/stripe/stripe-js/compare/v1.15.0...v1.15.1)
    ---
    updated-dependencies:
    - dependency-name: "@stripe/stripe-js"
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.14.0 to 3.15.0.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/commits/v3.15.0/packages/core-js)
    ---
    updated-dependencies:
    - dependency-name: core-js
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.14.5 to 7.14.7.
    - [Release notes](https://github.com/babel/babel/releases)
    - [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/babel/babel/commits/v7.14.7/packages/babel-preset-env)
    ---
    updated-dependencies:
    - dependency-name: "@babel/preset-env"
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [playwright](https://github.com/Microsoft/playwright) from 1.12.2 to 1.12.3.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.12.2...v1.12.3)
    ---
    updated-dependencies:
    - dependency-name: playwright
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [jest-resolve](https://github.com/facebook/jest/tree/HEAD/packages/jest-resolve) from 27.0.4 to 27.0.5.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/commits/v27.0.5/packages/jest-resolve)
    ---
    updated-dependencies:
    - dependency-name: jest-resolve
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.39.1 to 5.40.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.39.1...v5.40.0)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps playwright from v1.12.2 to v1.12.3.
    ---
    updated-dependencies:
    - dependency-name: playwright
      dependency-type: direct:production
    ...
  * Bumps [jest](https://github.com/facebook/jest) from 27.0.4 to 27.0.5.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/compare/v27.0.4...v27.0.5)
    ---
    updated-dependencies:
    - dependency-name: jest
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [playwright-chromium](https://github.com/Microsoft/playwright) from 1.12.2 to 1.12.3.
    - [Release notes](https://github.com/Microsoft/playwright/releases)
    - [Commits](https://github.com/Microsoft/playwright/compare/v1.12.2...v1.12.3)
    ---
    updated-dependencies:
    - dependency-name: playwright-chromium
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [react-dropzone](https://github.com/react-dropzone/react-dropzone) from 11.3.2 to 11.3.4.
    - [Release notes](https://github.com/react-dropzone/react-dropzone/releases)
    - [Commits](https://github.com/react-dropzone/react-dropzone/compare/v11.3.2...v11.3.4)
    ---
    updated-dependencies:
    - dependency-name: react-dropzone
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [html-webpack-plugin](https://github.com/jantimon/html-webpack-plugin) from 5.3.1 to 5.3.2.
    - [Release notes](https://github.com/jantimon/html-webpack-plugin/releases)
    - [Changelog](https://github.com/jantimon/html-webpack-plugin/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/jantimon/html-webpack-plugin/compare/v5.3.1...v5.3.2)
    ---
    updated-dependencies:
    - dependency-name: html-webpack-plugin
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.15.0 to 3.15.1.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/commits/v3.15.1/packages/core-js)
    ---
    updated-dependencies:
    - dependency-name: core-js
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [msw](https://github.com/mswjs/msw) from 0.29.0 to 0.30.0.
    - [Release notes](https://github.com/mswjs/msw/releases)
    - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/mswjs/msw/compare/v0.29.0...v0.30.0)
    ---
    updated-dependencies:
    - dependency-name: msw
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [victory](https://github.com/formidablelabs/victory) from 35.8.6 to 35.9.0.
    - [Release notes](https://github.com/formidablelabs/victory/releases)
    - [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/formidablelabs/victory/compare/v35.8.6...v35.9.0)
    ---
    updated-dependencies:
    - dependency-name: victory
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 1.6.0 to 1.6.1.
    - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
    - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v1.6.0...v1.6.1)
    ---
    updated-dependencies:
    - dependency-name: mini-css-extract-plugin
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.40.0 to 5.42.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.40.0...v5.42.0)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [typescript](https://github.com/Microsoft/TypeScript) from 4.3.4 to 4.3.5.
    - [Release notes](https://github.com/Microsoft/TypeScript/releases)
    - [Commits](https://github.com/Microsoft/TypeScript/compare/v4.3.4...v4.3.5)
    ---
    updated-dependencies:
    - dependency-name: typescript
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [husky](https://github.com/typicode/husky) from 6.0.0 to 7.0.0.
    - [Release notes](https://github.com/typicode/husky/releases)
    - [Commits](https://github.com/typicode/husky/compare/v6.0.0...v7.0.0)
    ---
    updated-dependencies:
    - dependency-name: husky
      dependency-type: direct:development
      update-type: version-update:semver-major
    ...
  * Bumps [postcss-loader](https://github.com/webpack-contrib/postcss-loader) from 6.1.0 to 6.1.1.
    - [Release notes](https://github.com/webpack-contrib/postcss-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/postcss-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/postcss-loader/compare/v6.1.0...v6.1.1)
    ---
    updated-dependencies:
    - dependency-name: postcss-loader
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [msw](https://github.com/mswjs/msw) from 0.30.0 to 0.30.1.
    - [Release notes](https://github.com/mswjs/msw/releases)
    - [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/mswjs/msw/compare/v0.30.0...v0.30.1)
    ---
    updated-dependencies:
    - dependency-name: msw
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [jest](https://github.com/facebook/jest) from 27.0.5 to 27.0.6.
    - [Release notes](https://github.com/facebook/jest/releases)
    - [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/facebook/jest/compare/v27.0.5...v27.0.6)
    ---
    updated-dependencies:
    - dependency-name: jest
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 7.31.2 to 8.1.0.
    - [Release notes](https://github.com/testing-library/dom-testing-library/releases)
    - [Changelog](https://github.com/testing-library/dom-testing-library/blob/main/CHANGELOG.md)
    - [Commits](https://github.com/testing-library/dom-testing-library/compare/v7.31.2...v8.1.0)
    ---
    updated-dependencies:
    - dependency-name: "@testing-library/dom"
      dependency-type: direct:development
      update-type: version-update:semver-major
    ...
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 1.6.1 to 2.0.0.
    - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
    - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v1.6.1...v2.0.0)
    ---
    updated-dependencies:
    - dependency-name: mini-css-extract-plugin
      dependency-type: direct:development
      update-type: version-update:semver-major
    ...
  * Bumps [eslint](https://github.com/eslint/eslint) from 7.29.0 to 7.30.0.
    - [Release notes](https://github.com/eslint/eslint/releases)
    - [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/eslint/eslint/compare/v7.29.0...v7.30.0)
    ---
    updated-dependencies:
    - dependency-name: eslint
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.15.1 to 3.15.2.
    - [Release notes](https://github.com/zloirock/core-js/releases)
    - [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/zloirock/core-js/commits/v3.15.2/packages/core-js)
    ---
    updated-dependencies:
    - dependency-name: core-js
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 10.0.0 to 10.0.1.
    - [Release notes](https://github.com/webpack-contrib/less-loader/releases)
    - [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/less-loader/compare/v10.0.0...v10.0.1)
    ---
    updated-dependencies:
    - dependency-name: less-loader
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 2.0.0 to 2.1.0.
    - [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
    - [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/v2.1.0/CHANGELOG.md)
    - [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v2.0.0...v2.1.0)
    ---
    updated-dependencies:
    - dependency-name: mini-css-extract-plugin
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.42.0 to 5.42.1.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.42.0...v5.42.1)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...
  * Bumps [webpack](https://github.com/webpack/webpack) from 5.42.1 to 5.43.0.
    - [Release notes](https://github.com/webpack/webpack/releases)
    - [Commits](https://github.com/webpack/webpack/compare/v5.42.1...v5.43.0)
    ---
    updated-dependencies:
    - dependency-name: webpack
      dependency-type: direct:development
      update-type: version-update:semver-minor
    ...
  * Bumps [husky](https://github.com/typicode/husky) from 7.0.0 to 7.0.1.
    - [Release notes](https://github.com/typicode/husky/releases)
    - [Commits](https://github.com/typicode/husky/compare/v7.0.0...v7.0.1)
    ---
    updated-dependencies:
    - dependency-name: husky
      dependency-type: direct:development
      update-type: version-update:semver-patch
    ...

#### inventory (3.0.0)

New changes in inventory since 2.3.0:

* New internal endpoint for getting device's groups
* Modify internal endpoint `/devices/:status` to
  `/devices/status/:status`
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.1 to 3.13.3.
  * Bumps golang from 1.15.8-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.7.1 to 1.8.0.
    - [Release notes](https://github.com/spf13/viper/releases)
    - [Commits](https://github.com/spf13/viper/compare/v1.7.1...v1.8.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/spf13/viper
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### inventory-enterprise (3.0.0)

New changes in inventory-enterprise since 2.3.0:

* fix RBAC group logic always filtering by group names
  ([MEN-4728](https://northerntech.atlassian.net/browse/MEN-4728))
* New internal endpoint for getting device's groups
* Modify internal endpoint `/devices/:status` to
  `/devices/status/:status`
* New internal endpoint for checking if given devices belong to given groups
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.2 to 3.13.3.
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.7.1 to 8.8.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.7.1...v8.8.0)
  * Bumps alpine from 3.13.1 to 3.13.3.
  * Bumps golang from 1.15.8-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.8.0 to 8.8.2.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.8.0...v8.8.2)
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.8.2 to 8.9.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.8.2...v8.9.0)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.9.0 to 8.10.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.9.0...v8.10.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/go-redis/redis/v8
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.7.1 to 1.8.0.
    - [Release notes](https://github.com/spf13/viper/releases)
    - [Commits](https://github.com/spf13/viper/compare/v1.7.1...v1.8.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/spf13/viper
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [github.com/spf13/viper](https://github.com/spf13/viper) from 1.7.1 to 1.8.0.
    - [Release notes](https://github.com/spf13/viper/releases)
    - [Commits](https://github.com/spf13/viper/compare/v1.7.1...v1.8.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/spf13/viper
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### tenantadm (3.2.0)

New changes in tenantadm since 3.1.0:

* Suspend the tenant on trial cancellation by the user
  ([MEN-4606](https://northerntech.atlassian.net/browse/MEN-4606))
* add suspend-tenants-expired-trial CLI command
  ([MEN-4602](https://northerntech.atlassian.net/browse/MEN-4602))
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.2 to 3.13.3.
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...

#### useradm (1.15.0)

New changes in useradm since 1.14.0:

* internal API end-point to remove users
  ([MEN-4628](https://northerntech.atlassian.net/browse/MEN-4628))
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.2 to 3.13.3.
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### useradm-enterprise (1.15.0)

New changes in useradm-enterprise since 1.14.0:

* internal API end-point to remove users
  ([MEN-4628](https://northerntech.atlassian.net/browse/MEN-4628))
* internal API end-point to remove users
  ([MEN-4628](https://northerntech.atlassian.net/browse/MEN-4628))
* fix duplicated user email address handling
* 2fa enable/disable endpoints
* security fix: invalidate user JWT token cache on logout
  ([MEN-4754](https://northerntech.atlassian.net/browse/MEN-4754))
* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.13.2 to 3.13.3.
  * Bumps alpine from 3.13.2 to 3.13.3.
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.7.1 to 8.8.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.7.1...v8.8.0)
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.8.0 to 8.8.2.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.8.0...v8.8.2)
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.8.2 to 8.9.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.8.2...v8.9.0)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.9.0 to 8.10.0.
    - [Release notes](https://github.com/go-redis/redis/releases)
    - [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/go-redis/redis/compare/v8.9.0...v8.10.0)
    ---
    updated-dependencies:
    - dependency-name: github.com/go-redis/redis/v8
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### workflows (2.0.0)

New changes in workflows since 1.4.0:

* update device status workflow: update the path of the status
  endpoint
* Aggregated Dependabot Changelogs:
  * Bumps golang from 1.14-alpine3.12 to 1.16.2-alpine3.12.
  * Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.6.0 to 1.8.1.
    - [Release notes](https://github.com/sirupsen/logrus/releases)
    - [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/sirupsen/logrus/compare/v1.6.0...v1.8.1)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.5.0.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...v1.5.0)
  * Bumps alpine from 3.13.0 to 3.13.3.
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.6.3 to 1.7.1.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.6.3...v1.7.1)
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.1 to 1.7.2.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.1...v1.7.2)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### workflows-enterprise (2.0.0)

New changes in workflows-enterprise since 1.4.0:

* Send alert email workflow for Monitoring
  ([MEN-4650](https://northerntech.atlassian.net/browse/MEN-4650))
* extend deploy device configuration workflow with update control map
* append tenant cancellation data to Google Sheets
  ([MEN-4705](https://northerntech.atlassian.net/browse/MEN-4705))
* update device status workflow: update the path of the status
  endpoint
* Aggregated Dependabot Changelogs:
  * Bumps golang from 1.14-alpine3.12 to 1.16.2-alpine3.12.
  * Bumps golang from 1.14-alpine3.12 to 1.16.2-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)
  * Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.6.0 to 1.8.1.
    - [Release notes](https://github.com/sirupsen/logrus/releases)
    - [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/sirupsen/logrus/compare/v1.6.0...v1.8.1)
  * Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.6.0 to 1.8.1.
    - [Release notes](https://github.com/sirupsen/logrus/releases)
    - [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/sirupsen/logrus/compare/v1.6.0...v1.8.1)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.5.0.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...v1.5.0)
  * Bumps alpine from 3.13.0 to 3.13.3.
  * Bumps alpine from 3.13.2 to 3.13.3.
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps golang from 1.16.2-alpine3.12 to 1.16.3-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.0 to 1.5.1.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.0...v1.5.1)
  * Bumps alpine from 3.13.3 to 3.13.4.
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.6.3 to 1.7.1.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.6.3...v1.7.1)
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.6.3 to 1.7.1.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.6.3...v1.7.1)
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps alpine from 3.13.4 to 3.13.5.
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps golang from 1.16.3-alpine3.12 to 1.16.4-alpine3.12.
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.1 to 1.5.2.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.1...v1.5.2)
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.1 to 1.7.2.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.1...v1.7.2)
  * Bumps [github.com/gin-gonic/gin](https://github.com/gin-gonic/gin) from 1.7.1 to 1.7.2.
    - [Release notes](https://github.com/gin-gonic/gin/releases)
    - [Changelog](https://github.com/gin-gonic/gin/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/gin-gonic/gin/compare/v1.7.1...v1.7.2)
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps golang from 1.16.4-alpine3.12 to 1.16.5-alpine3.12.
    ---
    updated-dependencies:
    - dependency-name: golang
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.5.2 to 1.5.3.
    - [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
    - [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.5.2...v1.5.3)
    ---
    updated-dependencies:
    - dependency-name: go.mongodb.org/mongo-driver
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps alpine from 3.13.5 to 3.14.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...

#### integration (3.0.0)

New changes in integration since 2.7.0:

* Remove nginx-based api-gateway and replace with Traefik.
* fix auth verification on useradm APIs
  ([MEN-4623](https://northerntech.atlassian.net/browse/MEN-4623))
* Enforce userauth middleware on non-signup tenantadm endpoints
  ([MEN-4657](https://northerntech.atlassian.net/browse/MEN-4657))
* Full integration test for file limits
  ([MEN-4588](https://northerntech.atlassian.net/browse/MEN-4588))
* [Træfik] Change dynamic config provider from "Docker" to "File"
* Fix mender-configure install in Docker image
  mendersoftware/mender-client-docker-addons
* Upgrade auditlogs to 1.2.0.
* Upgrade deployments to 3.0.0.
* Upgrade deployments-enterprise to 3.0.0.
* Upgrade deviceauth to 3.0.0.
* Upgrade deviceconfig to 1.1.0.
* Upgrade deviceconnect to 1.2.0.
* Upgrade gui to 3.0.0.
* Upgrade integration to 3.0.0.
* Upgrade inventory to 3.0.0.
* Upgrade inventory-enterprise to 3.0.0.
* Upgrade mender to 3.0.0.
* Upgrade mender-artifact to 3.6.0.
* Upgrade mender-connect to 1.2.0.
* Upgrade tenantadm to 3.2.0.
* Upgrade useradm to 1.15.0.
* Upgrade useradm-enterprise to 1.15.0.
* Upgrade workflows to 2.0.0.
* Upgrade workflows-enterprise to 2.0.0.
* Aggregated Dependabot Changelogs:
  * Bumps [python-dotenv](https://github.com/theskumar/python-dotenv) from 0.15.0 to 0.16.0.
    - [Release notes](https://github.com/theskumar/python-dotenv/releases)
    - [Changelog](https://github.com/theskumar/python-dotenv/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/theskumar/python-dotenv/compare/v0.15.0...v0.16.0)
  * Bumps [docker-compose](https://github.com/docker/compose) from 1.28.5 to 1.28.6.
    - [Release notes](https://github.com/docker/compose/releases)
    - [Changelog](https://github.com/docker/compose/blob/1.28.6/CHANGELOG.md)
    - [Commits](https://github.com/docker/compose/compare/1.28.5...1.28.6)
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.6 to 3.4.7.
    - [Release notes](https://github.com/pyca/cryptography/releases)
    - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pyca/cryptography/compare/3.4.6...3.4.7)
  * Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.6 to 3.4.7.
    - [Release notes](https://github.com/pyca/cryptography/releases)
    - [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pyca/cryptography/compare/3.4.6...3.4.7)
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.2.2 to 6.2.3.
    - [Release notes](https://github.com/pytest-dev/pytest/releases)
    - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/pytest/compare/6.2.2...6.2.3)
  * Bumps [python-dotenv](https://github.com/theskumar/python-dotenv) from 0.16.0 to 0.17.0.
    - [Release notes](https://github.com/theskumar/python-dotenv/releases)
    - [Changelog](https://github.com/theskumar/python-dotenv/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/theskumar/python-dotenv/compare/v0.16.0...v0.17.0)
  * Bumps [pillow](https://github.com/python-pillow/Pillow) from 8.1.2 to 8.2.0.
    - [Release notes](https://github.com/python-pillow/Pillow/releases)
    - [Changelog](https://github.com/python-pillow/Pillow/blob/master/CHANGES.rst)
    - [Commits](https://github.com/python-pillow/Pillow/compare/8.1.2...8.2.0)
  * Bumps python from 3.9.2 to 3.9.3.
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.2.2 to 6.2.3.
    - [Release notes](https://github.com/pytest-dev/pytest/releases)
    - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/pytest/compare/6.2.2...6.2.3)
  * Bumps [docker](https://github.com/docker/docker-py) from 4.4.4 to 5.0.0.
    - [Release notes](https://github.com/docker/docker-py/releases)
    - [Commits](https://github.com/docker/docker-py/compare/4.4.4...5.0.0)
  * Bumps [docker-compose](https://github.com/docker/compose) from 1.28.6 to 1.29.1.
    - [Release notes](https://github.com/docker/compose/releases)
    - [Changelog](https://github.com/docker/compose/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/docker/compose/compare/1.28.6...1.29.1)
  * Bumps python from 3.9.3 to 3.9.5.
  * Bumps [python-dotenv](https://github.com/theskumar/python-dotenv) from 0.17.0 to 0.17.1.
    - [Release notes](https://github.com/theskumar/python-dotenv/releases)
    - [Changelog](https://github.com/theskumar/python-dotenv/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/theskumar/python-dotenv/compare/v0.17.0...v0.17.1)
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.2.3 to 6.2.4.
    - [Release notes](https://github.com/pytest-dev/pytest/releases)
    - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/pytest/compare/6.2.3...6.2.4)
  * Bumps [attrs](https://github.com/python-attrs/attrs) from 20.3.0 to 21.2.0.
    - [Release notes](https://github.com/python-attrs/attrs/releases)
    - [Changelog](https://github.com/python-attrs/attrs/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/python-attrs/attrs/compare/20.3.0...21.2.0)
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.11.3 to 3.11.4.
    - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
    - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/3.11.4/doc/changelog.rst)
    - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.11.3...3.11.4)
  * Bumps [websockets](https://github.com/aaugustin/websockets) from 8.1 to 9.0.1.
    - [Release notes](https://github.com/aaugustin/websockets/releases)
    - [Changelog](https://github.com/aaugustin/websockets/blob/main/docs/changelog.rst)
    - [Commits](https://github.com/aaugustin/websockets/compare/8.1...9.0.1)
  * Bumps [websocket-client](https://github.com/websocket-client/websocket-client) from 0.58.0 to 0.59.0.
    - [Release notes](https://github.com/websocket-client/websocket-client/releases)
    - [Changelog](https://github.com/websocket-client/websocket-client/blob/master/ChangeLog)
    - [Commits](https://github.com/websocket-client/websocket-client/compare/v0.58.0...v0.59.0)
  * Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.2.3 to 6.2.4.
    - [Release notes](https://github.com/pytest-dev/pytest/releases)
    - [Changelog](https://github.com/pytest-dev/pytest/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/pytest/compare/6.2.3...6.2.4)
  * Bumps [websockets](https://github.com/aaugustin/websockets) from 9.0.1 to 9.0.2.
    - [Release notes](https://github.com/aaugustin/websockets/releases)
    - [Changelog](https://github.com/aaugustin/websockets/blob/9.0.2/docs/changelog.rst)
    - [Commits](https://github.com/aaugustin/websockets/compare/9.0.1...9.0.2)
  * Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.11.3 to 3.11.4.
    - [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
    - [Changelog](https://github.com/mongodb/mongo-python-driver/blob/3.11.4/doc/changelog.rst)
    - [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.11.3...3.11.4)
  * Bumps [attrs](https://github.com/python-attrs/attrs) from 20.3.0 to 21.2.0.
    - [Release notes](https://github.com/python-attrs/attrs/releases)
    - [Changelog](https://github.com/python-attrs/attrs/blob/main/CHANGELOG.rst)
    - [Commits](https://github.com/python-attrs/attrs/compare/20.3.0...21.2.0)
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.56.0 to 2.57.0.
    - [Release notes](https://github.com/stripe/stripe-python/releases)
    - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/stripe/stripe-python/compare/v2.56.0...v2.57.0)
  * Bumps [six](https://github.com/benjaminp/six) from 1.15.0 to 1.16.0.
    - [Release notes](https://github.com/benjaminp/six/releases)
    - [Changelog](https://github.com/benjaminp/six/blob/master/CHANGES)
    - [Commits](https://github.com/benjaminp/six/compare/1.15.0...1.16.0)
  * Bumps [docker-compose](https://github.com/docker/compose) from 1.29.1 to 1.29.2.
    - [Release notes](https://github.com/docker/compose/releases)
    - [Changelog](https://github.com/docker/compose/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/docker/compose/compare/1.29.1...1.29.2)
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.56.0 to 2.57.0.
    - [Release notes](https://github.com/stripe/stripe-python/releases)
    - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/stripe/stripe-python/compare/v2.56.0...v2.57.0)
  * Bumps [certifi](https://github.com/certifi/python-certifi) from 2020.12.5 to 2021.5.30.
    - [Release notes](https://github.com/certifi/python-certifi/releases)
    - [Commits](https://github.com/certifi/python-certifi/compare/2020.12.05...2021.05.30)
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.4 to 1.26.5.
    - [Release notes](https://github.com/urllib3/urllib3/releases)
    - [Changelog](https://github.com/urllib3/urllib3/blob/main/CHANGES.rst)
    - [Commits](https://github.com/urllib3/urllib3/compare/1.26.4...1.26.5)
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.4 to 1.26.5.
    - [Release notes](https://github.com/urllib3/urllib3/releases)
    - [Changelog](https://github.com/urllib3/urllib3/blob/main/CHANGES.rst)
    - [Commits](https://github.com/urllib3/urllib3/compare/1.26.4...1.26.5)
  * Bumps [websockets](https://github.com/aaugustin/websockets) from 9.0.2 to 9.1.
    - [Release notes](https://github.com/aaugustin/websockets/releases)
    - [Changelog](https://github.com/aaugustin/websockets/blob/9.1/docs/changelog.rst)
    - [Commits](https://github.com/aaugustin/websockets/compare/9.0.2...9.1)
  * Bumps [execnet](https://github.com/pytest-dev/execnet) from 1.8.0 to 1.8.1.
    - [Release notes](https://github.com/pytest-dev/execnet/releases)
    - [Changelog](https://github.com/pytest-dev/execnet/blob/master/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/execnet/compare/v1.8.0...v1.8.1)
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.57.0 to 2.58.0.
    - [Release notes](https://github.com/stripe/stripe-python/releases)
    - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/stripe/stripe-python/compare/v2.57.0...v2.58.0)
    ---
    updated-dependencies:
    - dependency-name: stripe
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [stripe](https://github.com/stripe/stripe-python) from 2.57.0 to 2.58.0.
    - [Release notes](https://github.com/stripe/stripe-python/releases)
    - [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/stripe/stripe-python/compare/v2.57.0...v2.58.0)
    ---
    updated-dependencies:
    - dependency-name: stripe
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [certifi](https://github.com/certifi/python-certifi) from 2020.12.5 to 2021.5.30.
    - [Release notes](https://github.com/certifi/python-certifi/releases)
    - [Commits](https://github.com/certifi/python-certifi/compare/2020.12.05...2021.05.30)
    ---
    updated-dependencies:
    - dependency-name: certifi
      dependency-type: direct:production
      update-type: version-update:semver-major
    ...
  * Bumps [execnet](https://github.com/pytest-dev/execnet) from 1.8.1 to 1.9.0.
    - [Release notes](https://github.com/pytest-dev/execnet/releases)
    - [Changelog](https://github.com/pytest-dev/execnet/blob/master/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/execnet/compare/v1.8.1...v1.9.0)
    ---
    updated-dependencies:
    - dependency-name: execnet
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [python-dotenv](https://github.com/theskumar/python-dotenv) from 0.17.1 to 0.18.0.
    - [Release notes](https://github.com/theskumar/python-dotenv/releases)
    - [Changelog](https://github.com/theskumar/python-dotenv/blob/master/CHANGELOG.md)
    - [Commits](https://github.com/theskumar/python-dotenv/compare/v0.17.1...v0.18.0)
    ---
    updated-dependencies:
    - dependency-name: python-dotenv
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [pytest-xdist](https://github.com/pytest-dev/pytest-xdist) from 2.2.1 to 2.3.0.
    - [Release notes](https://github.com/pytest-dev/pytest-xdist/releases)
    - [Changelog](https://github.com/pytest-dev/pytest-xdist/blob/master/CHANGELOG.rst)
    - [Commits](https://github.com/pytest-dev/pytest-xdist/compare/v2.2.1...v2.3.0)
    ---
    updated-dependencies:
    - dependency-name: pytest-xdist
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.5 to 1.26.6.
    - [Release notes](https://github.com/urllib3/urllib3/releases)
    - [Changelog](https://github.com/urllib3/urllib3/blob/1.26.6/CHANGES.rst)
    - [Commits](https://github.com/urllib3/urllib3/compare/1.26.5...1.26.6)
    ---
    updated-dependencies:
    - dependency-name: urllib3
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.5 to 1.26.6.
    - [Release notes](https://github.com/urllib3/urllib3/releases)
    - [Changelog](https://github.com/urllib3/urllib3/blob/1.26.6/CHANGES.rst)
    - [Commits](https://github.com/urllib3/urllib3/compare/1.26.5...1.26.6)
    ---
    updated-dependencies:
    - dependency-name: urllib3
      dependency-type: direct:production
      update-type: version-update:semver-patch
    ...
  * Bumps [contextlib2](https://github.com/jazzband/contextlib2) from 0.6.0.post1 to 21.6.0.
    - [Release notes](https://github.com/jazzband/contextlib2/releases)
    - [Changelog](https://github.com/jazzband/contextlib2/blob/master/NEWS.rst)
    - [Commits](https://github.com/jazzband/contextlib2/compare/v0.6.0.post1...21.6.0)
    ---
    updated-dependencies:
    - dependency-name: contextlib2
      dependency-type: direct:production
      update-type: version-update:semver-major
    ...


## Mender 2.7.2

_Released 11.04.2021_

### Statistics

A total of 255 lines added, 98 removed (delta 157)

| Developers with the most changesets | |
|---|---|
| Fabio Tranchitella | 5 (71.4%) |
| Lluis Campos | 1 (14.3%) |
| Kristian Amlie | 1 (14.3%) |

| Developers with the most changed lines | |
|---|---|
| Fabio Tranchitella | 205 (80.4%) |
| Lluis Campos | 43 (16.9%) |
| Kristian Amlie | 7 (2.7%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 7 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 255 (100.0%) |

| Employers with the most hackers (total 3) | |
|---|---|
| Northern.tech | 3 (100.0%) |

### Changelogs

#### inventory-enterprise (2.3.1)

New changes in inventory-enterprise since 2.3.0:

* fix filtering by datetime values (e.g. `updated_ts`)
  ([MEN-4644](https://northerntech.atlassian.net/browse/MEN-4644))

#### integration (2.7.2)

New changes in integration since 2.7.1:

* Upgrade integration to 2.7.2.
* Upgrade inventory-enterprise to 2.3.1.
* Upgrade inventory to 2.3.1.


## Mender 2.7.1

_Released 07.14.2021_

### Statistics

A total of 779 lines added, 504 removed (delta 275)

| Developers with the most changesets | |
|---|---|
| Fabio Tranchitella | 7 (33.3%) |
| Lluis Campos | 5 (23.8%) |
| Peter Grzybowski | 3 (14.3%) |
| Alf-Rune Siqveland | 2 (9.5%) |
| Kristian Amlie | 2 (9.5%) |
| Krzysztof Jaskiewicz | 1 (4.8%) |
| Ole Petter Orhagen | 1 (4.8%) |

| Developers with the most changed lines | |
|---|---|
| Fabio Tranchitella | 554 (70.3%) |
| Kristian Amlie | 153 (19.4%) |
| Krzysztof Jaskiewicz | 31 (3.9%) |
| Lluis Campos | 19 (2.4%) |
| Peter Grzybowski | 18 (2.3%) |
| Alf-Rune Siqveland | 12 (1.5%) |
| Ole Petter Orhagen | 1 (0.1%) |

| Developers with the most lines removed | |
|---|---|
| Alf-Rune Siqveland | 3 (0.6%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 20 (95.2%) |
| RnDity | 1 (4.8%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 757 (96.1%) |
| RnDity | 31 (3.9%) |

| Employers with the most signoffs (total 0) | |
|---|---|

| Employers with the most hackers (total 7) | |
|---|---|
| Northern.tech | 6 (85.7%) |
| RnDity | 1 (14.3%) |

### Changelogs

#### deviceauth (2.6.1)

New changes in deviceauth since 2.6.0:

* Increase robustness when propagating status to inventory for pending devices, making sure the database remains consistent
  ([MEN-4604](https://northerntech.atlassian.net/browse/MEN-4604))

#### deviceconnect (1.1.1)

New changes in deviceconnect since 1.1.0:

* [] Limit size of messages transferred over websockets
  ([MEN-4803](https://northerntech.atlassian.net/browse/MEN-4803))

#### useradm-enterprise (1.14.1)

New changes in useradm-enterprise since 1.14.0:

* security fix: invalidate user JWT token cache on logout
  ([MEN-4754](https://northerntech.atlassian.net/browse/MEN-4754))

#### integration (2.7.1)

New changes in integration since 2.7.0:

* Enforce userauth middleware on non-signup tenantadm endpoints
  ([MEN-4657](https://northerntech.atlassian.net/browse/MEN-4657))
* Fix mender-configure install in Docker image
  mendersoftware/mender-client-docker-addons
* fix ad improve the the production template
  ([MEN-4790](https://northerntech.atlassian.net/browse/MEN-4790))
* Upgrade deviceauth to 2.6.1.
* Upgrade deviceconnect to 1.1.1.
* Upgrade integration to 2.7.1.
* Upgrade mender to 2.6.1.
* Upgrade mender-artifact to 3.5.2.
* Upgrade mender-connect to 1.1.1.
* Upgrade useradm to 1.14.1.
* Upgrade useradm-enterprise to 1.14.1.

## Mender 2.7.0

_Released 04.16.2021_

### Changelogs

#### auditlogs (1.1.0)

New changes in auditlogs since 1.0.0:

* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps golang from 1.14-alpine3.12 to 1.15.6-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...1.4.6)
* Bumps golang from 1.15.6-alpine3.12 to 1.16.0-alpine3.12.
* Bumps golang from 1.16.0-alpine3.12 to 1.16.2-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)

#### create-artifact-worker (1.0.2)

New changes in create-artifact-worker since 1.0.1:

* bugfix to allow spaces in artifact names
([MEN-4179](https://northerntech.atlassian.net/browse/MEN-4179))
* upgrade mender-artifact to version 3.5.0.
This enables the create-artifact-worker to generate artifacts that
implement the provides and clear provides fields.
([MEN-4409](https://northerntech.atlassian.net/browse/MEN-4409))

#### deployments (2.3.0)

New changes in deployments since 2.2.0:

* New internal endpoint for creating configuration deployments
* extend get /deployment query params with optional deployment type
* New endpoint for generating configuration artifacts on the fly
* Handle configuration artifacts on /device/deployments/next
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.24 to 1.36.28.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.24...v1.36.28)
* Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.1.4 to 1.1.5.
- [Release notes](https://github.com/google/uuid/releases)
- [Commits](https://github.com/google/uuid/compare/v1.1.4...v1.1.5)
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.28 to 1.37.1.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.28...v1.37.1)
* Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.1.5 to 1.2.0.
- [Release notes](https://github.com/google/uuid/releases)
- [Commits](https://github.com/google/uuid/compare/v1.1.5...v1.2.0)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...1.4.6)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.1 to 1.37.10.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.1...v1.37.10)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.10 to 1.37.20.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.10...v1.37.20)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.20 to 1.37.25.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.20...v1.37.25)
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.7.0 to 1.8.1.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.7.0...v1.8.1)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.25 to 1.37.30.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.25...v1.37.30)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)

#### deployments-enterprise (2.3.0)

New changes in deployments-enterprise since 2.2.0:

* New internal endpoint for creating configuration deployments
* extend get /deployment query params with optional deployment type
* New endpoint for generating configuration artifacts on the fly
* Handle configuration artifacts on /device/deployments/next
* FIX: Phased deployments getting stuck on retries
* Fix: do not increment attempts on multiple subsequent failure status reports
* docs: Fix naming conflict in v1 and v2 NewDeployment definitions.
* docs: Document missing parameters for NewDeploymentForGroup schema.
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.24 to 1.36.28.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.24...v1.36.28)
* Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.1.4 to 1.1.5.
- [Release notes](https://github.com/google/uuid/releases)
- [Commits](https://github.com/google/uuid/compare/v1.1.4...v1.1.5)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.23 to 1.36.28.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.23...v1.36.28)
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.28 to 1.37.1.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.28...v1.37.1)
* Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.1.5 to 1.2.0.
- [Release notes](https://github.com/google/uuid/releases)
- [Commits](https://github.com/google/uuid/compare/v1.1.5...v1.2.0)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...1.4.6)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...1.4.6)
* Bumps [github.com/google/uuid](https://github.com/google/uuid) from 1.1.5 to 1.2.0.
- [Release notes](https://github.com/google/uuid/releases)
- [Commits](https://github.com/google/uuid/compare/v1.1.5...v1.2.0)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.28 to 1.37.7.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.28...v1.37.7)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.1 to 1.37.10.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.1...v1.37.10)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.7 to 1.37.10.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.7...v1.37.10)
* Bumps alpine from 3.13.1 to 3.13.2.
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.10 to 1.37.20.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.10...v1.37.20)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.10 to 1.37.20.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.10...v1.37.20)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.20 to 1.37.25.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.20...v1.37.25)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.20 to 1.37.25.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.20...v1.37.25)
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.7.0 to 1.8.1.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.7.0...v1.8.1)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.25 to 1.37.30.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.25...v1.37.30)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.37.25 to 1.37.30.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/main/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.37.25...v1.37.30)
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.7.0 to 1.8.1.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.7.0...v1.8.1)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)

#### deviceauth (2.6.0)

New changes in deviceauth since 2.5.0:

* Enable support for using the service with Traefik.
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps golang from 1.14-alpine3.12 to 1.15.7-alpine3.12.
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.4.8 to 8.4.10.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.4.8...v8.4.10)
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps golang from 1.15.7-alpine3.12 to 1.15.8-alpine3.12.
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.4.10 to 8.5.0.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.4.10...v8.5.0)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...1.4.6)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.5.0 to 8.7.1.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.5.0...v8.7.1)

#### deviceconfig (1.0.0)

* First release of deviceconfig

#### deviceconnect (1.1.0)

New changes in deviceconnect since 1.0.0:

* New API end-points to trigger check-update and send-inventory on device
* New internal API end-points to trigger check-update and send-inventory
* , implement file upload and download end-points
([MEN-4418](https://northerntech.atlassian.net/browse/MEN-4418), [MEN-4482](https://northerntech.atlassian.net/browse/MEN-4482))
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...1.4.6)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)

#### gui (2.7.0)

New changes in gui since 2.6.0:

* Rename Retry deployment to Recreate deployment.
* fix page number on rowsPerPage change
([MEN-4364](https://northerntech.atlassian.net/browse/MEN-4364))
* fixed an issue that prevented existing user roles from being removed
* fixed an issue that prevented loading dynamic group devices when navigating to device groups
* fixed an issue that prevented the deployment attempt count from being shown in the deployment report
([MEN-4399](https://northerntech.atlassian.net/browse/MEN-4399))
* added single device configuration editor
* fixed onboarding tips dismissal not being saved right away
* switched auditlogs to drawer interaction for details
([MEN-4313](https://northerntech.atlassian.net/browse/MEN-4313))
* onboarding: Pass `--demo` flag to `get.mender.io` script.
([MEN-4461](https://northerntech.atlassian.net/browse/MEN-4461))
* extend RBAC with "Deployments Manager" role
* added user verification requirement for 2fa activation
([MEN-4484](https://northerntech.atlassian.net/browse/MEN-4484))
* improved deployment creation for large device fleets
* fixed an error that prevented deployment timeframe selection
* prevented enter press on 2fa code entry causing a redirect
* Aggregated Dependabot Changelogs:
* Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 7.29.2 to 7.29.4.
- [Release notes](https://github.com/testing-library/dom-testing-library/releases)
- [Changelog](https://github.com/testing-library/dom-testing-library/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/dom-testing-library/compare/v7.29.2...v7.29.4)
* Bumps [webpack](https://github.com/webpack/webpack) from 5.12.3 to 5.15.0.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.12.3...v5.15.0)
* Bumps [@stripe/react-stripe-js](https://github.com/stripe/react-stripe-js) from 1.1.2 to 1.2.0.
- [Release notes](https://github.com/stripe/react-stripe-js/releases)
- [Changelog](https://github.com/stripe/react-stripe-js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/stripe/react-stripe-js/compare/v1.1.2...v1.2.0)
* Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 1.3.3 to 1.3.4.
- [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
- [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v1.3.3...v1.3.4)
* Bumps [cypress-localstorage-commands](https://github.com/javierbrea/cypress-localstorage-commands) from 1.3.1 to 1.4.0.
- [Release notes](https://github.com/javierbrea/cypress-localstorage-commands/releases)
- [Changelog](https://github.com/javierbrea/cypress-localstorage-commands/blob/master/CHANGELOG.md)
- [Commits](https://github.com/javierbrea/cypress-localstorage-commands/compare/v1.3.1...v1.4.0)
* Bumps [@cypress/skip-test](https://github.com/cypress-io/cypress-skip-test) from 2.5.1 to 2.6.0.
- [Release notes](https://github.com/cypress-io/cypress-skip-test/releases)
- [Commits](https://github.com/cypress-io/cypress-skip-test/compare/v2.5.1...v2.6.0)
* Bumps [generate-password](https://github.com/brendanashworth/generate-password) from 1.5.1 to 1.6.0.
- [Release notes](https://github.com/brendanashworth/generate-password/releases)
- [Changelog](https://github.com/brendanashworth/generate-password/blob/master/CHANGELOG.md)
- [Commits](https://github.com/brendanashworth/generate-password/commits)
* Bumps [eslint](https://github.com/eslint/eslint) from 7.17.0 to 7.18.0.
- [Release notes](https://github.com/eslint/eslint/releases)
- [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
- [Commits](https://github.com/eslint/eslint/compare/v7.17.0...v7.18.0)
* Bumps [husky](https://github.com/typicode/husky) from 4.3.7 to 4.3.8.
- [Release notes](https://github.com/typicode/husky/releases)
- [Commits](https://github.com/typicode/husky/compare/v4.3.7...v4.3.8)
* Bumps [react-copy-to-clipboard](https://github.com/nkbt/react-copy-to-clipboard) from 5.0.2 to 5.0.3.
- [Release notes](https://github.com/nkbt/react-copy-to-clipboard/releases)
- [Commits](https://github.com/nkbt/react-copy-to-clipboard/compare/v5.0.2...v5.0.3)
* Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.11.8 to 5.11.9.
- [Release notes](https://github.com/testing-library/jest-dom/releases)
- [Changelog](https://github.com/testing-library/jest-dom/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/jest-dom/compare/v5.11.8...v5.11.9)
* Bumps [core-js](https://github.com/zloirock/core-js) from 3.8.2 to 3.8.3.
- [Release notes](https://github.com/zloirock/core-js/releases)
- [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/zloirock/core-js/compare/v3.8.2...v3.8.3)
* Bumps [react-idle-timer](https://github.com/supremetechnopriest/react-idle-timer) from 4.5.1 to 4.5.2.
- [Release notes](https://github.com/supremetechnopriest/react-idle-timer/releases)
- [Changelog](https://github.com/SupremeTechnopriest/react-idle-timer/blob/master/CHANGELOG.md)
- [Commits](https://github.com/supremetechnopriest/react-idle-timer/compare/4.5.1...4.5.2)
* Bumps [@mdi/js](https://github.com/Templarian/MaterialDesign-JS) from 5.8.55 to 5.9.55.
- [Release notes](https://github.com/Templarian/MaterialDesign-JS/releases)
- [Commits](https://github.com/Templarian/MaterialDesign-JS/compare/v5.8.55...v5.9.55)
* Bumps [webpack](https://github.com/webpack/webpack) from 5.15.0 to 5.17.0.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.15.0...v5.17.0)
* Bumps node from 15.5.1-alpine to 15.6.0-alpine.
* Bumps [dayjs](https://github.com/iamkun/dayjs) from 1.10.3 to 1.10.4.
- [Release notes](https://github.com/iamkun/dayjs/releases)
- [Changelog](https://github.com/iamkun/dayjs/blob/v1.10.4/CHANGELOG.md)
- [Commits](https://github.com/iamkun/dayjs/compare/v1.10.3...v1.10.4)
* Bumps [cypress](https://github.com/cypress-io/cypress) from 6.2.1 to 6.3.0.
- [Release notes](https://github.com/cypress-io/cypress/releases)
- [Changelog](https://github.com/cypress-io/cypress/blob/develop/.releaserc.base.js)
- [Commits](https://github.com/cypress-io/cypress/compare/v6.2.1...v6.3.0)
* Bumps [cypress-image-snapshot](https://github.com/palmerhq/cypress-image-snapshot) from 4.0.0 to 4.0.1.
- [Release notes](https://github.com/palmerhq/cypress-image-snapshot/releases)
- [Changelog](https://github.com/jaredpalmer/cypress-image-snapshot/blob/master/CHANGELOG.md)
- [Commits](https://github.com/palmerhq/cypress-image-snapshot/compare/v4.0.0...v4.0.1)
* Bumps cypress/included from 6.2.1 to 6.3.0.
* Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.2.1 to 10.2.3.
- [Release notes](https://github.com/postcss/autoprefixer/releases)
- [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
- [Commits](https://github.com/postcss/autoprefixer/compare/10.2.1...10.2.3)
* Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 12.6.0 to 12.6.2.
- [Release notes](https://github.com/testing-library/user-event/releases)
- [Changelog](https://github.com/testing-library/user-event/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/user-event/compare/v12.6.0...v12.6.2)
* Bumps [cypress-file-upload](https://github.com/abramenal/cypress-file-upload) from 4.1.1 to 5.0.2.
- [Release notes](https://github.com/abramenal/cypress-file-upload/releases)
- [Commits](https://github.com/abramenal/cypress-file-upload/compare/v4.1.1...v5.0.2)
* Bumps [webpack-cli](https://github.com/webpack/webpack-cli) from 4.3.1 to 4.4.0.
- [Release notes](https://github.com/webpack/webpack-cli/releases)
- [Changelog](https://github.com/webpack/webpack-cli/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack/webpack-cli/compare/webpack-cli@4.3.1...webpack-cli@4.4.0)
* Bumps [postcss-loader](https://github.com/webpack-contrib/postcss-loader) from 4.1.0 to 4.2.0.
- [Release notes](https://github.com/webpack-contrib/postcss-loader/releases)
- [Changelog](https://github.com/webpack-contrib/postcss-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/postcss-loader/compare/v4.1.0...v4.2.0)
* Bumps node from 15.6.0-alpine to 15.7.0-alpine.
* Bumps [eslint](https://github.com/eslint/eslint) from 7.18.0 to 7.19.0.
- [Release notes](https://github.com/eslint/eslint/releases)
- [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
- [Commits](https://github.com/eslint/eslint/compare/v7.18.0...v7.19.0)
* Bumps [less](https://github.com/less/less.js) from 4.1.0 to 4.1.1.
- [Release notes](https://github.com/less/less.js/releases)
- [Changelog](https://github.com/less/less.js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/less/less.js/compare/v4.1.0...v4.1.1)
* Bumps [webpack](https://github.com/webpack/webpack) from 5.17.0 to 5.19.0.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.17.0...v5.19.0)
* Bumps [xterm-addon-search](https://github.com/xtermjs/xterm.js) from 0.7.0 to 0.8.0.
- [Release notes](https://github.com/xtermjs/xterm.js/releases)
- [Commits](https://github.com/xtermjs/xterm.js/compare/0.7...0.8)
* Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.30.0 to 0.31.0.
- [Release notes](https://github.com/jquense/react-big-calendar/releases)
- [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
- [Commits](https://github.com/jquense/react-big-calendar/compare/v0.30.0...v0.31.0)
* Bumps [xterm-addon-fit](https://github.com/xtermjs/xterm.js) from 0.4.0 to 0.5.0.
- [Release notes](https://github.com/xtermjs/xterm.js/releases)
- [Commits](https://github.com/xtermjs/xterm.js/compare/0.4...0.5)
* Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.2.3 to 10.2.4.
- [Release notes](https://github.com/postcss/autoprefixer/releases)
- [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
- [Commits](https://github.com/postcss/autoprefixer/compare/10.2.3...10.2.4)
* Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 1.3.4 to 1.3.5.
- [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
- [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v1.3.4...v1.3.5)
* Bumps [@stripe/react-stripe-js](https://github.com/stripe/react-stripe-js) from 1.2.0 to 1.2.1.
- [Release notes](https://github.com/stripe/react-stripe-js/releases)
- [Changelog](https://github.com/stripe/react-stripe-js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/stripe/react-stripe-js/compare/v1.2.0...v1.2.1)
* Bumps [msw](https://github.com/mswjs/msw) from 0.25.0 to 0.26.0.
- [Release notes](https://github.com/mswjs/msw/releases)
- [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
- [Commits](https://github.com/mswjs/msw/compare/v0.25.0...v0.26.0)
* Bumps [victory](https://github.com/formidablelabs/victory) from 35.4.6 to 35.4.8.
- [Release notes](https://github.com/formidablelabs/victory/releases)
- [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
- [Commits](https://github.com/formidablelabs/victory/compare/v35.4.6...v35.4.8)
* Bumps [msw](https://github.com/mswjs/msw) from 0.26.0 to 0.26.1.
- [Release notes](https://github.com/mswjs/msw/releases)
- [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
- [Commits](https://github.com/mswjs/msw/compare/v0.26.0...v0.26.1)
* Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 12.6.3 to 12.7.0.
- [Release notes](https://github.com/testing-library/user-event/releases)
- [Changelog](https://github.com/testing-library/user-event/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/user-event/compare/v12.6.3...v12.7.0)
* Bumps [msgpack5](https://github.com/mcollina/msgpack5) from 5.0.0 to 5.1.0.
- [Release notes](https://github.com/mcollina/msgpack5/releases)
- [Commits](https://github.com/mcollina/msgpack5/compare/v5.0.0...v5.1.0)
* Bumps [eslint](https://github.com/eslint/eslint) from 7.19.0 to 7.20.0.
- [Release notes](https://github.com/eslint/eslint/releases)
- [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
- [Commits](https://github.com/eslint/eslint/compare/v7.19.0...v7.20.0)
* Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.12.13 to 7.12.16.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.12.16/packages/babel-core)
* Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.12.13 to 7.12.16.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.12.16/packages/babel-preset-env)
* Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 12.7.0 to 12.7.1.
- [Release notes](https://github.com/testing-library/user-event/releases)
- [Changelog](https://github.com/testing-library/user-event/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/user-event/compare/v12.7.0...v12.7.1)
* Bumps [html-webpack-plugin](https://github.com/jantimon/html-webpack-plugin) from 5.0.0 to 5.1.0.
- [Release notes](https://github.com/jantimon/html-webpack-plugin/releases)
- [Changelog](https://github.com/jantimon/html-webpack-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/jantimon/html-webpack-plugin/compare/v5.0.0...v5.1.0)
* Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.31.0 to 0.32.0.
- [Release notes](https://github.com/jquense/react-big-calendar/releases)
- [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
- [Commits](https://github.com/jquense/react-big-calendar/compare/v0.31.0...v0.32.0)
* Bumps [victory](https://github.com/formidablelabs/victory) from 35.4.8 to 35.4.9.
- [Release notes](https://github.com/formidablelabs/victory/releases)
- [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
- [Commits](https://github.com/formidablelabs/victory/compare/v35.4.8...v35.4.9)
* Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.9.1 to 2.9.2.
- [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
- [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.9.1...v2.9.2)
* Bumps cypress/included from 6.4.0 to 6.5.0.
* Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.12.15 to 7.13.9.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.13.9/packages/babel-plugin-transform-runtime)
* Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.12.1 to 1.13.1.
- [Release notes](https://github.com/stripe/stripe-js/releases)
- [Commits](https://github.com/stripe/stripe-js/compare/v1.12.1...v1.13.1)
* Bumps [elliptic](https://github.com/indutny/elliptic) from 6.5.3 to 6.5.4.
- [Release notes](https://github.com/indutny/elliptic/releases)
- [Commits](https://github.com/indutny/elliptic/compare/v6.5.3...v6.5.4)
* Bumps [react-idle-timer](https://github.com/supremetechnopriest/react-idle-timer) from 4.5.5 to 4.5.6.
- [Release notes](https://github.com/supremetechnopriest/react-idle-timer/releases)
- [Changelog](https://github.com/SupremeTechnopriest/react-idle-timer/blob/master/CHANGELOG.md)
- [Commits](https://github.com/supremetechnopriest/react-idle-timer/compare/4.5.5...4.5.6)
* Bumps [eslint](https://github.com/eslint/eslint) from 7.21.0 to 7.22.0.
- [Release notes](https://github.com/eslint/eslint/releases)
- [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
- [Commits](https://github.com/eslint/eslint/compare/v7.21.0...v7.22.0)
* Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 12.8.1 to 12.8.3.
- [Release notes](https://github.com/testing-library/user-event/releases)
- [Changelog](https://github.com/testing-library/user-event/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/user-event/compare/v12.8.1...v12.8.3)
* Bumps [webpack](https://github.com/webpack/webpack) from 5.24.3 to 5.25.1.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.24.3...v5.25.1)
* Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.13.9 to 7.13.10.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.13.10/packages/babel-preset-env)
* Bumps nginx from 1.19.7-alpine to 1.19.8-alpine.
* Bumps [@material-ui/pickers](https://github.com/mui-org/material-ui-pickers) from 3.2.10 to 3.3.10.
- [Release notes](https://github.com/mui-org/material-ui-pickers/releases)
- [Changelog](https://github.com/mui-org/material-ui-pickers/blob/next/CHANGELOG.md)
- [Commits](https://github.com/mui-org/material-ui-pickers/compare/v3.2.10...v3.3.10)
* Bumps [msw](https://github.com/mswjs/msw) from 0.27.0 to 0.27.1.
- [Release notes](https://github.com/mswjs/msw/releases)
- [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
- [Commits](https://github.com/mswjs/msw/compare/v0.27.0...v0.27.1)
* Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.13.8 to 7.13.10.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.13.10/packages/babel-core)
* Bumps [postcss](https://github.com/postcss/postcss) from 8.2.7 to 8.2.8.
- [Release notes](https://github.com/postcss/postcss/releases)
- [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
- [Commits](https://github.com/postcss/postcss/compare/8.2.7...8.2.8)
* Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.9.2 to 2.10.0.
- [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
- [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.9.2...v2.10.0)
* Bumps [@babel/plugin-transform-runtime](https://github.com/babel/babel/tree/HEAD/packages/babel-plugin-transform-runtime) from 7.13.9 to 7.13.10.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.13.10/packages/babel-plugin-transform-runtime)
* Bumps [html-webpack-plugin](https://github.com/jantimon/html-webpack-plugin) from 5.3.0 to 5.3.1.
- [Release notes](https://github.com/jantimon/html-webpack-plugin/releases)
- [Changelog](https://github.com/jantimon/html-webpack-plugin/blob/main/CHANGELOG.md)
- [Commits](https://github.com/jantimon/html-webpack-plugin/compare/v5.3.0...v5.3.1)
* Bumps [webpack](https://github.com/webpack/webpack) from 5.25.1 to 5.26.0.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.25.1...v5.26.0)
* Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 5.1.1 to 5.1.3.
- [Release notes](https://github.com/webpack-contrib/css-loader/releases)
- [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/css-loader/compare/v5.1.1...v5.1.3)
* Bumps [jest](https://github.com/facebook/jest) from 27.0.0-next.4 to 27.0.0-next.5.
- [Release notes](https://github.com/facebook/jest/releases)
- [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
- [Commits](https://github.com/facebook/jest/compare/v27.0.0-next.4...v27.0.0-next.5)
* Bumps [xterm](https://github.com/xtermjs/xterm.js) from 4.10.0 to 4.11.0.
- [Release notes](https://github.com/xtermjs/xterm.js/releases)
- [Commits](https://github.com/xtermjs/xterm.js/compare/4.10.0...4.11.0)
* Bumps [postcss-loader](https://github.com/webpack-contrib/postcss-loader) from 5.1.0 to 5.2.0.
- [Release notes](https://github.com/webpack-contrib/postcss-loader/releases)
- [Changelog](https://github.com/webpack-contrib/postcss-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/postcss-loader/compare/v5.1.0...v5.2.0)
* Bumps [victory](https://github.com/formidablelabs/victory) from 35.4.11 to 35.4.12.
- [Release notes](https://github.com/formidablelabs/victory/releases)
- [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
- [Commits](https://github.com/formidablelabs/victory/compare/v35.4.11...v35.4.12)
* Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 12.8.3 to 13.0.6.
- [Release notes](https://github.com/testing-library/user-event/releases)
- [Changelog](https://github.com/testing-library/user-event/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/user-event/compare/v12.8.3...v13.0.6)
* Bumps [husky](https://github.com/typicode/husky) from 5.1.3 to 5.2.0.
- [Release notes](https://github.com/typicode/husky/releases)
- [Commits](https://github.com/typicode/husky/compare/v5.1.3...v5.2.0)
* Bumps [webpack](https://github.com/webpack/webpack) from 5.26.0 to 5.27.1.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.26.0...v5.27.1)
* Bumps node from 15.11.0-alpine to 15.12.0-alpine.
* Bumps [cypress-file-upload](https://github.com/abramenal/cypress-file-upload) from 5.0.2 to 5.0.3.
- [Release notes](https://github.com/abramenal/cypress-file-upload/releases)
- [Commits](https://github.com/abramenal/cypress-file-upload/compare/v5.0.2...v5.0.3)
* Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 13.0.6 to 13.0.7.
- [Release notes](https://github.com/testing-library/user-event/releases)
- [Changelog](https://github.com/testing-library/user-event/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/user-event/compare/v13.0.6...v13.0.7)
* Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.11.9 to 5.11.10.
- [Release notes](https://github.com/testing-library/jest-dom/releases)
- [Changelog](https://github.com/testing-library/jest-dom/blob/main/CHANGELOG.md)
- [Commits](https://github.com/testing-library/jest-dom/compare/v5.11.9...v5.11.10)
* Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.13.10 to 7.13.12.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.13.12/packages/babel-preset-env)
* Bumps [esbuild-loader](https://github.com/privatenumber/esbuild-loader) from 2.10.0 to 2.11.0.
- [Release notes](https://github.com/privatenumber/esbuild-loader/releases)
- [Commits](https://github.com/privatenumber/esbuild-loader/compare/v2.10.0...v2.11.0)
* Bumps [msw](https://github.com/mswjs/msw) from 0.27.1 to 0.28.0.
- [Release notes](https://github.com/mswjs/msw/releases)
- [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
- [Commits](https://github.com/mswjs/msw/compare/v0.27.1...v0.28.0)
* Bumps [msgpack5](https://github.com/mcollina/msgpack5) from 5.3.1 to 5.3.2.
- [Release notes](https://github.com/mcollina/msgpack5/releases)
- [Commits](https://github.com/mcollina/msgpack5/compare/v5.3.1...v5.3.2)
* Bumps [react-redux](https://github.com/reduxjs/react-redux) from 7.2.2 to 7.2.3.
- [Release notes](https://github.com/reduxjs/react-redux/releases)
- [Changelog](https://github.com/reduxjs/react-redux/blob/master/CHANGELOG.md)
- [Commits](https://github.com/reduxjs/react-redux/compare/v7.2.2...v7.2.3)
* Bumps [webpack-cli](https://github.com/webpack/webpack-cli) from 4.5.0 to 4.6.0.
- [Release notes](https://github.com/webpack/webpack-cli/releases)
- [Changelog](https://github.com/webpack/webpack-cli/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack/webpack-cli/compare/webpack-cli@4.5.0...webpack-cli@4.6.0)
* Bumps [@testing-library/user-event](https://github.com/testing-library/user-event) from 13.0.7 to 13.0.16.
- [Release notes](https://github.com/testing-library/user-event/releases)
- [Changelog](https://github.com/testing-library/user-event/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/user-event/compare/v13.0.7...v13.0.16)
* Bumps [eslint](https://github.com/eslint/eslint) from 7.22.0 to 7.23.0.
- [Release notes](https://github.com/eslint/eslint/releases)
- [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
- [Commits](https://github.com/eslint/eslint/compare/v7.22.0...v7.23.0)
* Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.13.10 to 7.13.13.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.13.13/packages/babel-core)
* Bumps [@stripe/stripe-js](https://github.com/stripe/stripe-js) from 1.13.1 to 1.13.2.
- [Release notes](https://github.com/stripe/stripe-js/releases)
- [Commits](https://github.com/stripe/stripe-js/compare/v1.13.1...v1.13.2)
* Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 1.3.9 to 1.4.0.
- [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
- [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v1.3.9...v1.4.0)
* Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.22.0 to 7.23.1.
- [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
- [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
- [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.22.0...v7.23.1)
* Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 7.30.0 to 7.30.1.
- [Release notes](https://github.com/testing-library/dom-testing-library/releases)
- [Changelog](https://github.com/testing-library/dom-testing-library/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/dom-testing-library/compare/v7.30.0...v7.30.1)
* Bumps [react-dropzone](https://github.com/react-dropzone/react-dropzone) from 11.3.1 to 11.3.2.
- [Release notes](https://github.com/react-dropzone/react-dropzone/releases)
- [Commits](https://github.com/react-dropzone/react-dropzone/compare/v11.3.1...v11.3.2)
* Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 5.1.3 to 5.2.0.
- [Release notes](https://github.com/webpack-contrib/css-loader/releases)
- [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/css-loader/compare/v5.1.3...v5.2.0)
* Bumps [husky](https://github.com/typicode/husky) from 5.2.0 to 6.0.0.
- [Release notes](https://github.com/typicode/husky/releases)
- [Commits](https://github.com/typicode/husky/compare/v5.2.0...v6.0.0)
* Bumps [webpack](https://github.com/webpack/webpack) from 5.27.1 to 5.28.0.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.27.1...v5.28.0)
* Bumps [@babel/preset-react](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-react) from 7.12.13 to 7.13.13.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.13.13/packages/babel-preset-react)
* Bumps [y18n](https://github.com/yargs/y18n) from 3.2.1 to 3.2.2.
- [Release notes](https://github.com/yargs/y18n/releases)
- [Changelog](https://github.com/yargs/y18n/blob/master/CHANGELOG.md)
- [Commits](https://github.com/yargs/y18n/commits)
* Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 7.30.1 to 7.30.3.
- [Release notes](https://github.com/testing-library/dom-testing-library/releases)
- [Changelog](https://github.com/testing-library/dom-testing-library/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/dom-testing-library/compare/v7.30.1...v7.30.3)
* Bumps [postcss](https://github.com/postcss/postcss) from 8.2.8 to 8.2.9.
- [Release notes](https://github.com/postcss/postcss/releases)
- [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
- [Commits](https://github.com/postcss/postcss/compare/8.2.8...8.2.9)
* Bumps [victory](https://github.com/formidablelabs/victory) from 35.4.12 to 35.4.13.
- [Release notes](https://github.com/formidablelabs/victory/releases)
- [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
- [Commits](https://github.com/formidablelabs/victory/compare/v35.4.12...v35.4.13)
* Bumps [webpack](https://github.com/webpack/webpack) from 5.28.0 to 5.30.0.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.28.0...v5.30.0)
* Bumps [core-js](https://github.com/zloirock/core-js/tree/HEAD/packages/core-js) from 3.9.1 to 3.10.0.
- [Release notes](https://github.com/zloirock/core-js/releases)
- [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/zloirock/core-js/commits/v3.10.0/packages/core-js)
* Bumps [cypress-localstorage-commands](https://github.com/javierbrea/cypress-localstorage-commands) from 1.4.1 to 1.4.2.
- [Release notes](https://github.com/javierbrea/cypress-localstorage-commands/releases)
- [Changelog](https://github.com/javierbrea/cypress-localstorage-commands/blob/master/CHANGELOG.md)
- [Commits](https://github.com/javierbrea/cypress-localstorage-commands/compare/v1.4.1...v1.4.2)
* Bumps node from 15.12.0-alpine to 15.13.0-alpine.
* Bumps nginx from 1.19.8-alpine to 1.19.9-alpine.
* Bumps [jest-watch-typeahead](https://github.com/jest-community/jest-watch-typeahead) from 0.6.1 to 0.6.2.
- [Release notes](https://github.com/jest-community/jest-watch-typeahead/releases)
- [Changelog](https://github.com/jest-community/jest-watch-typeahead/blob/master/CHANGELOG.md)
- [Commits](https://github.com/jest-community/jest-watch-typeahead/compare/v0.6.1...v0.6.2)
* Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.13.13 to 7.13.14.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.13.14/packages/babel-core)
* Bumps [@testing-library/react](https://github.com/testing-library/react-testing-library) from 11.2.5 to 11.2.6.
- [Release notes](https://github.com/testing-library/react-testing-library/releases)
- [Changelog](https://github.com/testing-library/react-testing-library/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/react-testing-library/compare/v11.2.5...v11.2.6)
* Bumps [mzedel-cypress-image-snapshot](https://github.com/mzedel/cypress-image-snapshot) from 4.0.3 to 4.0.5.
- [Release notes](https://github.com/mzedel/cypress-image-snapshot/releases)
- [Changelog](https://github.com/mzedel/cypress-image-snapshot/blob/master/CHANGELOG.md)
- [Commits](https://github.com/mzedel/cypress-image-snapshot/compare/v4.0.3...v4.0.5)
* Bumps [cypress](https://github.com/cypress-io/cypress) from 6.8.0 to 6.9.1.
- [Release notes](https://github.com/cypress-io/cypress/releases)
- [Changelog](https://github.com/cypress-io/cypress/blob/develop/.releaserc.base.js)
- [Commits](https://github.com/cypress-io/cypress/commits)
* Bumps [msw](https://github.com/mswjs/msw) from 0.28.0 to 0.28.1.
- [Release notes](https://github.com/mswjs/msw/releases)
- [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
- [Commits](https://github.com/mswjs/msw/compare/v0.28.0...v0.28.1)

#### integration (2.7.0)

New changes in integration since 2.6.0:

* demo script, include docker-compose.connect.yml by default
([MEN-4357](https://northerntech.atlassian.net/browse/MEN-4357))
* Add auditlogs and deviceconnect to production templates
* migrated gateway service to use traefik
* production template: configure mender-api-gateway as a storage proxy
* Include the configuration add-on in the demo script
* Remove nginx-based api-gateway and replace with Traefik.
* fix auth verification on useradm APIs
([MEN-4623](https://northerntech.atlassian.net/browse/MEN-4623))
* Upgrade auditlogs to 1.1.0.
* Upgrade create-artifact-worker to 1.0.2.
* Upgrade deployments to 2.3.0.
* Upgrade deployments-enterprise to 2.3.0.
* Upgrade deviceauth to 2.6.0.
* Add deviceconfig 1.0.0.
* Upgrade deviceconnect to 1.1.0.
* Upgrade gui to 2.7.0.
* Upgrade integration to 2.7.0.
* Upgrade inventory to 2.3.0.
* Upgrade inventory-enterprise to 2.3.0.
* Upgrade mender to 2.6.0.
* Upgrade mender-artifact to 3.5.1.
* Upgrade mender-cli to 1.7.0.
* Upgrade mender-connect to 1.1.0.
* Upgrade tenantadm to 3.1.0.
* Upgrade useradm to 1.14.0.
* Upgrade useradm-enterprise to 1.14.0.
* Upgrade workflows to 1.4.0.
* Upgrade workflows-enterprise to 1.4.0.
* Aggregated Dependabot Changelogs:
* Bumps [docker-compose](https://github.com/docker/compose) from 1.27.4 to 1.28.0.
- [Release notes](https://github.com/docker/compose/releases)
- [Changelog](https://github.com/docker/compose/blob/1.28.0/CHANGELOG.md)
- [Commits](https://github.com/docker/compose/compare/1.27.4...1.28.0)
* Bumps [fabric](http://fabfile.org) from 2.5.0 to 2.6.0.
* Bumps [docker-compose](https://github.com/docker/compose) from 1.28.0 to 1.28.2.
- [Release notes](https://github.com/docker/compose/releases)
- [Changelog](https://github.com/docker/compose/blob/1.28.2/CHANGELOG.md)
- [Commits](https://github.com/docker/compose/compare/1.28.0...1.28.2)
* Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.2.1 to 6.2.2.
- [Release notes](https://github.com/pytest-dev/pytest/releases)
- [Changelog](https://github.com/pytest-dev/pytest/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pytest-dev/pytest/compare/6.2.1...6.2.2)
* Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.2.1 to 6.2.2.
- [Release notes](https://github.com/pytest-dev/pytest/releases)
- [Changelog](https://github.com/pytest-dev/pytest/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pytest-dev/pytest/compare/6.2.1...6.2.2)
* Bumps [pyotp](https://github.com/pyotp/pyotp) from 2.4.1 to 2.5.1.
- [Release notes](https://github.com/pyotp/pyotp/releases)
- [Changelog](https://github.com/pyauth/pyotp/blob/develop/Changes.rst)
- [Commits](https://github.com/pyotp/pyotp/compare/v2.4.1...v2.5.1)
* Bumps [pyotp](https://github.com/pyotp/pyotp) from 2.5.1 to 2.6.0.
- [Release notes](https://github.com/pyotp/pyotp/releases)
- [Changelog](https://github.com/pyauth/pyotp/blob/develop/Changes.rst)
- [Commits](https://github.com/pyotp/pyotp/compare/v2.5.1...v2.6.0)
* Bumps [stripe](https://github.com/stripe/stripe-python) from 2.55.1 to 2.55.2.
- [Release notes](https://github.com/stripe/stripe-python/releases)
- [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
- [Commits](https://github.com/stripe/stripe-python/compare/v2.55.1...v2.55.2)
* Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.11.2 to 3.11.3.
- [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
- [Changelog](https://github.com/mongodb/mongo-python-driver/blob/3.11.3/doc/changelog.rst)
- [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.11.2...3.11.3)
* Bumps [pymongo](https://github.com/mongodb/mongo-python-driver) from 3.11.2 to 3.11.3.
- [Release notes](https://github.com/mongodb/mongo-python-driver/releases)
- [Changelog](https://github.com/mongodb/mongo-python-driver/blob/3.11.3/doc/changelog.rst)
- [Commits](https://github.com/mongodb/mongo-python-driver/compare/3.11.2...3.11.3)
* Bumps [cryptography](https://github.com/pyca/cryptography) from 3.3.1 to 3.4.4.
- [Release notes](https://github.com/pyca/cryptography/releases)
- [Changelog](https://github.com/pyca/cryptography/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pyca/cryptography/compare/3.3.1...3.4.4)
* Bumps [cryptography](https://github.com/pyca/cryptography) from 3.3.2 to 3.4.4.
- [Release notes](https://github.com/pyca/cryptography/releases)
- [Changelog](https://github.com/pyca/cryptography/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pyca/cryptography/compare/3.3.2...3.4.4)
* Bumps [cryptography](https://github.com/pyca/cryptography) from 3.3.2 to 3.4.4.
- [Release notes](https://github.com/pyca/cryptography/releases)
- [Changelog](https://github.com/pyca/cryptography/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pyca/cryptography/compare/3.3.2...3.4.4)
* Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.4 to 3.4.5.
- [Release notes](https://github.com/pyca/cryptography/releases)
- [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
- [Commits](https://github.com/pyca/cryptography/compare/3.4.4...3.4.5)
* Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.4 to 3.4.5.
- [Release notes](https://github.com/pyca/cryptography/releases)
- [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
- [Commits](https://github.com/pyca/cryptography/compare/3.4.4...3.4.5)
* Bumps python from 3.9.1 to 3.9.2.
* Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.5 to 3.4.6.
- [Release notes](https://github.com/pyca/cryptography/releases)
- [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
- [Commits](https://github.com/pyca/cryptography/compare/3.4.5...3.4.6)
* Bumps [docker-compose](https://github.com/docker/compose) from 1.28.2 to 1.28.4.
- [Release notes](https://github.com/docker/compose/releases)
- [Changelog](https://github.com/docker/compose/blob/1.28.4/CHANGELOG.md)
- [Commits](https://github.com/docker/compose/compare/1.28.2...1.28.4)
* Bumps [cryptography](https://github.com/pyca/cryptography) from 3.4.5 to 3.4.6.
- [Release notes](https://github.com/pyca/cryptography/releases)
- [Changelog](https://github.com/pyca/cryptography/blob/main/CHANGELOG.rst)
- [Commits](https://github.com/pyca/cryptography/compare/3.4.5...3.4.6)
* Bumps [stripe](https://github.com/stripe/stripe-python) from 2.55.2 to 2.56.0.
- [Release notes](https://github.com/stripe/stripe-python/releases)
- [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
- [Commits](https://github.com/stripe/stripe-python/compare/v2.55.2...v2.56.0)
* Bumps [docker-compose](https://github.com/docker/compose) from 1.28.4 to 1.28.5.
- [Release notes](https://github.com/docker/compose/releases)
- [Changelog](https://github.com/docker/compose/blob/1.28.5/CHANGELOG.md)
- [Commits](https://github.com/docker/compose/compare/1.28.4...1.28.5)
* Bumps [pillow](https://github.com/python-pillow/Pillow) from 8.1.0 to 8.1.2.
- [Release notes](https://github.com/python-pillow/Pillow/releases)
- [Changelog](https://github.com/python-pillow/Pillow/blob/master/CHANGES.rst)
- [Commits](https://github.com/python-pillow/Pillow/compare/8.1.0...8.1.2)
* Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.3 to 1.26.4.
- [Release notes](https://github.com/urllib3/urllib3/releases)
- [Changelog](https://github.com/urllib3/urllib3/blob/main/CHANGES.rst)
- [Commits](https://github.com/urllib3/urllib3/compare/1.26.3...1.26.4)
* Bumps [urllib3](https://github.com/urllib3/urllib3) from 1.26.2 to 1.26.4.
- [Release notes](https://github.com/urllib3/urllib3/releases)
- [Changelog](https://github.com/urllib3/urllib3/blob/main/CHANGES.rst)
- [Commits](https://github.com/urllib3/urllib3/compare/1.26.2...1.26.4)
* Bumps [contextlib2](https://github.com/jazzband/contextlib2) from 0.6.0 to 0.6.0.post1.
- [Release notes](https://github.com/jazzband/contextlib2/releases)
- [Commits](https://github.com/jazzband/contextlib2/compare/v0.6.0...v0.6.0.post1)

#### inventory (2.3.0)

New changes in inventory since 2.2.0:

* Support returning a subset of attributes in filters/search
* docs: deprecate DELETE /devices/{id} management endpoint
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps golang from 1.14-alpine3.12 to 1.15.7-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps golang from 1.15.7-alpine3.12 to 1.15.8-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...v1.5.0)

#### inventory-enterprise (2.3.0)

New changes in inventory-enterprise since 2.2.0:

* Support returning a subset of attributes in filters/search
* docs: deprecate DELETE /devices/{id} management endpoint
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps golang from 1.14-alpine3.12 to 1.15.7-alpine3.12.
* Bumps golang from 1.14-alpine3.12 to 1.15.7-alpine3.12.
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.4.8 to 8.4.10.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.4.8...v8.4.10)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps golang from 1.15.7-alpine3.12 to 1.15.8-alpine3.12.
* Bumps alpine from 3.13.1 to 3.13.2.
* Bumps golang from 1.15.7-alpine3.12 to 1.16.0-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...1.4.6)
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.4.10 to 8.7.1.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.4.10...v8.7.1)
* Bumps golang from 1.16.0-alpine3.12 to 1.16.2-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...v1.5.0)

#### tenantadm (3.1.0)

New changes in tenantadm since 3.0.0:

* Return Add-ons in GET user/tenant
([MEN-4306](https://northerntech.atlassian.net/browse/MEN-4306))
* internal api: PUT /tenant/:id accepts addons
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps golang from 1.14-alpine3.12 to 1.15.7-alpine3.12.
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps golang from 1.15.7-alpine3.12 to 1.15.8-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...1.4.6)
* Bumps golang from 1.15.8-alpine3.12 to 1.16.0-alpine3.12.
* Bumps alpine from 3.13.1 to 3.13.2.
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.7.0 to 1.8.0.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.7.0...v1.8.0)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.8.0 to 1.8.1.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.8.0...v1.8.1)
* Bumps golang from 1.16.0-alpine3.12 to 1.16.2-alpine3.12.

#### useradm (1.14.0)

New changes in useradm since 1.13.0:

* use traefik's X-Forwarded-* headers
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps golang from 1.14-alpine3.12 to 1.15.7-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...1.4.6)
* Bumps alpine from 3.13.1 to 3.13.2.
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.7.0 to 1.8.0.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.7.0...v1.8.0)
* Bumps golang from 1.15.7-alpine3.12 to 1.16.2-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.8.0 to 1.8.1.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.8.0...v1.8.1)

#### useradm-enterprise (1.14.0)

New changes in useradm-enterprise since 1.13.0:

* use traefik's X-Forwarded-* headers
* New endpoints for email verification.
Introduce new endpoints that enable email verification.
The first endpoint starts the email verification procedure.
As a part of this procedure, we are sending a verification email to the user.
The verification email contains a link for email verification.
The second endpoint can be used to finalize email verification.
Only users with a verified email address have access to two factor
authentication settings.
* rbac: extend observer role by adding access to device configuration
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.4.8 to 8.4.10.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.4.8...v8.4.10)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps golang from 1.14-alpine3.12 to 1.15.7-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.4.10 to 8.4.11.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.4.10...v8.4.11)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...1.4.6)
* Bumps alpine from 3.13.1 to 3.13.2.
* Bumps golang from 1.15.7-alpine3.12 to 1.16.0-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...1.4.6)
* Bumps alpine from 3.13.1 to 3.13.2.
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.7.0 to 1.8.0.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.7.0...v1.8.0)
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.4.11 to 8.7.1.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.4.11...v8.7.1)
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.7.0 to 1.8.0.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.7.0...v1.8.0)
* Bumps golang from 1.15.7-alpine3.12 to 1.16.2-alpine3.12.
* Bumps golang from 1.16.0-alpine3.12 to 1.16.2-alpine3.12.
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.8.0 to 1.8.1.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.8.0...v1.8.1)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.6 to 1.5.0.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/1.4.6...v1.5.0)
* Bumps [github.com/sirupsen/logrus](https://github.com/sirupsen/logrus) from 1.8.0 to 1.8.1.
- [Release notes](https://github.com/sirupsen/logrus/releases)
- [Changelog](https://github.com/sirupsen/logrus/blob/master/CHANGELOG.md)
- [Commits](https://github.com/sirupsen/logrus/compare/v1.8.0...v1.8.1)

#### workflows (1.4.0)

New changes in workflows since 1.3.0:

* Update workflow definitions for
provisioning/decomissioning devices in deviceconfig service
([MEN-4383](https://northerntech.atlassian.net/browse/MEN-4383), [MEN-4429](https://northerntech.atlassian.net/browse/MEN-4429))
* New workflow deploy_device_configuration
([MEN-4383](https://northerntech.atlassian.net/browse/MEN-4383), [MEN-4429](https://northerntech.atlassian.net/browse/MEN-4429))
* Configuration deployment triggers device update check
([MEN-4383](https://northerntech.atlassian.net/browse/MEN-4383), [MEN-4429](https://northerntech.atlassian.net/browse/MEN-4429))
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)

#### workflows-enterprise (1.4.0)

New changes in workflows-enterprise since 1.3.0:

* Update workflow definitions for
provisioning/decomissioning devices in deviceconfig service
([MEN-4383](https://northerntech.atlassian.net/browse/MEN-4383), [MEN-4429](https://northerntech.atlassian.net/browse/MEN-4429))
* New workflow deploy_device_configuration
([MEN-4383](https://northerntech.atlassian.net/browse/MEN-4383), [MEN-4429](https://northerntech.atlassian.net/browse/MEN-4429))
* Configuration deployment triggers device update check
([MEN-4383](https://northerntech.atlassian.net/browse/MEN-4383), [MEN-4429](https://northerntech.atlassian.net/browse/MEN-4429))
* Fix password reset button text
* Add workflow for sending password verification email
* New workflow contact_support for handling inbound email
requests to Mender support
* New workflow clear_tenant_tokens for puriging tenant JWTs
* Aggregated Dependabot Changelogs:
* Bumps alpine from 3.12 to 3.13.0.
* Bumps alpine from 3.12 to 3.13.0.
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [github.com/stretchr/testify](https://github.com/stretchr/testify) from 1.6.1 to 1.7.0.
- [Release notes](https://github.com/stretchr/testify/releases)
- [Commits](https://github.com/stretchr/testify/compare/v1.6.1...v1.7.0)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.4 to 1.4.5.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.4...v1.4.5)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.5 to 1.4.6.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.5...1.4.6)
* Bumps alpine from 3.13.0 to 3.13.1.
* Bumps alpine from 3.13.1 to 3.13.2.


## Mender 2.6.4

_Released 02.09.2022_

### Statistics

A total of 681 lines added, 873 removed (delta -192)

| Developers with the most changesets | |
|---|---|
| Lluis Campos | 15 (40.5%) |
| Kristian Amlie | 7 (18.9%) |
| Ole Petter Orhagen | 6 (16.2%) |
| Alf-Rune Siqveland | 3 (8.1%) |
| Manuel Zedel | 2 (5.4%) |
| Fabio Tranchitella | 2 (5.4%) |
| Jesus | 1 (2.7%) |
| Krzysztof Jaskiewicz | 1 (2.7%) |

| Developers with the most changed lines | |
|---|---|
| Lluis Campos | 549 (46.5%) |
| Alf-Rune Siqveland | 249 (21.1%) |
| Kristian Amlie | 152 (12.9%) |
| Ole Petter Orhagen | 147 (12.4%) |
| Manuel Zedel | 45 (3.8%) |
| Fabio Tranchitella | 20 (1.7%) |
| Krzysztof Jaskiewicz | 13 (1.1%) |
| Jesus | 6 (0.5%) |

| Developers with the most lines removed | |
|---|---|
| Lluis Campos | 266 (30.5%) |
| Alf-Rune Siqveland | 134 (15.3%) |
| Manuel Zedel | 31 (3.6%) |
| Krzysztof Jaskiewicz | 13 (1.5%) |
| Fabio Tranchitella | 6 (0.7%) |

| Developers with the most signoffs (total 7) | |
|---|---|
| Ole Petter Orhagen | 4 (57.1%) |
| Lluis Campos | 3 (42.9%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 35 (94.6%) |
| RnDity | 1 (2.7%) |
| wjaxxx@gmail.com | 1 (2.7%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 1162 (98.4%) |
| RnDity | 13 (1.1%) |
| wjaxxx@gmail.com | 6 (0.5%) |

| Employers with the most signoffs (total 7) | |
|---|---|
| Northern.tech | 7 (100.0%) |

| Employers with the most hackers (total 8) | |
|---|---|
| Northern.tech | 6 (75.0%) |
| RnDity | 1 (12.5%) |
| wjaxxx@gmail.com | 1 (12.5%) |

### Changelogs

#### create-artifact-worker (1.0.3)

New changes in create-artifact-worker since 1.0.2:

* Dockerfile: lock base image mendersoftware/workflows to mender-3.1.x

#### integration (2.6.4)

New changes in integration since 2.6.3:

* Unify the docker-compose version check through using the
  docker-compose version subcommand, as opposed to the --version flag when
  checking which docker-compose version is compatible with the current demo script.
* Upgrade create-artifact-worker to 1.0.3.
* Upgrade mender-connect to 1.0.3.
* Upgrade mender to 2.5.4.
* Upgrade mtls-ambassador to 1.0.1.

#### mtls-ambassador (1.0.1)

New changes in mtls-ambassador since 1.0.0:

* Aggregated Dependabot Changelogs:
  * Bumps alpine from 3.14.2 to 3.15.0.
    ---
    updated-dependencies:
    - dependency-name: alpine
      dependency-type: direct:production
      update-type: version-update:semver-minor
    ...


## Mender 2.6.3

_Release date 09.29.2021_

### Statistics

A total of 184 lines added, 101 removed (delta 83)

| Developers with the most changesets | |
|---|---|
| Kristian Amlie | 7 (43.8%) |
| Lluis Campos | 4 (25.0%) |
| Ole Petter Orhagen | 2 (12.5%) |
| Prashanth Joseph Babu | 2 (12.5%) |
| Alf-Rune Siqveland | 1 (6.2%) |

| Developers with the most changed lines | |
|---|---|
| Ole Petter Orhagen | 50 (27.2%) |
| Prashanth Joseph Babu | 46 (25.0%) |
| Kristian Amlie | 43 (23.4%) |
| Lluis Campos | 36 (19.6%) |
| Alf-Rune Siqveland | 9 (4.9%) |

| Developers with the most signoffs (total 1) | |
|---|---|
| Kristian Amlie | 1 (100.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 14 (87.5%) |
| prashanthjbabu@gmail.com | 2 (12.5%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 138 (75.0%) |
| prashanthjbabu@gmail.com | 46 (25.0%) |

| Employers with the most signoffs (total 1) | |
|---|---|
| Northern.tech | 1 (100.0%) |

| Employers with the most hackers (total 5) | |
|---|---|
| Northern.tech | 4 (80.0%) |
| prashanthjbabu@gmail.com | 1 (20.0%) |

### Changelogs

#### integration (2.6.3)

New changes in integration since 2.6.2:

* Upgrade inventory-enterprise to 2.2.2.
* Upgrade inventory to 2.2.2.
* Upgrade mender-artifact to 3.5.3.
* Upgrade mender to 2.5.3.

#### mender (2.5.3)

New changes in mender since 2.5.2:

* Add artifact_name to device provides if not found in store
* Add missing filesystem sync which could produce an empty or
  corrupted Update Module file tree in
  `/var/lib/mender/modules/v3/payloads/0000/tree/files/` after an
  unexpected reboot.
* [FIX] Fetch geo location data once per power cycle

#### mender-artifact (3.5.3)

New changes in mender-artifact since 3.5.2:

* Add missing error description when artifact header can't be written.
* cli: Fix parsing of filenames containing ".mender"
  ([MEN-5076](https://northerntech.atlassian.net/browse/MEN-5076))
* Fix the checksum errors encountered in rare cases where the entire byte
  stream is not consumed during verification, and thus giving wrong checksum errors.
  ([MEN-5094](https://northerntech.atlassian.net/browse/MEN-5094))
* Restore SSH snapshot feature on Mac OS
  ([MEN-4362](https://northerntech.atlassian.net/browse/MEN-4362), [MEN-5082](https://northerntech.atlassian.net/browse/MEN-5082))


## Mender 2.6.2

_Released 07.14.2021_

### Statistics

A total of 732 lines added, 415 removed (delta 317)

| Developers with the most changesets | |
|---|---|
| Kristian Amlie | 5 (31.2%) |
| Lluis Campos | 5 (31.2%) |
| Fabio Tranchitella | 3 (18.8%) |
| Alf-Rune Siqveland | 1 (6.2%) |
| Ole Petter | 1 (6.2%) |
| Peter Grzybowski | 1 (6.2%) |

| Developers with the most changed lines | |
|---|---|
| Fabio Tranchitella | 501 (68.4%) |
| Kristian Amlie | 177 (24.2%) |
| Alf-Rune Siqveland | 30 (4.1%) |
| Lluis Campos | 22 (3.0%) |
| Ole Petter | 1 (0.1%) |
| Peter Grzybowski | 1 (0.1%) |

| Developers with the most signoffs (total 1) | |
|---|---|
| Ole Petter | 1 (100.0%) |

| Top changeset contributors by employer | |
|---|---|
| Northern.tech | 16 (100.0%) |

| Top lines changed by employer | |
|---|---|
| Northern.tech | 732 (100.0%) |

| Employers with the most signoffs (total 1) | |
|---|---|
| Northern.tech | 1 (100.0%) |

| Employers with the most hackers (total 6) | |
|---|---|
| Northern.tech | 6 (100.0%) |

### Changelogs

#### deployments-enterprise (2.2.2)

New changes in deployments-enterprise since 2.2.1:

* docs: Fix naming conflict in v1 and v2 NewDeployment definitions.
* docs: Document missing parameters for NewDeploymentForGroup schema.

#### deviceconnect (1.0.1)

New changes in deviceconnect since 1.0.0:

* [] Limit size of messages transferred over websockets
  ([MEN-4803](https://northerntech.atlassian.net/browse/MEN-4803))

#### useradm-enterprise (1.13.1)

New changes in useradm-enterprise since 1.13.0:

* security fix: invalidate user JWT token cache on logout
  ([MEN-4754](https://northerntech.atlassian.net/browse/MEN-4754))

#### integration (2.6.2)

New changes in integration since 2.6.1:

* Upgrade deployments to 2.2.2.
* Upgrade deployments-enterprise to 2.2.2.
* Upgrade deviceconnect to 1.0.1.
* Upgrade mender to 2.5.2.
* Upgrade mender-artifact to 3.5.2.
* Upgrade mender-connect to 1.0.2.
* Upgrade useradm to 1.13.1.
* Upgrade useradm-enterprise to 1.13.1.

## Mender 2.6.1

_Released 16.04.2021_

### Changelogs

#### create-artifact-worker (1.0.2)

New changes in create-artifact-worker since 1.0.1:

* bugfix to allow spaces in artifact names
([MEN-4179](https://northerntech.atlassian.net/browse/MEN-4179))
* upgrade mender-artifact to version 3.5.0.
This enables the create-artifact-worker to generate artifacts that
implement the provides and clear provides fields.
([MEN-4409](https://northerntech.atlassian.net/browse/MEN-4409))

#### deployments-enterprise (2.2.1)

New changes in deployments-enterprise since 2.2.0:

* FIX: Phased deployments getting stuck on retries

#### integration (2.6.1)

New changes in integration since 2.6.0:

* Upgrade create-artifact-worker to 1.0.2.
* Upgrade deployments to 2.2.1.
* Upgrade deployments-enterprise to 2.2.1.
* Upgrade inventory to 2.2.1.
* Upgrade inventory-enterprise to 2.2.1.
* Upgrade mender to 2.5.1.
* Upgrade mender-artifact to 3.5.1.
* Upgrade mender-cli to 1.6.1.
* Upgrade mender-connect to 1.0.1.
## Mender 2.6.0

_Released 01.20.2021_

### Changelogs

#### auditlogs (1.0.0)

* First release of auditlogs

#### deployments (2.2.0)

New changes in deployments since 2.1.0:

* Vendor mender-artifact with `clears_artifact_provides` support.
([MEN-3480](https://northerntech.atlassian.net/browse/MEN-3480))
* document artifact_provides and artifact_depends in API docs
([MEN-4051](https://northerntech.atlassian.net/browse/MEN-4051))
* document artifact_provides and artifact_depends in API docs
([MEN-4051](https://northerntech.atlassian.net/browse/MEN-4051))
* include clears_artifact_provides in Artifact objects
([MEN-4050](https://northerntech.atlassian.net/browse/MEN-4050))
* add the possibility of creating deployments for all accepted devices
* Aggregated Dependabot Changelogs:
* Bumps [github.com/urfave/cli](https://github.com/urfave/cli) from 1.22.4 to 1.22.5.
- [Release notes](https://github.com/urfave/cli/releases)
- [Changelog](https://github.com/urfave/cli/blob/master/docs/CHANGELOG.md)
- [Commits](https://github.com/urfave/cli/compare/v1.22.4...v1.22.5)
* Bump github.com/urfave/cli from 1.22.4 to 1.22.5
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.35.8 to 1.35.33.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.35.8...v1.35.33)
* Bump github.com/aws/aws-sdk-go from 1.35.8 to 1.35.33
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.2 to 1.4.4.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.2...v1.4.4)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.35.33 to 1.36.2.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.35.33...v1.36.2)
* Bump github.com/aws/aws-sdk-go from 1.35.33 to 1.36.2
* Bump go.mongodb.org/mongo-driver from 1.4.2 to 1.4.4
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.2 to 1.36.7.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.2...v1.36.7)
* Bump github.com/aws/aws-sdk-go from 1.36.2 to 1.36.7
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.7 to 1.36.12.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.7...v1.36.12)
* Bump github.com/aws/aws-sdk-go from 1.36.7 to 1.36.12
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.12 to 1.36.15.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.12...v1.36.15)
* Bump github.com/aws/aws-sdk-go from 1.36.12 to 1.36.15
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.15 to 1.36.23.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.15...v1.36.23)
* Bump github.com/aws/aws-sdk-go from 1.36.15 to 1.36.23

#### deployments-enterprise (2.2.0)

New changes in deployments-enterprise since 2.1.0:

* Vendor mender-artifact with `clears_artifact_provides` support.
([MEN-3480](https://northerntech.atlassian.net/browse/MEN-3480))
* document artifact_provides and artifact_depends in API docs
([MEN-4051](https://northerntech.atlassian.net/browse/MEN-4051))
* document artifact_provides and artifact_depends in API docs
([MEN-4051](https://northerntech.atlassian.net/browse/MEN-4051))
* include clears_artifact_provides in Artifact objects
([MEN-4050](https://northerntech.atlassian.net/browse/MEN-4050))
* include clears_artifact_provides in Artifact objects
([MEN-4050](https://northerntech.atlassian.net/browse/MEN-4050))
* add the possibility of creating deployments for all accepted devices
* Aggregated Dependabot Changelogs:
* Bumps [github.com/urfave/cli](https://github.com/urfave/cli) from 1.22.4 to 1.22.5.
- [Release notes](https://github.com/urfave/cli/releases)
- [Changelog](https://github.com/urfave/cli/blob/master/docs/CHANGELOG.md)
- [Commits](https://github.com/urfave/cli/compare/v1.22.4...v1.22.5)
* Bumps [github.com/urfave/cli](https://github.com/urfave/cli) from 1.22.4 to 1.22.5.
- [Release notes](https://github.com/urfave/cli/releases)
- [Changelog](https://github.com/urfave/cli/blob/master/docs/CHANGELOG.md)
- [Commits](https://github.com/urfave/cli/compare/v1.22.4...v1.22.5)
* Bump github.com/urfave/cli from 1.22.4 to 1.22.5
* Bump github.com/urfave/cli from 1.22.4 to 1.22.5
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.35.8 to 1.35.33.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.35.8...v1.35.33)
* Bump github.com/aws/aws-sdk-go from 1.35.8 to 1.35.33
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.35.33 to 1.35.35.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.35.33...v1.35.35)
* Bump github.com/aws/aws-sdk-go from 1.35.33 to 1.35.35
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.35.8 to 1.35.33.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.35.8...v1.35.33)
* Bump github.com/aws/aws-sdk-go from 1.35.8 to 1.35.33
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.2 to 1.4.4.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.2...v1.4.4)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.35.33 to 1.36.2.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.35.33...v1.36.2)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.2 to 1.4.4.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.2...v1.4.4)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.35.35 to 1.36.2.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.35.35...v1.36.2)
* Bump github.com/aws/aws-sdk-go from 1.35.35 to 1.36.2
* Bump github.com/aws/aws-sdk-go from 1.35.33 to 1.36.2
* Bump go.mongodb.org/mongo-driver from 1.4.2 to 1.4.4
* Bump go.mongodb.org/mongo-driver from 1.4.2 to 1.4.4
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.2 to 1.36.7.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.2...v1.36.7)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.2 to 1.36.7.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.2...v1.36.7)
* Bump github.com/aws/aws-sdk-go from 1.36.2 to 1.36.7
* Bump github.com/aws/aws-sdk-go from 1.36.2 to 1.36.7
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.7 to 1.36.12.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.7...v1.36.12)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.7 to 1.36.12.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.7...v1.36.12)
* Bump github.com/aws/aws-sdk-go from 1.36.7 to 1.36.12
* Bump github.com/aws/aws-sdk-go from 1.36.7 to 1.36.12
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.12 to 1.36.15.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.12...v1.36.15)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.12 to 1.36.15.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.12...v1.36.15)
* Bump github.com/aws/aws-sdk-go from 1.36.12 to 1.36.15
* Bump github.com/aws/aws-sdk-go from 1.36.12 to 1.36.15
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.15 to 1.36.23.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.15...v1.36.23)
* Bumps [github.com/aws/aws-sdk-go](https://github.com/aws/aws-sdk-go) from 1.36.15 to 1.36.23.
- [Release notes](https://github.com/aws/aws-sdk-go/releases)
- [Changelog](https://github.com/aws/aws-sdk-go/blob/master/CHANGELOG.md)
- [Commits](https://github.com/aws/aws-sdk-go/compare/v1.36.15...v1.36.23)
* Bump github.com/aws/aws-sdk-go from 1.36.15 to 1.36.23
* Bump github.com/aws/aws-sdk-go from 1.36.15 to 1.36.23

#### deviceauth (2.5.0)

New changes in deviceauth since 2.4.0:

* New query parameter id for GET /api/management/v1/devices
* add internal end-point to retrieve the count of devices
([MEN-3923](https://northerntech.atlassian.net/browse/MEN-3923))
* New command for warning tenants approaching their device limit
* propagate device identity using workflows
([MEN-3979](https://northerntech.atlassian.net/browse/MEN-3979))
* ignore tenant claim in single tenant setup
([MEN-3972](https://northerntech.atlassian.net/browse/MEN-3972))
* New device auth query endpoint POST /api/management/v2/devauth/devices/search
* Aggregated Dependabot Changelogs:
* Bumps [github.com/urfave/cli](https://github.com/urfave/cli) from 1.22.4 to 1.22.5.
- [Release notes](https://github.com/urfave/cli/releases)
- [Changelog](https://github.com/urfave/cli/blob/master/docs/CHANGELOG.md)
- [Commits](https://github.com/urfave/cli/compare/v1.22.4...v1.22.5)
* Bump github.com/urfave/cli from 1.22.4 to 1.22.5
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.3.1 to 8.4.2.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.3.1...v8.4.2)
* Bumps [go.mongodb.org/mongo-driver](https://github.com/mongodb/mongo-go-driver) from 1.4.2 to 1.4.4.
- [Release notes](https://github.com/mongodb/mongo-go-driver/releases)
- [Commits](https://github.com/mongodb/mongo-go-driver/compare/v1.4.2...v1.4.4)
* Bump go.mongodb.org/mongo-driver from 1.4.2 to 1.4.4
* Bump github.com/go-redis/redis/v8 from 8.3.1 to 8.4.2
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.4.2 to 8.4.4.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.4.2...v8.4.4)
* Bump github.com/go-redis/redis/v8 from 8.4.2 to 8.4.4
* Bumps [github.com/go-redis/redis/v8](https://github.com/go-redis/redis) from 8.4.4 to 8.4.8.
- [Release notes](https://github.com/go-redis/redis/releases)
- [Changelog](https://github.com/go-redis/redis/blob/master/CHANGELOG.md)
- [Commits](https://github.com/go-redis/redis/compare/v8.4.4...v8.4.8)
* Bump github.com/go-redis/redis/v8 from 8.4.4 to 8.4.8

#### deviceconnect (1.0.0)

* First release of deviceconnect

#### gui (2.6.0)

New changes in gui since 2.5.0:

* added additional password validation to prevent email reuse
([MEN-3948](https://northerntech.atlassian.net/browse/MEN-3948))
* added security measures to prevent clickjacking
* isolated single authset handling to prevent confusing authstate notifications
([MEN-3988](https://northerntech.atlassian.net/browse/MEN-3988))
* implemented auditloglist to reflect user & deployment changes
* fixed a navigation issue that prevented deployment report navigation
* fixed an error caused by showing timeframe selection for a longer time
* removed sorting limitations for device id column
([MEN-3879](https://northerntech.atlassian.net/browse/MEN-3879))
* disabled sorting for status column in devices list
([MEN-3969](https://northerntech.atlassian.net/browse/MEN-3969))
* allowed setting equality filters through url to ease navigation
([MEN-3991](https://northerntech.atlassian.net/browse/MEN-3991))
* fixed an issue that prevented admin access to user management settings
* added possibility to update credit card in organization settings
([MEN-3823](https://northerntech.atlassian.net/browse/MEN-3823))
* fixed an issue that lead certain update module configurations to crash the app
* switched device attributes from local deducation to backend retrieval
* Update "Connect a device" onboarding dialog
([MEN-3999](https://northerntech.atlassian.net/browse/MEN-3999))
* device remote shell/terminal
([MEN-4091](https://northerntech.atlassian.net/browse/MEN-4091))
* fixed an error that prevented phased dynamic deployments + scheduled single device deployments
([MEN-4122](https://northerntech.atlassian.net/browse/MEN-4122))
* fixed deployment creation not using single devices as deployment name
([MEN-4182](https://northerntech.atlassian.net/browse/MEN-4182))
* fixed an issue that prevented deployment device count from being shown in single device deployments
* ensured settings show also after stripe initialization
([MEN-4275](https://northerntech.atlassian.net/browse/MEN-4275))
* fixed cookie paths to work with ui redirect to subpath
* Rename Retry deployment to Recreate deployment.
* fix page number on rowsPerPage change
([MEN-4364](https://northerntech.atlassian.net/browse/MEN-4364))
* fixed an issue that prevented existing user roles from being removed
* fixed an issue that prevented loading dynamic group devices when navigating to device groups
* Aggregated Dependabot Changelogs:
* Bumps [file-loader](https://github.com/webpack-contrib/file-loader) from 6.0.0 to 6.1.0.
- [Release notes](https://github.com/webpack-contrib/file-loader/releases)
- [Changelog](https://github.com/webpack-contrib/file-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/file-loader/compare/v6.0.0...v6.1.0)
* Bumps [less](https://github.com/less/less.js) from 3.11.3 to 3.12.2.
- [Release notes](https://github.com/less/less.js/releases)
- [Changelog](https://github.com/less/less.js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/less/less.js/commits)
* Bumps [copy-webpack-plugin](https://github.com/webpack-contrib/copy-webpack-plugin) from 6.0.3 to 6.1.0.
- [Release notes](https://github.com/webpack-contrib/copy-webpack-plugin/releases)
- [Changelog](https://github.com/webpack-contrib/copy-webpack-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/copy-webpack-plugin/compare/v6.0.3...v6.1.0)
* Bump file-loader from 6.0.0 to 6.1.0
* Bump less from 3.11.3 to 3.12.2
* Bump copy-webpack-plugin from 6.0.3 to 6.1.0
* Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 6.1.1 to 7.0.1.
- [Release notes](https://github.com/webpack-contrib/less-loader/releases)
- [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/less-loader/compare/v6.1.1...v7.0.1)
* Bump less-loader from 6.1.1 to 7.0.1
* Bumps node from 14.9.0-alpine to 14.10.1-alpine.
* Bumps [lint-staged](https://github.com/okonet/lint-staged) from 10.2.11 to 10.3.0.
- [Release notes](https://github.com/okonet/lint-staged/releases)
- [Commits](https://github.com/okonet/lint-staged/compare/v10.2.11...v10.3.0)
* Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.10.2 to 7.11.6.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.11.6/packages/babel-core)
* Bump @babel/core from 7.10.2 to 7.11.6
* Bump lint-staged from 10.2.11 to 10.3.0
* Bump node from 14.9.0-alpine to 14.10.1-alpine
* Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.20.1 to 7.20.6.
- [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
- [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
- [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.20.1...v7.20.6)
* Bumps [html-webpack-plugin](https://github.com/jantimon/html-webpack-plugin) from 4.3.0 to 4.4.1.
- [Release notes](https://github.com/jantimon/html-webpack-plugin/releases)
- [Changelog](https://github.com/jantimon/html-webpack-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/jantimon/html-webpack-plugin/compare/v4.3.0...v4.4.1)
* Bumps [copy-webpack-plugin](https://github.com/webpack-contrib/copy-webpack-plugin) from 6.1.0 to 6.1.1.
- [Release notes](https://github.com/webpack-contrib/copy-webpack-plugin/releases)
- [Changelog](https://github.com/webpack-contrib/copy-webpack-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/copy-webpack-plugin/compare/v6.1.0...v6.1.1)
* Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 9.8.4 to 9.8.6.
- [Release notes](https://github.com/postcss/autoprefixer/releases)
- [Changelog](https://github.com/postcss/autoprefixer/blob/master/CHANGELOG.md)
- [Commits](https://github.com/postcss/autoprefixer/compare/9.8.4...9.8.6)
* Bumps [victory](https://github.com/formidablelabs/victory) from 35.0.8 to 35.0.9.
- [Release notes](https://github.com/formidablelabs/victory/releases)
- [Changelog](https://github.com/FormidableLabs/victory/blob/main/CHANGELOG.md)
- [Commits](https://github.com/formidablelabs/victory/compare/v35.0.8...v35.0.9)
* Bumps node from 14.10.1-alpine to 14.11.0-alpine.
* Bump node from 14.10.1-alpine to 14.11.0-alpine
* Bump eslint-plugin-react from 7.20.1 to 7.20.6
* Bump copy-webpack-plugin from 6.1.0 to 6.1.1
* Bump autoprefixer from 9.8.4 to 9.8.6
* Bump victory from 35.0.8 to 35.0.9
* Bump html-webpack-plugin from 4.3.0 to 4.4.1
* Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.20.6 to 7.21.2.
- [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
- [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
- [Commits](https://github.com/yannickcr/eslint-plugin-react/commits)
* Bumps [eslint-plugin-import](https://github.com/benmosher/eslint-plugin-import) from 2.22.0 to 2.22.1.
- [Release notes](https://github.com/benmosher/eslint-plugin-import/releases)
- [Changelog](https://github.com/benmosher/eslint-plugin-import/blob/master/CHANGELOG.md)
- [Commits](https://github.com/benmosher/eslint-plugin-import/compare/v2.22.0...v2.22.1)
* Bumps [enzyme-adapter-react-16](https://github.com/enzymejs/enzyme/tree/HEAD/packages/enzyme-adapter-react-16) from 1.15.4 to 1.15.5.
- [Release notes](https://github.com/enzymejs/enzyme/releases)
- [Changelog](https://github.com/enzymejs/enzyme/blob/master/CHANGELOG.md)
- [Commits](https://github.com/enzymejs/enzyme/commits/enzyme-adapter-react-16@1.15.5/packages/enzyme-adapter-react-16)
* Bumps [universal-cookie](https://github.com/reactivestack/cookies) from 4.0.3 to 4.0.4.
- [Release notes](https://github.com/reactivestack/cookies/releases)
- [Changelog](https://github.com/reactivestack/cookies/blob/master/CHANGELOG.md)
- [Commits](https://github.com/reactivestack/cookies/compare/v4.0.3...v4.0.4)
* Bump universal-cookie from 4.0.3 to 4.0.4
* Bump enzyme-adapter-react-16 from 1.15.4 to 1.15.5
* Bump eslint-plugin-import from 2.22.0 to 2.22.1
* Bump eslint-plugin-react from 7.20.6 to 7.21.2
* Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 0.11.2 to 0.11.3.
- [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
- [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v0.11.2...v0.11.3)
* Bumps [eslint](https://github.com/eslint/eslint) from 7.9.0 to 7.10.0.
- [Release notes](https://github.com/eslint/eslint/releases)
- [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
- [Commits](https://github.com/eslint/eslint/compare/v7.9.0...v7.10.0)
* Bumps [yarn](https://github.com/yarnpkg/yarn) from 1.22.5 to 1.22.10.
- [Release notes](https://github.com/yarnpkg/yarn/releases)
- [Changelog](https://github.com/yarnpkg/yarn/blob/master/CHANGELOG.md)
- [Commits](https://github.com/yarnpkg/yarn/compare/v1.22.5...1.22.10)
* Bumps [jwt-decode](https://github.com/auth0/jwt-decode) from 2.2.0 to 3.0.0.
- [Release notes](https://github.com/auth0/jwt-decode/releases)
- [Changelog](https://github.com/auth0/jwt-decode/blob/master/CHANGELOG.md)
- [Commits](https://github.com/auth0/jwt-decode/compare/v2.2.0...v3.0.0)
* Bumps node from 14.11.0-alpine to 14.12.0-alpine.
* Bump node from 14.11.0-alpine to 14.12.0-alpine
* Bump jwt-decode from 2.2.0 to 3.0.0
* Bump yarn from 1.22.5 to 1.22.10
* Bump eslint from 7.9.0 to 7.10.0
* Bump mini-css-extract-plugin from 0.11.2 to 0.11.3
* Bumps [copy-webpack-plugin](https://github.com/webpack-contrib/copy-webpack-plugin) from 6.1.1 to 6.2.1.
- [Release notes](https://github.com/webpack-contrib/copy-webpack-plugin/releases)
- [Changelog](https://github.com/webpack-contrib/copy-webpack-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/copy-webpack-plugin/compare/v6.1.1...v6.2.1)
* Bumps [jest](https://github.com/facebook/jest) from 26.4.2 to 26.5.3.
- [Release notes](https://github.com/facebook/jest/releases)
- [Changelog](https://github.com/facebook/jest/blob/master/CHANGELOG.md)
- [Commits](https://github.com/facebook/jest/compare/v26.4.2...v26.5.3)
* Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.21.2 to 7.21.4.
- [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
- [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
- [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.21.2...v7.21.4)
* Bumps node from 14.12.0-alpine to 14.13.1-alpine.
* Bumps nginx from 1.19.2-alpine to 1.19.3-alpine.
* Bump nginx from 1.19.2-alpine to 1.19.3-alpine
* Bump node from 14.12.0-alpine to 14.13.1-alpine
* Bump eslint-plugin-react from 7.21.2 to 7.21.4
* Bump jest from 26.4.2 to 26.5.3
* Bump copy-webpack-plugin from 6.1.1 to 6.2.1
* Bumps [url-loader](https://github.com/webpack-contrib/url-loader) from 4.1.0 to 4.1.1.
- [Release notes](https://github.com/webpack-contrib/url-loader/releases)
- [Changelog](https://github.com/webpack-contrib/url-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/url-loader/compare/v4.1.0...v4.1.1)
* Bumps [file-loader](https://github.com/webpack-contrib/file-loader) from 6.1.0 to 6.1.1.
- [Release notes](https://github.com/webpack-contrib/file-loader/releases)
- [Changelog](https://github.com/webpack-contrib/file-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/file-loader/compare/v6.1.0...v6.1.1)
* Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.11.6 to 7.12.3.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.12.3/packages/babel-core)
* Bumps node from 14.13.1-alpine to 14.14.0-alpine.
* Bump @babel/core from 7.11.6 to 7.12.3
* Bump file-loader from 6.1.0 to 6.1.1
* Bump url-loader from 4.1.0 to 4.1.1
* Bump node from 14.13.1-alpine to 14.14.0-alpine
* Bumps [react-dropzone](https://github.com/react-dropzone/react-dropzone) from 11.2.0 to 11.2.1.
- [Release notes](https://github.com/react-dropzone/react-dropzone/releases)
- [Commits](https://github.com/react-dropzone/react-dropzone/compare/v11.2.0...v11.2.1)
* Bumps [resolve-url-loader](https://github.com/bholloway/resolve-url-loader) from 3.1.1 to 3.1.2.
- [Release notes](https://github.com/bholloway/resolve-url-loader/releases)
- [Commits](https://github.com/bholloway/resolve-url-loader/compare/3.1.1...3.1.2)
* Bumps node from 14.14.0-alpine to 15.0.1-alpine.
* Bump resolve-url-loader from 3.1.1 to 3.1.2
* Bump react-dropzone from 11.2.0 to 11.2.1
* Bump node from 14.14.0-alpine to 15.0.1-alpine
* Bumps [react-ga](https://github.com/react-ga/react-ga) from 3.1.2 to 3.2.0.
- [Release notes](https://github.com/react-ga/react-ga/releases)
- [Commits](https://github.com/react-ga/react-ga/compare/v3.1.2...v3.2.0)
* Bump react-ga from 3.1.2 to 3.2.0
* Bumps [@babel/preset-react](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-react) from 7.10.4 to 7.12.1.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.12.1/packages/babel-preset-react)
* Bumps [react-idle-timer](https://github.com/supremetechnopriest/react-idle-timer) from 4.3.6 to 4.5.0.
- [Release notes](https://github.com/supremetechnopriest/react-idle-timer/releases)
- [Changelog](https://github.com/SupremeTechnopriest/react-idle-timer/blob/master/CHANGELOG.md)
- [Commits](https://github.com/supremetechnopriest/react-idle-timer/compare/4.3.6...4.5.0)
* Bumps [@mdi/js](https://github.com/Templarian/MaterialDesign-JS) from 5.6.55 to 5.8.55.
- [Release notes](https://github.com/Templarian/MaterialDesign-JS/releases)
- [Commits](https://github.com/Templarian/MaterialDesign-JS/compare/v5.6.55...v5.8.55)
* Bump @mdi/js from 5.6.55 to 5.8.55
* Bump react-idle-timer from 4.3.6 to 4.5.0
* Bump @babel/preset-react from 7.10.4 to 7.12.1
* Bumps node from 15.0.1-alpine to 15.1.0-alpine.
* Bumps nginx from 1.19.3-alpine to 1.19.4-alpine.
* Bump nginx from 1.19.3-alpine to 1.19.4-alpine
* Bump node from 15.0.1-alpine to 15.1.0-alpine
* Bumps [postcss](https://github.com/postcss/postcss) from 8.1.4 to 8.1.6.
- [Release notes](https://github.com/postcss/postcss/releases)
- [Changelog](https://github.com/postcss/postcss/blob/master/CHANGELOG.md)
- [Commits](https://github.com/postcss/postcss/compare/8.1.4...8.1.6)
* Bump postcss from 8.1.4 to 8.1.6
* Bumps node from 15.1.0-alpine to 15.2.0-alpine.
* Bumps [cypress-localstorage-commands](https://github.com/javierbrea/cypress-localstorage-commands) from 1.2.3 to 1.2.4.
- [Release notes](https://github.com/javierbrea/cypress-localstorage-commands/releases)
- [Changelog](https://github.com/javierbrea/cypress-localstorage-commands/blob/master/CHANGELOG.md)
- [Commits](https://github.com/javierbrea/cypress-localstorage-commands/compare/v1.2.3...v1.2.4)
* Bumps [jwt-decode](https://github.com/auth0/jwt-decode) from 2.2.0 to 3.1.1.
- [Release notes](https://github.com/auth0/jwt-decode/releases)
- [Changelog](https://github.com/auth0/jwt-decode/blob/master/CHANGELOG.md)
- [Commits](https://github.com/auth0/jwt-decode/compare/v2.2.0...v3.1.1)
* Bumps [cypress](https://github.com/cypress-io/cypress) from 5.4.0 to 5.6.0.
- [Release notes](https://github.com/cypress-io/cypress/releases)
- [Changelog](https://github.com/cypress-io/cypress/blob/develop/.releaserc.base.js)
- [Commits](https://github.com/cypress-io/cypress/compare/v5.4.0...v5.6.0)
* Bumps [eslint-plugin-cypress](https://github.com/cypress-io/eslint-plugin-cypress) from 2.11.1 to 2.11.2.
- [Release notes](https://github.com/cypress-io/eslint-plugin-cypress/releases)
- [Commits](https://github.com/cypress-io/eslint-plugin-cypress/compare/v2.11.1...v2.11.2)
* Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 7.0.2 to 7.1.0.
- [Release notes](https://github.com/webpack-contrib/less-loader/releases)
- [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/less-loader/compare/v7.0.2...v7.1.0)
* Bump node from 15.1.0-alpine to 15.2.0-alpine
* Bump jwt-decode from 2.2.0 to 3.1.1 in /tests/e2e_tests
* Bump eslint-plugin-cypress from 2.11.1 to 2.11.2
* Bump less-loader from 7.0.2 to 7.1.0
* Bump cypress from 5.4.0 to 5.6.0 in /tests/e2e_tests
* Bump cypress-localstorage-commands from 1.2.3 to 1.2.4 in /tests/e2e_tests
* Bumps [react](https://github.com/facebook/react/tree/HEAD/packages/react) from 16.13.1 to 16.14.0.
- [Release notes](https://github.com/facebook/react/releases)
- [Changelog](https://github.com/facebook/react/blob/master/CHANGELOG.md)
- [Commits](https://github.com/facebook/react/commits/v16.14.0/packages/react)
* Bump react from 16.13.1 to 16.14.0
* Bumps cypress/included from 5.4.0 to 5.6.0.
* Bump cypress/included from 5.4.0 to 5.6.0 in /tests/e2e_tests
* Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.0.1 to 10.0.2.
- [Release notes](https://github.com/postcss/autoprefixer/releases)
- [Changelog](https://github.com/postcss/autoprefixer/blob/master/CHANGELOG.md)
- [Commits](https://github.com/postcss/autoprefixer/compare/10.0.1...10.0.2)
* Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 1.2.1 to 1.3.1.
- [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
- [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v1.2.1...v1.3.1)
* Bumps [css-loader](https://github.com/webpack-contrib/css-loader) from 5.0.0 to 5.0.1.
- [Release notes](https://github.com/webpack-contrib/css-loader/releases)
- [Changelog](https://github.com/webpack-contrib/css-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/css-loader/compare/v5.0.0...v5.0.1)
* Bump css-loader from 5.0.0 to 5.0.1
* Bump mini-css-extract-plugin from 1.2.1 to 1.3.1
* Bump autoprefixer from 10.0.1 to 10.0.2
* Bumps [react-dom](https://github.com/facebook/react/tree/HEAD/packages/react-dom) from 16.13.1 to 16.14.0.
- [Release notes](https://github.com/facebook/react/releases)
- [Changelog](https://github.com/facebook/react/blob/master/CHANGELOG.md)
- [Commits](https://github.com/facebook/react/commits/v16.14.0/packages/react-dom)
* Bumps [react-big-calendar](https://github.com/jquense/react-big-calendar) from 0.28.2 to 0.28.6.
- [Release notes](https://github.com/jquense/react-big-calendar/releases)
- [Changelog](https://github.com/jquense/react-big-calendar/blob/master/CHANGELOG.md)
- [Commits](https://github.com/jquense/react-big-calendar/compare/v0.28.2...v0.28.6)
* Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.12.1 to 7.12.7.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.12.7/packages/babel-preset-env)
* Bumps node from 15.2.0-alpine to 15.2.1-alpine.
* Bumps [jwt-decode](https://github.com/auth0/jwt-decode) from 3.1.1 to 3.1.2.
- [Release notes](https://github.com/auth0/jwt-decode/releases)
- [Changelog](https://github.com/auth0/jwt-decode/blob/master/CHANGELOG.md)
- [Commits](https://github.com/auth0/jwt-decode/compare/v3.1.1...v3.1.2)
* Bump jwt-decode from 3.1.1 to 3.1.2 in /tests/e2e_tests
* Bump node from 15.2.0-alpine to 15.2.1-alpine
* Bump @babel/preset-env from 7.12.1 to 7.12.7
* Bump react-big-calendar from 0.28.2 to 0.28.6
* Bump react-dom from 16.13.1 to 16.14.0
* Bumps [lint-staged](https://github.com/okonet/lint-staged) from 10.5.1 to 10.5.2.
- [Release notes](https://github.com/okonet/lint-staged/releases)
- [Commits](https://github.com/okonet/lint-staged/compare/v10.5.1...v10.5.2)
* Bumps [@babel/preset-react](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-react) from 7.12.5 to 7.12.7.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.12.7/packages/babel-preset-react)
* Bumps [@material-ui/core](https://github.com/mui-org/material-ui/tree/HEAD/packages/material-ui) from 4.11.0 to 4.11.1.
- [Release notes](https://github.com/mui-org/material-ui/releases)
- [Changelog](https://github.com/mui-org/material-ui/blob/v4.11.1/CHANGELOG.md)
- [Commits](https://github.com/mui-org/material-ui/commits/v4.11.1/packages/material-ui)
* Bumps [buffer](https://github.com/feross/buffer) from 6.0.0 to 6.0.3.
- [Release notes](https://github.com/feross/buffer/releases)
- [Commits](https://github.com/feross/buffer/compare/v6.0.0...v6.0.3)
* Bumps nginx from 1.19.4-alpine to 1.19.5-alpine.
* Bumps node from 15.2.1-alpine to 15.3.0-alpine.
* Bump lint-staged from 10.5.1 to 10.5.2
* Bump @babel/preset-react from 7.12.5 to 7.12.7
* Bump @material-ui/core from 4.11.0 to 4.11.1
* Bump node from 15.2.1-alpine to 15.3.0-alpine
* Bump buffer from 6.0.0 to 6.0.3
* Bump nginx from 1.19.4-alpine to 1.19.5-alpine
* Bumps cypress/included from 5.6.0 to 6.0.0.
* Bump cypress/included from 5.6.0 to 6.0.0 in /tests/e2e_tests
* Bumps [eslint](https://github.com/eslint/eslint) from 7.12.1 to 7.14.0.
- [Release notes](https://github.com/eslint/eslint/releases)
- [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
- [Commits](https://github.com/eslint/eslint/compare/v7.12.1...v7.14.0)
* Bumps [postcss](https://github.com/postcss/postcss) from 8.1.6 to 8.1.10.
- [Release notes](https://github.com/postcss/postcss/releases)
- [Changelog](https://github.com/postcss/postcss/blob/master/CHANGELOG.md)
- [Commits](https://github.com/postcss/postcss/compare/8.1.6...8.1.10)
* Bumps [@babel/core](https://github.com/babel/babel/tree/HEAD/packages/babel-core) from 7.12.3 to 7.12.9.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.12.9/packages/babel-core)
* Bumps [react-dropzone](https://github.com/react-dropzone/react-dropzone) from 11.2.3 to 11.2.4.
- [Release notes](https://github.com/react-dropzone/react-dropzone/releases)
- [Commits](https://github.com/react-dropzone/react-dropzone/compare/v11.2.3...v11.2.4)
* Bump react-dropzone from 11.2.3 to 11.2.4
* Bump @babel/core from 7.12.3 to 7.12.9
* Bump postcss from 8.1.6 to 8.1.10
* Bump eslint from 7.12.1 to 7.14.0
* Bumps [webpack](https://github.com/webpack/webpack) from 5.4.0 to 5.9.0.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.4.0...v5.9.0)
* Bumps [prettier](https://github.com/prettier/prettier) from 2.1.2 to 2.2.1.
- [Release notes](https://github.com/prettier/prettier/releases)
- [Changelog](https://github.com/prettier/prettier/blob/master/CHANGELOG.md)
- [Commits](https://github.com/prettier/prettier/compare/2.1.2...2.2.1)
* Bumps [react-ga](https://github.com/react-ga/react-ga) from 3.2.0 to 3.3.0.
- [Release notes](https://github.com/react-ga/react-ga/releases)
- [Commits](https://github.com/react-ga/react-ga/compare/v3.2.0...v3.3.0)
* Bump react-ga from 3.2.0 to 3.3.0
* Bump prettier from 2.1.2 to 2.2.1
* Bump webpack from 5.4.0 to 5.9.0
* Bumps [postcss-loader](https://github.com/webpack-contrib/postcss-loader) from 4.0.4 to 4.1.0.
- [Release notes](https://github.com/webpack-contrib/postcss-loader/releases)
- [Changelog](https://github.com/webpack-contrib/postcss-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/postcss-loader/compare/v4.0.4...v4.1.0)
* Bump postcss-loader from 4.0.4 to 4.1.0
* Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.0.2 to 10.0.4.
- [Release notes](https://github.com/postcss/autoprefixer/releases)
- [Changelog](https://github.com/postcss/autoprefixer/blob/master/CHANGELOG.md)
- [Commits](https://github.com/postcss/autoprefixer/compare/10.0.2...10.0.4)
* Bumps [babel-loader](https://github.com/babel/babel-loader) from 8.1.0 to 8.2.2.
- [Release notes](https://github.com/babel/babel-loader/releases)
- [Changelog](https://github.com/babel/babel-loader/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel-loader/compare/v8.1.0...v8.2.2)
* Bumps [core-js](https://github.com/zloirock/core-js) from 3.6.5 to 3.8.0.
- [Release notes](https://github.com/zloirock/core-js/releases)
- [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/zloirock/core-js/compare/v3.6.5...v3.8.0)
* Bump babel-loader from 8.1.0 to 8.2.2
* Bump autoprefixer from 10.0.2 to 10.0.4
* Bump core-js from 3.6.5 to 3.8.0
* Bumps [jwt-decode](https://github.com/auth0/jwt-decode) from 3.0.0 to 3.1.2.
- [Release notes](https://github.com/auth0/jwt-decode/releases)
- [Changelog](https://github.com/auth0/jwt-decode/blob/master/CHANGELOG.md)
- [Commits](https://github.com/auth0/jwt-decode/compare/v3.0.0...v3.1.2)
* Bumps [validator](https://github.com/chriso/validator.js) from 13.1.17 to 13.5.1.
- [Release notes](https://github.com/chriso/validator.js/releases)
- [Changelog](https://github.com/validatorjs/validator.js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/chriso/validator.js/compare/13.1.17...13.5.1)
* Bump jwt-decode from 3.0.0 to 3.1.2
* Bump validator from 13.1.17 to 13.5.1
* Bumps [core-js](https://github.com/zloirock/core-js) from 3.8.0 to 3.8.1.
- [Release notes](https://github.com/zloirock/core-js/releases)
- [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/zloirock/core-js/compare/v3.8.0...v3.8.1)
* Bumps [mini-css-extract-plugin](https://github.com/webpack-contrib/mini-css-extract-plugin) from 1.3.1 to 1.3.2.
- [Release notes](https://github.com/webpack-contrib/mini-css-extract-plugin/releases)
- [Changelog](https://github.com/webpack-contrib/mini-css-extract-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/mini-css-extract-plugin/compare/v1.3.1...v1.3.2)
* Bumps [@cypress/skip-test](https://github.com/cypress-io/cypress-skip-test) from 2.5.0 to 2.5.1.
- [Release notes](https://github.com/cypress-io/cypress-skip-test/releases)
- [Commits](https://github.com/cypress-io/cypress-skip-test/compare/v2.5.0...v2.5.1)
* Bumps [cypress-localstorage-commands](https://github.com/javierbrea/cypress-localstorage-commands) from 1.2.4 to 1.2.5.
- [Release notes](https://github.com/javierbrea/cypress-localstorage-commands/releases)
- [Changelog](https://github.com/javierbrea/cypress-localstorage-commands/blob/master/CHANGELOG.md)
- [Commits](https://github.com/javierbrea/cypress-localstorage-commands/compare/v1.2.4...v1.2.5)
* Bumps cypress/included from 6.0.0 to 6.0.1.
* Bump mini-css-extract-plugin from 1.3.1 to 1.3.2
* Bump @cypress/skip-test from 2.5.0 to 2.5.1 in /tests/e2e_tests
* Bump cypress-localstorage-commands from 1.2.4 to 1.2.5 in /tests/e2e_tests
* Bump cypress/included from 6.0.0 to 6.0.1 in /tests/e2e_tests
* Bump core-js from 3.8.0 to 3.8.1
* Bumps [webpack](https://github.com/webpack/webpack) from 5.9.0 to 5.10.0.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.9.0...v5.10.0)
* Bump webpack from 5.9.0 to 5.10.0
* Bumps [lint-staged](https://github.com/okonet/lint-staged) from 10.5.2 to 10.5.3.
- [Release notes](https://github.com/okonet/lint-staged/releases)
- [Commits](https://github.com/okonet/lint-staged/compare/v10.5.2...v10.5.3)
* Bumps [eslint-plugin-prettier](https://github.com/prettier/eslint-plugin-prettier) from 3.1.4 to 3.2.0.
- [Release notes](https://github.com/prettier/eslint-plugin-prettier/releases)
- [Changelog](https://github.com/prettier/eslint-plugin-prettier/blob/master/CHANGELOG.md)
- [Commits](https://github.com/prettier/eslint-plugin-prettier/compare/v3.1.4...v3.2.0)
* Bumps [postcss](https://github.com/postcss/postcss) from 8.1.10 to 8.1.14.
- [Release notes](https://github.com/postcss/postcss/releases)
- [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
- [Commits](https://github.com/postcss/postcss/compare/8.1.10...8.1.14)
* Bump lint-staged from 10.5.2 to 10.5.3
* Bump postcss from 8.1.10 to 8.1.14
* Bump eslint-plugin-prettier from 3.1.4 to 3.2.0
* Bumps [ini](https://github.com/isaacs/ini) from 1.3.5 to 1.3.7.
- [Release notes](https://github.com/isaacs/ini/releases)
- [Commits](https://github.com/isaacs/ini/compare/v1.3.5...v1.3.7)
* Bumps [ini](https://github.com/isaacs/ini) from 1.3.5 to 1.3.8.
- [Release notes](https://github.com/isaacs/ini/releases)
- [Commits](https://github.com/isaacs/ini/compare/v1.3.5...v1.3.8)
* Bumps [@babel/preset-env](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-env) from 7.12.7 to 7.12.10.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.12.10/packages/babel-preset-env)
* Bumps [webpack](https://github.com/webpack/webpack) from 5.10.0 to 5.10.1.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.10.0...v5.10.1)
* Bumps [cypress-localstorage-commands](https://github.com/javierbrea/cypress-localstorage-commands) from 1.2.5 to 1.3.1.
- [Release notes](https://github.com/javierbrea/cypress-localstorage-commands/releases)
- [Changelog](https://github.com/javierbrea/cypress-localstorage-commands/blob/master/CHANGELOG.md)
- [Commits](https://github.com/javierbrea/cypress-localstorage-commands/compare/v1.2.5...v1.3.1)
* Bumps [uuid](https://github.com/uuidjs/uuid) from 8.3.1 to 8.3.2.
- [Release notes](https://github.com/uuidjs/uuid/releases)
- [Changelog](https://github.com/uuidjs/uuid/blob/master/CHANGELOG.md)
- [Commits](https://github.com/uuidjs/uuid/compare/v8.3.1...v8.3.2)
* Bumps node from 15.3.0-alpine to 15.4.0-alpine.
* Bumps cypress/included from 6.0.1 to 6.1.0.
* Bump cypress/included from 6.0.1 to 6.1.0 in /tests/e2e_tests
* Bump node from 15.3.0-alpine to 15.4.0-alpine
* Bump uuid from 8.3.1 to 8.3.2 in /tests/e2e_tests
* Bump cypress-localstorage-commands from 1.2.5 to 1.3.1 in /tests/e2e_tests
* Bump @babel/preset-env from 7.12.7 to 7.12.10
* Bump ini from 1.3.5 to 1.3.8 in /tests/e2e_tests
* Bump webpack from 5.10.0 to 5.10.1
* Bump ini from 1.3.5 to 1.3.7
* Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.0.4 to 10.1.0.
- [Release notes](https://github.com/postcss/autoprefixer/releases)
- [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
- [Commits](https://github.com/postcss/autoprefixer/compare/10.0.4...10.1.0)
* Bumps [@babel/preset-react](https://github.com/babel/babel/tree/HEAD/packages/babel-preset-react) from 7.12.7 to 7.12.10.
- [Release notes](https://github.com/babel/babel/releases)
- [Changelog](https://github.com/babel/babel/blob/main/CHANGELOG.md)
- [Commits](https://github.com/babel/babel/commits/v7.12.10/packages/babel-preset-react)
* Bumps nginx from 1.19.5-alpine to 1.19.6-alpine.
* Bump nginx from 1.19.5-alpine to 1.19.6-alpine
* Bump autoprefixer from 10.0.4 to 10.1.0
* Bump @babel/preset-react from 7.12.7 to 7.12.10
* Bumps node from 15.4.0-alpine to 15.5.0-alpine.
* Bump node from 15.4.0-alpine to 15.5.0-alpine
* Bumps [@testing-library/jest-dom](https://github.com/testing-library/jest-dom) from 5.11.6 to 5.11.8.
- [Release notes](https://github.com/testing-library/jest-dom/releases)
- [Changelog](https://github.com/testing-library/jest-dom/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/jest-dom/compare/v5.11.6...v5.11.8)
* Bump @testing-library/jest-dom from 5.11.6 to 5.11.8
* Bumps [core-js](https://github.com/zloirock/core-js) from 3.8.1 to 3.8.2.
- [Release notes](https://github.com/zloirock/core-js/releases)
- [Changelog](https://github.com/zloirock/core-js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/zloirock/core-js/compare/v3.8.1...v3.8.2)
* Bump core-js from 3.8.1 to 3.8.2
* Bumps [@testing-library/dom](https://github.com/testing-library/dom-testing-library) from 7.29.0 to 7.29.1.
- [Release notes](https://github.com/testing-library/dom-testing-library/releases)
- [Changelog](https://github.com/testing-library/dom-testing-library/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/dom-testing-library/compare/v7.29.0...v7.29.1)
* Bumps [msgpack5](https://github.com/mcollina/msgpack5) from 4.2.1 to 5.0.0.
- [Release notes](https://github.com/mcollina/msgpack5/releases)
- [Commits](https://github.com/mcollina/msgpack5/commits/v5.0.0)
* Bumps [eslint](https://github.com/eslint/eslint) from 7.16.0 to 7.17.0.
- [Release notes](https://github.com/eslint/eslint/releases)
- [Changelog](https://github.com/eslint/eslint/blob/master/CHANGELOG.md)
- [Commits](https://github.com/eslint/eslint/compare/v7.16.0...v7.17.0)
* Bumps [html-webpack-plugin](https://github.com/jantimon/html-webpack-plugin) from 4.5.0 to 4.5.1.
- [Release notes](https://github.com/jantimon/html-webpack-plugin/releases)
- [Changelog](https://github.com/jantimon/html-webpack-plugin/blob/master/CHANGELOG.md)
- [Commits](https://github.com/jantimon/html-webpack-plugin/compare/v4.5.0...v4.5.1)
* Bump html-webpack-plugin from 4.5.0 to 4.5.1
* Bump eslint from 7.16.0 to 7.17.0
* Bump @testing-library/dom from 7.29.0 to 7.29.1
* Bumps [webpack](https://github.com/webpack/webpack) from 5.11.0 to 5.11.1.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.11.0...v5.11.1)
* Bumps [eslint-plugin-prettier](https://github.com/prettier/eslint-plugin-prettier) from 3.3.0 to 3.3.1.
- [Release notes](https://github.com/prettier/eslint-plugin-prettier/releases)
- [Changelog](https://github.com/prettier/eslint-plugin-prettier/blob/master/CHANGELOG.md)
- [Commits](https://github.com/prettier/eslint-plugin-prettier/compare/v3.3.0...v3.3.1)
* Bump eslint-plugin-prettier from 3.3.0 to 3.3.1
* Bump webpack from 5.11.0 to 5.11.1
* Bumps [msw](https://github.com/mswjs/msw) from 0.24.2 to 0.25.0.
- [Release notes](https://github.com/mswjs/msw/releases)
- [Changelog](https://github.com/mswjs/msw/blob/master/CHANGELOG.md)
- [Commits](https://github.com/mswjs/msw/compare/v0.24.2...v0.25.0)
* Bumps [postcss](https://github.com/postcss/postcss) from 8.2.1 to 8.2.2.
- [Release notes](https://github.com/postcss/postcss/releases)
- [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
- [Commits](https://github.com/postcss/postcss/compare/8.2.1...8.2.2)
* Bumps [less](https://github.com/less/less.js) from 3.12.2 to 3.13.1.
- [Release notes](https://github.com/less/less.js/releases)
- [Changelog](https://github.com/less/less.js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/less/less.js/compare/v3.12.2...v3.13.1)
* Bumps [axios](https://github.com/axios/axios) from 0.21.0 to 0.21.1.
- [Release notes](https://github.com/axios/axios/releases)
- [Changelog](https://github.com/axios/axios/blob/v0.21.1/CHANGELOG.md)
- [Commits](https://github.com/axios/axios/compare/v0.21.0...v0.21.1)
* Bumps [eslint-plugin-react](https://github.com/yannickcr/eslint-plugin-react) from 7.21.5 to 7.22.0.
- [Release notes](https://github.com/yannickcr/eslint-plugin-react/releases)
- [Changelog](https://github.com/yannickcr/eslint-plugin-react/blob/master/CHANGELOG.md)
- [Commits](https://github.com/yannickcr/eslint-plugin-react/compare/v7.21.5...v7.22.0)
* Bump axios from 0.21.0 to 0.21.1
* Bump eslint-plugin-react from 7.21.5 to 7.22.0
* Bumps [less-loader](https://github.com/webpack-contrib/less-loader) from 7.1.0 to 7.2.1.
- [Release notes](https://github.com/webpack-contrib/less-loader/releases)
- [Changelog](https://github.com/webpack-contrib/less-loader/blob/master/CHANGELOG.md)
- [Commits](https://github.com/webpack-contrib/less-loader/compare/v7.1.0...v7.2.1)
* Bump msgpack5 from 4.2.1 to 5.0.0
* Bumps [webpack](https://github.com/webpack/webpack) from 5.11.1 to 5.12.1.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.11.1...v5.12.1)
* Bumps [react-idle-timer](https://github.com/supremetechnopriest/react-idle-timer) from 4.5.0 to 4.5.1.
- [Release notes](https://github.com/supremetechnopriest/react-idle-timer/releases)
- [Changelog](https://github.com/SupremeTechnopriest/react-idle-timer/blob/master/CHANGELOG.md)
- [Commits](https://github.com/supremetechnopriest/react-idle-timer/compare/4.5.0...4.5.1)
* Bumps [autoprefixer](https://github.com/postcss/autoprefixer) from 10.2.0 to 10.2.1.
- [Release notes](https://github.com/postcss/autoprefixer/releases)
- [Changelog](https://github.com/postcss/autoprefixer/blob/main/CHANGELOG.md)
- [Commits](https://github.com/postcss/autoprefixer/compare/10.2.0...10.2.1)
* Bumps [@testing-library/react](https://github.com/testing-library/react-testing-library) from 11.2.2 to 11.2.3.
- [Release notes](https://github.com/testing-library/react-testing-library/releases)
- [Changelog](https://github.com/testing-library/react-testing-library/blob/master/CHANGELOG.md)
- [Commits](https://github.com/testing-library/react-testing-library/compare/v11.2.2...v11.2.3)
* Bump @testing-library/react from 11.2.2 to 11.2.3
* Bump autoprefixer from 10.2.0 to 10.2.1
* Bump react-idle-timer from 4.5.0 to 4.5.1
* Bump webpack from 5.11.1 to 5.12.1
* Bumps [webpack](https://github.com/webpack/webpack) from 5.12.1 to 5.12.3.
- [Release notes](https://github.com/webpack/webpack/releases)
- [Commits](https://github.com/webpack/webpack/compare/v5.12.1...v5.12.3)
* Bumps [postcss](https://github.com/postcss/postcss) from 8.2.3 to 8.2.4.
- [Release notes](https://github.com/postcss/postcss/releases)
- [Changelog](https://github.com/postcss/postcss/blob/main/CHANGELOG.md)
- [Commits](https://github.com/postcss/postcss/compare/8.2.3...8.2.4)
* Bumps [less](https://github.com/less/less.js) from 4.0.0 to 4.1.0.
- [Release notes](https://github.com/less/less.js/releases)
- [Changelog](https://github.com/less/less.js/blob/master/CHANGELOG.md)
- [Commits](https://github.com/less/less.js/compare/v4.0.0...v4.1.0)
* Bumps node from 15.5.0-alpine to 15.5.1-alpine.
* Bump node from 15.5.0-alpine to 15.5.1-alpine
* Bump less from 4.0.0 to 4.1.0
* Bump postcss from 8.2.3 to 8.2.4
* Bump webpack from 5.12.1 to 5.12.3

#### integration (2.6.0)

New changes in integration since 2.5.0:

* New compose file to optionally add deviceconnect service to the backend
* New compose file to optionally add deviceconnect service to the backend
* demo script, include docker-compose.connect.yml by default
([MEN-4357](https://northerntech.atlassian.net/browse/MEN-4357))
* Add auditlogs and deviceconnect to production templates
* Add auditlogs 1.0.0.
* Upgrade deployments to 2.2.0.
* Upgrade deployments-enterprise to 2.2.0.
* Upgrade deviceauth to 2.5.0.
* Add deviceconnect 1.0.0.
* Upgrade gui to 2.6.0.
* Upgrade inventory to 2.2.0.
* Upgrade inventory-enterprise to 2.2.0.
* Upgrade mender to 2.5.0.
* Upgrade mender-api-gateway-docker to 2.4.0.
* Upgrade mender-artifact to 3.5.0.
* Upgrade mender-cli to 1.6.0.
* Add mender-connect 1.0.0.
* Upgrade tenantadm to 3.0.0.
* Upgrade useradm to 1.13.0.
* Upgrade useradm-enterprise to 1.13.0.
* Upgrade workflows to 1.3.0.
* Upgrade workflows-enterprise to 1.3.0.
* Aggregated Dependabot Changelogs:
* Bumps [stripe](https://github.com/stripe/stripe-python) from 2.50.0 to 2.51.0.
- [Release notes](https://github.com/stripe/stripe-python/releases)
- [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
- [Commits](https://github.com/stripe/stripe-python/compare/v2.50.0...v2.51.0)
* Bump stripe from 2.50.0 to 2.51.0 in /backend-tests
* Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.0.1 to 6.0.2.
- [Release notes](https://github.com/pytest-dev/pytest/releases)
- [Changelog](https://github.com/pytest-dev/pytest/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pytest-dev/pytest/compare/6.0.1...6.0.2)
* Bumps [docker-compose](https://github.com/docker/compose) from 1.26.2 to 1.27.2.
- [Release notes](https://github.com/docker/compose/releases)
- [Changelog](https://github.com/docker/compose/blob/master/CHANGELOG.md)
- [Commits](https://github.com/docker/compose/compare/1.26.2...1.27.2)
* Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.0.1 to 6.0.2.
- [Release notes](https://github.com/pytest-dev/pytest/releases)
- [Changelog](https://github.com/pytest-dev/pytest/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pytest-dev/pytest/compare/6.0.1...6.0.2)
* Bump pytest from 6.0.1 to 6.0.2 in /tests/requirements
* Bump docker-compose from 1.26.2 to 1.27.2 in /tests/requirements
* Bump pytest from 6.0.1 to 6.0.2 in /backend-tests
* Bumps [docker-compose](https://github.com/docker/compose) from 1.27.2 to 1.27.3.
- [Release notes](https://github.com/docker/compose/releases)
- [Changelog](https://github.com/docker/compose/blob/1.27.3/CHANGELOG.md)
- [Commits](https://github.com/docker/compose/compare/1.27.2...1.27.3)
* Bump docker-compose from 1.27.2 to 1.27.3 in /tests/requirements
* Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.0.2 to 6.1.0.
- [Release notes](https://github.com/pytest-dev/pytest/releases)
- [Changelog](https://github.com/pytest-dev/pytest/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pytest-dev/pytest/compare/6.0.2...6.1.0)
* Bumps [docker-compose](https://github.com/docker/compose) from 1.27.3 to 1.27.4.
- [Release notes](https://github.com/docker/compose/releases)
- [Changelog](https://github.com/docker/compose/blob/1.27.4/CHANGELOG.md)
- [Commits](https://github.com/docker/compose/compare/1.27.3...1.27.4)
* Bumps [cryptography](https://github.com/pyca/cryptography) from 3.1 to 3.1.1.
- [Release notes](https://github.com/pyca/cryptography/releases)
- [Changelog](https://github.com/pyca/cryptography/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pyca/cryptography/compare/3.1...3.1.1)
* Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.0.2 to 6.1.0.
- [Release notes](https://github.com/pytest-dev/pytest/releases)
- [Changelog](https://github.com/pytest-dev/pytest/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pytest-dev/pytest/compare/6.0.2...6.1.0)
* Bumps [stripe](https://github.com/stripe/stripe-python) from 2.51.0 to 2.53.0.
- [Release notes](https://github.com/stripe/stripe-python/releases)
- [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
- [Commits](https://github.com/stripe/stripe-python/compare/v2.51.0...v2.53.0)
* Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.1.0 to 6.1.1.
- [Release notes](https://github.com/pytest-dev/pytest/releases)
- [Changelog](https://github.com/pytest-dev/pytest/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pytest-dev/pytest/compare/6.1.0...6.1.1)
* Bumps [pytest](https://github.com/pytest-dev/pytest) from 6.1.0 to 6.1.1.
- [Release notes](https://github.com/pytest-dev/pytest/releases)
- [Changelog](https://github.com/pytest-dev/pytest/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pytest-dev/pytest/compare/6.1.0...6.1.1)
* Bumps [stripe](https://github.com/stripe/stripe-python) from 2.53.0 to 2.54.0.
- [Release notes](https://github.com/stripe/stripe-python/releases)
- [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
- [Commits](https://github.com/stripe/stripe-python/compare/v2.53.0...v2.54.0)
* Bumps python from 3.8 to 3.9.0.
* Bump python from 3.8 to 3.9.0 in /backend-tests/docker
* Bumps [stripe](https://github.com/stripe/stripe-python) from 2.54.0 to 2.55.0.
- [Release notes](https://github.com/stripe/stripe-python/releases)
- [Changelog](https://github.com/stripe/stripe-python/blob/master/CHANGELOG.md)
- [Commits](https://github.com/stripe/stripe-python/compare/v2.54.0...v2.55.0)
* Bumps [pillow](https://github.com/python-pillow/Pillow) from 7.2.0 to 8.0.0.
- [Release notes](https://github.com/python-pillow/Pillow/releases)
- [Changelog](https://github.com/python-pillow/Pillow/blob/master/CHANGES.rst)
- [Commits](https://github.com/python-pillow/Pillow/compare/7.2.0...8.0.0)
* Bumps [pyotp](https://github.com/pyotp/pyotp) from 2.4.0 to 2.4.1.
- [Release notes](https://github.com/pyotp/pyotp/releases)
- [Changelog](https://github.com/pyauth/pyotp/blob/develop/Changes.rst)
- [Commits](https://github.com/pyotp/pyotp/compare/v2.4.0...v2.4.1)
* Bumps [cryptography](https://github.com/pyca/cryptography) from 3.1.1 to 3.2.
- [Release notes](https://github.com/pyca/cryptography/releases)
- [Changelog](https://github.com/pyca/cryptography/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pyca/cryptography/compare/3.1.1...3.2)
* Bumps [pillow](https://github.com/python-pillow/Pillow) from 8.0.0 to 8.0.1.
- [Release notes](https://github.com/python-pillow/Pillow/releases)
- [Changelog](https://github.com/python-pillow/Pillow/blob/master/CHANGES.rst)
- [Commits](https://github.com/python-pillow/Pillow/compare/8.0.0...8.0.1)
* Bumps [cryptography](https://github.com/pyca/cryptography) from 3.2 to 3.2.1.
- [Release notes](https://github.com/pyca/cryptography/releases)
- [Changelog](https://github.com/pyca/cryptography/blob/master/CHANGELOG.rst)
- [Commits](https://github.com/pyca/cryptography/compare/3.2...3.2.1)
* Bumps [pytest](https://github.com/pyte