// Copyright 2020 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

package utils

const (
	TestRSAPublic = `-----BEGIN PUBLIC KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzogVU7RGDilbsoUt/DdH
VJvcepl0A5+xzGQ50cq1VE/Dyyy8Zp0jzRXCnnu9nu395mAFSZGotZVr+sWEpO3c
yC3VmXdBZmXmQdZqbdD/GuixJOYfqta2ytbIUPRXFN7/I7sgzxnXWBYXYmObYvdP
okP0mQanY+WKxp7Q16pt1RoqoAd0kmV39g13rFl35muSHbSBoAW3GBF3gO+mF5Ty
1ddp/XcgLOsmvNNjY+2HOD5F/RX0fs07mWnbD7x+xz7KEKjF+H7ZpkqCwmwCXaf0
iyYyh1852rti3Afw4mDxuVSD7sd9ggvYMc0QHIpQNkD4YWOhNiE1AB0zH57VbUYG
UwIDAQAB
-----END PUBLIC KEY-----
`
	TestRSAPrivate = `-----BEGIN RSA PRIVATE KEY-----
MIIEpAIBAAKCAQEAzogVU7RGDilbsoUt/DdHVJvcepl0A5+xzGQ50cq1VE/Dyyy8
Zp0jzRXCnnu9nu395mAFSZGotZVr+sWEpO3cyC3VmXdBZmXmQdZqbdD/GuixJOYf
qta2ytbIUPRXFN7/I7sgzxnXWBYXYmObYvdPokP0mQanY+WKxp7Q16pt1RoqoAd0
kmV39g13rFl35muSHbSBoAW3GBF3gO+mF5Ty1ddp/XcgLOsmvNNjY+2HOD5F/RX0
fs07mWnbD7x+xz7KEKjF+H7ZpkqCwmwCXaf0iyYyh1852rti3Afw4mDxuVSD7sd9
ggvYMc0QHIpQNkD4YWOhNiE1AB0zH57VbUYGUwIDAQABAoIBAQC/CheYJp/Kh60f
U5u2ujdL5yQpb3plw7kGFAt7qGLUizfT3xyiWmZ8VM2CJXm/4erCxzz80TRaSs3n
1/6bRL69l9AFtc8T9dvoOHqX/AONE4KQXCEcuKG6vLPsViea0a71kSmHCCMugri8
tOBNye+qa+t8BTCe8fvNP6h0ZVxVCcXkcnLgNM0m9+4LK4dwUMOv95CReumXwGA+
bCpeaMVKPleMr/NS6VbweOVPjc/2XGzG/5xtfcZxC8/I4OBS5WPTpjmAqJL3A/3d
Is9Eq9MD6BT4wthMqtHMZrSKdC/1BVFqe5lLWsnjYEWJBh/FH0W9uqXUt/yCL+Jy
x9f9R+nxAoGBAPWldbOaE3/q4kPbBJyY3X9BooMlfXTLfGstG19dKMlsB9Oi2x4E
gDHYlM6ovw1YGjw9Ertwbo3G3NG1i7xnKh3ZOpwaFnfZgOWqIDbCS8xk018+BgyQ
LM0/s3vr5C1WN1+ccPvoNrtCb7hsOiIcDFFLt1ck+CALzgB8CH928s0rAoGBANc8
kqBnbGLghDsUrUMAqZg9HOH/snAFxZL+hyYnc0UxH5nA2Fq+VH24cL4BJaKfRTAP
Fw9/YBgOVH79BVAH/bSJHE8t2pxF1JXdWnfqC8Ytnb27ssrFi8HdyJ0kxJbow93e
7+KTvzDMk0DR9X4vflGMckFLXcVQFL/W22HUBKd5AoGBAMvAqpiGvJXl5jgSewjJ
YzAi6QGPHzi5cEIV8BZx11r7WKKa+tUzNoIh+4xPO+l9ooVEwzzmTU0cHh10UKu9
hpmrjYndubU/nELjkkTZdLXdC9Z8Q9g33nGA3Qd06pcQZG3R/YV1X7CDstduLeoN
CcqE21ZVO9qY8A5G02Wm7E5xAoGAR6KNWn2RgUcgO1miYM5zo4uTdVRY2xfQrh+w
c25l2v2CevXIDEuUa1NbkqFnGTzRFjGvhyTpopgCX1Fu1zgRpGiN13x3adOD8Wz+
kzJ+QLMl8OPrmbktzpQ2FLcMBv3pUorEZDCwTVmJGOXIQvsjm5iW3kxrJSSGA2NL
GMAr3GECgYBR7Gc1tW/txOJP/jn9zlEFizhE7392tjOlsV4IKnS0JI7Wz9oeEAN5
gbJcS+fBHAv2JFGmm2cqhyU4AozidF0vqlC04pohBdPRzrHXTTKY/bzu7yuZWZt1
oRS8PfTSPT6uS6hskTshrwRDjs1a+q1loZy8PAT3FTtaKt1ZdR0wuQ==
-----END RSA PRIVATE KEY-----
`
	TestRSAPrivatInvalid = `-----BEGIN RSA PRIVATE KEY-----
MIIEpQIBAAKCAQEAwMAOavdsjJro5+8QjZDf3mZmLCSS41HB44xzk63rwn7tLDe8
SmF8lT9FuZtcUDr/4g++8NsbHfN1LCRIs/6R1GNBKqu3q4cPGd3FjHfpLt9xJHG4
AV5F1Vzj0lAvva49DiKjkc0gZGKtVWShDzRE0IYIZkMjyOzHa51bJdvwIur7WZkz
C2lDycivbR0iviXG1X+5xu6eUk/A4rgoaPcpxjlzHsLesonpCBgnnXOXuXeNv774
z8SqqlLVIBgxtzXfAc+sY8CkzkTLuyjKXNHlX7pH7JjEOmKJed0XW10IRA7lOG+Z
ZKFF+h4sEkCLmbz9AMP171LEgvX0hSfnaBdqpwIDAQABAoIBAQCoZGF0M9rCb+eA
EQxOET5zhtRGRmGJdPjFugOTBkPM9KRxl/PIq6hynwdkIwWgFhtMvOLcex8SqIo6
WSynC4UNnvTkuYZJtUGNIIGguXWffJfU9gCCOYEa6P8j0ugSd3FhswNhsmpVKRwz
WSmYJdrkreQSqx9NPwbtzlg+GAqQBWQVeLzKoLRWyTDcQAVbbUY/TXLQbAVgD88E
FtDrhqwsKqVnDgdPlzardRUsWQuUFZqctyxN579brRxovobjUDsJS9xWbVLb9FSN
gf65vQ59+SK7hdWS+3b+9mNsnqCxWNe/g6oHULBbjqKChnMwYlMj4gSSdEO2qKvV
KuaoBVdBAoGBAN5Mp2delibTEEjEk+oDnVHBdfE1uR9srIj6kBB8IyQi7zaJjPb8
Oq6DcawNjZUZgxvC3MmSLt9PTkXGdznKKM6zy5WYpB9Uu07HkJXEVmR8Mj9z0N5k
dL+j8pUfLZdIfZvm5sfXJAUiDov7gweE7etPjcEFHLio3kYqpczLE97HAoGBAN34
nDTL43XITn9FPVVPqdhuSEXVae0aeSTQsBqGnQSzGd5t232oCPUoUznC+g4aFMKa
Qz7s3s7r81KwjLhNGM22Yj7ob2qntMIisktEFIDYDQo53kDkmm50jIa80n37C+Va
jRKfXdJxoTi3xYsGnWnvdsKdZpJee9ffwsfw07UhAoGBANnJwayNR5AL8oVISh3X
orZpUjKaTp8R6ktdJ+1uoUMTEsecpUWIwbkdwC0vLgnob8Gv/H1jQZa4bNgBY+dz
Pt2b2pXacNjdO5EoBWglbfqOjvAJeJWZV6Q1bEFaxWDUvXMTGgCpr3lz70qHg8zH
GA0U6K01Y/kqQHH/8GYeg34bAoGBAL89wtd6Eq8XtQnSDdXCnQLrgTkpdeniNR2S
7ybrc7zo0hDhdYn9jDosVAggBHDB58ECR42fZxfAEhPcKGFhi00xJdQtTlEFzKa2
Xgaa0U9w1UtKMEKYsrUXlTtA09nWwZkJOyIgTCVT4SOMsZXmTRlIR3nFQuo4nVqQ
XrEEvGIBAoGAay0z5LjCoDY3oRDwwtv1MXn516NtHhs5+ycdUup86xRF8m2HdeBc
aehqOcW0lcuEvEbHUAjmQcRbf/NcDgtRHYu/IRcDX6R3iW6h5mTLKjMdNXDVe3rK
mhaW8NAJfcT40p80xG9CSRBHnP6S6u/8RG/xZfLEow8/d9zaa5pY3k0=
-----END RSA PRIVATE KEY-----
`
	TestRSAPublicBadPEM = `-----BEGIN FOO-----MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzogVU7RGDilbsoUt/DdH
VJvcepl0A5+xzGQ50cq1VE/Dyyy8Zp0jzRXCnnu9nu395mAFSZGotZVr+sWEpO3c
yC3VmXdBZmXmQdZqbdD/GuixJOYfqta2ytbIUPRXFN7/I7sgzxnXWBYXYmObYvdP
okP0mQanY+WKxp7Q16pt1RoqoAd0kmV39g13rFl35muSHbSBoAW3GBF3gO+mF5Ty
1ddp/XcgLOsmvNNjY+2HOD5F/RX0fs07mWnbD7x+xz7KEKjF+H7ZpkqCwmwCXaf0
iyYyh1852rti3Afw4mDxuVSD7sd9ggvYMc0QHIpQNkD4YWOhNiE1AB0zH57VbUYG
UwIDAQAB
-----END FOO-----
`
	TestRSAPublicBadContent = `-----BEGIN PUBLIC KEY-----
IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzogVU7RGDilbsoUt/DdH
VJvcepl0A5+xzGQ50cq1VE/Dyyy8Zp0jzRXCnnu9nu395mAFSZGotZVr+sWEpO3c
yC3VmXdBZmXmQdZqbdD/GuixJOYfqta2ytbIUPRXFN7/I7sgzxnXWBYXYmObYvdP
okP0mQanY+WKxp7Q16pt1RoqoAd0kmV39g13rFl35muSHbSBoAW3GBF3gO+mF5Ty
1ddp/XcgLOsmvNNjY+2HOD5F/RX0fs07mWnbD7x+xz7KEKjF+H7ZpkqCwmwCXaf0
iyYyh1852rti3Afw4mDxuVSD7sd9ggvYMc0QHIpQNkD4YWOhNiE1AB0zH57VbUYG
UwIDAQAB
-----END PUBLIC KEY-----
`
	TestDSAPublic = `-----BEGIN PUBLIC KEY-----
MIIBwDCCATQGByqGSM44BAEwggEnAoGBAJEKECdCkAAmrwUT81dlZEPBO3xpcnRG
uUBPqWjZzYgwB2PW+bUG+bN5i2kev5hUE2kc6Oj4XG4Wv0ZwSLoX8f4fz/M9q0xX
yn9bOjGFl3CkPZFZLzv6Jkr/PpHKAG/sIj77nvPF/zURPpgwWhwxNgvHHH7jhQJd
RSibaaSUQAilAh0Ago4+3R5rUrAdn4Et86Hn7WYgY5dNxCt/E+fvYwKBgQCEneRs
HGLsjSofWtwTjw5+fYpitKR3BmhwTVgDYD9XFOSb31U/2jNILPYjBDwR4zH/yNLc
19SsX9UzniagLLU09fPIwQdbRxHh+9qTLwwY2fFcCHhzeP/Tbn87IdWCB3rx4aA/
KVk1clTXHI/AFnQVbEbL4zISH0qulZgu0HdtfAOBhQACgYEAjLltkEtHgJZMQ6+0
7hVi4pW5ZDyRil4W0+Ou5NtIxdT1Dn97WmB5+2aomiDC/se6kf6bFGI6BH6XHvkv
R+V6M2+YrBoMsCg4UHT45B3MV0anuiVPoFyazLHRRWWbyO2ojub4ILBotng4jx7+
2xWv8rdHI96RUpjUQ5dqxxdERO8=
-----END PUBLIC KEY-----
`
	TestECDSAPrivate = `-----BEGIN PRIVATE KEY-----
MIHuAgEAMBAGByqGSM49AgEGBSuBBAAjBIHWMIHTAgEBBEIBSiqjnXafUNXJfoPY
MCe9OciR/pPQzaztnlMnN2Ajf5c3QmamzNnDV//nzdcSiiyYE6Oynqenfm0R/0Lw
kDwGhRChgYkDgYYABAGHJsXwy6XPqOIW6R4JDEAU9jOnZ2PZSFRP3I9teZ09tPNS
vRA1cHCBoj44tQs1DvfvRGw+EmJQ/dCHdJLfWHFa2gFM0d1vt15B5fzp4hEHF6Jl
iGeCZfDDDQXD8thXt+kHM8JSwbPq+bl6/OeuX0PhmBjWQeUW5zHVHeUhOIJk7iiC
/Q==
-----END PRIVATE KEY-----
`
	TestECDSAPublic = `-----BEGIN PUBLIC KEY-----
MIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQBhybF8Mulz6jiFukeCQxAFPYzp2dj
2UhUT9yPbXmdPbTzUr0QNXBwgaI+OLULNQ7370RsPhJiUP3Qh3SS31hxWtoBTNHd
b7deQeX86eIRBxeiZYhngmXwww0Fw/LYV7fpBzPCUsGz6vm5evznrl9D4ZgY1kHl
Fucx1R3lITiCZO4ogv0=
-----END PUBLIC KEY-----`
	TestED25519Private = `-----BEGIN PRIVATE KEY-----
MC4CAQAwBQYDK2VwBCIEIF9TfRLLIbG0+A+gv5KF3sa8FgDCrD8+6hBU8+03K42D
-----END PRIVATE KEY-----

`
	TestED25519Public = `-----BEGIN PRIVATE KEY-----
MC4CAQAwBQYDK2VwBCIEIF9TfRLLIbG0+A+gv5KF3sa8FgDCrD8+6hBU8+03K42D
-----END PRIVATE KEY-----
`
)
