// Copyright 2023 Northern.tech AS
//
//	Licensed under the Apache License, Version 2.0 (the "License");
//	you may not use this file except in compliance with the License.
//	You may obtain a copy of the License at
//
//	    http://www.apache.org/licenses/LICENSE-2.0
//
//	Unless required by applicable law or agreed to in writing, software
//	distributed under the License is distributed on an "AS IS" BASIS,
//	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//	See the License for the specific language governing permissions and
//	limitations under the License.

// Code generated by mockery v2.45.1. DO NOT EDIT.

package mocks

import (
	context "context"

	model "github.com/mendersoftware/mender-server/services/deployments/model"
	mock "github.com/stretchr/testify/mock"

	workflows "github.com/mendersoftware/mender-server/services/deployments/client/workflows"
)

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// CheckHealth provides a mock function with given fields: ctx
func (_m *Client) CheckHealth(ctx context.Context) error {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for CheckHealth")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// StartGenerateArtifact provides a mock function with given fields: ctx, multipartGenerateImageMsg
func (_m *Client) StartGenerateArtifact(ctx context.Context, multipartGenerateImageMsg *model.MultipartGenerateImageMsg) error {
	ret := _m.Called(ctx, multipartGenerateImageMsg)

	if len(ret) == 0 {
		panic("no return value specified for StartGenerateArtifact")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.MultipartGenerateImageMsg) error); ok {
		r0 = rf(ctx, multipartGenerateImageMsg)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// StartReindexReporting provides a mock function with given fields: c, device
func (_m *Client) StartReindexReporting(c context.Context, device string) error {
	ret := _m.Called(c, device)

	if len(ret) == 0 {
		panic("no return value specified for StartReindexReporting")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(c, device)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// StartReindexReportingDeployment provides a mock function with given fields: c, device, deployment, id
func (_m *Client) StartReindexReportingDeployment(c context.Context, device string, deployment string, id string) error {
	ret := _m.Called(c, device, deployment, id)

	if len(ret) == 0 {
		panic("no return value specified for StartReindexReportingDeployment")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string) error); ok {
		r0 = rf(c, device, deployment, id)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// StartReindexReportingDeploymentBatch provides a mock function with given fields: c, info
func (_m *Client) StartReindexReportingDeploymentBatch(c context.Context, info []workflows.DeviceDeploymentShortInfo) error {
	ret := _m.Called(c, info)

	if len(ret) == 0 {
		panic("no return value specified for StartReindexReportingDeploymentBatch")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, []workflows.DeviceDeploymentShortInfo) error); ok {
		r0 = rf(c, info)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NewClient creates a new instance of Client. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewClient(t interface {
	mock.TestingT
	Cleanup(func())
}) *Client {
	mock := &Client{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
