// Copyright 2023 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

// Code generated by mockery v2.45.1. DO NOT EDIT.

package mocks

import (
	context "context"

	model "github.com/mendersoftware/mender-server/services/deviceauth/model"
	mock "github.com/stretchr/testify/mock"

	time "time"
)

// Cache is an autogenerated mock type for the Cache type
type Cache struct {
	mock.Mock
}

// CacheCheckInTime provides a mock function with given fields: ctx, t, tid, id
func (_m *Cache) CacheCheckInTime(ctx context.Context, t *time.Time, tid string, id string) error {
	ret := _m.Called(ctx, t, tid, id)

	if len(ret) == 0 {
		panic("no return value specified for CacheCheckInTime")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *time.Time, string, string) error); ok {
		r0 = rf(ctx, t, tid, id)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CacheToken provides a mock function with given fields: ctx, tid, id, idtype, token, expireSec
func (_m *Cache) CacheToken(ctx context.Context, tid string, id string, idtype string, token string, expireSec time.Duration) error {
	ret := _m.Called(ctx, tid, id, idtype, token, expireSec)

	if len(ret) == 0 {
		panic("no return value specified for CacheToken")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string, string, time.Duration) error); ok {
		r0 = rf(ctx, tid, id, idtype, token, expireSec)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteLimit provides a mock function with given fields: ctx, name
func (_m *Cache) DeleteLimit(ctx context.Context, name string) error {
	ret := _m.Called(ctx, name)

	if len(ret) == 0 {
		panic("no return value specified for DeleteLimit")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, name)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteToken provides a mock function with given fields: ctx, tid, id, idtype
func (_m *Cache) DeleteToken(ctx context.Context, tid string, id string, idtype string) error {
	ret := _m.Called(ctx, tid, id, idtype)

	if len(ret) == 0 {
		panic("no return value specified for DeleteToken")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string) error); ok {
		r0 = rf(ctx, tid, id, idtype)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetCheckInTime provides a mock function with given fields: ctx, tid, id
func (_m *Cache) GetCheckInTime(ctx context.Context, tid string, id string) (*time.Time, error) {
	ret := _m.Called(ctx, tid, id)

	if len(ret) == 0 {
		panic("no return value specified for GetCheckInTime")
	}

	var r0 *time.Time
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string) (*time.Time, error)); ok {
		return rf(ctx, tid, id)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, string) *time.Time); ok {
		r0 = rf(ctx, tid, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*time.Time)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, tid, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetCheckInTimes provides a mock function with given fields: ctx, tid, ids
func (_m *Cache) GetCheckInTimes(ctx context.Context, tid string, ids []string) ([]*time.Time, error) {
	ret := _m.Called(ctx, tid, ids)

	if len(ret) == 0 {
		panic("no return value specified for GetCheckInTimes")
	}

	var r0 []*time.Time
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, []string) ([]*time.Time, error)); ok {
		return rf(ctx, tid, ids)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, []string) []*time.Time); ok {
		r0 = rf(ctx, tid, ids)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*time.Time)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, []string) error); ok {
		r1 = rf(ctx, tid, ids)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetLimit provides a mock function with given fields: ctx, name
func (_m *Cache) GetLimit(ctx context.Context, name string) (*model.Limit, error) {
	ret := _m.Called(ctx, name)

	if len(ret) == 0 {
		panic("no return value specified for GetLimit")
	}

	var r0 *model.Limit
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string) (*model.Limit, error)); ok {
		return rf(ctx, name)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string) *model.Limit); ok {
		r0 = rf(ctx, name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Limit)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, name)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetLimit provides a mock function with given fields: ctx, limit
func (_m *Cache) SetLimit(ctx context.Context, limit *model.Limit) error {
	ret := _m.Called(ctx, limit)

	if len(ret) == 0 {
		panic("no return value specified for SetLimit")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.Limit) error); ok {
		r0 = rf(ctx, limit)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SuspendTenant provides a mock function with given fields: ctx, tid
func (_m *Cache) SuspendTenant(ctx context.Context, tid string) error {
	ret := _m.Called(ctx, tid)

	if len(ret) == 0 {
		panic("no return value specified for SuspendTenant")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, tid)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Throttle provides a mock function with given fields: ctx, rawToken, tid, id, idtype, url, action
func (_m *Cache) Throttle(ctx context.Context, rawToken string, tid string, id string, idtype string, url string, action string) (string, error) {
	ret := _m.Called(ctx, rawToken, tid, id, idtype, url, action)

	if len(ret) == 0 {
		panic("no return value specified for Throttle")
	}

	var r0 string
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string, string, string, string) (string, error)); ok {
		return rf(ctx, rawToken, tid, id, idtype, url, action)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string, string, string, string) string); ok {
		r0 = rf(ctx, rawToken, tid, id, idtype, url, action)
	} else {
		r0 = ret.Get(0).(string)
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, string, string, string, string, string) error); ok {
		r1 = rf(ctx, rawToken, tid, id, idtype, url, action)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// NewCache creates a new instance of Cache. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewCache(t interface {
	mock.TestingT
	Cleanup(func())
}) *Cache {
	mock := &Cache{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
