// Copyright 2023 Northern.tech AS
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.

// Code generated by mockery v2.45.1. DO NOT EDIT.

package mocks

import (
	context "context"
	io "io"

	mock "github.com/stretchr/testify/mock"

	model "github.com/mendersoftware/mender-server/services/deviceconnect/model"

	time "time"
)

// App is an autogenerated mock type for the App type
type App struct {
	mock.Mock
}

// DeleteDevice provides a mock function with given fields: ctx, tenantID, deviceID
func (_m *App) DeleteDevice(ctx context.Context, tenantID string, deviceID string) error {
	ret := _m.Called(ctx, tenantID, deviceID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteDevice")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string) error); ok {
		r0 = rf(ctx, tenantID, deviceID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteTenant provides a mock function with given fields: ctx, tenantID
func (_m *App) DeleteTenant(ctx context.Context, tenantID string) error {
	ret := _m.Called(ctx, tenantID)

	if len(ret) == 0 {
		panic("no return value specified for DeleteTenant")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string) error); ok {
		r0 = rf(ctx, tenantID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DownloadFile provides a mock function with given fields: ctx, userID, deviceID, path
func (_m *App) DownloadFile(ctx context.Context, userID string, deviceID string, path string) error {
	ret := _m.Called(ctx, userID, deviceID, path)

	if len(ret) == 0 {
		panic("no return value specified for DownloadFile")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string) error); ok {
		r0 = rf(ctx, userID, deviceID, path)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// FreeUserSession provides a mock function with given fields: ctx, sessionID, sessionTypes
func (_m *App) FreeUserSession(ctx context.Context, sessionID string, sessionTypes []string) error {
	ret := _m.Called(ctx, sessionID, sessionTypes)

	if len(ret) == 0 {
		panic("no return value specified for FreeUserSession")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, []string) error); ok {
		r0 = rf(ctx, sessionID, sessionTypes)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetControlRecorder provides a mock function with given fields: ctx, sessionID
func (_m *App) GetControlRecorder(ctx context.Context, sessionID string) io.Writer {
	ret := _m.Called(ctx, sessionID)

	if len(ret) == 0 {
		panic("no return value specified for GetControlRecorder")
	}

	var r0 io.Writer
	if rf, ok := ret.Get(0).(func(context.Context, string) io.Writer); ok {
		r0 = rf(ctx, sessionID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.Writer)
		}
	}

	return r0
}

// GetDevice provides a mock function with given fields: ctx, tenantID, deviceID
func (_m *App) GetDevice(ctx context.Context, tenantID string, deviceID string) (*model.Device, error) {
	ret := _m.Called(ctx, tenantID, deviceID)

	if len(ret) == 0 {
		panic("no return value specified for GetDevice")
	}

	var r0 *model.Device
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string) (*model.Device, error)); ok {
		return rf(ctx, tenantID, deviceID)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, string) *model.Device); ok {
		r0 = rf(ctx, tenantID, deviceID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*model.Device)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, tenantID, deviceID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetRecorder provides a mock function with given fields: ctx, sessionID
func (_m *App) GetRecorder(ctx context.Context, sessionID string) io.Writer {
	ret := _m.Called(ctx, sessionID)

	if len(ret) == 0 {
		panic("no return value specified for GetRecorder")
	}

	var r0 io.Writer
	if rf, ok := ret.Get(0).(func(context.Context, string) io.Writer); ok {
		r0 = rf(ctx, sessionID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(io.Writer)
		}
	}

	return r0
}

// GetSessionRecording provides a mock function with given fields: ctx, id, w
func (_m *App) GetSessionRecording(ctx context.Context, id string, w io.Writer) error {
	ret := _m.Called(ctx, id, w)

	if len(ret) == 0 {
		panic("no return value specified for GetSessionRecording")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, io.Writer) error); ok {
		r0 = rf(ctx, id, w)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// HealthCheck provides a mock function with given fields: ctx
func (_m *App) HealthCheck(ctx context.Context) error {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for HealthCheck")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context) error); ok {
		r0 = rf(ctx)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// LogUserSession provides a mock function with given fields: ctx, sess, sessionType
func (_m *App) LogUserSession(ctx context.Context, sess *model.Session, sessionType string) error {
	ret := _m.Called(ctx, sess, sessionType)

	if len(ret) == 0 {
		panic("no return value specified for LogUserSession")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.Session, string) error); ok {
		r0 = rf(ctx, sess, sessionType)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// PrepareUserSession provides a mock function with given fields: ctx, sess
func (_m *App) PrepareUserSession(ctx context.Context, sess *model.Session) error {
	ret := _m.Called(ctx, sess)

	if len(ret) == 0 {
		panic("no return value specified for PrepareUserSession")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, *model.Session) error); ok {
		r0 = rf(ctx, sess)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ProvisionDevice provides a mock function with given fields: ctx, tenantID, device
func (_m *App) ProvisionDevice(ctx context.Context, tenantID string, device *model.Device) error {
	ret := _m.Called(ctx, tenantID, device)

	if len(ret) == 0 {
		panic("no return value specified for ProvisionDevice")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, *model.Device) error); ok {
		r0 = rf(ctx, tenantID, device)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// RegisterShutdownCancel provides a mock function with given fields: _a0
func (_m *App) RegisterShutdownCancel(_a0 context.CancelFunc) uint32 {
	ret := _m.Called(_a0)

	if len(ret) == 0 {
		panic("no return value specified for RegisterShutdownCancel")
	}

	var r0 uint32
	if rf, ok := ret.Get(0).(func(context.CancelFunc) uint32); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Get(0).(uint32)
	}

	return r0
}

// SaveSessionRecording provides a mock function with given fields: ctx, id, sessionBytes
func (_m *App) SaveSessionRecording(ctx context.Context, id string, sessionBytes []byte) error {
	ret := _m.Called(ctx, id, sessionBytes)

	if len(ret) == 0 {
		panic("no return value specified for SaveSessionRecording")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, []byte) error); ok {
		r0 = rf(ctx, id, sessionBytes)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetDeviceConnected provides a mock function with given fields: ctx, tenantID, deviceID
func (_m *App) SetDeviceConnected(ctx context.Context, tenantID string, deviceID string) (int64, error) {
	ret := _m.Called(ctx, tenantID, deviceID)

	if len(ret) == 0 {
		panic("no return value specified for SetDeviceConnected")
	}

	var r0 int64
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string) (int64, error)); ok {
		return rf(ctx, tenantID, deviceID)
	}
	if rf, ok := ret.Get(0).(func(context.Context, string, string) int64); ok {
		r0 = rf(ctx, tenantID, deviceID)
	} else {
		r0 = ret.Get(0).(int64)
	}

	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, tenantID, deviceID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SetDeviceDisconnected provides a mock function with given fields: ctx, tenantID, deviceID, version
func (_m *App) SetDeviceDisconnected(ctx context.Context, tenantID string, deviceID string, version int64) error {
	ret := _m.Called(ctx, tenantID, deviceID, version)

	if len(ret) == 0 {
		panic("no return value specified for SetDeviceDisconnected")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, int64) error); ok {
		r0 = rf(ctx, tenantID, deviceID, version)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Shutdown provides a mock function with given fields: timeout
func (_m *App) Shutdown(timeout time.Duration) {
	_m.Called(timeout)
}

// ShutdownDone provides a mock function with given fields:
func (_m *App) ShutdownDone() {
	_m.Called()
}

// UnregisterShutdownCancel provides a mock function with given fields: _a0
func (_m *App) UnregisterShutdownCancel(_a0 uint32) {
	_m.Called(_a0)
}

// UploadFile provides a mock function with given fields: ctx, userID, deviceID, path
func (_m *App) UploadFile(ctx context.Context, userID string, deviceID string, path string) error {
	ret := _m.Called(ctx, userID, deviceID, path)

	if len(ret) == 0 {
		panic("no return value specified for UploadFile")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string) error); ok {
		r0 = rf(ctx, userID, deviceID, path)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NewApp creates a new instance of App. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewApp(t interface {
	mock.TestingT
	Cleanup(func())
}) *App {
	mock := &App{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
