#!/bin/bash
# Copyright 2022 Northern.tech AS
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.

set -e

PYTEST_EXTRA_ARGS=""
if [ -n "$K8S" ]; then
    export KUBECONFIG="${HOME}/kubeconfig.${K8S}"
    aws eks update-kubeconfig --region $AWS_DEFAULT_REGION --name $AWS_EKS_CLUSTER_NAME --kubeconfig ${HOME}/kubeconfig.${K8S}
    kubectl config set-context --current --namespace=$K8S
    kubectl get pods -o wide
    if ! python3 -m pip show pytest-xdist >/dev/null; then
        echo "WARNING: install pytest-xdist for running tests in parallel"
    else
        PYTEST_EXTRA_ARGS="${XDIST_ARGS:--n ${TESTS_IN_PARALLEL_BACKEND_INTEGRATION:-auto}}"
    fi
fi

if [ -n "$SSH_PRIVATE_KEY" ]; then
    eval $(ssh-agent -s)
    echo "$SSH_PRIVATE_KEY" | tr -d '\r' | ssh-add - > /dev/null
    mkdir -p ~/.ssh
    chmod 700 ~/.ssh
    ssh-keyscan github.com >> ~/.ssh/known_hosts
fi

chmod 755 /usr/local/bin/mender-artifact

if [[ "${PYTEST_TEST_TO_RUN}" == "" ]]; then
    GLOBIGNORE="/tests/*separate.py"
    python3 -m pytest -v /tests/test_*.py $PYTEST_EXTRA_ARGS "$@"
    unset GLOBIGNORE
else
    python3 -m pytest -v /tests/${PYTEST_TEST_TO_RUN} $PYTEST_EXTRA_ARGS "$@"
fi
